/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.fs.impl.WrappedIOException;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallableSupplier<T>
implements Supplier {
    private static final Logger LOG = LoggerFactory.getLogger(CallableSupplier.class);
    private final Callable<T> call;

    public CallableSupplier(Callable<T> call) {
        this.call = call;
    }

    public Object get() {
        try {
            return this.call.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
        catch (Exception e) {
            throw new WrappedIOException(new IOException(e));
        }
    }

    public static <T> CompletableFuture<T> submit(Executor executor, Callable<T> call) {
        return CompletableFuture.supplyAsync(new CallableSupplier<T>(call), executor);
    }

    public static <T> void waitForCompletion(List<CompletableFuture<T>> futures) throws IOException {
        if (futures.isEmpty()) {
            return;
        }
        CallableSupplier.waitForCompletion(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
    }

    public static <T> void waitForCompletion(CompletableFuture<T> future) throws IOException {
        try (DurationInfo ignore = new DurationInfo(LOG, false, "Waiting for task completion", new Object[0]);){
            future.join();
        }
        catch (CancellationException e) {
            throw new IOException(e);
        }
        catch (CompletionException e) {
            FutureIOSupport.raiseInnerCause((CompletionException)e);
        }
    }

    public static <T> void waitForCompletionIgnoringExceptions(@Nullable CompletableFuture<T> future) {
        if (future != null) {
            try (DurationInfo ignore = new DurationInfo(LOG, false, "Waiting for task completion", new Object[0]);){
                future.join();
            }
            catch (Exception e) {
                LOG.debug("Ignoring exception raised in task completion: ");
            }
        }
    }

    public static void maybeAwaitCompletion(@Nullable CompletableFuture<Void> future) throws IOException {
        if (future != null) {
            CallableSupplier.waitForCompletion(future);
        }
    }
}

