/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public interface DynamoDBClientFactory
extends Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBClientFactory.class);

    public AmazonDynamoDB createDynamoDBClient(String var1, String var2, AWSCredentialsProvider var3) throws IOException;

    public static class DefaultDynamoDBClientFactory
    extends Configured
    implements DynamoDBClientFactory {
        @Override
        public AmazonDynamoDB createDynamoDBClient(String defaultRegion, String bucket, AWSCredentialsProvider credentials) throws IOException {
            Preconditions.checkNotNull((Object)this.getConf(), (Object)"Should have been configured before usage");
            Configuration conf = this.getConf();
            ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, bucket, "DDB");
            String region = DefaultDynamoDBClientFactory.getRegion(conf, defaultRegion);
            LOG.debug("Creating DynamoDB client in region {}", (Object)region);
            return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(credentials)).withClientConfiguration(awsConf)).withRegion(region)).build();
        }

        static String getRegion(Configuration conf, String defaultRegion) throws IOException {
            String region = conf.getTrimmed("fs.s3a.s3guard.ddb.region");
            if (StringUtils.isEmpty((CharSequence)region)) {
                region = defaultRegion;
            }
            try {
                Regions.fromName((String)region);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IOException("Invalid region specified: " + region + "; " + "Region can be configured with " + "fs.s3a.s3guard.ddb.region" + ": " + DefaultDynamoDBClientFactory.validRegionsString());
            }
            return region;
        }

        private static String validRegionsString() {
            String delimiter = ", ";
            Regions[] regions = Regions.values();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(regions[i].getName());
            }
            return sb.toString();
        }
    }
}

