/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.PutItemOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ListTagsOfResourceRequest;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.SSESpecification;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.Tag;
import com.amazonaws.services.dynamodbv2.model.TagResourceRequest;
import com.amazonaws.waiters.WaiterTimedOutException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSClientIOException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadataDynamoDBTranslation;
import org.apache.hadoop.fs.s3a.s3guard.TableDeleteTimeoutException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBMetadataStoreTableManager {
    public static final Logger LOG = LoggerFactory.getLogger(DynamoDBMetadataStoreTableManager.class);
    public static final String E_NO_VERSION_MARKER_AND_NOT_EMPTY = "S3Guard table lacks version marker, and it is not empty.";
    public static final String E_INCOMPATIBLE_TAG_VERSION = "Database table is from an incompatible S3Guard version based on table TAG.";
    public static final String E_INCOMPATIBLE_ITEM_VERSION = "Database table is from an incompatible S3Guard version based on table ITEM.";
    public static final String SSE_DEFAULT_MASTER_KEY = "alias/aws/dynamodb";
    private Invoker invoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.NO_OP);
    private final AmazonDynamoDB amazonDynamoDB;
    private final DynamoDB dynamoDB;
    private final String tableName;
    private final String region;
    private final Configuration conf;
    private final Invoker readOp;
    private final RetryPolicy batchWriteRetryPolicy;
    private Table table;
    private String tableArn;

    public DynamoDBMetadataStoreTableManager(DynamoDB dynamoDB, String tableName, String region, AmazonDynamoDB amazonDynamoDB, Configuration conf, Invoker readOp, RetryPolicy batchWriteCapacityExceededEvents) {
        this.dynamoDB = dynamoDB;
        this.amazonDynamoDB = amazonDynamoDB;
        this.tableName = tableName;
        this.region = region;
        this.conf = conf;
        this.readOp = readOp;
        this.batchWriteRetryPolicy = batchWriteCapacityExceededEvents;
    }

    @VisibleForTesting
    Table initTable() throws IOException {
        block19: {
            this.table = this.dynamoDB.getTable(this.tableName);
            try {
                try {
                    String status;
                    LOG.debug("Binding to table {}", (Object)this.tableName);
                    TableDescription description = this.table.describe();
                    LOG.debug("Table state: {}", (Object)description);
                    this.tableArn = description.getTableArn();
                    switch (status = description.getTableStatus()) {
                        case "CREATING": {
                            LOG.debug("Table {} in region {} is being created/updated. This may indicate that the table is being operated by another concurrent thread or process. Waiting for active...", (Object)this.tableName, (Object)this.region);
                            this.waitForTableActive(this.table);
                            break;
                        }
                        case "DELETING": {
                            throw new FileNotFoundException("DynamoDB table '" + this.tableName + "' is being " + "deleted in region " + this.region);
                        }
                        case "UPDATING": {
                            LOG.debug("Table is being updated.");
                            break;
                        }
                        case "ACTIVE": {
                            break;
                        }
                        default: {
                            throw new IOException("Unknown DynamoDB table status " + status + ": tableName='" + this.tableName + "', region=" + this.region);
                        }
                    }
                    this.verifyVersionCompatibility();
                    Item versionMarker = this.getVersionMarkerItem();
                    Long created = PathMetadataDynamoDBTranslation.extractCreationTimeFromMarker(versionMarker);
                    LOG.debug("Using existing DynamoDB table {} in region {} created {}", new Object[]{this.tableName, this.region, created != null ? new Date(created) : null});
                }
                catch (ResourceNotFoundException rnfe) {
                    if (this.conf.getBoolean("fs.s3a.s3guard.ddb.table.create", false)) {
                        ProvisionedThroughput capacity;
                        long readCapacity = this.conf.getLong("fs.s3a.s3guard.ddb.table.capacity.read", 0L);
                        long writeCapacity = this.conf.getLong("fs.s3a.s3guard.ddb.table.capacity.write", 0L);
                        if (readCapacity > 0L && writeCapacity > 0L) {
                            capacity = new ProvisionedThroughput(Long.valueOf(readCapacity), Long.valueOf(writeCapacity));
                        } else {
                            Preconditions.checkArgument((readCapacity == 0L && writeCapacity == 0L ? 1 : 0) != 0, (String)"S3Guard table read capacity %d and and write capacity %d are inconsistent", (long)readCapacity, (long)writeCapacity);
                            capacity = null;
                        }
                        this.createTable(capacity);
                        break block19;
                    }
                    throw (FileNotFoundException)new FileNotFoundException("DynamoDB table '" + this.tableName + "' does not " + "exist in region " + this.region + "; auto-creation is turned off").initCause(rnfe);
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("initTable", this.tableName, (SdkBaseException)e);
            }
        }
        return this.table;
    }

    protected void tagTableWithVersionMarker() throws AmazonDynamoDBException {
        try {
            TagResourceRequest tagResourceRequest = new TagResourceRequest().withResourceArn(this.table.getDescription().getTableArn()).withTags(new Tag[]{DynamoDBMetadataStoreTableManager.newVersionMarkerTag()});
            this.amazonDynamoDB.tagResource(tagResourceRequest);
        }
        catch (AmazonDynamoDBException e) {
            LOG.debug("Exception during tagging table: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected static Item getVersionMarkerFromTags(Table table, AmazonDynamoDB addb) throws IOException {
        List tags = null;
        try {
            TableDescription description = table.describe();
            ListTagsOfResourceRequest listTagsOfResourceRequest = new ListTagsOfResourceRequest().withResourceArn(description.getTableArn());
            tags = addb.listTagsOfResource(listTagsOfResourceRequest).getTags();
        }
        catch (ResourceNotFoundException e) {
            LOG.error("Table: {} not found.", (Object)table.getTableName());
            throw e;
        }
        catch (AmazonDynamoDBException e) {
            LOG.debug("Exception while getting tags from the dynamo table: {}", (Object)e.getMessage(), (Object)e);
            throw S3AUtils.translateDynamoDBException(table.getTableName(), "Retrieving tags.", e);
        }
        if (tags == null) {
            return null;
        }
        Optional<Tag> first = tags.stream().filter(tag -> tag.getKey().equals("s3guard_version")).findFirst();
        if (first.isPresent()) {
            Tag vmTag = first.get();
            return PathMetadataDynamoDBTranslation.createVersionMarker(vmTag.getKey(), Integer.parseInt(vmTag.getValue()), 0L);
        }
        return null;
    }

    private void createTable(ProvisionedThroughput capacity) throws IOException {
        try {
            String mode;
            CreateTableRequest request = new CreateTableRequest().withTableName(this.tableName).withKeySchema(PathMetadataDynamoDBTranslation.keySchema()).withAttributeDefinitions(PathMetadataDynamoDBTranslation.attributeDefinitions()).withSSESpecification(this.getSseSpecFromConfig()).withTags(this.getTableTagsFromConfig());
            if (capacity != null) {
                mode = String.format("with provisioned read capacity %d and write capacity %s", capacity.getReadCapacityUnits(), capacity.getWriteCapacityUnits());
                request.withProvisionedThroughput(capacity);
            } else {
                mode = "with pay-per-request billing";
                request.withBillingMode(BillingMode.PAY_PER_REQUEST);
            }
            LOG.info("Creating non-existent DynamoDB table {} in region {} {}", new Object[]{this.tableName, this.region, mode});
            this.table = this.dynamoDB.createTable(request);
            LOG.debug("Awaiting table becoming active");
        }
        catch (ResourceInUseException e) {
            LOG.warn("ResourceInUseException while creating DynamoDB table {} in region {}.  This may indicate that the table was created by another concurrent thread or process.", (Object)this.tableName, (Object)this.region);
        }
        this.waitForTableActive(this.table);
        this.putVersionMarkerItemToTable();
    }

    private SSESpecification getSseSpecFromConfig() {
        SSESpecification sseSpecification = new SSESpecification();
        boolean enabled = this.conf.getBoolean("fs.s3a.s3guard.ddb.table.sse.enabled", false);
        if (!enabled) {
            return sseSpecification;
        }
        sseSpecification.setEnabled(Boolean.TRUE);
        String cmk = null;
        try {
            cmk = S3AUtils.lookupPassword("", this.conf, "fs.s3a.s3guard.ddb.table.sse.cmk");
        }
        catch (IOException e) {
            LOG.error("Cannot retrieve fs.s3a.s3guard.ddb.table.sse.cmk", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)cmk)) {
            return sseSpecification;
        }
        if (SSE_DEFAULT_MASTER_KEY.equals(cmk)) {
            LOG.warn("Ignoring default DynamoDB table KMS Master Key {}", (Object)SSE_DEFAULT_MASTER_KEY);
        } else {
            sseSpecification.setSSEType("KMS");
            sseSpecification.setKMSMasterKeyId(cmk);
        }
        return sseSpecification;
    }

    public List<Tag> getTableTagsFromConfig() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Map tagProperties = this.conf.getPropsWithPrefix("fs.s3a.s3guard.ddb.table.tag.");
        for (Map.Entry tagMapEntry : tagProperties.entrySet()) {
            Tag tag = new Tag().withKey((String)tagMapEntry.getKey()).withValue((String)tagMapEntry.getValue());
            tags.add(tag);
        }
        tags.add(DynamoDBMetadataStoreTableManager.newVersionMarkerTag());
        return tags;
    }

    private static Tag newVersionMarkerTag() {
        return new Tag().withKey("s3guard_version").withValue(String.valueOf(100));
    }

    @VisibleForTesting
    protected void verifyVersionCompatibility() throws IOException {
        Item versionMarkerItem = this.getVersionMarkerItem();
        Item versionMarkerFromTag = null;
        boolean canReadDdbTags = true;
        try {
            versionMarkerFromTag = DynamoDBMetadataStoreTableManager.getVersionMarkerFromTags(this.table, this.amazonDynamoDB);
        }
        catch (AccessDeniedException e) {
            LOG.debug("Can not read tags of table.");
            canReadDdbTags = false;
        }
        LOG.debug("versionMarkerItem: {};  versionMarkerFromTag: {}", (Object)versionMarkerItem, (Object)versionMarkerFromTag);
        if (versionMarkerItem == null && versionMarkerFromTag == null) {
            if (!DynamoDBMetadataStoreTableManager.isEmptyTable(this.tableName, this.amazonDynamoDB)) {
                LOG.error("Table is not empty but missing the version maker. Failing.");
                throw new IOException("S3Guard table lacks version marker, and it is not empty. Table: " + this.tableName);
            }
            if (canReadDdbTags) {
                LOG.info("Table {} contains no version marker item and tag. The table is empty, so the version marker will be added as TAG and ITEM.", (Object)this.tableName);
                this.putVersionMarkerItemToTable();
                this.tagTableWithVersionMarker();
            }
            if (!canReadDdbTags) {
                LOG.info("Table {} contains no version marker item and the tags are not readable. The table is empty, so the ITEM version marker will be added .", (Object)this.tableName);
                this.putVersionMarkerItemToTable();
            }
        }
        if (versionMarkerItem == null && versionMarkerFromTag != null) {
            int tagVersionMarker = PathMetadataDynamoDBTranslation.extractVersionFromMarker(versionMarkerFromTag);
            DynamoDBMetadataStoreTableManager.throwExceptionOnVersionMismatch(tagVersionMarker, this.tableName, E_INCOMPATIBLE_TAG_VERSION);
            LOG.info("Table {} contains no version marker ITEM but contains compatible version marker TAG. Restoring the version marker item from tag.", (Object)this.tableName);
            this.putVersionMarkerItemToTable();
        }
        if (versionMarkerItem != null && versionMarkerFromTag == null && canReadDdbTags) {
            int itemVersionMarker = PathMetadataDynamoDBTranslation.extractVersionFromMarker(versionMarkerItem);
            DynamoDBMetadataStoreTableManager.throwExceptionOnVersionMismatch(itemVersionMarker, this.tableName, E_INCOMPATIBLE_ITEM_VERSION);
            LOG.info("Table {} contains no version marker TAG but contains compatible version marker ITEM. Restoring the version marker item from item.", (Object)this.tableName);
            this.tagTableWithVersionMarker();
        }
        if (versionMarkerItem != null && versionMarkerFromTag != null) {
            int tagVersionMarker = PathMetadataDynamoDBTranslation.extractVersionFromMarker(versionMarkerFromTag);
            int itemVersionMarker = PathMetadataDynamoDBTranslation.extractVersionFromMarker(versionMarkerItem);
            DynamoDBMetadataStoreTableManager.throwExceptionOnVersionMismatch(tagVersionMarker, this.tableName, E_INCOMPATIBLE_TAG_VERSION);
            DynamoDBMetadataStoreTableManager.throwExceptionOnVersionMismatch(itemVersionMarker, this.tableName, E_INCOMPATIBLE_ITEM_VERSION);
            LOG.debug("Table {} contains correct version marker TAG and ITEM.", (Object)this.tableName);
        }
    }

    private static boolean isEmptyTable(String tableName, AmazonDynamoDB aadb) {
        ScanRequest req = new ScanRequest().withTableName(tableName).withLimit(Integer.valueOf(1));
        ScanResult result = aadb.scan(req);
        return result.getCount() == 0;
    }

    private static void throwExceptionOnVersionMismatch(int actual, String tableName, String exMsg) throws IOException {
        if (100 != actual) {
            throw new IOException(exMsg + " Table " + tableName + " Expected version: " + 100 + " actual tag version: " + actual);
        }
    }

    private void putVersionMarkerItemToTable() {
        Item marker = PathMetadataDynamoDBTranslation.createVersionMarker("../VERSION", 100, System.currentTimeMillis());
        this.putItem(marker);
    }

    private void waitForTableActive(Table t) throws IOException {
        this.invoker.retry("Waiting for active state of table " + this.tableName, null, true, () -> {
            try {
                t.waitForActive();
            }
            catch (IllegalArgumentException ex) {
                throw DynamoDBMetadataStoreTableManager.translateTableWaitFailure(this.tableName, ex);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for table {} in region {} active", new Object[]{this.tableName, this.region, e});
                Thread.currentThread().interrupt();
                throw (InterruptedIOException)new InterruptedIOException("DynamoDB table '" + this.tableName + "' is not active yet in region " + this.region).initCause(e);
            }
        });
    }

    @VisibleForTesting
    static IOException translateTableWaitFailure(String name, IllegalArgumentException e) {
        SdkBaseException ex = DynamoDBMetadataStoreTableManager.extractInnerException(e);
        if (ex != null) {
            if (ex instanceof WaiterTimedOutException) {
                return new AWSClientIOException(e.getMessage(), ex);
            }
            return S3AUtils.translateException(e.getMessage(), name, ex);
        }
        return new IOException(e);
    }

    public static SdkBaseException extractInnerException(IllegalArgumentException ex) {
        if (ex.getCause() instanceof SdkBaseException) {
            return (SdkBaseException)ex.getCause();
        }
        return null;
    }

    @VisibleForTesting
    protected Item getVersionMarkerItem() throws IOException {
        PrimaryKey versionMarkerKey = PathMetadataDynamoDBTranslation.createVersionMarkerPrimaryKey("../VERSION");
        int retryCount = 0;
        Item versionMarker = this.queryVersionMarker(versionMarkerKey);
        while (versionMarker == null) {
            try {
                RetryPolicy.RetryAction action = this.batchWriteRetryPolicy.shouldRetry(null, retryCount, 0, true);
                if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) break;
                LOG.warn("No version marker found in the DynamoDB table: {}. Sleeping {} ms before next retry", (Object)this.tableName, (Object)action.delayMillis);
                Thread.sleep(action.delayMillis);
            }
            catch (Exception e) {
                throw new IOException("initTable: Unexpected exception " + e, e);
            }
            ++retryCount;
            versionMarker = this.queryVersionMarker(versionMarkerKey);
        }
        return versionMarker;
    }

    private Item queryVersionMarker(PrimaryKey versionMarkerKey) throws IOException {
        return this.readOp.retry("getVersionMarkerItem", "../VERSION", true, () -> this.table.getItem(versionMarkerKey));
    }

    private PutItemOutcome putItem(Item item) {
        LOG.debug("Putting item {}", (Object)item);
        return this.table.putItem(item);
    }

    void provisionTable(Long readCapacity, Long writeCapacity) throws IOException {
        if (readCapacity == 0L || writeCapacity == 0L) {
            throw new IOException("Neither ReadCapacityUnits nor WriteCapacityUnits can be specified when BillingMode is PAY_PER_REQUEST");
        }
        ProvisionedThroughput toProvision = new ProvisionedThroughput().withReadCapacityUnits(readCapacity).withWriteCapacityUnits(writeCapacity);
        this.invoker.retry("ProvisionTable", this.tableName, true, () -> {
            ProvisionedThroughputDescription p = this.table.updateTable(toProvision).getProvisionedThroughput();
            LOG.info("Provision table {} in region {}: readCapacityUnits={}, writeCapacityUnits={}", new Object[]{this.tableName, this.region, p.getReadCapacityUnits(), p.getWriteCapacityUnits()});
        });
    }

    public void destroy() throws IOException {
        if (this.table == null) {
            LOG.info("In destroy(): no table to delete");
            return;
        }
        LOG.info("Deleting DynamoDB table {} in region {}", (Object)this.tableName, (Object)this.region);
        Preconditions.checkNotNull((Object)this.dynamoDB, (Object)"Not connected to DynamoDB");
        try {
            this.invoker.retry("delete", null, true, () -> this.table.delete());
            this.table.waitForDelete();
        }
        catch (IllegalArgumentException ex) {
            throw new TableDeleteTimeoutException(this.tableName, "Timeout waiting for the table " + this.getTableArn() + " to be deleted", ex);
        }
        catch (FileNotFoundException rnfe) {
            LOG.info("FileNotFoundException while deleting DynamoDB table {} in region {}.  This may indicate that the table does not exist, or has been deleted by another concurrent thread or process.", (Object)this.tableName, (Object)this.region);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted while waiting for DynamoDB table {} being deleted", (Object)this.tableName, (Object)ie);
            throw new InterruptedIOException("Table " + this.tableName + " in region " + this.region + " has not been deleted");
        }
    }

    @VisibleForTesting
    void provisionTableBlocking(Long readCapacity, Long writeCapacity) throws IOException {
        this.provisionTable(readCapacity, writeCapacity);
        this.waitForTableActive(this.table);
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableArn() {
        return this.tableArn;
    }
}

