/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

final class PathOrderComparators {
    static final Comparator<Path> TOPMOST_PATH_FIRST = new TopmostFirst();
    static final Comparator<Path> TOPMOST_PATH_LAST = new TopmostLast();
    static final Comparator<PathMetadata> TOPMOST_PM_FIRST = new PathMetadataComparator(TOPMOST_PATH_FIRST);
    static final Comparator<PathMetadata> TOPMOST_PM_LAST = new PathMetadataComparator(TOPMOST_PATH_LAST);

    private PathOrderComparators() {
    }

    static final class PathMetadataComparator
    implements Comparator<PathMetadata>,
    Serializable {
        private final Comparator<Path> inner;

        PathMetadataComparator(Comparator<Path> inner) {
            this.inner = inner;
        }

        @Override
        public int compare(PathMetadata o1, PathMetadata o2) {
            return this.inner.compare(o1.getFileStatus().getPath(), o2.getFileStatus().getPath());
        }
    }

    private static final class TopmostLast
    extends TopmostFirst {
        private TopmostLast() {
        }

        @Override
        public int compare(Path pathL, Path pathR) {
            int compare = super.compare(pathL, pathR);
            if (compare < 0) {
                return 1;
            }
            if (compare > 0) {
                return -1;
            }
            return 0;
        }
    }

    private static class TopmostFirst
    implements Comparator<Path>,
    Serializable {
        private TopmostFirst() {
        }

        @Override
        public int compare(Path pathL, Path pathR) {
            int depthR;
            if (pathL.equals((Object)pathR)) {
                return 0;
            }
            int depthL = pathL.depth();
            if (depthL < (depthR = pathR.depth())) {
                return -1;
            }
            if (depthR < depthL) {
                return 1;
            }
            return pathL.compareTo((Object)pathR);
        }
    }
}

