/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.select;

import com.amazonaws.AbortedException;
import com.amazonaws.services.s3.model.SelectObjectContentEvent;
import com.amazonaws.services.s3.model.SelectObjectContentEventVisitor;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.SelectRecordsInputStream;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SelectInputStream
extends FSInputStream
implements CanSetReadahead {
    private static final Logger LOG = LoggerFactory.getLogger(SelectInputStream.class);
    public static final String SEEK_UNSUPPORTED = "seek()";
    private final S3ObjectAttributes objectAttributes;
    private AtomicLong pos = new AtomicLong(0L);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean completedSuccessfully = new AtomicBoolean(false);
    private final SelectRecordsInputStream wrappedStream;
    private final String bucket;
    private final String key;
    private final String uri;
    private final S3AReadOpContext readContext;
    private final S3AInputStreamStatistics streamStatistics;
    private long readahead;

    public SelectInputStream(S3AReadOpContext readContext, S3ObjectAttributes objectAttributes, SelectObjectContentResult selectResponse) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)objectAttributes.getBucket()), (Object)"No Bucket");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)objectAttributes.getKey()), (Object)"No Key");
        this.objectAttributes = objectAttributes;
        this.bucket = objectAttributes.getBucket();
        this.key = objectAttributes.getKey();
        this.uri = "s3a://" + this.bucket + "/" + this.key;
        this.readContext = readContext;
        this.readahead = readContext.getReadahead();
        this.streamStatistics = readContext.getS3AStatisticsContext().newInputStreamStatistics();
        SelectRecordsInputStream stream = (SelectRecordsInputStream)Invoker.once("S3 Select", this.uri, () -> selectResponse.getPayload().getRecordsInputStream(new SelectObjectContentEventVisitor(){

            public void visit(SelectObjectContentEvent.EndEvent event) {
                LOG.debug("Completed successful S3 select read from {}", (Object)SelectInputStream.this.uri);
                SelectInputStream.this.completedSuccessfully.set(true);
            }
        }));
        this.wrappedStream = (SelectRecordsInputStream)Preconditions.checkNotNull((Object)stream);
        this.streamStatistics.streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        long skipped = 0L;
        boolean aborted = false;
        if (!this.closed.getAndSet(true)) {
            block6: {
                try {
                    boolean shouldAbort;
                    boolean bl = shouldAbort = (long)this.wrappedStream.available() > this.readahead;
                    if (!shouldAbort) {
                        skipped = this.wrappedStream.skip(this.readahead);
                        boolean bl2 = shouldAbort = this.wrappedStream.read() >= 0;
                    }
                    if (!shouldAbort) break block6;
                    aborted = true;
                    this.wrappedStream.abort();
                }
                catch (AbortedException | IOException e) {
                    try {
                        LOG.debug("While closing stream", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.wrappedStream});
                        this.streamStatistics.streamClose(aborted, skipped);
                        this.streamStatistics.close();
                        super.close();
                        throw throwable;
                    }
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.wrappedStream});
                    this.streamStatistics.streamClose(aborted, skipped);
                    this.streamStatistics.close();
                    super.close();
                }
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.wrappedStream});
            this.streamStatistics.streamClose(aborted, skipped);
            this.streamStatistics.close();
            super.close();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed.get()) {
            throw new PathIOException(this.uri, "Stream is closed!");
        }
    }

    public int available() throws IOException {
        this.checkNotClosed();
        return this.wrappedStream.available();
    }

    public synchronized long skip(long n) throws IOException {
        this.checkNotClosed();
        long skipped = (Long)Invoker.once("skip", this.uri, () -> this.wrappedStream.skip(n));
        this.pos.addAndGet(skipped);
        this.streamStatistics.seekForwards(skipped, skipped);
        return skipped;
    }

    public long getPos() {
        return this.pos.get();
    }

    public void setReadahead(Long readahead) {
        this.readahead = S3AInputStream.validateReadahead(readahead);
    }

    public long getReadahead() {
        return this.readahead;
    }

    public synchronized int read() throws IOException {
        int byteRead;
        this.checkNotClosed();
        try {
            byteRead = (Integer)Invoker.once("read()", this.uri, () -> this.wrappedStream.read());
        }
        catch (EOFException e) {
            if (this.completedSuccessfully.get()) {
                return -1;
            }
            LOG.info("Reading of S3 Select data from {} failed before all results  were generated.", (Object)this.uri);
            this.streamStatistics.readException();
            throw new PathIOException(this.uri, "Read of S3 Select data did not complete");
        }
        if (byteRead >= 0) {
            this.incrementBytesRead(1L);
        }
        return byteRead;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int bytesRead;
        this.checkNotClosed();
        this.validatePositionedReadArgs(this.pos.get(), buf, off, len);
        if (len == 0) {
            return 0;
        }
        try {
            this.streamStatistics.readOperationStarted(this.pos.get(), len);
            bytesRead = this.wrappedStream.read(buf, off, len);
        }
        catch (EOFException e) {
            this.streamStatistics.readException();
            return -1;
        }
        this.incrementBytesRead(bytesRead);
        this.streamStatistics.readOperationCompleted(len, bytesRead);
        return bytesRead;
    }

    public synchronized void seek(long newPos) throws IOException {
        long current = this.getPos();
        long distance = newPos - current;
        if (distance < 0L) {
            throw this.unsupported("seek() backwards from " + current + " to " + newPos);
        }
        if (distance == 0L) {
            LOG.debug("ignoring seek to current position.");
        } else {
            LOG.debug("Forward seek by reading {} bytes", (Object)distance);
            long bytesSkipped = 0L;
            while (distance > 0L) {
                int r = this.read();
                if (r == -1) {
                    throw new EOFException("Seek to " + newPos + " reached End of File at offset " + this.getPos());
                }
                --distance;
                ++bytesSkipped;
            }
            this.streamStatistics.seekForwards(bytesSkipped, bytesSkipped);
        }
    }

    protected PathIOException unsupported(String action) {
        return new PathIOException(String.format("s3a://%s/%s", this.bucket, this.key), action + " not supported");
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw this.unsupported("Mark");
    }

    public void abort() {
        if (!this.closed.get()) {
            LOG.debug("Aborting");
            this.wrappedStream.abort();
        }
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.seek(position);
        return this.read(buffer, offset, length);
    }

    private void incrementBytesRead(long bytesRead) {
        if (bytesRead > 0L) {
            this.pos.addAndGet(bytesRead);
        }
        this.streamStatistics.bytesRead(bytesRead);
        if (this.readContext.getStats() != null && bytesRead > 0L) {
            this.readContext.getStats().incrementBytesRead(bytesRead);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public S3AInputStreamStatistics getS3AStreamStatistics() {
        return this.streamStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceStability.Unstable
    public String toString() {
        String s = this.streamStatistics.toString();
        SelectInputStream selectInputStream = this;
        synchronized (selectInputStream) {
            StringBuilder sb = new StringBuilder("SelectInputStream{");
            sb.append(this.uri);
            sb.append("; state ").append(!this.closed.get() ? "open" : "closed");
            sb.append("; pos=").append(this.getPos());
            sb.append("; readahead=").append(this.readahead);
            sb.append('\n').append(s);
            sb.append('}');
            return sb.toString();
        }
    }
}

