/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.RuntimeHttpUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.impl.LogExactlyOnce;
import org.apache.hadoop.fs.s3a.statistics.impl.AwsStatisticsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultS3ClientFactory
extends Configured
implements S3ClientFactory {
    private static final String S3_SERVICE_NAME = "s3";
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultS3ClientFactory.class);
    private static final LogExactlyOnce WARN_OF_DEFAULT_REGION_CHAIN = new LogExactlyOnce(LOG);
    private static final String SDK_REGION_CHAIN_IN_USE = "S3A filesystem client is using the SDK region resolution chain.";

    @Override
    public AmazonS3 createS3Client(URI uri, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        Configuration conf = this.getConf();
        ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, uri.getHost(), "S3");
        parameters.getHeaders().forEach((h, v) -> awsConf.addHeader(h, v));
        awsConf.setUseThrottleRetries(conf.getBoolean("fs.s3a.experimental.aws.s3.throttling", true));
        if (!StringUtils.isEmpty((CharSequence)parameters.getUserAgentSuffix())) {
            awsConf.setUserAgentSuffix(parameters.getUserAgentSuffix());
        }
        try {
            return this.buildAmazonS3Client(awsConf, parameters);
        }
        catch (SdkClientException e) {
            throw S3AUtils.translateException("creating AWS S3 client", uri.toString(), (SdkBaseException)((Object)e));
        }
    }

    protected AmazonS3 buildAmazonS3Client(ClientConfiguration awsConf, S3ClientFactory.S3ClientCreationParameters parameters) {
        AwsClientBuilder.EndpointConfiguration epr;
        AmazonS3ClientBuilder b = AmazonS3Client.builder();
        b.withCredentials(parameters.getCredentialSet());
        b.withClientConfiguration(awsConf);
        b.withPathStyleAccessEnabled(Boolean.valueOf(parameters.isPathStyleAccess()));
        if (parameters.getMetrics() != null) {
            b.withMetricsCollector((RequestMetricCollector)new AwsStatisticsCollector(parameters.getMetrics()));
        }
        if (parameters.getRequestHandlers() != null) {
            b.withRequestHandlers(parameters.getRequestHandlers().toArray(new RequestHandler2[0]));
        }
        if (parameters.getMonitoringListener() != null) {
            b.withMonitoringListener(parameters.getMonitoringListener());
        }
        if ((epr = DefaultS3ClientFactory.createEndpointConfiguration(parameters.getEndpoint(), awsConf, this.getConf().getTrimmed("fs.s3a.endpoint.region"))) != null) {
            b.withEndpointConfiguration(epr);
        } else {
            b.withForceGlobalBucketAccessEnabled(Boolean.valueOf(true));
            String region = this.getConf().getTrimmed("fs.s3a.endpoint.region", "us-east-1");
            LOG.debug("fs.s3a.endpoint.region=\"{}\"", (Object)region);
            if (!region.isEmpty()) {
                LOG.debug("Using default endpoint; setting region to {}", (Object)region);
                b.setRegion(region);
            } else {
                WARN_OF_DEFAULT_REGION_CHAIN.warn(SDK_REGION_CHAIN_IN_USE, new Object[0]);
                LOG.debug(SDK_REGION_CHAIN_IN_USE);
            }
        }
        AmazonS3 client = (AmazonS3)b.build();
        return client;
    }

    protected static AmazonS3 configureAmazonS3Client(AmazonS3 s3, String endPoint, boolean pathStyleAccess) throws IllegalArgumentException {
        if (!endPoint.isEmpty()) {
            try {
                s3.setEndpoint(endPoint);
            }
            catch (IllegalArgumentException e) {
                String msg = "Incorrect endpoint: " + e.getMessage();
                LOG.error(msg);
                throw new IllegalArgumentException(msg, e);
            }
        }
        if (pathStyleAccess) {
            LOG.debug("Enabling path style access!");
            s3.setS3ClientOptions(S3ClientOptions.builder().setPathStyleAccess(true).build());
        }
        return s3;
    }

    @VisibleForTesting
    public static AwsClientBuilder.EndpointConfiguration createEndpointConfiguration(String endpoint, ClientConfiguration awsConf, String awsRegion) {
        LOG.debug("Creating endpoint configuration for \"{}\"", (Object)endpoint);
        if (endpoint == null || endpoint.isEmpty()) {
            LOG.debug("Using default endpoint -no need to generate a configuration");
            return null;
        }
        URI epr = RuntimeHttpUtils.toUri((String)endpoint, (ClientConfiguration)awsConf);
        LOG.debug("Endpoint URI = {}", (Object)epr);
        String region = awsRegion;
        if (StringUtils.isBlank((CharSequence)region)) {
            if (!ServiceUtils.isS3USStandardEndpoint((String)endpoint)) {
                LOG.debug("Endpoint {} is not the default; parsing", (Object)epr);
                region = AwsHostNameUtils.parseRegion((String)epr.getHost(), (String)S3_SERVICE_NAME);
            } else {
                LOG.debug("Endpoint {} is the standard one; declare region as null", (Object)epr);
                region = null;
            }
        }
        LOG.debug("Region for endpoint {}, URI {} is determined as {}", new Object[]{endpoint, epr, region});
        return new AwsClientBuilder.EndpointConfiguration(endpoint, region);
    }
}

