/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.thirdparty.apache.http.conn.socket.ConnectionSocketFactory;
import com.amazonaws.thirdparty.apache.http.conn.ssl.SSLConnectionSocketFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkBinding {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkBinding.class);
    private static final String AWS_SOCKET_FACTORY_CLASSNAME = "com.amazonaws.thirdparty.apache.http.conn.ssl.SSLConnectionSocketFactory";

    public static void bindSSLChannelMode(Configuration conf, ClientConfiguration awsConf) throws IOException {
        String channelModeString = conf.getTrimmed("fs.s3a.ssl.channel.mode", Constants.DEFAULT_SSL_CHANNEL_MODE.name());
        DelegatingSSLSocketFactory.SSLChannelMode channelMode = null;
        for (DelegatingSSLSocketFactory.SSLChannelMode mode : DelegatingSSLSocketFactory.SSLChannelMode.values()) {
            if (!mode.name().equalsIgnoreCase(channelModeString)) continue;
            channelMode = mode;
        }
        if (channelMode == null) {
            throw new IllegalArgumentException(channelModeString + " is not a valid value for " + "fs.s3a.ssl.channel.mode");
        }
        DelegatingSSLSocketFactory.initializeDefaultFactory(channelMode);
        try {
            Class<?> sslConnectionSocketFactory = Class.forName(AWS_SOCKET_FACTORY_CLASSNAME);
            Constructor<?> factoryConstructor = sslConnectionSocketFactory.getDeclaredConstructor(SSLSocketFactory.class, HostnameVerifier.class);
            awsConf.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)((SSLConnectionSocketFactory)factoryConstructor.newInstance(DelegatingSSLSocketFactory.getDefaultFactory(), null)));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("Unable to create class {}, value of {} will be ignored", new Object[]{AWS_SOCKET_FACTORY_CLASSNAME, "fs.s3a.ssl.channel.mode", e});
        }
    }

    public static String fixBucketRegion(String region) {
        return region == null || region.equals("US") ? "us-east-1" : region;
    }

    public static void logDnsLookup(Configuration conf) {
        String endPoint;
        String hostName = endPoint = conf.getTrimmed("fs.s3a.endpoint", "");
        if (!endPoint.isEmpty() && LOG.isDebugEnabled()) {
            if (endPoint.contains("://")) {
                try {
                    URI uri = new URI(endPoint);
                    hostName = uri.getHost();
                }
                catch (URISyntaxException e) {
                    LOG.debug("Got URISyntaxException, ignoring");
                }
            }
            LOG.debug("Bucket endpoint : {}, Hostname : {}, DNSAddress : {}", new Object[]{endPoint, hostName, NetUtils.normalizeHostName((String)hostName)});
        }
    }
}

