/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.RenameTracker;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.util.DurationInfo;

public class ProgressiveRenameTracker
extends RenameTracker {
    private final Collection<Path> pathsToDelete = new HashSet<Path>();

    public ProgressiveRenameTracker(StoreContext storeContext, MetadataStore metadataStore, Path sourceRoot, Path dest, BulkOperationState operationState) {
        super("ProgressiveRenameTracker", storeContext, metadataStore, sourceRoot, dest, operationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileCopied(Path sourcePath, S3ObjectAttributes sourceAttributes, S3ObjectAttributes destAttributes, Path destPath, long blockSize, boolean addAncestors) throws IOException {
        ArrayList<PathMetadata> entriesToAdd = new ArrayList<PathMetadata>(1);
        LOG.debug("Updating store with copied file {}", (Object)sourcePath);
        MetadataStore store = this.getMetadataStore();
        ProgressiveRenameTracker progressiveRenameTracker = this;
        synchronized (progressiveRenameTracker) {
            Preconditions.checkArgument((!this.pathsToDelete.contains(sourcePath) ? 1 : 0) != 0, (String)"File being renamed is already processed %s", (Object)destPath);
            S3Guard.addMoveFile(store, this.pathsToDelete, entriesToAdd, sourcePath, destPath, sourceAttributes.getLen(), blockSize, this.getOwner(), destAttributes.getETag(), destAttributes.getVersionId());
            LOG.debug("New metastore entry : {}", entriesToAdd.get(0));
            if (addAncestors) {
                S3Guard.addMoveAncestors(store, this.pathsToDelete, entriesToAdd, this.getSourceRoot(), sourcePath, destPath, this.getOwner());
            }
        }
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Adding new metastore entries", new Object[0]);){
            store.move(null, entriesToAdd, this.getOperationState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void directoryMarkerCopied(Path sourcePath, Path destPath, boolean addAncestors) throws IOException {
        ArrayList<PathMetadata> entriesToAdd = new ArrayList<PathMetadata>(1);
        MetadataStore store = this.getMetadataStore();
        ProgressiveRenameTracker progressiveRenameTracker = this;
        synchronized (progressiveRenameTracker) {
            S3Guard.addMoveDir(store, this.pathsToDelete, entriesToAdd, sourcePath, destPath, this.getOwner());
            if (addAncestors) {
                S3Guard.addMoveAncestors(store, this.pathsToDelete, entriesToAdd, this.getSourceRoot(), sourcePath, destPath, this.getOwner());
            }
        }
        try (DurationInfo ignored = new DurationInfo(LOG, false, "adding %s metastore entries", new Object[]{entriesToAdd.size()});){
            store.move(null, entriesToAdd, this.getOperationState());
        }
    }

    @Override
    public synchronized void moveSourceDirectory() throws IOException {
        if (!this.pathsToDelete.contains(this.getSourceRoot())) {
            ArrayList<Path> toDelete = new ArrayList<Path>(1);
            ArrayList<PathMetadata> toAdd = new ArrayList<PathMetadata>(1);
            S3Guard.addMoveDir(this.getMetadataStore(), this.pathsToDelete, toAdd, this.getSourceRoot(), this.getDest(), this.getOwner());
            this.getMetadataStore().move(toDelete, toAdd, this.getOperationState());
        }
        this.getMetadataStore().markAsAuthoritative(this.getDest(), this.getOperationState());
    }

    @Override
    public void sourceObjectsDeleted(Collection<Path> paths) throws IOException {
        try (DurationInfo ignored = new DurationInfo(LOG, false, "delete %s metastore entries", new Object[]{paths.size()});){
            this.getMetadataStore().move(paths, null, this.getOperationState());
            this.getMetadataStore().deletePaths(paths, this.getOperationState());
        }
    }

    @Override
    public synchronized void completeRename() throws IOException {
        this.sourceObjectsDeleted(this.pathsToDelete);
        super.completeRename();
    }
}

