/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.internal.IteratorSupport;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadataDynamoDBTranslation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class S3GuardTableAccess {
    private static final Logger LOG = LoggerFactory.getLogger(S3GuardTableAccess.class);
    private final DynamoDBMetadataStore store;
    private final Table table;

    S3GuardTableAccess(DynamoDBMetadataStore store) {
        this.store = (DynamoDBMetadataStore)Preconditions.checkNotNull((Object)store);
        this.table = (Table)Preconditions.checkNotNull((Object)store.getTable());
    }

    private String getUsername() {
        return this.store.getUsername();
    }

    ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.table.query(spec);
    }

    Iterable<DDBPathMetadata> queryMetadata(QuerySpec spec) {
        return new DDBPathMetadataCollection(this.query(spec));
    }

    ItemCollection<ScanOutcome> scan(ExpressionSpecBuilder spec) {
        return this.table.scan(spec.buildForScan());
    }

    Iterable<DDBPathMetadata> scanMetadata(ExpressionSpecBuilder spec) {
        return new DDBPathMetadataCollection(this.scan(spec));
    }

    void delete(Collection<Path> paths) {
        paths.stream().map(PathMetadataDynamoDBTranslation::pathToKey).forEach(arg_0 -> ((Table)this.table).deleteItem(arg_0));
    }

    void delete(Path path) {
        this.table.deleteItem(PathMetadataDynamoDBTranslation.pathToKey(path));
    }

    private static Pair<String, String> primaryKey(Item item) {
        return Pair.of((Object)item.getString("parent"), (Object)item.getString("child"));
    }

    static final class VersionMarker
    extends DDBPathMetadata {
        VersionMarker(Item versionMarker) {
            super(new S3AFileStatus(true, new Path("/VERSION"), "" + versionMarker.getString("table_version")));
        }
    }

    private final class DDBPathMetadataIterator<T>
    implements Iterator<DDBPathMetadata> {
        private final IteratorSupport<Item, T> it;

        private DDBPathMetadataIterator(IteratorSupport<Item, T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public DDBPathMetadata next() {
            Item item = (Item)this.it.next();
            Pair key = S3GuardTableAccess.primaryKey(item);
            if ("../VERSION".equals(key.getLeft()) && "../VERSION".equals(key.getRight())) {
                return new VersionMarker(item);
            }
            return PathMetadataDynamoDBTranslation.itemToPathMetadata(item, S3GuardTableAccess.this.getUsername());
        }
    }

    private final class DDBPathMetadataCollection<T>
    implements Iterable<DDBPathMetadata> {
        private final ItemCollection<T> outcome;

        private DDBPathMetadataCollection(ItemCollection<T> outcome) {
            this.outcome = outcome;
        }

        @Override
        public Iterator<DDBPathMetadata> iterator() {
            return new DDBPathMetadataIterator(this.outcome.iterator());
        }
    }
}

