/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.s3a.audit.impl.NoopAuditor;
import org.apache.hadoop.fs.s3a.audit.impl.NoopSpan;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.service.CompositeService;

@InterfaceAudience.Private
public class NoopAuditManagerS3A
extends CompositeService
implements AuditManagerS3A,
NoopSpan.SpanActivationCallbacks {
    private static final NoopAuditor NOOP_AUDITOR = NoopAuditor.createAndStartNoopAuditor(new Configuration(), null);
    private NoopAuditor auditor = NOOP_AUDITOR;
    private final ThreadLocal<AuditSpanS3A> activeSpan = ThreadLocal.withInitial(this::getUnbondedSpan);
    private final String id = UUID.randomUUID().toString();

    public NoopAuditManagerS3A() {
        super("NoopAuditManagerS3A");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        NoopAuditor audit = new NoopAuditor(this);
        OperationAuditorOptions options = OperationAuditorOptions.builder().withConfiguration(conf).withIoStatisticsStore(IOStatisticsBinding.iostatisticsStore().build());
        this.addService(audit);
        audit.init(options);
    }

    @Override
    public String getSpanId() {
        return this.id;
    }

    @Override
    public String getOperationName() {
        return this.getName();
    }

    @Override
    public OperationAuditor getAuditor() {
        return this.auditor;
    }

    private AuditSpanS3A getUnbondedSpan() {
        return this.auditor.getUnbondedSpan();
    }

    public AuditSpanS3A getActiveAuditSpan() {
        return NoopSpan.INSTANCE;
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return NoopAuditManagerS3A.createNewSpan(operation, path1, path2);
    }

    @Override
    public List<RequestHandler2> createRequestHandlers() throws IOException {
        return new ArrayList<RequestHandler2>();
    }

    @Override
    public TransferStateChangeListener createStateChangeListener() {
        return new TransferStateChangeListener(){

            public void transferStateChanged(Transfer transfer, Transfer.TransferState state) {
            }
        };
    }

    @Override
    public boolean checkAccess(Path path, S3AFileStatus status, FsAction mode) throws IOException {
        return this.auditor.checkAccess(path, status, mode);
    }

    @Override
    public void activate(AuditSpanS3A span) {
        this.activeSpan.set(span);
    }

    @Override
    public void deactivate(AuditSpanS3A span) {
        this.activate(this.getUnbondedSpan());
    }

    public static AuditSpanS3A createNewSpan(String name, String path1, String path2) {
        return NOOP_AUDITOR.createSpan(name, path1, path2);
    }
}

