/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.HandlerContextAware;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.SdkBaseException;
import com.amazonaws.handlers.HandlerAfterAttemptContext;
import com.amazonaws.handlers.HandlerBeforeAttemptContext;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.audit.AWSAuditEventCallbacks;
import org.apache.hadoop.fs.s3a.audit.AWSRequestAnalyzer;
import org.apache.hadoop.fs.s3a.audit.AuditFailureException;
import org.apache.hadoop.fs.s3a.audit.AuditIntegration;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.s3a.audit.impl.AbstractAuditSpanImpl;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ActiveAuditManagerS3A
extends CompositeService
implements AuditManagerS3A {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveAuditManagerS3A.class);
    public static final LogExactlyOnce WARN_OF_SPAN_TYPE = new LogExactlyOnce(LOG);
    public static final String AUDIT_MANAGER_OPERATION = "AuditManagerS3A";
    public static final String NOT_A_WRAPPED_SPAN = "Span attached to request is not a wrapped span";
    private OperationAuditor auditor;
    private final AWSRequestAnalyzer analyzer = new AWSRequestAnalyzer();
    private WrappingAuditSpan unbondedSpan;
    private final ThreadLocal<WrappingAuditSpan> activeSpan = ThreadLocal.withInitial(() -> this.getUnbondedSpan());
    private final IOStatisticsStore ioStatisticsStore;

    public ActiveAuditManagerS3A(IOStatisticsStore iostatistics) {
        super("ActiveAuditManagerS3A");
        this.ioStatisticsStore = iostatistics;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        OperationAuditorOptions options = OperationAuditorOptions.builder().withConfiguration(conf).withIoStatisticsStore(this.ioStatisticsStore);
        this.auditor = AuditIntegration.createAndInitAuditor(this.getConfig(), "fs.s3a.audit.service.classname", options);
        this.addService(this.auditor);
        LOG.debug("Audit manager initialized with audit service {}", (Object)this.auditor);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.setUnbondedSpan(new WrappingAuditSpan(this.auditor.getUnbondedSpan(), false));
        LOG.debug("Started audit service {}", (Object)this.auditor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", auditor=").append(this.auditor);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public OperationAuditor getAuditor() {
        return this.auditor;
    }

    private WrappingAuditSpan getUnbondedSpan() {
        return this.unbondedSpan;
    }

    private void setUnbondedSpan(WrappingAuditSpan unbondedSpan) {
        this.unbondedSpan = unbondedSpan;
    }

    public AuditSpanS3A getActiveAuditSpan() {
        return this.activeSpan();
    }

    private WrappingAuditSpan activeSpan() {
        return this.activeSpan.get();
    }

    private AuditSpanS3A setActiveThreadSpan(AuditSpanS3A span) {
        return this.switchToActiveSpan(new WrappingAuditSpan(span, span.isValidSpan()));
    }

    private WrappingAuditSpan switchToActiveSpan(WrappingAuditSpan span) {
        if (span != null && span.isValidSpan()) {
            this.activeSpan.set(span);
        } else {
            this.activeSpan.set(this.unbondedSpan);
        }
        return this.activeSpan();
    }

    @Override
    public String getSpanId() {
        return this.auditor != null ? this.auditor.getAuditorId() : "(auditor not yet created)";
    }

    @Override
    public String getOperationName() {
        return AUDIT_MANAGER_OPERATION;
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        Preconditions.checkState((boolean)this.isInState(Service.STATE.STARTED), (String)"Audit Manager %s is in wrong state: %s", (Object)this, (Object)this.getServiceState());
        this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_SPAN_CREATION.getSymbol());
        return this.setActiveThreadSpan((AuditSpanS3A)this.auditor.createSpan(operation, path1, path2));
    }

    @Override
    public List<RequestHandler2> createRequestHandlers() throws IOException {
        ArrayList<RequestHandler2> requestHandlers = new ArrayList<RequestHandler2>();
        requestHandlers.add(new SdkRequestHandler());
        Class[] handlers = this.getConfig().getClasses("fs.s3a.audit.request.handlers", new Class[0]);
        if (handlers != null) {
            for (Class handler : handlers) {
                try {
                    Constructor ctor = handler.getConstructor(new Class[0]);
                    requestHandlers.add((RequestHandler2)ctor.newInstance(new Object[0]));
                }
                catch (ExceptionInInitializerError e) {
                    throw FutureIO.unwrapInnerException((Throwable)e);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        return requestHandlers;
    }

    @Override
    public TransferStateChangeListener createStateChangeListener() {
        final WrappingAuditSpan span = this.activeSpan();
        return new TransferStateChangeListener(){

            public void transferStateChanged(Transfer transfer, Transfer.TransferState state) {
                ActiveAuditManagerS3A.this.switchToActiveSpan(span);
            }
        };
    }

    @Override
    public boolean checkAccess(Path path, S3AFileStatus status, FsAction mode) throws IOException {
        return this.auditor.checkAccess(path, status, mode);
    }

    @Override
    public <T extends AmazonWebServiceRequest> T requestCreated(T request) {
        AuditSpanS3A span = this.getActiveAuditSpan();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created Request {} in span {}", (Object)this.analyzer.analyze(request), (Object)span);
        }
        AuditIntegration.attachSpanToRequest(request, span);
        try {
            return (T)span.requestCreated(request);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public <T extends AmazonWebServiceRequest> T beforeExecution(T request) {
        this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_REQUEST_EXECUTION.getSymbol());
        try {
            return this.extractAndActivateSpanFromRequest(request).beforeExecution(request);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) throws AuditFailureException, SdkBaseException {
        try {
            this.extractAndActivateSpanFromRequest((HandlerContextAware)request).afterResponse(request, response);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    private <T extends HandlerContextAware> AWSAuditEventCallbacks extractAndActivateSpanFromRequest(T request) {
        AWSAuditEventCallbacks span = AuditIntegration.retrieveAttachedSpan(request);
        if (span == null) {
            LOG.debug("No audit span attached to request {}", request);
            span = this.getActiveAuditSpan();
        } else if (span instanceof WrappingAuditSpan) {
            this.switchToActiveSpan((WrappingAuditSpan)span);
        } else {
            WARN_OF_SPAN_TYPE.warn("Span attached to request is not a wrapped span: {}", new Object[]{span});
            LOG.debug("Span attached to request is not a wrapped span: {}", (Object)span);
        }
        return span;
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception exception) throws AuditFailureException, SdkBaseException {
        try {
            this.extractAndActivateSpanFromRequest((HandlerContextAware)request).afterError(request, response, exception);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        try {
            return this.extractAndActivateSpanFromRequest(request).beforeMarshalling(request);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public void beforeRequest(Request<?> request) {
        try {
            this.extractAndActivateSpanFromRequest((HandlerContextAware)request).beforeRequest(request);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public void beforeAttempt(HandlerBeforeAttemptContext context) {
        try {
            this.extractAndActivateSpanFromRequest(context.getRequest()).beforeAttempt(context);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public void afterAttempt(HandlerAfterAttemptContext context) {
        try {
            this.extractAndActivateSpanFromRequest(context.getRequest()).afterAttempt(context);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
    }

    @Override
    public HttpResponse beforeUnmarshalling(Request<?> request, HttpResponse httpResponse) {
        try {
            this.extractAndActivateSpanFromRequest(request.getOriginalRequest()).beforeUnmarshalling(request, httpResponse);
        }
        catch (AuditFailureException e) {
            this.ioStatisticsStore.incrementCounter(Statistic.AUDIT_FAILURE.getSymbol());
            throw e;
        }
        return httpResponse;
    }

    private final class WrappingAuditSpan
    extends AbstractAuditSpanImpl {
        private final AuditSpanS3A span;
        private final boolean isValid;

        private WrappingAuditSpan(AuditSpanS3A span, boolean isValid) {
            super(span.getSpanId(), span.getTimestamp(), span.getOperationName());
            this.span = Objects.requireNonNull(span);
            this.isValid = isValid;
        }

        private boolean isActive() {
            return this == ActiveAuditManagerS3A.this.getActiveAuditSpan();
        }

        @Override
        public AuditSpanS3A activate() {
            if (!this.isActive()) {
                ActiveAuditManagerS3A.this.switchToActiveSpan(this);
                this.span.activate();
            }
            return this;
        }

        public void deactivate() {
            if (!this.isValid || !this.isActive()) {
                return;
            }
            this.span.deactivate();
            ActiveAuditManagerS3A.this.switchToActiveSpan(ActiveAuditManagerS3A.this.getUnbondedSpan());
        }

        @Override
        public <T extends AmazonWebServiceRequest> T requestCreated(T request) {
            return (T)this.span.requestCreated(request);
        }

        public boolean isValidSpan() {
            return this.isValid && this.span.isValidSpan();
        }

        public void set(String key, String value) {
            this.span.set(key, value);
        }

        @Override
        public <T extends AmazonWebServiceRequest> T beforeExecution(T request) {
            return (T)this.span.beforeExecution(request);
        }

        @Override
        public void afterResponse(Request<?> request, Response<?> response) {
            this.span.afterResponse(request, response);
        }

        @Override
        public void afterError(Request<?> request, Response<?> response, Exception exception) {
            this.span.afterError(request, response, exception);
        }

        @Override
        public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
            return this.span.beforeMarshalling(request);
        }

        @Override
        public void beforeRequest(Request<?> request) {
            this.span.beforeRequest(request);
        }

        @Override
        public void beforeAttempt(HandlerBeforeAttemptContext context) {
            this.span.beforeAttempt(context);
        }

        @Override
        public void afterAttempt(HandlerAfterAttemptContext context) {
            this.span.afterAttempt(context);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("WrappingAuditSpan{");
            sb.append("span=").append(this.span);
            sb.append(", valid=").append(this.isValidSpan());
            sb.append('}');
            return sb.toString();
        }
    }

    private class SdkRequestHandler
    extends RequestHandler2 {
        private SdkRequestHandler() {
        }

        public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest request) {
            return ActiveAuditManagerS3A.this.beforeExecution(request);
        }

        public void afterResponse(Request<?> request, Response<?> response) {
            ActiveAuditManagerS3A.this.afterResponse(request, response);
        }

        public void afterError(Request<?> request, Response<?> response, Exception e) {
            ActiveAuditManagerS3A.this.afterError(request, response, e);
        }

        public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
            return ActiveAuditManagerS3A.this.beforeMarshalling(request);
        }

        public void beforeRequest(Request<?> request) {
            ActiveAuditManagerS3A.this.beforeRequest(request);
        }

        public void beforeAttempt(HandlerBeforeAttemptContext context) {
            ActiveAuditManagerS3A.this.beforeAttempt(context);
        }

        public HttpResponse beforeUnmarshalling(Request<?> request, HttpResponse httpResponse) {
            return ActiveAuditManagerS3A.this.beforeUnmarshalling(request, httpResponse);
        }

        public void afterAttempt(HandlerAfterAttemptContext context) {
            ActiveAuditManagerS3A.this.afterAttempt(context);
        }
    }
}

