/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.Globber;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.MetadataPersistenceException;
import org.apache.hadoop.fs.s3a.MultipartUtils;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.RemoteFileChangedException;
import org.apache.hadoop.fs.s3a.RenameFailedException;
import org.apache.hadoop.fs.s3a.S3ABlockOutputStream;
import org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.S3GuardExistsRetryPolicy;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.s3a.S3ListResult;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.UnknownStoreException;
import org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.audit.AuditIntegration;
import org.apache.hadoop.fs.s3a.audit.AuditManagerS3A;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.RolePolicies;
import org.apache.hadoop.fs.s3a.auth.SignerManager;
import org.apache.hadoop.fs.s3a.auth.delegation.AWSPolicyProvider;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenProvider;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.S3ADelegationTokens;
import org.apache.hadoop.fs.s3a.commit.MagicCommitIntegration;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.impl.BulkDeleteRetryHandler;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.ContextAccessors;
import org.apache.hadoop.fs.s3a.impl.CopyFromLocalOperation;
import org.apache.hadoop.fs.s3a.impl.CopyOutcome;
import org.apache.hadoop.fs.s3a.impl.DeleteOperation;
import org.apache.hadoop.fs.s3a.impl.DirectoryPolicy;
import org.apache.hadoop.fs.s3a.impl.DirectoryPolicyImpl;
import org.apache.hadoop.fs.s3a.impl.ErrorTranslation;
import org.apache.hadoop.fs.s3a.impl.GetContentSummaryOperation;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.fs.s3a.impl.InternalConstants;
import org.apache.hadoop.fs.s3a.impl.ListingOperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.MkdirOperation;
import org.apache.hadoop.fs.s3a.impl.MultiObjectDeleteSupport;
import org.apache.hadoop.fs.s3a.impl.NetworkBinding;
import org.apache.hadoop.fs.s3a.impl.OperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.RenameOperation;
import org.apache.hadoop.fs.s3a.impl.RequestFactoryImpl;
import org.apache.hadoop.fs.s3a.impl.StatusProbeEnum;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.impl.StoreContextBuilder;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.ITtlTimeProvider;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.select.InternalSelectConstants;
import org.apache.hadoop.fs.s3a.select.SelectBinding;
import org.apache.hadoop.fs.s3a.statistics.BlockOutputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.s3a.statistics.impl.BondedS3AStatisticsContext;
import org.apache.hadoop.fs.s3a.tools.MarkerToolOperations;
import org.apache.hadoop.fs.s3a.tools.MarkerToolOperationsImpl;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.store.EtagChecksum;
import org.apache.hadoop.fs.store.audit.ActiveThreadSpanSource;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DelegationTokenIssuer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.LambdaUtils;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileSystem
extends FileSystem
implements StreamCapabilities,
AWSPolicyProvider,
DelegationTokenProvider,
IOStatisticsSource,
AuditSpanSource<AuditSpanS3A>,
ActiveThreadSpanSource<AuditSpanS3A> {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    public static final boolean DELETE_CONSIDERED_IDEMPOTENT = true;
    private URI uri;
    private Path workingDir;
    private String username;
    private AmazonS3 s3;
    private Invoker invoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private Invoker s3guardInvoker = new Invoker(RetryPolicies.TRY_ONCE_THEN_FAIL, Invoker.LOG_EVENT);
    private final Invoker.Retried onRetry = this::operationRetried;
    private String bucket;
    private int maxKeys;
    private Listing listing;
    private long partSize;
    private boolean enableMultiObjectsDelete;
    private TransferManager transfers;
    private ListeningExecutorService boundedThreadPool;
    private ThreadPoolExecutor unboundedThreadPool;
    private int executorCapacity;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private static final Logger PROGRESS = LoggerFactory.getLogger((String)"org.apache.hadoop.fs.s3a.S3AFileSystem.Progress");
    private LocalDirAllocator directoryAllocator;
    private CannedAccessControlList cannedACL;
    private boolean failOnMetadataWriteError;
    private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
    private S3AInstrumentation instrumentation;
    private S3AStatisticsContext statisticsContext;
    private S3AStorageStatistics storageStatistics;
    private long readAhead;
    private S3AInputPolicy inputPolicy;
    private ChangeDetectionPolicy changeDetectionPolicy;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean isClosed = false;
    private MetadataStore metadataStore;
    private boolean allowAuthoritativeMetadataStore;
    private Collection<String> allowAuthoritativePaths;
    private Optional<S3ADelegationTokens> delegationTokens = Optional.empty();
    private UserGroupInformation owner;
    private String blockOutputBuffer;
    private S3ADataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    private WriteOperationHelper writeHelper;
    private boolean useListV1;
    private MagicCommitIntegration committerIntegration;
    private AWSCredentialProviderList credentials;
    private SignerManager signerManager;
    private ITtlTimeProvider ttlTimeProvider;
    private int pageSize;
    private final ListingOperationCallbacks listingOperationCallbacks = new ListingOperationCallbacksImpl();
    private DirectoryPolicy directoryPolicy;
    private final ContextAccessors contextAccessors = new ContextAccessorsImpl();
    private RequestFactory requestFactory;
    private AuditManagerS3A auditManager = AuditIntegration.stubAuditManager();
    private boolean isCSEEnabled;

    private static void addDeprecatedKeys() {
        Configuration.DeprecationDelta[] deltas = new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("fs.s3a.committer.staging.abort.pending.uploads", "fs.s3a.committer.abort.pending.uploads"), new Configuration.DeprecationDelta("fs.s3a.server-side-encryption-algorithm", "fs.s3a.encryption.algorithm"), new Configuration.DeprecationDelta("fs.s3a.server-side-encryption.key", "fs.s3a.encryption.key")};
        if (deltas.length > 0) {
            Configuration.addDeprecations((Configuration.DeprecationDelta[])deltas);
            Configuration.reloadExistingConfigurations();
        }
    }

    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.bucket = name.getHost();
        AuditSpanS3A span = null;
        try {
            LOG.debug("Initializing S3AFileSystem for {}", (Object)this.bucket);
            Configuration conf = S3AUtils.propagateBucketOptions(originalConf, this.bucket);
            conf = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, S3AFileSystem.class);
            conf.setClassLoader(this.getClass().getClassLoader());
            S3AUtils.patchSecurityCredentialProviders(conf);
            boolean delegationTokensEnabled = S3ADelegationTokens.hasDelegationTokenBinding(conf);
            if (delegationTokensEnabled) {
                LOG.debug("Using delegation tokens");
            }
            this.setUri(name, delegationTokensEnabled);
            super.initialize(this.uri, conf);
            this.setConf(conf);
            this.setEncryptionSecrets(S3AUtils.buildEncryptionSecrets(this.bucket, conf));
            this.invoker = new Invoker(new S3ARetryPolicy(this.getConf()), this.onRetry);
            this.instrumentation = new S3AInstrumentation(this.uri);
            this.initializeStatisticsBinding();
            this.isCSEEnabled = S3AEncryptionMethods.CSE_KMS.getMethod().equals(this.getS3EncryptionAlgorithm().getMethod());
            LOG.debug("Client Side Encryption enabled: {}", (Object)this.isCSEEnabled);
            this.setCSEGauge();
            this.owner = UserGroupInformation.getCurrentUser();
            this.username = this.owner.getShortUserName();
            this.workingDir = new Path("/user", this.username).makeQualified(this.uri, this.getWorkingDirectory());
            this.s3guardInvoker = new Invoker(new S3GuardExistsRetryPolicy(this.getConf()), this.onRetry);
            this.failOnMetadataWriteError = conf.getBoolean("fs.s3a.metadatastore.fail.on.write.error", true);
            this.maxKeys = S3AUtils.intOption(conf, "fs.s3a.paging.maximum", 5000, 1);
            this.partSize = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.size", 0x4000000L);
            this.multiPartThreshold = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.threshold", 0x8000000L);
            S3AUtils.longBytesOption(conf, "fs.s3a.block.size", 0x2000000L, 1L);
            this.enableMultiObjectsDelete = conf.getBoolean("fs.s3a.multiobjectdelete.enable", true);
            this.readAhead = S3AUtils.longBytesOption(conf, "fs.s3a.readahead.range", 65536L, 0L);
            this.initThreadPools(conf);
            int listVersion = conf.getInt("fs.s3a.list.version", 2);
            if (listVersion < 1 || listVersion > 2) {
                LOG.warn("Configured fs.s3a.list.version {} is invalid, forcing version 2", (Object)listVersion);
            }
            this.useListV1 = listVersion == 1;
            this.signerManager = new SignerManager(this.bucket, this, conf, this.owner);
            this.signerManager.initCustomSigners();
            this.initializeAuditService();
            this.requestFactory = this.createRequestFactory();
            this.writeHelper = this.createWriteOperationHelper(this.getActiveAuditSpan());
            span = this.createSpan("initialize", this.bucket, null);
            this.bindAWSClient(name, delegationTokensEnabled);
            this.initTransferManager();
            this.doBucketProbing();
            this.inputPolicy = S3AInputPolicy.getPolicy(conf.getTrimmed("fs.s3a.experimental.input.fadvise", "normal"));
            LOG.debug("Input fadvise policy = {}", (Object)this.inputPolicy);
            this.changeDetectionPolicy = ChangeDetectionPolicy.getPolicy(conf);
            LOG.debug("Change detection policy = {}", (Object)this.changeDetectionPolicy);
            boolean magicCommitterEnabled = conf.getBoolean("fs.s3a.committer.magic.enabled", true);
            LOG.debug("Filesystem support for magic committers {} enabled", (Object)(magicCommitterEnabled ? "is" : "is not"));
            this.committerIntegration = new MagicCommitIntegration(this, magicCommitterEnabled);
            boolean blockUploadEnabled = conf.getBoolean("fs.s3a.fast.upload", true);
            if (!blockUploadEnabled) {
                LOG.warn("The \"slow\" output stream is no longer supported");
            }
            this.blockOutputBuffer = conf.getTrimmed("fs.s3a.fast.upload.buffer", "disk");
            this.partSize = S3AUtils.ensureOutputParameterInRange("fs.s3a.multipart.size", this.partSize);
            this.blockFactory = S3ADataBlocks.createFactory(this, this.blockOutputBuffer);
            this.blockOutputActiveBlocks = S3AUtils.intOption(conf, "fs.s3a.fast.upload.active.blocks", 4, 1);
            if (this.isCSEEnabled) {
                this.blockOutputActiveBlocks = 1;
            }
            LOG.debug("Using S3ABlockOutputStream with buffer = {}; block={}; queue limit={}", new Object[]{this.blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks});
            long authDirTtl = conf.getTimeDuration("fs.s3a.metadatastore.metadata.ttl", Constants.DEFAULT_METADATASTORE_METADATA_TTL, TimeUnit.MILLISECONDS);
            this.ttlTimeProvider = new S3Guard.TtlTimeProvider(authDirTtl);
            this.setMetadataStore(S3Guard.getMetadataStore(this, this.ttlTimeProvider));
            this.allowAuthoritativeMetadataStore = conf.getBoolean("fs.s3a.metadatastore.authoritative", false);
            this.allowAuthoritativePaths = S3Guard.getAuthoritativePaths(this);
            if (this.hasMetadataStore()) {
                LOG.debug("Using metadata store {}, authoritative store={}, authoritative path={}", new Object[]{this.getMetadataStore(), this.allowAuthoritativeMetadataStore, this.allowAuthoritativePaths});
                if (this.isCSEEnabled) {
                    throw new PathIOException(this.uri.toString(), "S3-CSE cannot be used with S3Guard");
                }
            }
            if (!this.hasMetadataStore()) {
                String warnLevel = conf.getTrimmed("fs.s3a.s3guard.disabled.warn.level", "SILENT");
                S3Guard.logS3GuardDisabled(LOG, warnLevel, this.bucket);
            }
            this.directoryPolicy = DirectoryPolicyImpl.getDirectoryPolicy(conf, this::allowAuthoritative);
            LOG.debug("Directory marker retention policy is {}", (Object)this.directoryPolicy);
            this.initMultipartUploads(conf);
            this.pageSize = S3AUtils.intOption(this.getConf(), "fs.s3a.bulk.delete.page.size", 250, 0);
            org.apache.hadoop.util.Preconditions.checkArgument((this.pageSize <= 1000 ? 1 : 0) != 0, (String)"page size out of range: %s", (Object[])new Object[]{this.pageSize});
            this.listing = new Listing(this.listingOperationCallbacks, this.createStoreContext());
        }
        catch (AmazonClientException e) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{span});
            this.stopAllServices();
            throw S3AUtils.translateException("initializing ", new Path(name), e);
        }
        catch (IOException | RuntimeException e) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{span});
            this.stopAllServices();
            throw e;
        }
    }

    private void setCSEGauge() {
        IOStatisticsStore ioStatisticsStore = (IOStatisticsStore)this.getIOStatistics();
        if (this.isCSEEnabled) {
            ioStatisticsStore.setGauge(Statistic.CLIENT_SIDE_ENCRYPTION_ENABLED.getSymbol(), 1L);
        } else {
            ioStatisticsStore.setGauge(Statistic.CLIENT_SIDE_ENCRYPTION_ENABLED.getSymbol(), 0L);
        }
    }

    private void doBucketProbing() throws IOException {
        int bucketProbe = this.getConf().getInt("fs.s3a.bucket.probe", 0);
        Preconditions.checkArgument((bucketProbe >= 0 ? 1 : 0) != 0, (Object)"Value of fs.s3a.bucket.probe should be >= 0");
        switch (bucketProbe) {
            case 0: {
                LOG.debug("skipping check for bucket existence");
                break;
            }
            case 1: {
                NetworkBinding.logDnsLookup(this.getConf());
                this.verifyBucketExists();
                break;
            }
            case 2: {
                NetworkBinding.logDnsLookup(this.getConf());
                this.verifyBucketExistsV2();
                break;
            }
            default: {
                LOG.warn("Unknown bucket probe option {}: {}; falling back to check #2", (Object)"fs.s3a.bucket.probe", (Object)bucketProbe);
                this.verifyBucketExistsV2();
            }
        }
    }

    protected void initializeStatisticsBinding() {
        this.storageStatistics = S3AFileSystem.createStorageStatistics(Objects.requireNonNull(this.getIOStatistics()));
        this.statisticsContext = new BondedS3AStatisticsContext(new BondedS3AStatisticsContext.S3AFSStatisticsSource(){

            @Override
            public S3AInstrumentation getInstrumentation() {
                return S3AFileSystem.this.getInstrumentation();
            }

            @Override
            public FileSystem.Statistics getInstanceStatistics() {
                return S3AFileSystem.this.statistics;
            }
        });
    }

    private void initThreadPools(Configuration conf) {
        String name = "s3a-transfer-" + this.getBucket();
        int maxThreads = conf.getInt("fs.s3a.threads.max", 10);
        if (maxThreads < 2) {
            LOG.warn("fs.s3a.threads.max must be at least 2: forcing to 2.");
            maxThreads = 2;
        }
        int totalTasks = S3AUtils.intOption(conf, "fs.s3a.max.total.tasks", 32, 1);
        long keepAliveTime = S3AUtils.longOption(conf, "fs.s3a.threads.keepalivetime", 60L, 0L);
        this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance((int)maxThreads, (int)(maxThreads + totalTasks), (long)keepAliveTime, (TimeUnit)TimeUnit.SECONDS, (String)(name + "-bounded"));
        this.unboundedThreadPool = new ThreadPoolExecutor(maxThreads, Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory((String)(name + "-unbounded")));
        this.unboundedThreadPool.allowCoreThreadTimeOut(true);
        this.executorCapacity = S3AUtils.intOption(conf, "fs.s3a.executor.capacity", 16, 1);
    }

    protected static S3AStorageStatistics createStorageStatistics(IOStatistics ioStatistics) {
        return (S3AStorageStatistics)GlobalStorageStatistics.INSTANCE.put("S3AStorageStatistics", () -> new S3AStorageStatistics(ioStatistics));
    }

    protected void verifyBucketExists() throws UnknownStoreException, IOException {
        if (!((Boolean)this.invoker.retry("doesBucketExist", this.bucket, true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.STORE_EXISTS_PROBE.getSymbol(), () -> this.s3.doesBucketExist(this.bucket)))).booleanValue()) {
            throw new UnknownStoreException("s3a://" + this.bucket + "/", " Bucket does not exist");
        }
    }

    protected void verifyBucketExistsV2() throws UnknownStoreException, IOException {
        if (!((Boolean)this.invoker.retry("doesBucketExistV2", this.bucket, true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.STORE_EXISTS_PROBE.getSymbol(), () -> this.s3.doesBucketExistV2(this.bucket)))).booleanValue()) {
            throw new UnknownStoreException("s3a://" + this.bucket + "/", " Bucket does not exist");
        }
    }

    @VisibleForTesting
    public S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @VisibleForTesting
    public FileSystem.Statistics getFsStatistics() {
        return this.statistics;
    }

    public Listing getListing() {
        return this.listing;
    }

    private void bindAWSClient(URI name, boolean dtEnabled) throws IOException {
        Configuration conf = this.getConf();
        this.credentials = null;
        String uaSuffix = "";
        if (dtEnabled) {
            LOG.debug("Using delegation tokens");
            S3ADelegationTokens tokens = new S3ADelegationTokens();
            this.delegationTokens = Optional.of(tokens);
            tokens.bindToFileSystem(this.getCanonicalUri(), this);
            tokens.init(conf);
            tokens.start();
            if (tokens.isBoundToDT()) {
                LOG.debug("Using existing delegation token");
            } else {
                LOG.debug("No delegation token for this instance");
            }
            this.credentials = tokens.getCredentialProviders();
            tokens.getEncryptionSecrets().ifPresent(this::setEncryptionSecrets);
            uaSuffix = tokens.getUserAgentField();
        } else {
            this.credentials = S3AUtils.createAWSCredentialProviderSet(name, conf);
        }
        LOG.debug("Using credential provider {}", (Object)this.credentials);
        Class s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
        S3ClientFactory.S3ClientCreationParameters parameters = null;
        parameters = new S3ClientFactory.S3ClientCreationParameters().withCredentialSet(this.credentials).withEndpoint(conf.getTrimmed("fs.s3a.endpoint", "")).withMetrics(this.statisticsContext.newStatisticsFromAwsSdk()).withPathStyleAccess(conf.getBoolean("fs.s3a.path.style.access", false)).withUserAgentSuffix(uaSuffix).withRequestHandlers(this.auditManager.createRequestHandlers());
        this.s3 = ((S3ClientFactory)ReflectionUtils.newInstance((Class)s3ClientFactoryClass, (Configuration)conf)).createS3Client(this.getUri(), parameters);
    }

    @VisibleForTesting
    public DelegationOperations createDelegationOperations() {
        return new DelegationOperationsImpl();
    }

    protected void initializeAuditService() throws IOException {
        this.auditManager = AuditIntegration.createAndStartAuditManager(this.getConf(), this.instrumentation.createMetricsUpdatingStore());
    }

    @InterfaceAudience.Private
    public AuditManagerS3A getAuditManager() {
        return this.auditManager;
    }

    @InterfaceAudience.Private
    public OperationAuditor getAuditor() {
        return this.getAuditManager().getAuditor();
    }

    @InterfaceAudience.Private
    public AuditSpanS3A getActiveAuditSpan() {
        return (AuditSpanS3A)this.getAuditManager().getActiveAuditSpan();
    }

    @InterfaceAudience.Private
    public AuditSpanSource getAuditSpanSource() {
        return this;
    }

    public AuditSpanS3A createSpan(String operation, @Nullable String path1, @Nullable String path2) throws IOException {
        return (AuditSpanS3A)this.getAuditManager().createSpan(operation, path1, path2);
    }

    protected RequestFactory createRequestFactory() {
        long partCountLimit = S3AUtils.longOption(this.getConf(), "fs.s3a.internal.upload.part.count.limit", 10000L, 1L);
        if (partCountLimit != 10000L) {
            LOG.warn("Configuration property {} shouldn't be overridden by client", (Object)"fs.s3a.internal.upload.part.count.limit");
        }
        this.initCannedAcls(this.getConf());
        return RequestFactoryImpl.builder().withBucket(Objects.requireNonNull(this.bucket)).withCannedACL(this.getCannedACL()).withEncryptionSecrets(Objects.requireNonNull(this.encryptionSecrets)).withMultipartPartCountLimit(partCountLimit).withRequestPreparer(this.getAuditManager()::requestCreated).build();
    }

    @VisibleForTesting
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    protected void setEncryptionSecrets(EncryptionSecrets secrets) {
        this.encryptionSecrets = secrets;
        if (this.requestFactory != null) {
            this.requestFactory.setEncryptionSecrets(secrets);
        }
    }

    public EncryptionSecrets getEncryptionSecrets() {
        return this.encryptionSecrets;
    }

    private void initTransferManager() {
        TransferManagerConfiguration transferConfiguration = new TransferManagerConfiguration();
        transferConfiguration.setMinimumUploadPartSize(this.partSize);
        transferConfiguration.setMultipartUploadThreshold(this.multiPartThreshold);
        transferConfiguration.setMultipartCopyPartSize(this.partSize);
        transferConfiguration.setMultipartCopyThreshold(this.multiPartThreshold);
        this.transfers = new TransferManager(this.s3, (ExecutorService)this.unboundedThreadPool);
        this.transfers.setConfiguration(transferConfiguration);
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? CannedAccessControlList.valueOf((String)cannedACLName) : null;
    }

    private void initMultipartUploads(Configuration conf) throws IOException {
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        long purgeExistingMultipartAge = S3AUtils.longOption(conf, "fs.s3a.multipart.purge.age", 86400L, 0L);
        if (purgeExistingMultipart) {
            try {
                this.abortOutstandingMultipartUploads(purgeExistingMultipartAge);
            }
            catch (AccessDeniedException e) {
                this.instrumentation.errorIgnored();
                LOG.debug("Failed to purge multipart uploads against {}, FS may be read only", (Object)this.bucket);
            }
        }
    }

    public void abortOutstandingMultipartUploads(long seconds) throws IOException {
        Preconditions.checkArgument((seconds >= 0L ? 1 : 0) != 0);
        Date purgeBefore = new Date(new Date().getTime() - seconds * 1000L);
        LOG.debug("Purging outstanding multipart uploads older than {}", (Object)purgeBefore);
        this.invoker.retry("Purging multipart uploads", this.bucket, true, () -> this.transfers.abortMultipartUploads(this.bucket, purgeBefore));
    }

    public String getScheme() {
        return "s3a";
    }

    public URI getUri() {
        return this.uri;
    }

    @VisibleForTesting
    protected void setUri(URI fsUri, boolean canonicalize) {
        URI u = S3xLoginHelper.buildFSURI(fsUri);
        this.uri = canonicalize ? u : this.canonicalizeUri(u);
    }

    public URI getCanonicalUri() {
        return this.uri;
    }

    @VisibleForTesting
    public int getDefaultPort() {
        return 0;
    }

    AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    public AmazonS3 getAmazonS3ClientForTesting(String reason) {
        LOG.warn("Access to S3A client requested, reason {}", (Object)reason);
        return this.s3;
    }

    protected void setAmazonS3Client(AmazonS3 client) {
        Preconditions.checkNotNull((Object)client, (Object)"client");
        LOG.debug("Setting S3 client to {}", (Object)client);
        this.s3 = client;
        this.initThreadPools(this.getConf());
        this.initTransferManager();
    }

    @InterfaceAudience.LimitedPrivate(value={"diagnostics"})
    public String getBucketLocation() throws IOException {
        return this.getBucketLocation(this.bucket);
    }

    @VisibleForTesting
    public String getBucketLocation(String bucketName) throws IOException {
        String region = (String)this.trackDurationAndSpan(Statistic.STORE_EXISTS_PROBE, bucketName, null, () -> (String)this.invoker.retry("getBucketLocation()", bucketName, true, () -> this.s3.getBucketLocation(bucketName)));
        return NetworkBinding.fixBucketRegion(region);
    }

    @VisibleForTesting
    long getReadAheadRange() {
        return this.readAhead;
    }

    @InterfaceStability.Unstable
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    @VisibleForTesting
    public ChangeDetectionPolicy getChangeDetectionPolicy() {
        return this.changeDetectionPolicy;
    }

    public S3AEncryptionMethods getS3EncryptionAlgorithm() {
        return this.encryptionSecrets.getEncryptionMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        if (this.directoryAllocator == null) {
            S3AFileSystem s3AFileSystem = this;
            synchronized (s3AFileSystem) {
                String bufferDir = conf.get("fs.s3a.buffer.dir") != null ? "fs.s3a.buffer.dir" : "hadoop.tmp.dir";
                this.directoryAllocator = new LocalDirAllocator(bufferDir);
            }
        }
        Path path = this.directoryAllocator.getLocalPathForWrite(pathStr, size, conf);
        File dir = new File(path.getParent().toUri().getPath());
        String prefix = path.getName();
        return File.createTempFile(prefix, null, dir);
    }

    public String getBucket() {
        return this.bucket;
    }

    @VisibleForTesting
    protected void setBucket(String bucket) {
        this.bucket = bucket;
    }

    CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    @InterfaceStability.Unstable
    public void setInputPolicy(S3AInputPolicy inputPolicy) {
        Objects.requireNonNull(inputPolicy, "Null inputStrategy");
        LOG.debug("Setting input strategy: {}", (Object)inputPolicy);
        this.inputPolicy = inputPolicy;
    }

    @VisibleForTesting
    public String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    @InterfaceAudience.Private
    public String maybeAddTrailingSlash(String key) {
        return S3AUtils.maybeAddTrailingSlash(key);
    }

    Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public Path keyToQualifiedPath(String key) {
        return this.qualify(this.keyToPath(key));
    }

    public Path makeQualified(Path path) {
        String urlString;
        Path q = super.makeQualified(path);
        if (!q.isRoot() && (urlString = q.toUri().toString()).endsWith("/")) {
            LOG.debug("Stripping trailing '/' from {}", (Object)q);
            q = new Path(urlString.substring(0, urlString.length() - 1));
        }
        if (!q.isRoot() && q.getName().isEmpty()) {
            q = q.getParent();
        }
        return q;
    }

    public Path qualify(Path path) {
        return this.makeQualified(path);
    }

    public void checkPath(Path path) {
        S3xLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return S3xLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.open(f, Optional.empty(), Optional.empty());
    }

    private FSDataInputStream open(Path file, Optional<Configuration> options, Optional<S3AFileStatus> providedStatus) throws IOException {
        S3AReadOpContext readContext;
        Path path = this.qualify(file);
        AuditSpan auditSpan = this.entryPoint(Statistic.INVOCATION_OPEN, path);
        S3AFileStatus fileStatus = this.extractOrFetchSimpleFileStatus(path, providedStatus);
        if (options.isPresent()) {
            Configuration o = options.get();
            S3AInputPolicy policy = S3AInputPolicy.getPolicy(o.get("fs.s3a.experimental.input.fadvise", this.inputPolicy.toString()));
            long readAheadRange2 = o.getLong("fs.s3a.readahead.range", this.readAhead);
            readContext = this.createReadContext(fileStatus, policy, this.changeDetectionPolicy, readAheadRange2, auditSpan);
        } else {
            readContext = this.createReadContext(fileStatus, this.inputPolicy, this.changeDetectionPolicy, this.readAhead, auditSpan);
        }
        LOG.debug("Opening '{}'", (Object)readContext);
        return new FSDataInputStream((InputStream)((Object)new S3AInputStream(readContext, this.createObjectAttributes(fileStatus), this.createInputStreamCallbacks(auditSpan))));
    }

    private S3AInputStream.InputStreamCallbacks createInputStreamCallbacks(AuditSpan auditSpan) {
        return new InputStreamCallbacksImpl(auditSpan);
    }

    @VisibleForTesting
    protected S3AReadOpContext createReadContext(FileStatus fileStatus, S3AInputPolicy seekPolicy, ChangeDetectionPolicy changePolicy, long readAheadRange, AuditSpan auditSpan) {
        return new S3AReadOpContext(fileStatus.getPath(), this.hasMetadataStore(), this.invoker, this.s3guardInvoker, this.statistics, this.statisticsContext, fileStatus, seekPolicy, changePolicy, readAheadRange, auditSpan);
    }

    private S3ObjectAttributes createObjectAttributes(Path f, String eTag, String versionId, long len) {
        return new S3ObjectAttributes(this.bucket, f, this.pathToKey(f), this.getS3EncryptionAlgorithm(), this.encryptionSecrets.getEncryptionKey(), eTag, versionId, len);
    }

    private S3ObjectAttributes createObjectAttributes(S3AFileStatus fileStatus) {
        return this.createObjectAttributes(fileStatus.getPath(), fileStatus.getEtag(), fileStatus.getVersionId(), fileStatus.getLen());
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path path = this.qualify(f);
        return (FSDataOutputStream)this.trackDurationAndSpan(Statistic.INVOCATION_CREATE, path, () -> this.innerCreateFile(path, permission, overwrite, bufferSize, replication, blockSize, progress));
    }

    private FSDataOutputStream innerCreateFile(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String key = this.pathToKey(path);
        S3AFileStatus status = null;
        try {
            status = this.innerGetFileStatus(path, false, overwrite ? StatusProbeEnum.DIRECTORIES : StatusProbeEnum.ALL);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(path + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(path + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.instrumentation.fileCreated();
        PutTracker putTracker = this.committerIntegration.createTracker(path, key);
        String destKey = putTracker.getDestKey();
        BlockOutputStreamStatistics outputStreamStatistics = this.statisticsContext.newOutputStreamStatistics();
        S3ABlockOutputStream.BlockOutputStreamBuilder builder = S3ABlockOutputStream.builder().withKey(destKey).withBlockFactory(this.blockFactory).withBlockSize(this.partSize).withStatistics(outputStreamStatistics).withProgress(progress).withPutTracker(putTracker).withWriteOperations(this.createWriteOperationHelper(this.getActiveAuditSpan())).withExecutorService((ExecutorService)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true)).withDowngradeSyncableExceptions(this.getConf().getBoolean("fs.s3a.downgrade.syncable.exceptions", false)).withCSEEnabled(this.isCSEEnabled);
        return new FSDataOutputStream((OutputStream)new S3ABlockOutputStream(builder), null);
    }

    @InterfaceAudience.Private
    public WriteOperationHelper getWriteOperationHelper() {
        return this.createWriteOperationHelper(this.getActiveAuditSpan());
    }

    @InterfaceAudience.Private
    public WriteOperationHelper createWriteOperationHelper(AuditSpan auditSpan) {
        return new WriteOperationHelper(this, this.getConf(), this.statisticsContext, this.getAuditSpanSource(), auditSpan);
    }

    public FSDataOutputStream createNonRecursive(Path p, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path path = this.makeQualified(p);
        try (AuditSpan span = this.entryPoint(Statistic.INVOCATION_CREATE_NON_RECURSIVE, path);){
            Path parent = path.getParent();
            if (parent != null && !parent.isRoot()) {
                S3AFileStatus status;
                try {
                    status = this.innerGetFileStatus(parent, false, StatusProbeEnum.DIRECTORIES);
                }
                catch (FileNotFoundException e) {
                    status = this.innerGetFileStatus(parent, false, StatusProbeEnum.HEAD_ONLY);
                }
                if (!status.isDirectory()) {
                    throw new FileAlreadyExistsException("Not a directory: " + parent);
                }
            }
            FSDataOutputStream fSDataOutputStream = this.innerCreateFile(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
            return fSDataOutputStream;
        }
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported by S3AFileSystem");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        try {
            long bytesCopied = (Long)this.trackDurationAndSpan(Statistic.INVOCATION_RENAME, src.toString(), dst.toString(), () -> this.innerRename(src, dst));
            LOG.debug("Copied {} bytes", (Object)bytesCopied);
            return true;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("rename(" + src + ", " + dst + ")", src, e);
        }
        catch (RenameFailedException e) {
            LOG.info("{}", (Object)e.getMessage());
            LOG.debug("rename failure", (Throwable)((Object)e));
            return e.getExitCode();
        }
    }

    private Pair<S3AFileStatus, S3AFileStatus> initiateRename(Path src, Path dst) throws IOException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        block13: {
            String srcKey = this.pathToKey(src);
            String dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "source is root directory");
            }
            if (dstKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "dest is root directory");
            }
            srcStatus = this.innerGetFileStatus(src, true, StatusProbeEnum.ALL);
            if (srcKey.equals(dstKey)) {
                LOG.debug("rename: src and dest refer to the same file or directory: {}", (Object)dst);
                throw new RenameFailedException(src, dst, "source and dest refer to the same file or directory").withExitCode(srcStatus.isFile());
            }
            dstStatus = null;
            try {
                dstStatus = this.innerGetFileStatus(dst, true, StatusProbeEnum.ALL);
                if (srcStatus.isDirectory()) {
                    if (dstStatus.isFile()) {
                        throw new FileAlreadyExistsException("Failed to rename " + src + " to " + dst + "; source is a directory and dest is a file");
                    }
                    if (dstStatus.isEmptyDirectory() != Tristate.TRUE) {
                        throw new RenameFailedException(src, dst, "Destination is a non-empty directory").withExitCode(false);
                    }
                } else if (dstStatus.isFile()) {
                    throw new FileAlreadyExistsException("Failed to rename " + src + " to " + dst + "; destination file exists");
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("rename: destination path {} not found", (Object)dst);
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty() || parent.equals((Object)src.getParent())) break block13;
                try {
                    S3AFileStatus dstParentStatus = this.innerGetFileStatus(parent, false, StatusProbeEnum.FILE);
                    if (!dstParentStatus.isDirectory()) {
                        throw new RenameFailedException(src, dst, "destination parent is not a directory");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return Pair.of((Object)((Object)srcStatus), (Object)((Object)dstStatus));
    }

    private long innerRename(Path source, Path dest) throws RenameFailedException, FileNotFoundException, IOException, AmazonClientException {
        Path src = this.qualify(source);
        Path dst = this.qualify(dest);
        LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
        String srcKey = this.pathToKey(src);
        String dstKey = this.pathToKey(dst);
        Pair<S3AFileStatus, S3AFileStatus> p = this.initiateRename(src, dst);
        RenameOperation renameOperation = new RenameOperation(this.createStoreContext(), src, srcKey, (S3AFileStatus)((Object)p.getLeft()), dst, dstKey, (S3AFileStatus)((Object)p.getRight()), new OperationCallbacksImpl(), this.pageSize);
        return renameOperation.execute();
    }

    @Override
    public Token<? extends TokenIdentifier> getFsDelegationToken() throws IOException {
        return this.getDelegationToken(null);
    }

    @InterfaceAudience.LimitedPrivate(value={"utilities"})
    @InterfaceStability.Evolving
    @VisibleForTesting
    public ObjectMetadata getObjectMetadata(Path path) throws IOException {
        return (ObjectMetadata)this.trackDurationAndSpan(Statistic.INVOCATION_GET_FILE_STATUS, path, () -> this.getObjectMetadata(this.makeQualified(path), null, this.invoker, "getObjectMetadata"));
    }

    private ObjectMetadata getObjectMetadata(Path path, ChangeTracker changeTracker, Invoker changeInvoker, String operation) throws IOException {
        String key = this.pathToKey(path);
        return (ObjectMetadata)Invoker.once(operation, key, () -> this.getObjectMetadata(key, changeTracker, changeInvoker, operation));
    }

    public boolean hasMetadataStore() {
        return !S3Guard.isNullMetadataStore(this.metadataStore);
    }

    @VisibleForTesting
    public boolean hasAuthoritativeMetadataStore() {
        return this.hasMetadataStore() && this.allowAuthoritativeMetadataStore;
    }

    @VisibleForTesting
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @VisibleForTesting
    void setMetadataStore(MetadataStore ms) {
        Preconditions.checkNotNull((Object)ms);
        this.metadataStore = ms;
    }

    protected AuditSpan entryPoint(Statistic operation, Path path) throws IOException {
        return this.entryPoint(operation, path != null ? this.pathToKey(path) : null, null);
    }

    protected AuditSpan entryPoint(Statistic operation, @Nullable String path1, @Nullable String path2) throws IOException {
        this.checkNotClosed();
        this.incrementStatistic(operation);
        return this.createSpan(operation.getSymbol(), path1, path2);
    }

    private <B> B trackDurationAndSpan(Statistic statistic, String path, String path2, CallableRaisingIOE<B> input) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(statistic.getSymbol(), path, path2);){
            Object object = IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)statistic.getSymbol(), input);
            return (B)object;
        }
    }

    private <B> B trackDurationAndSpan(Statistic statistic, @Nullable Path path, CallableRaisingIOE<B> input) throws IOException {
        return this.trackDurationAndSpan(statistic, path != null ? this.pathToKey(path) : null, null, input);
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.statisticsContext.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.statisticsContext.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.statisticsContext.incrementGauge(statistic, count);
    }

    public void operationRetried(Exception ex) {
        if (S3AUtils.isThrottleException(ex)) {
            this.operationThrottled(false);
        } else {
            this.incrementStatistic(Statistic.STORE_IO_RETRY);
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    public void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        this.operationRetried(ex);
    }

    public void metastoreOperationRetried(Exception ex, int retries, boolean idempotent) {
        this.incrementStatistic(Statistic.S3GUARD_METADATASTORE_RETRY);
        if (S3AUtils.isThrottleException(ex)) {
            this.operationThrottled(true);
        } else {
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    private void operationThrottled(boolean metastore) {
        LOG.debug("Request throttled on {}", (Object)(metastore ? "S3" : "DynamoDB"));
        if (metastore) {
            this.incrementStatistic(Statistic.S3GUARD_METADATASTORE_THROTTLED);
            this.statisticsContext.addValueToQuantiles(Statistic.S3GUARD_METADATASTORE_THROTTLE_RATE, 1L);
        } else {
            this.incrementStatistic(Statistic.STORE_IO_THROTTLED);
            this.statisticsContext.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, 1L);
        }
    }

    public S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    public IOStatistics getIOStatistics() {
        return this.instrumentation != null ? this.instrumentation.getIOStatistics() : null;
    }

    protected DurationTrackerFactory getDurationTrackerFactory() {
        return this.instrumentation != null ? this.instrumentation.getDurationTrackerFactory() : null;
    }

    @InterfaceAudience.LimitedPrivate(value={"external utilities"})
    @VisibleForTesting
    ObjectMetadata getObjectMetadata(String key) throws IOException {
        return this.getObjectMetadata(key, null, this.invoker, "getObjectMetadata");
    }

    protected ObjectMetadata getObjectMetadata(String key, ChangeTracker changeTracker, Invoker changeInvoker, String operation) throws IOException {
        ObjectMetadata meta = (ObjectMetadata)changeInvoker.retryUntranslated("GET " + key, true, () -> {
            GetObjectMetadataRequest request = this.getRequestFactory().newGetObjectMetadataRequest(key);
            this.incrementStatistic(Statistic.OBJECT_METADATA_REQUESTS);
            try (DurationTracker duration = this.getDurationTrackerFactory().trackDuration(Statistic.ACTION_HTTP_HEAD_REQUEST.getSymbol());){
                LOG.debug("HEAD {} with change tracker {}", (Object)key, (Object)changeTracker);
                if (changeTracker != null) {
                    changeTracker.maybeApplyConstraint(request);
                }
                ObjectMetadata objectMetadata = this.s3.getObjectMetadata(request);
                if (changeTracker != null) {
                    changeTracker.processMetadata(objectMetadata, operation);
                }
                ObjectMetadata objectMetadata2 = objectMetadata;
                return objectMetadata2;
            }
        });
        this.incrementReadOperations();
        return meta;
    }

    protected S3ListResult listObjects(S3ListRequest request, @Nullable DurationTrackerFactory trackerFactory) throws IOException {
        this.incrementReadOperations();
        LOG.debug("LIST {}", (Object)request);
        this.validateListArguments(request);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "LIST", new Object[0]);){
            S3ListResult s3ListResult = (S3ListResult)this.invoker.retryUntranslated(request.toString(), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)trackerFactory, (String)"object_list_request", () -> {
                if (this.useListV1) {
                    return S3ListResult.v1(this.s3.listObjects(request.getV1()));
                }
                return S3ListResult.v2(this.s3.listObjectsV2(request.getV2()));
            }));
            return s3ListResult;
        }
    }

    private void validateListArguments(S3ListRequest request) {
        if (this.useListV1) {
            Preconditions.checkArgument((boolean)request.isV1());
        } else {
            Preconditions.checkArgument((!request.isV1() ? 1 : 0) != 0);
        }
    }

    protected S3ListResult continueListObjects(S3ListRequest request, S3ListResult prevResult, DurationTrackerFactory trackerFactory) throws IOException {
        this.incrementReadOperations();
        this.validateListArguments(request);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "LIST (continued)", new Object[0]);){
            S3ListResult s3ListResult = (S3ListResult)this.invoker.retryUntranslated(request.toString(), true, IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)trackerFactory, (String)"object_continue_list_request", () -> {
                if (this.useListV1) {
                    return S3ListResult.v1(this.s3.listNextBatchOfObjects(this.getRequestFactory().newListNextBatchOfObjectsRequest(prevResult.getV1())));
                }
                request.getV2().setContinuationToken(prevResult.getV2().getNextContinuationToken());
                return S3ListResult.v2(this.s3.listObjectsV2(request.getV2()));
            }));
            return s3ListResult;
        }
    }

    public void incrementReadOperations() {
        this.statistics.incrementReadOps(1);
    }

    public void incrementWriteOperations() {
        this.statistics.incrementWriteOps(1);
    }

    @VisibleForTesting
    protected void deleteObject(String key) throws AmazonClientException, IOException {
        this.blockRootDelete(key);
        this.incrementWriteOperations();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "deleting %s", new Object[]{key});){
            this.invoker.retryUntranslated(String.format("Delete %s:/%s", this.bucket, key), true, () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_OBJECTS);
                IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_DELETE_REQUEST.getSymbol(), () -> this.s3.deleteObject(this.getRequestFactory().newDeleteObjectRequest(key)));
                return null;
            });
        }
    }

    void deleteObjectAtPath(Path f, String key, boolean isFile, @Nullable BulkOperationState operationState) throws AmazonClientException, IOException {
        if (isFile) {
            this.instrumentation.fileDeleted(1);
        } else {
            this.instrumentation.directoryDeleted();
        }
        this.deleteObject(key);
        this.metadataStore.delete(f, operationState);
    }

    private void blockRootDelete(String key) throws InvalidRequestException {
        if (key.isEmpty() || "/".equals(key)) {
            throw new InvalidRequestException("Bucket " + this.bucket + " cannot be deleted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteRequest) throws MultiObjectDeleteException, AmazonClientException, IOException {
        this.incrementWriteOperations();
        BulkDeleteRetryHandler retryHandler = new BulkDeleteRetryHandler(this.createStoreContext());
        int keyCount = deleteRequest.getKeys().size();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "DELETE %d keys", new Object[]{keyCount});){
            DeleteObjectsResult deleteObjectsResult = (DeleteObjectsResult)this.invoker.retryUntranslated("delete", true, (text, e, r, i) -> retryHandler.bulkDeleteRetried(deleteRequest, e), IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_BULK_DELETE_REQUEST.getSymbol(), () -> {
                this.incrementStatistic(Statistic.OBJECT_DELETE_OBJECTS, keyCount);
                return this.s3.deleteObjects(deleteRequest);
            }));
            return deleteObjectsResult;
        }
        catch (MultiObjectDeleteException e2) {
            List errors = e2.getErrors();
            LOG.debug("Partial failure of delete, {} errors", (Object)errors.size(), (Object)e2);
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                MultiObjectDeleteException.DeleteError error = (MultiObjectDeleteException.DeleteError)iterator.next();
                LOG.debug("{}: \"{}\" - {}", new Object[]{error.getKey(), error.getCode(), error.getMessage()});
            }
            throw e2;
        }
    }

    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, File srcfile) {
        return this.requestFactory.newPutObjectRequest(key, metadata, srcfile);
    }

    public ObjectMetadata newObjectMetadata(long length) {
        return this.requestFactory.newObjectMetadata(length);
    }

    public UploadInfo putObject(PutObjectRequest putObjectRequest) {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {} via transfer manager ", (Object)len, (Object)putObjectRequest.getKey());
        this.incrementPutStartStatistics(len);
        Upload upload = this.transfers.upload(putObjectRequest);
        return new UploadInfo(upload, len);
    }

    @VisibleForTesting
    PutObjectResult putObjectDirect(PutObjectRequest putObjectRequest) throws AmazonClientException, MetadataPersistenceException {
        long len = this.getPutRequestLength(putObjectRequest);
        LOG.debug("PUT {} bytes to {}", (Object)len, (Object)putObjectRequest.getKey());
        this.incrementPutStartStatistics(len);
        try {
            PutObjectResult result = (PutObjectResult)IOStatisticsBinding.trackDurationOfSupplier((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_PUT_REQUESTS.getSymbol(), () -> this.s3.putObject(putObjectRequest));
            this.incrementPutCompletedStatistics(true, len);
            this.finishedWrite(putObjectRequest.getKey(), len, result.getETag(), result.getVersionId(), null);
            return result;
        }
        catch (SdkBaseException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    private long getPutRequestLength(PutObjectRequest putObjectRequest) {
        long len = putObjectRequest.getFile() != null ? putObjectRequest.getFile().length() : putObjectRequest.getMetadata().getContentLength();
        Preconditions.checkState((len >= 0L ? 1 : 0) != 0, (Object)"Cannot PUT object of unknown length");
        return len;
    }

    UploadPartResult uploadPart(UploadPartRequest request) throws AmazonClientException {
        long len = request.getPartSize();
        this.incrementPutStartStatistics(len);
        try {
            UploadPartResult uploadPartResult = this.s3.uploadPart(request);
            this.incrementPutCompletedStatistics(true, len);
            return uploadPartResult;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    public void incrementPutStartStatistics(long bytes) {
        LOG.debug("PUT start {} bytes", (Object)bytes);
        this.incrementWriteOperations();
        this.incrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
        if (bytes > 0L) {
            this.incrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
    }

    public void incrementPutCompletedStatistics(boolean success, long bytes) {
        LOG.debug("PUT completed success={}; {} bytes", (Object)success, (Object)bytes);
        if (bytes > 0L) {
            this.incrementStatistic(Statistic.OBJECT_PUT_BYTES, bytes);
            this.decrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS_COMPLETED);
        this.decrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
    }

    public void incrementPutProgressStatistics(String key, long bytes) {
        PROGRESS.debug("PUT {}: {} bytes", (Object)key, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.statistics.incrementBytesWritten(bytes);
        }
    }

    private void removeKeysS3(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, boolean quiet) throws MultiObjectDeleteException, AmazonClientException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating delete operation for {} objects", (Object)keysToDelete.size());
            for (DeleteObjectsRequest.KeyVersion key : keysToDelete) {
                LOG.debug(" {} {}", (Object)key.getKey(), (Object)(key.getVersion() != null ? key.getVersion() : ""));
            }
        }
        if (keysToDelete.isEmpty()) {
            return;
        }
        for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
            this.blockRootDelete(keyVersion.getKey());
        }
        try {
            if (this.enableMultiObjectsDelete) {
                if (keysToDelete.size() <= this.pageSize) {
                    this.deleteObjects(this.getRequestFactory().newBulkDeleteRequest(keysToDelete, true));
                } else {
                    LOG.debug("Partitioning the keys to delete as it is more than page size. Number of keys: {}, Page size: {}", (Object)keysToDelete.size(), (Object)this.pageSize);
                    for (List batchOfKeysToDelete : Lists.partition(keysToDelete, (int)this.pageSize)) {
                        this.deleteObjects(this.getRequestFactory().newBulkDeleteRequest(batchOfKeysToDelete, true));
                    }
                }
            } else {
                for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
                    this.deleteObject(keyVersion.getKey());
                }
            }
        }
        catch (MultiObjectDeleteException ex) {
            int rejected = ex.getErrors().size();
            this.noteDeleted(keysToDelete.size() - rejected, deleteFakeDir);
            this.incrementStatistic(Statistic.FILES_DELETE_REJECTED, rejected);
            throw ex;
        }
        this.noteDeleted(keysToDelete.size(), deleteFakeDir);
    }

    private void noteDeleted(int count, boolean deleteFakeDir) {
        if (!deleteFakeDir) {
            this.instrumentation.fileDeleted(count);
        } else {
            this.instrumentation.fakeDirsDeleted(count);
        }
    }

    @VisibleForTesting
    public void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, BulkOperationState operationState) throws MultiObjectDeleteException, AmazonClientException, IOException {
        this.removeKeys(keysToDelete, deleteFakeDir, new ArrayList<Path>(), operationState, true);
    }

    private void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, List<Path> undeletedObjectsOnFailure, BulkOperationState operationState, boolean quiet) throws MultiObjectDeleteException, AmazonClientException, IOException {
        undeletedObjectsOnFailure.clear();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Deleting %d keys", new Object[]{keysToDelete.size()});){
            this.removeKeysS3(keysToDelete, deleteFakeDir, quiet);
        }
        catch (MultiObjectDeleteException ex) {
            LOG.debug("Partial delete failure");
            if (!deleteFakeDir) {
                Triple<List<Path>, List<Path>, List<Pair<Path, IOException>>> results = new MultiObjectDeleteSupport(this.createStoreContext(), operationState).processDeleteFailure(ex, keysToDelete, new ArrayList<Path>());
                undeletedObjectsOnFailure.addAll((Collection)results.getLeft());
            }
            throw ex;
        }
        catch (AmazonClientException | IOException ex) {
            List<Path> paths = new MultiObjectDeleteSupport(this.createStoreContext(), operationState).processDeleteFailureGenericException((Exception)ex, keysToDelete);
            undeletedObjectsOnFailure.addAll(paths);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(Path f, boolean recursive) throws IOException {
        this.checkNotClosed();
        Path path = this.qualify(f);
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_DELETE.getSymbol(), path.toString(), null);){
            boolean outcome = (Boolean)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.INVOCATION_DELETE.getSymbol(), (CallableRaisingIOE)new DeleteOperation(this.createStoreContext(), this.innerGetFileStatus(path, true, StatusProbeEnum.ALL), recursive, new OperationCallbacksImpl(), this.pageSize));
            if (outcome) {
                try {
                    this.maybeCreateFakeParentDirectory(path);
                }
                catch (AccessDeniedException e) {
                    LOG.warn("Cannot create directory marker at {}: {}", (Object)f.getParent(), (Object)e.toString());
                    LOG.debug("Failed to create fake dir above {}", (Object)path, (Object)e);
                }
            }
            boolean bl = outcome;
            return bl;
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist: {}", (Object)path, (Object)e.toString());
            this.instrumentation.errorIgnored();
            return false;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("delete", path, e);
        }
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException, AmazonClientException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.s3Exists(f, StatusProbeEnum.DIRECTORIES)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.createFakeDirectory(key);
        }
    }

    @VisibleForTesting
    protected void maybeCreateFakeParentDirectory(Path path) throws IOException, AmazonClientException {
        Path parent = path.getParent();
        if (parent != null && !parent.isRoot()) {
            this.createFakeDirectoryIfNecessary(parent);
        }
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws FileNotFoundException, IOException {
        Path path = this.qualify(p);
        return RemoteIterators.typeCastingRemoteIterator((RemoteIterator)((RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_STATUS, path, () -> (RemoteIterator)Invoker.once("listStatus", path.toString(), () -> this.innerListStatus(p)))));
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        Path path = this.qualify(f);
        return (FileStatus[])this.trackDurationAndSpan(Statistic.INVOCATION_LIST_STATUS, path, () -> (S3AFileStatus[])Invoker.once("listStatus", path.toString(), () -> S3AUtils.iteratorToStatuses(this.innerListStatus(path), new HashSet<Path>())));
    }

    private RemoteIterator<S3AFileStatus> innerListStatus(Path f) throws FileNotFoundException, IOException, AmazonClientException {
        S3AFileStatus fileStatus;
        Path path = this.qualify(f);
        LOG.debug("List status for path: {}", (Object)path);
        Triple<RemoteIterator<S3AFileStatus>, DirListingMetadata, Boolean> statusesAssumingNonEmptyDir = this.listing.getFileStatusesAssumingNonEmptyDir(path, this.getActiveAuditSpan());
        if (!((RemoteIterator)statusesAssumingNonEmptyDir.getLeft()).hasNext() && ((Boolean)statusesAssumingNonEmptyDir.getRight()).booleanValue()) {
            return (RemoteIterator)statusesAssumingNonEmptyDir.getLeft();
        }
        if (!((RemoteIterator)statusesAssumingNonEmptyDir.getLeft()).hasNext() && (fileStatus = this.innerGetFileStatus(path, false, StatusProbeEnum.ALL)).isFile()) {
            LOG.debug("Adding: rd (not a dir): {}", (Object)path);
            S3AFileStatus[] stats = new S3AFileStatus[]{fileStatus};
            return this.listing.createProvidedFileStatusIterator(stats, S3AUtils.ACCEPT_ALL, Listing.ACCEPT_ALL_BUT_S3N);
        }
        return S3Guard.dirListingUnion(this.metadataStore, path, (RemoteIterator<S3AFileStatus>)((RemoteIterator)statusesAssumingNonEmptyDir.getLeft()), (DirListingMetadata)statusesAssumingNonEmptyDir.getMiddle(), this.allowAuthoritative(path), this.ttlTimeProvider, p -> this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses((DirListingMetadata)statusesAssumingNonEmptyDir.getMiddle()), S3AUtils.ACCEPT_ALL, Listing.ACCEPT_ALL_BUT_S3N));
    }

    public boolean allowAuthoritative(Path path) {
        return S3Guard.allowAuthoritative(path, this, this.allowAuthoritativeMetadataStore, this.allowAuthoritativePaths);
    }

    @VisibleForTesting
    public S3ListRequest createListObjectsRequest(String key, String delimiter) {
        return this.createListObjectsRequest(key, delimiter, this.maxKeys);
    }

    private S3ListRequest createListObjectsRequest(String key, String delimiter, int limit) {
        if (!this.useListV1) {
            ListObjectsV2Request request = this.getRequestFactory().newListObjectsV2Request(key, delimiter, limit);
            return S3ListRequest.v2(request);
        }
        ListObjectsRequest request = this.getRequestFactory().newListObjectsV1Request(key, delimiter, limit);
        return S3ListRequest.v1(request);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeQualified(newDir);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getUsername() {
        return this.username;
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public boolean mkdirs(Path p, FsPermission permission) throws IOException, FileAlreadyExistsException {
        Path path = this.qualify(p);
        return this.trackDurationAndSpan(Statistic.INVOCATION_MKDIRS, path, new MkdirOperation(this.createStoreContext(), path, this.createMkdirOperationCallbacks()));
    }

    @VisibleForTesting
    public MkdirOperation.MkdirCallbacks createMkdirOperationCallbacks() {
        return new MkdirOperationCallbacksImpl();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        Path path = this.qualify(f);
        return this.trackDurationAndSpan(Statistic.INVOCATION_GET_CONTENT_SUMMARY, path, new GetContentSummaryOperation(this.createStoreContext(), path, this.createGetContentSummaryCallbacks()));
    }

    protected GetContentSummaryOperation.GetContentSummaryCallbacks createGetContentSummaryCallbacks() {
        return new GetContentSummaryCallbacksImpl();
    }

    public void access(Path f, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        Path path = this.qualify(f);
        LOG.debug("check access mode {} for {}", (Object)path, (Object)mode);
        this.trackDurationAndSpan(Statistic.INVOCATION_ACCESS, path, () -> {
            S3AFileStatus stat = this.innerGetFileStatus(path, false, StatusProbeEnum.ALL);
            if (!this.getAuditManager().checkAccess(path, stat, mode)) {
                this.incrementStatistic(Statistic.AUDIT_ACCESS_CHECK_FAILURE);
                throw new AccessControlException(String.format("Permission denied: user=%s, path=\"%s\":%s:%s:%s%s", this.getOwner().getUserName(), stat.getPath(), stat.getOwner(), stat.getGroup(), stat.isDirectory() ? "d" : "-", mode));
            }
            return true;
        });
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        Path path = this.qualify(f);
        return (FileStatus)this.trackDurationAndSpan(Statistic.INVOCATION_GET_FILE_STATUS, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.ALL));
    }

    @VisibleForTesting
    S3AFileStatus innerGetFileStatus(Path f, boolean needEmptyDirectoryFlag, Set<StatusProbeEnum> probes) throws IOException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("Getting path status for {}  ({}); needEmptyDirectory={}", new Object[]{path, key, needEmptyDirectoryFlag});
        boolean allowAuthoritative = this.allowAuthoritative(path);
        PathMetadata pm = null;
        if (this.hasMetadataStore()) {
            pm = S3Guard.getWithTtl(this.metadataStore, path, this.ttlTimeProvider, needEmptyDirectoryFlag, allowAuthoritative);
        }
        Set<Path> tombstones = Collections.emptySet();
        if (pm != null) {
            S3AFileStatus msStatus = pm.getFileStatus();
            if (pm.isDeleted()) {
                OffsetDateTime deletedAt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(msStatus.getModificationTime()), ZoneOffset.UTC);
                throw new FileNotFoundException("Path " + path + " is recorded as deleted by S3Guard at " + deletedAt);
            }
            if (!msStatus.isDirectory() && !allowAuthoritative && probes.contains((Object)StatusProbeEnum.Head)) {
                S3AFileStatus s3AFileStatus;
                LOG.debug("Metadata for {} found in the non-auth metastore.", (Object)path);
                long msModTime = pm.getFileStatus().getModificationTime();
                try {
                    s3AFileStatus = this.s3GetFileStatus(path, key, probes, tombstones, needEmptyDirectoryFlag);
                }
                catch (FileNotFoundException fne) {
                    LOG.trace("File Not Found from probes for {}", (Object)key, (Object)fne);
                    s3AFileStatus = null;
                }
                if (s3AFileStatus == null) {
                    LOG.warn("Failed to find file {}. Either it is not yet visible, or it has been deleted.", (Object)path);
                } else {
                    long s3ModTime = s3AFileStatus.getModificationTime();
                    if (s3ModTime > msModTime) {
                        LOG.debug("S3Guard metadata for {} is outdated; s3modtime={}; msModTime={} updating metastore", new Object[]{path, s3ModTime, msModTime});
                        return S3Guard.putAndReturn(this.metadataStore, s3AFileStatus, this.ttlTimeProvider);
                    }
                }
            }
            if (needEmptyDirectoryFlag && msStatus.isDirectory()) {
                if (pm.isEmptyDirectory() != Tristate.UNKNOWN) {
                    return msStatus;
                }
                DirListingMetadata children = S3Guard.listChildrenWithTtl(this.metadataStore, path, this.ttlTimeProvider, allowAuthoritative);
                if (children != null) {
                    tombstones = children.listTombstones();
                }
            } else {
                return msStatus;
            }
            LOG.debug("MetadataStore doesn't know if {} is empty, using S3.", (Object)path);
            try {
                S3AFileStatus s3FileStatus = this.s3GetFileStatus(path, key, probes, tombstones, true);
                return S3Guard.putAndReturn(this.metadataStore, s3FileStatus, this.ttlTimeProvider);
            }
            catch (FileNotFoundException e) {
                return S3AFileStatus.fromFileStatus(msStatus, Tristate.TRUE, null, null);
            }
        }
        return S3Guard.putAndReturn(this.metadataStore, this.s3GetFileStatus(path, key, probes, tombstones, needEmptyDirectoryFlag), this.ttlTimeProvider);
    }

    @VisibleForTesting
    S3AFileStatus s3GetFileStatus(Path path, String key, Set<StatusProbeEnum> probes, @Nullable Set<Path> tombstones, boolean needEmptyDirectoryFlag) throws IOException {
        LOG.debug("S3GetFileStatus {}", (Object)path);
        Preconditions.checkArgument((!needEmptyDirectoryFlag || probes.contains((Object)StatusProbeEnum.List) ? 1 : 0) != 0, (String)"s3GetFileStatus(%s) wants to know if a directory is empty but does not request a list probe", (Object)path);
        if (key.isEmpty() && !needEmptyDirectoryFlag) {
            return new S3AFileStatus(Tristate.UNKNOWN, path, this.username);
        }
        if (!key.isEmpty() && !key.endsWith("/") && probes.contains((Object)StatusProbeEnum.Head)) {
            try {
                ObjectMetadata meta = this.getObjectMetadata(key);
                LOG.debug("Found exact file: normal file {}", (Object)key);
                long contentLength = meta.getContentLength();
                if (this.isCSEEnabled && meta.getUserMetaDataOf("x-amz-cek-alg") != null && contentLength >= 16L) {
                    contentLength -= 16L;
                }
                return new S3AFileStatus(contentLength, S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username, meta.getETag(), meta.getVersionId());
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                    throw S3AUtils.translateException("getFileStatus", path, (AmazonClientException)((Object)e));
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
        }
        if (probes.contains((Object)StatusProbeEnum.List)) {
            try {
                String dirKey = this.maybeAddTrailingSlash(key);
                int listSize = tombstones == null ? 2 : Math.min(2 + tombstones.size(), Math.max(2, this.maxKeys));
                S3ListRequest request = this.createListObjectsRequest(dirKey, "/", listSize);
                S3ListResult listResult = this.listObjects(request, this.getDurationTrackerFactory());
                if (listResult.hasPrefixesOrObjects(this.contextAccessors, tombstones)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found path as directory (with /)");
                        listResult.logAtDebug(LOG);
                    }
                    if (needEmptyDirectoryFlag && listResult.representsEmptyDirectory(this.contextAccessors, dirKey, tombstones)) {
                        return new S3AFileStatus(Tristate.TRUE, path, this.username);
                    }
                    return new S3AFileStatus(Tristate.FALSE, path, this.username);
                }
                if (key.isEmpty()) {
                    LOG.debug("Found root directory");
                    return new S3AFileStatus(Tristate.TRUE, path, this.username);
                }
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404 || ErrorTranslation.isUnknownBucket(e)) {
                    throw S3AUtils.translateException("getFileStatus", path, (AmazonClientException)((Object)e));
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
        }
        LOG.debug("Not Found: {}", (Object)path);
        throw new FileNotFoundException("No such file or directory: " + path);
    }

    private boolean s3Exists(Path path, Set<StatusProbeEnum> probes) throws IOException {
        String key = this.pathToKey(path);
        try {
            this.s3GetFileStatus(path, key, probes, null, false);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.checkNotClosed();
        LOG.debug("Copying local file from {} to {}", (Object)src, (Object)dst);
        this.trackDurationAndSpan(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE, dst, () -> new CopyFromLocalOperation(this.createStoreContext(), src, dst, delSrc, overwrite, this.createCopyFromLocalCallbacks()).execute());
    }

    protected CopyFromLocalOperation.CopyFromLocalOperationCallbacks createCopyFromLocalCallbacks() throws IOException {
        LocalFileSystem local = S3AFileSystem.getLocal((Configuration)this.getConf());
        return new CopyFromLocalCallbacksImpl(local);
    }

    UploadResult executePut(PutObjectRequest putObjectRequest, Progressable progress) throws InterruptedIOException, MetadataPersistenceException {
        String key = putObjectRequest.getKey();
        UploadInfo info = this.putObject(putObjectRequest);
        Upload upload = info.getUpload();
        ProgressableProgressListener listener = new ProgressableProgressListener(this, key, upload, progress);
        upload.addProgressListener((ProgressListener)listener);
        UploadResult result = this.waitForUploadCompletion(key, info);
        listener.uploadCompleted();
        this.finishedWrite(key, info.getLength(), result.getETag(), result.getVersionId(), null);
        return result;
    }

    UploadResult waitForUploadCompletion(String key, UploadInfo uploadInfo) throws InterruptedIOException {
        Upload upload = uploadInfo.getUpload();
        try {
            UploadResult result = upload.waitForUploadResult();
            this.incrementPutCompletedStatistics(true, uploadInfo.getLength());
            return result;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted: aborting upload");
            this.incrementPutCompletedStatistics(false, uploadInfo.getLength());
            upload.abort();
            throw (InterruptedIOException)new InterruptedIOException("Interrupted in PUT to " + this.keyToQualifiedPath(key)).initCause(e);
        }
    }

    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Filesystem {} is closed", (Object)this.uri);
        if (this.getConf() != null) {
            String iostatisticsLoggingLevel = this.getConf().getTrimmed("fs.iostatistics.logging.level", "debug");
            IOStatisticsLogging.logIOStatisticsAtLevel((Logger)LOG, (String)iostatisticsLoggingLevel, (Object)this.getIOStatistics());
        }
        try {
            super.close();
        }
        finally {
            this.stopAllServices();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Statistics for {}: {}", (Object)this.uri, (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)this.getIOStatistics()));
        }
    }

    protected synchronized void stopAllServices() {
        if (this.transfers != null) {
            try {
                this.transfers.shutdownNow(true);
            }
            catch (RuntimeException e) {
                LOG.debug("When shutting down", (Throwable)e);
            }
            this.transfers = null;
        }
        HadoopExecutors.shutdown((ExecutorService)this.boundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.boundedThreadPool = null;
        HadoopExecutors.shutdown((ExecutorService)this.unboundedThreadPool, (Logger)LOG, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.unboundedThreadPool = null;
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.metadataStore, this.instrumentation, this.delegationTokens.orElse(null), this.signerManager, this.auditManager});
        S3AUtils.closeAutocloseables(LOG, this.credentials);
        this.delegationTokens = Optional.empty();
        this.signerManager = null;
        this.credentials = null;
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(this.uri + ": " + "FileSystem is closed!");
        }
    }

    @VisibleForTesting
    public Optional<S3ADelegationTokens> getDelegationTokens() {
        return this.delegationTokens;
    }

    public String getCanonicalServiceName() {
        if (!this.delegationTokens.isPresent()) {
            return null;
        }
        S3ADelegationTokens dt = this.delegationTokens.get();
        return dt.getTokenIssuingPolicy() != S3ADelegationTokens.TokenIssuingPolicy.NoTokensAvailable ? dt.getCanonicalServiceName() : null;
    }

    public Token<AbstractS3ATokenIdentifier> getDelegationToken(String renewer) throws IOException {
        this.checkNotClosed();
        LOG.debug("Delegation token requested");
        if (this.delegationTokens.isPresent()) {
            return (Token)this.trackDurationAndSpan(Statistic.INVOCATION_GET_DELEGATION_TOKEN, null, () -> this.delegationTokens.get().getBoundOrNewDT(this.encryptionSecrets, renewer != null ? new Text(renewer) : new Text()));
        }
        LOG.debug("Token support is not enabled");
        return null;
    }

    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        this.checkNotClosed();
        if (this.delegationTokens.isPresent()) {
            return this.delegationTokens.get().getAdditionalTokenIssuers();
        }
        LOG.debug("Token support is not enabled");
        return null;
    }

    @Override
    @InterfaceAudience.Private
    public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
        if (access.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RoleModel.Statement> statements = new ArrayList<RoleModel.Statement>(RolePolicies.allowS3Operations(this.bucket, access.contains((Object)AWSPolicyProvider.AccessLevel.WRITE) || access.contains((Object)AWSPolicyProvider.AccessLevel.ADMIN)));
        statements.add(RolePolicies.STATEMENT_ALLOW_SSE_KMS_RW);
        if (this.metadataStore instanceof AWSPolicyProvider) {
            statements.addAll(((AWSPolicyProvider)((Object)this.metadataStore)).listAWSPolicyRules(access));
        }
        return statements;
    }

    private CopyResult copyFile(String srcKey, String dstKey, long size, S3ObjectAttributes srcAttributes, S3AReadOpContext readContext) throws IOException, InterruptedIOException {
        ObjectMetadata srcom;
        LOG.debug("copyFile {} -> {} ", (Object)srcKey, (Object)dstKey);
        ProgressListener progressListener = progressEvent -> {
            switch (progressEvent.getEventType()) {
                case TRANSFER_PART_COMPLETED_EVENT: {
                    this.incrementWriteOperations();
                    break;
                }
            }
        };
        ChangeTracker changeTracker = new ChangeTracker(this.keyToQualifiedPath(srcKey).toString(), this.changeDetectionPolicy, readContext.getS3AStatisticsContext().newInputStreamStatistics().getChangeTrackerStatistics(), srcAttributes);
        String action = "copyFile(" + srcKey + ", " + dstKey + ")";
        Invoker readInvoker = readContext.getReadInvoker();
        try {
            srcom = (ObjectMetadata)Invoker.once(action, srcKey, () -> this.getObjectMetadata(srcKey, changeTracker, readInvoker, "copy"));
        }
        catch (FileNotFoundException e) {
            LOG.debug("getObjectMetadata({}) failed to find an expected file", (Object)srcKey, (Object)e);
            String message = this.hasMetadataStore() ? "File to rename not found on guarded S3 store after repeated attempts" : "File to rename not found on unguarded S3 store";
            throw new RemoteFileChangedException(this.keyToQualifiedPath(srcKey).toString(), action, message, e);
        }
        return (CopyResult)readInvoker.retry(action, srcKey, true, () -> {
            CopyObjectRequest copyObjectRequest = this.getRequestFactory().newCopyObjectRequest(srcKey, dstKey, srcom);
            changeTracker.maybeApplyConstraint(copyObjectRequest);
            this.incrementStatistic(Statistic.OBJECT_COPY_REQUESTS);
            Copy copy = this.transfers.copy(copyObjectRequest, this.getAuditManager().createStateChangeListener());
            copy.addProgressListener(progressListener);
            CopyOutcome copyOutcome = CopyOutcome.waitForCopy(copy);
            InterruptedException interruptedException = copyOutcome.getInterruptedException();
            if (interruptedException != null) {
                throw (IOException)new InterruptedIOException("Interrupted copying " + srcKey + " to " + dstKey + ", cancelling").initCause(interruptedException);
            }
            SdkBaseException awsException = copyOutcome.getAwsException();
            if (awsException != null) {
                changeTracker.processException(awsException, "copy");
                throw awsException;
            }
            CopyResult result = copyOutcome.getCopyResult();
            changeTracker.processResponse(result);
            this.incrementWriteOperations();
            this.instrumentation.filesCopied(1, size);
            return result;
        });
    }

    InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws IOException {
        LOG.debug("Initiate multipart upload to {}", (Object)request.getKey());
        return (InitiateMultipartUploadResult)IOStatisticsBinding.trackDurationOfSupplier((DurationTrackerFactory)this.getDurationTrackerFactory(), (String)Statistic.OBJECT_MULTIPART_UPLOAD_INITIATED.getSymbol(), () -> this.getAmazonS3Client().initiateMultipartUpload(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void finishedWrite(String key, long length, String eTag, String versionId, @Nullable BulkOperationState operationState) throws MetadataPersistenceException {
        LOG.debug("Finished write to {}, len {}. etag {}, version {}", new Object[]{key, length, eTag, versionId});
        Path p = this.keyToQualifiedPath(key);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"content length is negative");
        boolean isDir = S3AUtils.objectRepresentsDirectory(key);
        CompletableFuture<Object> deletion = !this.keepDirectoryMarkers(p) ? CallableSupplier.submit(this.unboundedThreadPool, this.getActiveAuditSpan(), () -> {
            this.deleteUnnecessaryFakeDirectories(p.getParent(), operationState);
            return null;
        }) : null;
        BulkOperationState stateToClose = null;
        try {
            if (this.hasMetadataStore()) {
                BulkOperationState activeState = operationState;
                if (activeState == null) {
                    activeState = stateToClose = S3Guard.initiateBulkWrite(this.metadataStore, isDir ? BulkOperationState.OperationType.Mkdir : BulkOperationState.OperationType.Put, this.keyToPath(key));
                }
                S3Guard.addAncestors(this.metadataStore, p, this.ttlTimeProvider, activeState);
                S3AFileStatus status = S3AUtils.createUploadFileStatus(p, isDir, length, this.getDefaultBlockSize(p), this.username, eTag, versionId);
                boolean authoritative = false;
                if (isDir) {
                    status.setIsEmptyDirectory(Tristate.TRUE);
                    authoritative = this.allowAuthoritative(p);
                }
                if (!authoritative) {
                    S3Guard.putAndReturn(this.metadataStore, status, this.ttlTimeProvider, activeState);
                } else {
                    S3Guard.putAuthDirectoryMarker(this.metadataStore, status, this.ttlTimeProvider, activeState);
                }
            }
            CallableSupplier.waitForCompletionIgnoringExceptions(deletion);
        }
        catch (IOException e) {
            try {
                if (this.failOnMetadataWriteError) {
                    throw new MetadataPersistenceException(p.toString(), e);
                }
                LOG.error("S3Guard: Error updating MetadataStore for write to {}", (Object)p, (Object)e);
                this.instrumentation.errorIgnored();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{stateToClose});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{stateToClose});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{stateToClose});
    }

    private boolean keepDirectoryMarkers(Path path) {
        return this.directoryPolicy.keepDirectoryMarkers(path);
    }

    private void deleteUnnecessaryFakeDirectories(Path path, BulkOperationState operationState) {
        block4: {
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToRemove = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            while (!path.isRoot()) {
                String key = this.pathToKey(path);
                key = key.endsWith("/") ? key : key + "/";
                LOG.trace("To delete unnecessary fake directory {} for {}", (Object)key, (Object)path);
                keysToRemove.add(new DeleteObjectsRequest.KeyVersion(key));
                path = path.getParent();
            }
            try {
                this.removeKeys(keysToRemove, true, operationState);
            }
            catch (AmazonClientException | IOException e) {
                this.instrumentation.errorIgnored();
                if (!LOG.isDebugEnabled()) break block4;
                StringBuilder sb = new StringBuilder();
                for (DeleteObjectsRequest.KeyVersion kv : keysToRemove) {
                    sb.append(kv.getKey()).append(",");
                }
                LOG.debug("While deleting keys {} ", (Object)sb.toString(), (Object)e);
            }
        }
    }

    private void createFakeDirectory(String objectName) throws IOException {
        this.createEmptyObject(objectName);
    }

    private void createEmptyObject(String objectName) throws IOException {
        this.invoker.retry("PUT 0-byte object ", objectName, true, () -> this.putObjectDirect(this.getRequestFactory().newDirectoryMarkerRequest(objectName)));
        this.incrementPutProgressStatistics(objectName, 0L);
        this.instrumentation.directoryCreated();
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("fs.s3a.block.size", 0x2000000L);
    }

    public DirectoryPolicy getDirectoryMarkerPolicy() {
        return this.directoryPolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectsDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAhead=").append(this.readAhead);
        if (this.getConf() != null) {
            sb.append(", blockSize=").append(this.getDefaultBlockSize());
        }
        sb.append(", multiPartThreshold=").append(this.multiPartThreshold);
        if (this.getS3EncryptionAlgorithm() != null) {
            sb.append(", s3EncryptionAlgorithm='").append((Object)this.getS3EncryptionAlgorithm()).append('\'');
        }
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", auditManager=").append(this.auditManager);
        sb.append(", metastore=").append(this.metadataStore);
        sb.append(", authoritativeStore=").append(this.allowAuthoritativeMetadataStore);
        sb.append(", authoritativePath=").append(this.allowAuthoritativePaths);
        sb.append(", useListV1=").append(this.useListV1);
        if (this.committerIntegration != null) {
            sb.append(", magicCommitter=").append(this.isMagicCommitEnabled());
        }
        sb.append(", boundedExecutor=").append(this.boundedThreadPool);
        sb.append(", unboundedExecutor=").append(this.unboundedThreadPool);
        sb.append(", credentials=").append(this.credentials);
        sb.append(", delegation tokens=").append(this.delegationTokens.map(Objects::toString).orElse("disabled"));
        sb.append(", ").append(this.directoryPolicy);
        if (this.getInstrumentation() != null) {
            sb.append(", instrumentation {").append(this.getInstrumentation().toString()).append("}");
        }
        sb.append(", ClientSideEncryption=").append(this.isCSEEnabled);
        sb.append('}');
        return sb.toString();
    }

    public long getPartitionSize() {
        return this.partSize;
    }

    public long getMultiPartThreshold() {
        return this.multiPartThreshold;
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public boolean isMagicCommitEnabled() {
        return this.committerIntegration.isMagicCommitEnabled();
    }

    public boolean isMagicCommitPath(Path path) {
        return this.committerIntegration.isMagicCommitPath(path);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, S3AUtils.ACCEPT_ALL);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return (FileStatus[])this.trackDurationAndSpan(Statistic.INVOCATION_GLOB_STATUS, pathPattern, () -> Globber.createGlobber((FileSystem)this).withPathPattern(pathPattern).withPathFiltern(filter).withResolveSymlinks(false).build().glob());
    }

    public boolean exists(Path f) throws IOException {
        Path path = this.qualify(f);
        try {
            this.trackDurationAndSpan(Statistic.INVOCATION_EXISTS, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.ALL));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isDirectory(Path f) throws IOException {
        Path path = this.qualify(f);
        try {
            return (Boolean)this.trackDurationAndSpan(Statistic.INVOCATION_IS_DIRECTORY, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.DIRECTORIES).isDirectory());
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        Path path = this.qualify(f);
        try {
            return (Boolean)this.trackDurationAndSpan(Statistic.INVOCATION_IS_FILE, path, () -> this.innerGetFileStatus(path, false, StatusProbeEnum.HEAD_ONLY).isFile());
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public EtagChecksum getFileChecksum(Path f, long length) throws IOException {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        Path path = this.qualify(f);
        if (this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false)) {
            return (EtagChecksum)this.trackDurationAndSpan(Statistic.INVOCATION_GET_FILE_CHECKSUM, path, () -> {
                LOG.debug("getFileChecksum({})", (Object)path);
                ObjectMetadata headers = this.getObjectMetadata(path, null, this.invoker, "getFileChecksum are");
                String eTag = headers.getETag();
                return eTag != null ? new EtagChecksum(eTag) : null;
            });
        }
        return null;
    }

    private HeaderProcessing getHeaderProcessing() {
        return new HeaderProcessing(this.createStoreContext(), this.createHeaderProcessingCallbacks());
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_XATTR_GET_NAMED.getSymbol(), path.toString(), null);){
            byte[] byArray = this.getHeaderProcessing().getXAttr(path, name);
            return byArray;
        }
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_XATTR_GET_MAP.getSymbol(), path.toString(), null);){
            Map<String, byte[]> map = this.getHeaderProcessing().getXAttrs(path);
            return map;
        }
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_XATTR_GET_NAMED_MAP.getSymbol(), path.toString(), null);){
            Map<String, byte[]> map = this.getHeaderProcessing().getXAttrs(path, names);
            return map;
        }
    }

    public List<String> listXAttrs(Path path) throws IOException {
        this.checkNotClosed();
        try (AuditSpanS3A span = this.createSpan(Statistic.INVOCATION_OP_XATTR_LIST.getSymbol(), path.toString(), null);){
            List<String> list = this.getHeaderProcessing().listXAttrs(path);
            return list;
        }
    }

    protected HeaderProcessing.HeaderProcessingCallbacks createHeaderProcessingCallbacks() {
        return new HeaderProcessingCallbacksImpl();
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        Path path = this.qualify(f);
        return Listing.toLocatedFileStatusIterator((RemoteIterator<? extends LocatedFileStatus>)((RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_FILES, path, () -> this.innerListFiles(path, recursive, new Listing.AcceptFilesOnly(path), null, true, false))));
    }

    @InterfaceAudience.Private
    public RemoteIterator<S3ALocatedFileStatus> listFilesAndEmptyDirectories(Path f, boolean recursive) throws IOException {
        Path path = this.qualify(f);
        return (RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_FILES, path, () -> this.innerListFiles(path, recursive, Listing.ACCEPT_ALL_BUT_S3N, null, true, false));
    }

    @InterfaceAudience.Private
    public RemoteIterator<S3ALocatedFileStatus> listFilesAndEmptyDirectoriesForceNonAuth(Path f, boolean recursive) throws IOException {
        Path path = this.qualify(f);
        return (RemoteIterator)this.trackDurationAndSpan(Statistic.INVOCATION_LIST_FILES, path, () -> this.innerListFiles(path, recursive, Listing.ACCEPT_ALL_BUT_S3N, null, true, true));
    }

    private RemoteIterator<S3ALocatedFileStatus> innerListFiles(Path f, boolean recursive, Listing.FileStatusAcceptor acceptor, S3AFileStatus status, boolean collectTombstones, boolean forceNonAuthoritativeMS) throws IOException {
        Path path = this.qualify(f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            if (status != null && status.isFile()) {
                LOG.debug("Path is a file: {}", (Object)path);
                return this.listing.createSingleStatusIterator(this.toLocatedFileStatus(status));
            }
            RemoteIterator<S3ALocatedFileStatus> listFilesAssumingDir = this.listing.getListFilesAssumingDir(path, recursive, acceptor, collectTombstones, forceNonAuthoritativeMS, this.getActiveAuditSpan());
            if (!listFilesAssumingDir.hasNext()) {
                S3AFileStatus fileStatus;
                S3AFileStatus s3AFileStatus = fileStatus = status != null ? status : this.innerGetFileStatus(path, false, StatusProbeEnum.ALL);
                if (fileStatus.isFile()) {
                    return this.listing.createSingleStatusIterator(this.toLocatedFileStatus(fileStatus));
                }
            }
            return listFilesAssumingDir;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, S3AUtils.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        Path path = this.qualify(f);
        AuditSpan span = this.entryPoint(Statistic.INVOCATION_LIST_LOCATED_STATUS, path);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        RemoteIterator iterator = (RemoteIterator)Invoker.once("listLocatedStatus", path.toString(), () -> {
            S3AFileStatus fileStatus;
            RemoteIterator<S3ALocatedFileStatus> locatedFileStatusIteratorForDir = this.listing.getLocatedFileStatusIteratorForDir(path, filter, span);
            if (!locatedFileStatusIteratorForDir.hasNext() && (fileStatus = this.innerGetFileStatus(path, false, StatusProbeEnum.ALL)).isFile()) {
                LOG.debug("Path is a file");
                return this.listing.createSingleStatusIterator(filter.accept(path) ? this.toLocatedFileStatus(fileStatus) : null);
            }
            return locatedFileStatusIteratorForDir;
        });
        return Listing.toLocatedFileStatusIterator((RemoteIterator<? extends LocatedFileStatus>)iterator);
    }

    S3ALocatedFileStatus toLocatedFileStatus(S3AFileStatus status) throws IOException {
        return new S3ALocatedFileStatus(status, status.isFile() ? this.getFileBlockLocations(status, 0L, status.getLen()) : null);
    }

    @InterfaceAudience.Private
    public MultipartUtils.UploadIterator listUploads(@Nullable String prefix) throws IOException {
        return (MultipartUtils.UploadIterator)this.trackDurationAndSpan(Statistic.MULTIPART_UPLOAD_LIST, prefix, null, () -> MultipartUtils.listMultipartUploads(this.createStoreContext(), this.s3, prefix, this.maxKeys));
    }

    @InterfaceAudience.Private
    public List<MultipartUpload> listMultipartUploads(String prefix) throws IOException {
        if (prefix != null && !prefix.isEmpty() && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        String p = prefix;
        return (List)this.invoker.retry("listMultipartUploads", p, true, () -> {
            ListMultipartUploadsRequest request = this.getRequestFactory().newListMultipartUploadsRequest(p);
            return this.s3.listMultipartUploads(request).getMultipartUploads();
        });
    }

    void abortMultipartUpload(String destKey, String uploadId) {
        LOG.info("Aborting multipart upload {} to {}", (Object)uploadId, (Object)destKey);
        this.getAmazonS3Client().abortMultipartUpload(this.getRequestFactory().newAbortMultipartUploadRequest(destKey, uploadId));
    }

    void abortMultipartUpload(MultipartUpload upload) {
        String destKey = upload.getKey();
        String uploadId = upload.getUploadId();
        if (LOG.isInfoEnabled()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            LOG.debug("Aborting multipart upload {} to {} initiated by {} on {}", new Object[]{uploadId, destKey, upload.getInitiator(), df.format(upload.getInitiated())});
        }
        this.getAmazonS3Client().abortMultipartUpload(this.getRequestFactory().newAbortMultipartUploadRequest(destKey, uploadId));
    }

    public CommitterStatistics newCommitterStatistics() {
        return this.statisticsContext.newCommitterStatistics();
    }

    public boolean hasPathCapability(Path path, String capability) throws IOException {
        String cap;
        Path p = this.makeQualified(path);
        switch (cap = PathCapabilitiesSupport.validatePathCapabilityArgs((Path)p, (String)capability)) {
            case "fs.s3a.capability.magic.committer": 
            case "s3a:magic.committer": {
                return this.isMagicCommitEnabled();
            }
            case "fs.s3a.capability.select.sql": {
                return !this.isCSEEnabled && SelectBinding.isSelectEnabled(this.getConf());
            }
            case "fs.capability.paths.checksums": {
                return this.getConf().getBoolean("fs.s3a.etag.checksum.enabled", false);
            }
            case "fs.capability.outputstream.abortable": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.aware": {
                return true;
            }
            case "fs.capability.etags.available": {
                return true;
            }
            case "fs.s3a.capability.directory.marker.policy.keep": 
            case "fs.s3a.capability.directory.marker.policy.delete": 
            case "fs.s3a.capability.directory.marker.policy.authoritative": 
            case "fs.s3a.capability.directory.marker.action.keep": 
            case "fs.s3a.capability.directory.marker.action.delete": {
                return this.getDirectoryMarkerPolicy().hasPathCapability(path, cap);
            }
        }
        return super.hasPathCapability(p, cap);
    }

    @Deprecated
    public boolean hasCapability(String capability) {
        try {
            return this.hasPathCapability(new Path("/"), capability);
        }
        catch (IOException ex) {
            LOG.debug("Ignoring exception on hasCapability({}})", (Object)capability, (Object)ex);
            return false;
        }
    }

    public AWSCredentialProviderList shareCredentials(String purpose) {
        LOG.debug("Sharing credentials for: {}", (Object)purpose);
        return this.credentials.share();
    }

    @VisibleForTesting
    public ITtlTimeProvider getTtlTimeProvider() {
        return this.ttlTimeProvider;
    }

    @VisibleForTesting
    protected void setTtlTimeProvider(ITtlTimeProvider ttlTimeProvider) {
        this.ttlTimeProvider = ttlTimeProvider;
        this.metadataStore.setTtlTimeProvider(ttlTimeProvider);
    }

    private FSDataInputStream select(Path source, String expression, Configuration options, Optional<S3AFileStatus> providedStatus) throws IOException {
        AuditSpan auditSpan = this.entryPoint(Statistic.OBJECT_SELECT_REQUESTS, source);
        this.requireSelectSupport(source);
        Path path = this.makeQualified(source);
        S3AFileStatus fileStatus = this.extractOrFetchSimpleFileStatus(path, providedStatus);
        long ra = options.getLong("fs.s3a.readahead.range", this.readAhead);
        S3ObjectAttributes objectAttributes = this.createObjectAttributes(fileStatus);
        S3AReadOpContext readContext = this.createReadContext(fileStatus, this.inputPolicy, this.changeDetectionPolicy, ra, auditSpan);
        if (this.changeDetectionPolicy.getSource() != ChangeDetectionPolicy.Source.None && fileStatus.getEtag() != null) {
            ChangeTracker changeTracker = new ChangeTracker(this.uri.toString(), this.changeDetectionPolicy, readContext.getS3AStatisticsContext().newInputStreamStatistics().getChangeTrackerStatistics(), objectAttributes);
            Invoker readInvoker = readContext.getReadInvoker();
            this.getObjectMetadata(path, changeTracker, readInvoker, "select");
        }
        SelectBinding selectBinding = new SelectBinding(this.createWriteOperationHelper(auditSpan));
        return selectBinding.select(readContext, expression, options, objectAttributes);
    }

    private void requireSelectSupport(Path source) throws UnsupportedOperationException {
        if (!this.isCSEEnabled && !SelectBinding.isSelectEnabled(this.getConf())) {
            throw new UnsupportedOperationException("S3 Select is not supported");
        }
    }

    private S3AFileStatus extractOrFetchSimpleFileStatus(Path path, Optional<S3AFileStatus> optStatus) throws IOException {
        S3AFileStatus fileStatus = optStatus.isPresent() ? optStatus.get() : this.innerGetFileStatus(path, false, StatusProbeEnum.HEAD_ONLY);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException(path.toString() + " is a directory");
        }
        return fileStatus;
    }

    public CompletableFuture<FSDataInputStream> openFileWithOptions(Path rawPath, OpenFileParameters parameters) throws IOException {
        S3AFileStatus fileStatus;
        boolean isSelect;
        Path path = this.qualify(rawPath);
        Configuration options = parameters.getOptions();
        Set mandatoryKeys = parameters.getMandatoryKeys();
        String sql = options.get("fs.s3a.select.sql", null);
        boolean bl = isSelect = sql != null;
        if (isSelect) {
            AbstractFSBuilderImpl.rejectUnknownMandatoryKeys((Set)mandatoryKeys, InternalSelectConstants.SELECT_OPTIONS, (String)("for " + path + " in S3 Select operation"));
        } else {
            AbstractFSBuilderImpl.rejectUnknownMandatoryKeys((Set)mandatoryKeys, InternalConstants.STANDARD_OPENFILE_KEYS, (String)("for " + path + " in non-select file I/O"));
        }
        FileStatus providedStatus = parameters.getStatus();
        if (providedStatus != null) {
            Preconditions.checkArgument((boolean)path.equals((Object)providedStatus.getPath()), (String)"FileStatus parameter is not for the path %s: %s", (Object)path, (Object)providedStatus);
            if (providedStatus instanceof S3AFileStatus) {
                LOG.debug("File was opened with a supplied S3AFileStatus; skipping getFileStatus call in open() operation: {}", (Object)providedStatus);
                fileStatus = (S3AFileStatus)providedStatus;
            } else if (providedStatus instanceof S3ALocatedFileStatus) {
                LOG.debug("File was opened with a supplied S3ALocatedFileStatus; skipping getFileStatus call in open() operation: {}", (Object)providedStatus);
                fileStatus = ((S3ALocatedFileStatus)providedStatus).toS3AFileStatus();
            } else {
                LOG.debug("Ignoring file status {}", (Object)providedStatus);
                fileStatus = null;
            }
        } else {
            fileStatus = null;
        }
        Optional<Object> ost = Optional.ofNullable(fileStatus);
        CompletableFuture<FSDataInputStream> result = new CompletableFuture<FSDataInputStream>();
        if (!isSelect) {
            this.unboundedThreadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> this.open(path, Optional.of(options), ost)));
        } else {
            this.requireSelectSupport(path);
            this.unboundedThreadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> this.select(path, sql, options, ost)));
        }
        return result;
    }

    @InterfaceAudience.Private
    public StoreContext createStoreContext() {
        return new StoreContextBuilder().setFsURI(this.getUri()).setBucket(this.getBucket()).setConfiguration(this.getConf()).setUsername(this.getUsername()).setOwner(this.owner).setExecutor(this.boundedThreadPool).setExecutorCapacity(this.executorCapacity).setInvoker(this.invoker).setInstrumentation(this.statisticsContext).setStorageStatistics(this.getStorageStatistics()).setInputPolicy(this.getInputPolicy()).setChangeDetectionPolicy(this.changeDetectionPolicy).setMultiObjectDeleteEnabled(this.enableMultiObjectsDelete).setMetadataStore(this.metadataStore).setUseListV1(this.useListV1).setContextAccessors(new ContextAccessorsImpl()).setTimeProvider(this.getTtlTimeProvider()).setAuditor(this.getAuditor()).setEnableCSE(this.isCSEEnabled).build();
    }

    @InterfaceAudience.Private
    public MarkerToolOperations createMarkerToolOperations(String target) throws IOException {
        this.createSpan("marker-tool-scan", target, null);
        return new MarkerToolOperationsImpl(new OperationCallbacksImpl());
    }

    @InterfaceAudience.Private
    public static void initializeClass() {
        LOG.debug("Initialize S3A class");
    }

    public boolean isCSEEnabled() {
        return this.isCSEEnabled;
    }

    static {
        S3AFileSystem.addDeprecatedKeys();
    }

    private class ContextAccessorsImpl
    implements ContextAccessors {
        private ContextAccessorsImpl() {
        }

        @Override
        public Path keyToPath(String key) {
            return S3AFileSystem.this.keyToQualifiedPath(key);
        }

        @Override
        public String pathToKey(Path path) {
            return S3AFileSystem.this.pathToKey(path);
        }

        @Override
        public File createTempFile(String prefix, long size) throws IOException {
            return S3AFileSystem.this.createTmpFileForWrite(prefix, size, S3AFileSystem.this.getConf());
        }

        @Override
        public String getBucketLocation() throws IOException {
            return S3AFileSystem.this.getBucketLocation();
        }

        @Override
        public Path makeQualified(Path path) {
            return S3AFileSystem.this.makeQualified(path);
        }

        @Override
        public AuditSpan getActiveAuditSpan() {
            return S3AFileSystem.this.getActiveAuditSpan();
        }

        @Override
        public RequestFactory getRequestFactory() {
            return S3AFileSystem.this.getRequestFactory();
        }
    }

    protected final class HeaderProcessingCallbacksImpl
    implements HeaderProcessing.HeaderProcessingCallbacks {
        protected HeaderProcessingCallbacksImpl() {
        }

        @Override
        public ObjectMetadata getObjectMetadata(String key) throws IOException {
            return (ObjectMetadata)Invoker.once("getObjectMetadata", key, () -> S3AFileSystem.this.getObjectMetadata(key));
        }
    }

    protected class CopyFromLocalCallbacksImpl
    implements CopyFromLocalOperation.CopyFromLocalOperationCallbacks {
        private final LocalFileSystem local;

        private CopyFromLocalCallbacksImpl(LocalFileSystem local) {
            this.local = local;
        }

        @Override
        public RemoteIterator<LocatedFileStatus> listLocalStatusIterator(Path path) throws IOException {
            return this.local.listLocatedStatus(path);
        }

        @Override
        public File pathToLocalFile(Path path) {
            return this.local.pathToFile(path);
        }

        @Override
        public boolean deleteLocal(Path path, boolean recursive) throws IOException {
            return this.local.delete(path, recursive);
        }

        @Override
        public void copyLocalFileFromTo(File file, Path from, Path to) throws IOException {
            S3AFileSystem.this.trackDurationAndSpan(Statistic.OBJECT_PUT_REQUESTS, to, () -> {
                String key = S3AFileSystem.this.pathToKey(to);
                ObjectMetadata om = S3AFileSystem.this.newObjectMetadata(file.length());
                Progressable progress = null;
                PutObjectRequest putObjectRequest = S3AFileSystem.this.newPutObjectRequest(key, om, file);
                S3AFileSystem.this.invoker.retry("putObject()", to.toString(), true, () -> S3AFileSystem.this.executePut(putObjectRequest, progress));
                return null;
            });
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            return S3AFileSystem.this.getFileStatus(f);
        }

        @Override
        public boolean createEmptyDir(Path path, StoreContext storeContext) throws IOException {
            return (Boolean)IOStatisticsBinding.trackDuration((DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory(), (String)Statistic.INVOCATION_MKDIRS.getSymbol(), (CallableRaisingIOE)new MkdirOperation(storeContext, path, S3AFileSystem.this.createMkdirOperationCallbacks()));
        }
    }

    protected class GetContentSummaryCallbacksImpl
    implements GetContentSummaryOperation.GetContentSummaryCallbacks {
        protected GetContentSummaryCallbacksImpl() {
        }

        @Override
        public S3AFileStatus probePathStatus(Path path, Set<StatusProbeEnum> probes) throws IOException {
            return S3AFileSystem.this.innerGetFileStatus(path, false, probes);
        }

        @Override
        public RemoteIterator<S3AFileStatus> listStatusIterator(Path path) throws IOException {
            return S3AFileSystem.this.innerListStatus(path);
        }
    }

    protected class MkdirOperationCallbacksImpl
    implements MkdirOperation.MkdirCallbacks {
        protected MkdirOperationCallbacksImpl() {
        }

        @Override
        public S3AFileStatus probePathStatus(Path path, Set<StatusProbeEnum> probes) throws IOException {
            return S3AFileSystem.this.innerGetFileStatus(path, false, probes);
        }

        @Override
        public void createFakeDirectory(String key) throws IOException {
            S3AFileSystem.this.createEmptyObject(key);
        }
    }

    protected class ListingOperationCallbacksImpl
    implements ListingOperationCallbacks {
        protected ListingOperationCallbacksImpl() {
        }

        @Override
        public CompletableFuture<S3ListResult> listObjectsAsync(S3ListRequest request, DurationTrackerFactory trackerFactory, AuditSpan span) throws IOException {
            return CallableSupplier.submit(S3AFileSystem.this.unboundedThreadPool, span, () -> S3AFileSystem.this.listObjects(request, IOStatisticsBinding.pairedTrackerFactory((DurationTrackerFactory)trackerFactory, (DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory())));
        }

        @Override
        public CompletableFuture<S3ListResult> continueListObjectsAsync(S3ListRequest request, S3ListResult prevResult, DurationTrackerFactory trackerFactory, AuditSpan span) throws IOException {
            return CallableSupplier.submit(S3AFileSystem.this.unboundedThreadPool, span, () -> S3AFileSystem.this.continueListObjects(request, prevResult, IOStatisticsBinding.pairedTrackerFactory((DurationTrackerFactory)trackerFactory, (DurationTrackerFactory)S3AFileSystem.this.getDurationTrackerFactory())));
        }

        @Override
        public S3ALocatedFileStatus toLocatedFileStatus(S3AFileStatus status) throws IOException {
            return S3AFileSystem.this.toLocatedFileStatus(status);
        }

        @Override
        public S3ListRequest createListObjectsRequest(String key, String delimiter, AuditSpan span) {
            span.activate();
            return S3AFileSystem.this.createListObjectsRequest(key, delimiter);
        }

        @Override
        public long getDefaultBlockSize(Path path) {
            return S3AFileSystem.this.getDefaultBlockSize(path);
        }

        @Override
        public int getMaxKeys() {
            return S3AFileSystem.this.getMaxKeys();
        }

        @Override
        public ITtlTimeProvider getUpdatedTtlTimeProvider() {
            return S3AFileSystem.this.ttlTimeProvider;
        }

        @Override
        public boolean allowAuthoritative(Path p) {
            return S3AFileSystem.this.allowAuthoritative(p);
        }
    }

    private final class OperationCallbacksImpl
    implements OperationCallbacks {
        private final AuditSpan auditSpan;

        private OperationCallbacksImpl() {
            this.auditSpan = S3AFileSystem.this.getActiveAuditSpan();
        }

        @Override
        public S3ObjectAttributes createObjectAttributes(Path path, String eTag, String versionId, long len) {
            return S3AFileSystem.this.createObjectAttributes(path, eTag, versionId, len);
        }

        @Override
        public S3ObjectAttributes createObjectAttributes(S3AFileStatus fileStatus) {
            return S3AFileSystem.this.createObjectAttributes(fileStatus);
        }

        @Override
        public S3AReadOpContext createReadContext(FileStatus fileStatus) {
            return S3AFileSystem.this.createReadContext(fileStatus, S3AFileSystem.this.inputPolicy, S3AFileSystem.this.changeDetectionPolicy, S3AFileSystem.this.readAhead, this.auditSpan);
        }

        @Override
        public void deleteObjectAtPath(Path path, String key, boolean isFile, BulkOperationState operationState) throws IOException {
            this.auditSpan.activate();
            Invoker.once("delete", path.toString(), () -> S3AFileSystem.this.deleteObjectAtPath(path, key, isFile, operationState));
        }

        @Override
        public RemoteIterator<S3ALocatedFileStatus> listFilesAndDirectoryMarkers(Path path, S3AFileStatus status, boolean collectTombstones, boolean includeSelf) throws IOException {
            this.auditSpan.activate();
            return S3AFileSystem.this.innerListFiles(path, true, includeSelf ? Listing.ACCEPT_ALL_BUT_S3N : new Listing.AcceptAllButSelfAndS3nDirs(path), status, collectTombstones, true);
        }

        @Override
        public CopyResult copyFile(String srcKey, String destKey, S3ObjectAttributes srcAttributes, S3AReadOpContext readContext) throws IOException {
            this.auditSpan.activate();
            return S3AFileSystem.this.copyFile(srcKey, destKey, srcAttributes.getLen(), srcAttributes, readContext);
        }

        @Override
        public void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean deleteFakeDir, List<Path> undeletedObjectsOnFailure, BulkOperationState operationState, boolean quiet) throws MultiObjectDeleteException, AmazonClientException, IOException {
            this.auditSpan.activate();
            S3AFileSystem.this.removeKeys(keysToDelete, deleteFakeDir, undeletedObjectsOnFailure, operationState, quiet);
        }

        @Override
        public void finishRename(Path sourceRenamed, Path destCreated) throws IOException {
            this.auditSpan.activate();
            Path destParent = destCreated.getParent();
            if (!sourceRenamed.getParent().equals((Object)destParent)) {
                LOG.debug("source & dest parents are different; fix up dir markers");
                if (!S3AFileSystem.this.keepDirectoryMarkers(destParent)) {
                    S3AFileSystem.this.deleteUnnecessaryFakeDirectories(destParent, null);
                }
                S3AFileSystem.this.maybeCreateFakeParentDirectory(sourceRenamed);
            }
        }

        @Override
        public boolean allowAuthoritative(Path p) {
            return S3AFileSystem.this.allowAuthoritative(p);
        }

        @Override
        public RemoteIterator<S3AFileStatus> listObjects(Path path, String key) throws IOException {
            return (RemoteIterator)Invoker.once("listObjects", key, () -> S3AFileSystem.this.listing.createFileStatusListingIterator(path, S3AFileSystem.this.createListObjectsRequest(key, null), S3AUtils.ACCEPT_ALL, Listing.ACCEPT_ALL_BUT_S3N, null, this.auditSpan));
        }
    }

    private final class InputStreamCallbacksImpl
    implements S3AInputStream.InputStreamCallbacks {
        private final AuditSpan auditSpan;

        private InputStreamCallbacksImpl(AuditSpan auditSpan) {
            this.auditSpan = Objects.requireNonNull(auditSpan);
        }

        @Override
        public void close() {
            this.auditSpan.close();
        }

        @Override
        public GetObjectRequest newGetRequest(String key) {
            try (AuditSpan span = this.auditSpan.activate();){
                GetObjectRequest getObjectRequest = S3AFileSystem.this.getRequestFactory().newGetObjectRequest(key);
                return getObjectRequest;
            }
        }

        @Override
        public S3Object getObject(GetObjectRequest request) {
            try (AuditSpan span = this.auditSpan.activate();){
                S3Object s3Object = S3AFileSystem.this.s3.getObject(request);
                return s3Object;
            }
        }
    }

    private class DelegationOperationsImpl
    implements DelegationOperations {
        private DelegationOperationsImpl() {
        }

        @Override
        public List<RoleModel.Statement> listAWSPolicyRules(Set<AWSPolicyProvider.AccessLevel> access) {
            return S3AFileSystem.this.listAWSPolicyRules(access);
        }
    }
}

