/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class STSClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(STSClientFactory.class);

    public static AWSSecurityTokenServiceClientBuilder builder(Configuration conf, String bucket, AWSCredentialsProvider credentials) throws IOException {
        ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, bucket, "STS");
        String endpoint = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint", "");
        String region = conf.getTrimmed("fs.s3a.assumed.role.sts.endpoint.region", "");
        return STSClientFactory.builder(credentials, awsConf, endpoint, region);
    }

    public static AWSSecurityTokenServiceClientBuilder builder(Configuration conf, String bucket, AWSCredentialsProvider credentials, String stsEndpoint, String stsRegion) throws IOException {
        ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, bucket, "STS");
        return STSClientFactory.builder(credentials, awsConf, stsEndpoint, stsRegion);
    }

    public static AWSSecurityTokenServiceClientBuilder builder(AWSCredentialsProvider credentials, ClientConfiguration awsConf, String stsEndpoint, String stsRegion) {
        AWSSecurityTokenServiceClientBuilder builder = AWSSecurityTokenServiceClientBuilder.standard();
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0, (Object)"No credentials");
        builder.withClientConfiguration(awsConf);
        builder.withCredentials(credentials);
        boolean destIsStandardEndpoint = "sts.amazonaws.com".equals(stsEndpoint);
        if (StringUtils.isNotEmpty((CharSequence)stsEndpoint) && !destIsStandardEndpoint) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)stsRegion), (String)"STS endpoint is set to %s but no signing region was provided", (Object)stsEndpoint);
            LOG.debug("STS Endpoint={}; region='{}'", (Object)stsEndpoint, (Object)stsRegion);
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(stsEndpoint, stsRegion));
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)stsRegion), (String)"STS signing region set set to %s but no STS endpoint specified", (Object)stsRegion);
        }
        return builder;
    }

    public static STSClient createClientConnection(AWSSecurityTokenService tokenService, Invoker invoker) throws IOException {
        return new STSClient(tokenService, invoker);
    }

    public static final class STSClient
    implements Closeable {
        private final AWSSecurityTokenService tokenService;
        private final Invoker invoker;

        private STSClient(AWSSecurityTokenService tokenService, Invoker invoker) {
            this.tokenService = tokenService;
            this.invoker = invoker;
        }

        @Override
        public void close() throws IOException {
            try {
                this.tokenService.shutdown();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        public Credentials requestSessionCredentials(long duration, TimeUnit timeUnit) throws IOException {
            int durationSeconds = (int)timeUnit.toSeconds(duration);
            LOG.debug("Requesting session token of duration {}", (Object)duration);
            GetSessionTokenRequest request = new GetSessionTokenRequest();
            request.setDurationSeconds(Integer.valueOf(durationSeconds));
            return (Credentials)this.invoker.retry("request session credentials", "", true, () -> {
                LOG.info("Requesting Amazon STS Session credentials");
                return this.tokenService.getSessionToken(request).getCredentials();
            });
        }

        public Credentials requestRole(String roleARN, String sessionName, String policy, long duration, TimeUnit timeUnit) throws IOException {
            LOG.debug("Requesting role {} with duration {}; policy = {}", new Object[]{roleARN, duration, policy});
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setDurationSeconds(Integer.valueOf((int)timeUnit.toSeconds(duration)));
            request.setRoleArn(roleARN);
            request.setRoleSessionName(sessionName);
            if (StringUtils.isNotEmpty((CharSequence)policy)) {
                request.setPolicy(policy);
            }
            return (Credentials)this.invoker.retry("request role credentials", "", true, () -> this.tokenService.assumeRole(request).getCredentials());
        }
    }
}

