/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.impl.CallableSupplier;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.impl.OperationCallbacks;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditingFunctions;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOperation
extends ExecutingStoreOperation<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteOperation.class);
    private final S3AFileStatus status;
    private final boolean recursive;
    private final OperationCallbacks callbacks;
    private final int pageSize;
    private final MetadataStore metadataStore;
    private final ListeningExecutorService executor;
    private List<DeleteEntry> keys;
    private List<Path> paths;
    private CompletableFuture<Void> deleteFuture;
    private BulkOperationState operationState;
    private long filesDeleted;
    private long extraFilesDeleted;

    public DeleteOperation(StoreContext context, S3AFileStatus status, boolean recursive, OperationCallbacks callbacks, int pageSize) {
        super(context);
        this.status = status;
        this.recursive = recursive;
        this.callbacks = callbacks;
        Preconditions.checkArgument((pageSize > 0 && pageSize <= 1000 ? 1 : 0) != 0, (String)"page size out of range: %s", (int)pageSize);
        this.pageSize = pageSize;
        this.metadataStore = context.getMetadataStore();
        this.executor = context.createThrottledExecutor(1);
    }

    public long getFilesDeleted() {
        return this.filesDeleted;
    }

    public long getExtraFilesDeleted() {
        return this.extraFilesDeleted;
    }

    @Override
    public Boolean execute() throws IOException {
        this.executeOnlyOnce();
        StoreContext context = this.getStoreContext();
        Path path = this.status.getPath();
        LOG.debug("Delete path {} - recursive {}", (Object)path, (Object)this.recursive);
        LOG.debug("Type = {}", (Object)(this.status.isFile() ? "File" : (this.status.isEmptyDirectory() == Tristate.TRUE ? "Empty Directory" : "Directory")));
        String key = context.pathToKey(path);
        if (this.status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)path);
            Preconditions.checkArgument((this.status.isEmptyDirectory() != Tristate.UNKNOWN ? 1 : 0) != 0, (Object)"File status must have directory emptiness computed");
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if ("/".equals(key)) {
                LOG.error("S3A: Cannot delete the root directory. Path: {}. Recursive: {}", (Object)this.status.getPath(), (Object)this.recursive);
                return false;
            }
            if (!this.recursive && this.status.isEmptyDirectory() == Tristate.FALSE) {
                throw new PathIsNotEmptyDirectoryException(path.toString());
            }
            if (this.status.isEmptyDirectory() == Tristate.TRUE) {
                LOG.debug("deleting empty directory {}", (Object)path);
                this.deleteObjectAtPath(path, key, false);
            } else {
                this.deleteDirectoryTree(path, key);
            }
        } else {
            LOG.debug("deleting simple file {}", (Object)path);
            this.deleteObjectAtPath(path, key, true);
        }
        LOG.debug("Deleted {} objects", (Object)this.filesDeleted);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDirectoryTree(Path path, String dirKey) throws IOException {
        this.operationState = S3Guard.initiateBulkWrite(this.metadataStore, BulkOperationState.OperationType.Delete, path);
        try (DurationInfo ignored = new DurationInfo(LOG, false, "deleting %s", new Object[]{dirKey});){
            this.resetDeleteList();
            this.deleteFuture = null;
            LOG.debug("Getting objects for directory prefix {} to delete", (Object)dirKey);
            RemoteIterator<S3ALocatedFileStatus> locatedFiles = this.callbacks.listFilesAndDirectoryMarkers(path, this.status, false, true);
            while (locatedFiles.hasNext()) {
                S3AFileStatus child = ((S3ALocatedFileStatus)((Object)locatedFiles.next())).toS3AFileStatus();
                this.queueForDeletion(child);
            }
            LOG.debug("Deleting final batch of listed files");
            this.submitNextBatch();
            CallableSupplier.maybeAwaitCompletion(this.deleteFuture);
            if (this.callbacks.allowAuthoritative(path)) {
                LOG.debug("Path is authoritatively guarded; listing files on S3 for completeness");
                RemoteIterator<S3AFileStatus> objects = this.callbacks.listObjects(path, dirKey);
                while (objects.hasNext()) {
                    ++this.extraFilesDeleted;
                    S3AFileStatus next = (S3AFileStatus)((Object)objects.next());
                    LOG.debug("Found Unlisted entry {}", (Object)next);
                    this.queueForDeletion(this.deletionKey(next), null, next.isDirectory());
                }
                if (this.extraFilesDeleted > 0L) {
                    LOG.debug("Raw S3 Scan found {} extra file(s) to delete", (Object)this.extraFilesDeleted);
                    this.submitNextBatch();
                    CallableSupplier.maybeAwaitCompletion(this.deleteFuture);
                }
            }
            try (DurationInfo ignored2 = new DurationInfo(LOG, false, "Delete metastore", new Object[0]);){
                this.metadataStore.deleteSubtree(path, this.operationState);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.operationState});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.operationState});
        LOG.debug("Delete \"{}\" completed; deleted {} objects", (Object)path, (Object)this.filesDeleted);
    }

    private String deletionKey(S3AFileStatus stat) {
        return this.getStoreContext().fullKey(stat);
    }

    private void queueForDeletion(S3AFileStatus stat) throws IOException {
        this.queueForDeletion(this.deletionKey(stat), stat.getPath(), stat.isDirectory());
    }

    private void queueForDeletion(String key, @Nullable Path deletePath, boolean isDirMarker) throws IOException {
        LOG.debug("Adding object to delete: \"{}\"", (Object)key);
        this.keys.add(new DeleteEntry(key, isDirMarker));
        if (deletePath != null && !isDirMarker) {
            this.paths.add(deletePath);
        }
        if (this.keys.size() == this.pageSize) {
            this.submitNextBatch();
        }
    }

    private void submitNextBatch() throws IOException {
        CallableSupplier.maybeAwaitCompletion(this.deleteFuture);
        this.deleteFuture = this.submitDelete(this.keys, this.paths);
        this.resetDeleteList();
    }

    private void resetDeleteList() {
        this.keys = new ArrayList<DeleteEntry>(this.pageSize);
        this.paths = new ArrayList<Path>(this.pageSize);
    }

    private void deleteObjectAtPath(Path path, String key, boolean isFile) throws IOException {
        LOG.debug("delete: {} {}", (Object)(isFile ? "file" : "dir marker"), (Object)key);
        ++this.filesDeleted;
        this.callbacks.deleteObjectAtPath(path, key, isFile, this.operationState);
    }

    private CompletableFuture<Void> submitDelete(List<DeleteEntry> keyList, List<Path> pathList) {
        if (keyList.isEmpty() && pathList.isEmpty()) {
            return null;
        }
        this.filesDeleted += (long)keyList.size();
        return CallableSupplier.submit((Executor)this.executor, AuditingFunctions.callableWithinAuditSpan((AuditSpan)this.getAuditSpan(), () -> {
            this.asyncDeleteAction(this.operationState, keyList, pathList, LOG.isDebugEnabled());
            return null;
        }));
    }

    private void asyncDeleteAction(BulkOperationState state, List<DeleteEntry> keyList, List<Path> pathList, boolean auditDeletedKeys) throws IOException {
        ArrayList deletedObjects = new ArrayList();
        try (DurationInfo ignored = new DurationInfo(LOG, false, "Delete page of %d keys", new Object[]{keyList.size()});){
            Object result = null;
            ArrayList undeletedObjects = new ArrayList();
            if (!keyList.isEmpty()) {
                List files = keyList.stream().filter(e -> !((DeleteEntry)e).isDirMarker).map(e -> ((DeleteEntry)e).keyVersion).collect(Collectors.toList());
                LOG.debug("Deleting of {} file objects", (Object)files.size());
                Invoker.once("Remove S3 Files", this.status.getPath().toString(), () -> this.callbacks.removeKeys(files, false, undeletedObjects, state, !auditDeletedKeys));
                if (result != null) {
                    deletedObjects.addAll(result.getDeletedObjects());
                }
                List dirs = keyList.stream().filter(e -> ((DeleteEntry)e).isDirMarker).map(e -> ((DeleteEntry)e).keyVersion).collect(Collectors.toList());
                LOG.debug("Deleting of {} directory markers", (Object)dirs.size());
                Invoker.once("Remove S3 Dir Markers", this.status.getPath().toString(), () -> this.callbacks.removeKeys(dirs, true, undeletedObjects, state, !auditDeletedKeys));
                if (result != null) {
                    deletedObjects.addAll(result.getDeletedObjects());
                }
            }
            if (!pathList.isEmpty()) {
                this.metadataStore.deletePaths(pathList, state);
            }
            if (auditDeletedKeys && deletedObjects.size() != keyList.size()) {
                LOG.warn("Size mismatch in deletion operation. Expected count of deleted files: {}; actual: {}", (Object)keyList.size(), (Object)deletedObjects.size());
                for (DeleteObjectsResult.DeletedObject del : deletedObjects) {
                    keyList.removeIf(kv -> kv.getKey().equals(del.getKey()));
                }
                for (DeleteEntry kv2 : keyList) {
                    LOG.debug("{}", (Object)kv2.getKey());
                }
            }
        }
    }

    private static final class DeleteEntry {
        private final DeleteObjectsRequest.KeyVersion keyVersion;
        private final boolean isDirMarker;

        private DeleteEntry(String key, boolean isDirMarker) {
            this.keyVersion = new DeleteObjectsRequest.KeyVersion(key);
            this.isDirMarker = isDirMarker;
        }

        public String getKey() {
            return this.keyVersion.getKey();
        }

        public String toString() {
            return "DeleteEntry{key='" + this.getKey() + '\'' + ", isDirMarker=" + this.isDirMarker + '}';
        }
    }
}

