/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.dynamodbv2.xspec.Condition;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.s3guard.AbstractS3GuardDynamoDBDiagnostic;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DumpS3GuardDynamoTable;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardTableAccess;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ExitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PurgeS3GuardDynamoTable
extends AbstractS3GuardDynamoDBDiagnostic {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeS3GuardDynamoTable.class);
    public static final String NAME = "PurgeS3GuardDynamoTable";
    public static final String FORCE = "-force";
    private static final String USAGE_MESSAGE = "PurgeS3GuardDynamoTable [-force] <filesystem>";
    private boolean force;
    private long filesFound;
    private long filesDeleted;

    public PurgeS3GuardDynamoTable(String name) {
        super(name);
    }

    public PurgeS3GuardDynamoTable() {
        this(NAME);
    }

    public PurgeS3GuardDynamoTable(S3AFileSystem filesystem, DynamoDBMetadataStore store, URI uri, boolean force) {
        super(NAME, filesystem, store, uri);
        this.force = force;
    }

    protected void serviceStart() throws Exception {
        if (this.getStore() == null) {
            List<String> arg = this.getArgumentList(1, 2, USAGE_MESSAGE);
            String fsURI = arg.get(0);
            if (arg.size() == 2) {
                if (!arg.get(0).equals(FORCE)) {
                    throw new ServiceLaunchException(42, USAGE_MESSAGE);
                }
                this.force = true;
                fsURI = arg.get(1);
            }
            this.bindFromCLI(fsURI);
        }
    }

    public int execute() throws ServiceLaunchException, IOException {
        URI uri = this.getUri();
        String host = uri.getHost();
        String prefix = "/" + host + "/";
        DynamoDBMetadataStore ddbms = this.getStore();
        S3GuardTableAccess tableAccess = new S3GuardTableAccess(ddbms);
        ExpressionSpecBuilder builder = new ExpressionSpecBuilder();
        builder.withKeyCondition((Condition)ExpressionSpecBuilder.S((String)"parent").beginsWith(prefix));
        LOG.info("Scanning for entries with prefix {} to delete from {}", (Object)prefix, (Object)ddbms);
        Iterable<DDBPathMetadata> entries = ddbms.wrapWithRetries(tableAccess.scanMetadata(builder));
        ArrayList list = new ArrayList();
        entries.iterator().forEachRemaining(e -> {
            if (!(e instanceof S3GuardTableAccess.VersionMarker)) {
                Path p = e.getFileStatus().getPath();
                String type = e.getFileStatus().isFile() ? "file" : "directory";
                boolean tombstone = e.isDeleted();
                if (tombstone) {
                    type = "tombstone " + type;
                }
                LOG.info("{} {}", (Object)type, (Object)p);
                list.add(p);
            }
        });
        int count = list.size();
        this.filesFound = count;
        LOG.info("Found {} entries{}", (Object)count, (Object)(count == 0 ? " -nothing to purge" : ""));
        if (count > 0) {
            if (this.force) {
                DurationInfo duration = new DurationInfo(LOG, "deleting %s entries from %s", new Object[]{count, ddbms.toString()});
                for (Path path : list) {
                    ddbms.getInvoker().retry("delete", prefix, true, () -> tableAccess.delete(path));
                }
                duration.close();
                long durationMillis = duration.value();
                long timePerEntry = durationMillis / (long)count;
                LOG.info("Time per entry: {} ms", (Object)timePerEntry);
                this.filesDeleted = count;
            } else {
                LOG.info("Delete process will only be executed when -force is set");
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        try {
            DumpS3GuardDynamoTable.serviceMain(Arrays.asList(args), new PurgeS3GuardDynamoTable());
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.terminate((ExitUtil.ExitException)e);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static Pair<Long, Long> purgeStore(@Nullable S3AFileSystem fs, @Nullable DynamoDBMetadataStore store, @Nullable Configuration conf, @Nullable URI uri, boolean force) throws ExitUtil.ExitException {
        PurgeS3GuardDynamoTable purge;
        ExitUtil.ExitException ex;
        ServiceLauncher serviceLauncher = new ServiceLauncher(NAME);
        if (conf == null) {
            conf = ((S3AFileSystem)Preconditions.checkNotNull((Object)fs, (Object)"No filesystem")).getConf();
        }
        if (store == null) {
            store = (DynamoDBMetadataStore)((S3AFileSystem)Preconditions.checkNotNull((Object)fs, (Object)"No filesystem")).getMetadataStore();
        }
        if ((ex = serviceLauncher.launchService(conf, (Service)(purge = new PurgeS3GuardDynamoTable(fs, store, uri, force)), Collections.emptyList(), false, true)) != null && ex.getExitCode() != 0) {
            throw ex;
        }
        return Pair.of((Object)purge.filesFound, (Object)purge.filesDeleted);
    }
}

