/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.constants;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class FileSystemConfigurations {
    public static final String USER_HOME_DIRECTORY_PREFIX = "/user";
    public static final int DEFAULT_MIN_BACKOFF_INTERVAL = 3000;
    public static final int DEFAULT_MAX_BACKOFF_INTERVAL = 30000;
    public static final int DEFAULT_BACKOFF_INTERVAL = 3000;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 30;
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 0x800000;
    public static final int DEFAULT_READ_BUFFER_SIZE = 0x400000;
    public static final int DEFAULT_READ_AHEAD_RANGE = 65536;
    public static final int MIN_BUFFER_SIZE = 16384;
    public static final int MAX_BUFFER_SIZE = 0x6400000;
    public static final long MAX_AZURE_BLOCK_SIZE = 0x10000000L;
    public static final String AZURE_BLOCK_LOCATION_HOST_DEFAULT = "localhost";
    public static final int MAX_CONCURRENT_READ_THREADS = 12;
    public static final int MAX_CONCURRENT_WRITE_THREADS = 8;
    public static final boolean DEFAULT_READ_TOLERATE_CONCURRENT_APPEND = false;
    public static final boolean DEFAULT_AZURE_CREATE_REMOTE_FILESYSTEM_DURING_INITIALIZATION = false;
    public static final boolean DEFAULT_AZURE_SKIP_USER_GROUP_METADATA_DURING_INITIALIZATION = false;
    public static final String DEFAULT_FS_AZURE_ATOMIC_RENAME_DIRECTORIES = "/hbase";
    public static final int DEFAULT_READ_AHEAD_QUEUE_DEPTH = -1;
    public static final boolean DEFAULT_ENABLE_FLUSH = true;
    public static final boolean DEFAULT_DISABLE_OUTPUTSTREAM_FLUSH = true;
    public static final boolean DEFAULT_ENABLE_AUTOTHROTTLING = true;
    public static final DelegatingSSLSocketFactory.SSLChannelMode DEFAULT_FS_AZURE_SSL_CHANNEL_MODE = DelegatingSSLSocketFactory.SSLChannelMode.Default;
    public static final boolean DEFAULT_ENABLE_DELEGATION_TOKEN = false;
    public static final boolean DEFAULT_ENABLE_HTTPS = true;
    public static final boolean DEFAULT_USE_UPN = false;
    public static final boolean DEFAULT_ENABLE_CHECK_ACCESS = false;
    public static final boolean DEFAULT_ABFS_LATENCY_TRACK = false;
    public static final boolean DEFAULT_ENABLE_READAHEAD = true;

    private FileSystemConfigurations() {
    }
}

