/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformerInterface;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityTransformer
implements IdentityTransformerInterface {
    private static final Logger LOG = LoggerFactory.getLogger(IdentityTransformer.class);
    private boolean isSecure;
    private String servicePrincipalId;
    private String serviceWhiteList;
    private String domainName;
    private boolean enableShortName;
    private boolean skipUserIdentityReplacement;
    private boolean skipSuperUserReplacement;
    private boolean domainIsSet;
    private static final String UUID_PATTERN = "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$";

    public IdentityTransformer(Configuration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        UserGroupInformation.getCurrentUser();
        this.isSecure = UserGroupInformation.isSecurityEnabled();
        this.servicePrincipalId = configuration.get("fs.azure.identity.transformer.service.principal.id", "");
        this.serviceWhiteList = configuration.get("fs.azure.identity.transformer.service.principal.substitution.list", "");
        this.domainName = configuration.get("fs.azure.identity.transformer.domain.name", "");
        this.enableShortName = configuration.getBoolean("fs.azure.identity.transformer.enable.short.name", false);
        this.skipUserIdentityReplacement = this.servicePrincipalId.isEmpty() && this.serviceWhiteList.isEmpty() && !this.enableShortName;
        this.skipSuperUserReplacement = configuration.getBoolean("fs.azure.identity.transformer.skip.superuser.replacement", false);
        if (this.enableShortName) {
            this.domainIsSet = !this.domainName.isEmpty();
        }
    }

    @Override
    public String transformIdentityForGetRequest(String originalIdentity, boolean isUserName, String localIdentity) throws IOException {
        if (originalIdentity == null) {
            originalIdentity = localIdentity;
        }
        if (!this.skipSuperUserReplacement && "$superuser".equals(originalIdentity)) {
            return localIdentity;
        }
        if (this.skipUserIdentityReplacement) {
            return originalIdentity;
        }
        if (originalIdentity.equals(this.servicePrincipalId) && this.isInSubstitutionList(localIdentity)) {
            return localIdentity;
        }
        if (isUserName && this.shouldUseShortUserName(originalIdentity)) {
            return this.getShortName(originalIdentity);
        }
        return originalIdentity;
    }

    @Override
    public String transformUserOrGroupForSetRequest(String userOrGroup) {
        if (userOrGroup == null || userOrGroup.isEmpty() || this.skipUserIdentityReplacement) {
            return userOrGroup;
        }
        if (this.isInSubstitutionList(userOrGroup)) {
            return this.servicePrincipalId;
        }
        if (this.shouldUseFullyQualifiedUserName(userOrGroup)) {
            return this.getFullyQualifiedName(userOrGroup);
        }
        return userOrGroup;
    }

    @Override
    public void transformAclEntriesForSetRequest(List<AclEntry> aclEntries) {
        if (this.skipUserIdentityReplacement) {
            return;
        }
        for (int i = 0; i < aclEntries.size(); ++i) {
            String name;
            AclEntry aclEntry = aclEntries.get(i);
            String transformedName = name = aclEntry.getName();
            if (name == null || name.isEmpty() || aclEntry.getType().equals((Object)AclEntryType.OTHER) || aclEntry.getType().equals((Object)AclEntryType.MASK)) continue;
            if (this.isInSubstitutionList(name)) {
                transformedName = this.servicePrincipalId;
            } else if (aclEntry.getType().equals((Object)AclEntryType.USER) && this.shouldUseFullyQualifiedUserName(name)) {
                transformedName = this.getFullyQualifiedName(name);
            }
            if (transformedName.equals(name)) continue;
            AclEntry.Builder aclEntryBuilder = new AclEntry.Builder();
            aclEntryBuilder.setType(aclEntry.getType());
            aclEntryBuilder.setName(transformedName);
            aclEntryBuilder.setScope(aclEntry.getScope());
            aclEntryBuilder.setPermission(aclEntry.getPermission());
            aclEntries.set(i, aclEntryBuilder.build());
        }
    }

    @Override
    public void transformAclEntriesForGetRequest(List<AclEntry> aclEntries, String localUser, String localGroup) throws IOException {
        if (this.skipUserIdentityReplacement) {
            return;
        }
        for (int i = 0; i < aclEntries.size(); ++i) {
            String name;
            AclEntry aclEntry = aclEntries.get(i);
            String transformedName = name = aclEntry.getName();
            if (name == null || name.isEmpty() || aclEntry.getType().equals((Object)AclEntryType.OTHER) || aclEntry.getType().equals((Object)AclEntryType.MASK)) continue;
            if (aclEntry.getType().equals((Object)AclEntryType.USER)) {
                transformedName = this.transformIdentityForGetRequest(name, true, localUser);
            } else if (aclEntry.getType().equals((Object)AclEntryType.GROUP)) {
                transformedName = this.transformIdentityForGetRequest(name, false, localGroup);
            }
            if (transformedName.equals(name)) continue;
            AclEntry.Builder aclEntryBuilder = new AclEntry.Builder();
            aclEntryBuilder.setType(aclEntry.getType());
            aclEntryBuilder.setName(transformedName);
            aclEntryBuilder.setScope(aclEntry.getScope());
            aclEntryBuilder.setPermission(aclEntry.getPermission());
            aclEntries.set(i, aclEntryBuilder.build());
        }
    }

    private boolean isShortUserName(String owner) {
        return owner != null && !owner.contains("@");
    }

    private boolean shouldUseShortUserName(String owner) {
        return this.enableShortName && !this.isShortUserName(owner);
    }

    private String getShortName(String userName) {
        if (userName == null) {
            return null;
        }
        if (this.isShortUserName(userName)) {
            return userName;
        }
        String userNameBeforeAt = userName.substring(0, userName.indexOf("@"));
        if (this.isSecure) {
            return userNameBeforeAt.toLowerCase(Locale.ENGLISH);
        }
        return userNameBeforeAt;
    }

    private String getFullyQualifiedName(String name) {
        if (this.domainIsSet && name != null && !name.contains("@")) {
            return name + "@" + this.domainName;
        }
        return name;
    }

    private boolean shouldUseFullyQualifiedUserName(String owner) {
        return this.domainIsSet && !"$superuser".equals(owner) && !this.isUuid(owner) && this.enableShortName && this.isShortUserName(owner);
    }

    private boolean isInSubstitutionList(String localUserName) {
        return this.serviceWhiteList.contains("*") || this.serviceWhiteList.contains(localUserName);
    }

    private boolean isUuid(String input) {
        if (input == null) {
            return false;
        }
        return input.matches(UUID_PATTERN);
    }
}

