/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsiTokenProvider
extends AccessTokenProvider {
    private final String authEndpoint;
    private final String authority;
    private final String tenantGuid;
    private final String clientId;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public MsiTokenProvider(String authEndpoint, String tenantGuid, String clientId, String authority) {
        this.authEndpoint = authEndpoint;
        this.tenantGuid = tenantGuid;
        this.clientId = clientId;
        this.authority = authority;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing token from MSI");
        AzureADToken token = AzureADAuthenticator.getTokenFromMsi(this.authEndpoint, this.tenantGuid, this.clientId, this.authority, false);
        return token;
    }
}

