/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;

public class SyncableDataOutputStream
extends DataOutputStream
implements Syncable,
StreamCapabilities {
    public SyncableDataOutputStream(OutputStream out) {
        super(out);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public OutputStream getOutStream() {
        return this.out;
    }

    public boolean hasCapability(String capability) {
        return StoreImplementationUtils.hasCapability((OutputStream)this.out, (String)capability);
    }

    public void hflush() throws IOException {
        if (this.out instanceof Syncable) {
            ((Syncable)this.out).hflush();
        }
    }

    public void hsync() throws IOException {
        if (this.out instanceof Syncable) {
            ((Syncable)this.out).hsync();
        }
    }
}

