/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class KeyShell
extends Configured
implements Tool {
    private static final String USAGE_PREFIX = "Usage: hadoop key [generic options]\n";
    private static final String COMMANDS = "   [-help]\n   [create <keyname> [-cipher <cipher>] [-size <size>]\n                     [-description <description>]\n                     [-attr <attribute=value>]\n                     [-provider <provider>] [-help]]\n   [roll <keyname> [-provider <provider>] [-help]]\n   [delete <keyname> [-provider <provider>] [-help]]\n   [list [-provider <provider>] [-metadata] [-help]]\n";
    private static final String LIST_METADATA = "keyShell.list.metadata";
    private boolean interactive = false;
    private Command command = null;
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private boolean userSuppliedProvider = false;

    @Override
    public int run(String[] args) throws Exception {
        int exitCode = 0;
        try {
            exitCode = this.init(args);
            if (exitCode != 0) {
                return exitCode;
            }
            if (this.command.validate()) {
                this.command.execute();
            } else {
                exitCode = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            return 1;
        }
        return exitCode;
    }

    private int init(String[] args) throws IOException {
        KeyProvider.Options options = KeyProvider.options(this.getConf());
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String keyName;
            boolean moreTokens;
            boolean bl = moreTokens = i < args.length - 1;
            if (args[i].equals("create")) {
                keyName = "-help";
                if (moreTokens) {
                    keyName = args[++i];
                }
                this.command = new CreateCommand(keyName, options);
                if (!"-help".equals(keyName)) continue;
                this.printKeyShellUsage();
                return 1;
            }
            if (args[i].equals("delete")) {
                keyName = "-help";
                if (moreTokens) {
                    keyName = args[++i];
                }
                this.command = new DeleteCommand(keyName);
                if (!"-help".equals(keyName)) continue;
                this.printKeyShellUsage();
                return 1;
            }
            if (args[i].equals("roll")) {
                keyName = "-help";
                if (moreTokens) {
                    keyName = args[++i];
                }
                this.command = new RollCommand(keyName);
                if (!"-help".equals(keyName)) continue;
                this.printKeyShellUsage();
                return 1;
            }
            if ("list".equals(args[i])) {
                this.command = new ListCommand();
                continue;
            }
            if ("-size".equals(args[i]) && moreTokens) {
                options.setBitLength(Integer.parseInt(args[++i]));
                continue;
            }
            if ("-cipher".equals(args[i]) && moreTokens) {
                options.setCipher(args[++i]);
                continue;
            }
            if ("-description".equals(args[i]) && moreTokens) {
                options.setDescription(args[++i]);
                continue;
            }
            if ("-attr".equals(args[i]) && moreTokens) {
                String[] attrval = args[++i].split("=", 2);
                String attr = attrval[0].trim();
                String val = attrval[1].trim();
                if (attr.isEmpty() || val.isEmpty()) {
                    this.out.println("\nAttributes must be in attribute=value form, or quoted\nlike \"attribute = value\"\n");
                    this.printKeyShellUsage();
                    return 1;
                }
                if (attributes.containsKey(attr)) {
                    this.out.println("\nEach attribute must correspond to only one value:\natttribute \"" + attr + "\" was repeated\n");
                    this.printKeyShellUsage();
                    return 1;
                }
                attributes.put(attr, val);
                continue;
            }
            if ("-provider".equals(args[i]) && moreTokens) {
                this.userSuppliedProvider = true;
                this.getConf().set("hadoop.security.key.provider.path", args[++i]);
                continue;
            }
            if ("-metadata".equals(args[i])) {
                this.getConf().setBoolean(LIST_METADATA, true);
                continue;
            }
            if ("-i".equals(args[i]) || "-interactive".equals(args[i])) {
                this.interactive = true;
                continue;
            }
            if ("-help".equals(args[i])) {
                this.printKeyShellUsage();
                return 1;
            }
            this.printKeyShellUsage();
            ToolRunner.printGenericCommandUsage(System.err);
            return 1;
        }
        if (this.command == null) {
            this.printKeyShellUsage();
            return 1;
        }
        if (!attributes.isEmpty()) {
            options.setAttributes(attributes);
        }
        return 0;
    }

    private void printKeyShellUsage() {
        this.out.println("Usage: hadoop key [generic options]\n   [-help]\n   [create <keyname> [-cipher <cipher>] [-size <size>]\n                     [-description <description>]\n                     [-attr <attribute=value>]\n                     [-provider <provider>] [-help]]\n   [roll <keyname> [-provider <provider>] [-help]]\n   [delete <keyname> [-provider <provider>] [-help]]\n   [list [-provider <provider>] [-metadata] [-help]]\n");
        if (this.command != null) {
            this.out.println(this.command.getUsage());
        } else {
            this.out.println("===============================================================");
            this.out.println("create <keyname> [-cipher <cipher>] [-size <size>]\n                     [-description <description>]\n                     [-attr <attribute=value>]\n                     [-provider <provider>] [-help]:\n\nThe create subcommand creates a new key for the name specified\nby the <keyname> argument within the provider specified by the\n-provider argument. You may specify a cipher with the -cipher\nargument. The default cipher is currently \"AES/CTR/NoPadding\".\nThe default keysize is 128. You may specify the requested key\nlength using the -size argument. Arbitrary attribute=value\nstyle attributes may be specified using the -attr argument.\n-attr may be specified multiple times, once per attribute.\n");
            this.out.println("===============================================================");
            this.out.println("roll <keyname> [-provider <provider>] [-help]:\n\nThe roll subcommand creates a new version for the specified key\nwithin the provider indicated using the -provider argument\n");
            this.out.println("===============================================================");
            this.out.println("delete <keyname> [-provider <provider>] [-help]:\n\nThe delete subcommand deletes all versions of the key\nspecified by the <keyname> argument from within the\nprovider specified -provider.");
            this.out.println("===============================================================");
            this.out.println("list [-provider <provider>] [-metadata] [-help]:\n\nThe list subcommand displays the keynames contained within\na particular provider as configured in core-site.xml or\nspecified with the -provider argument. -metadata displays\nthe metadata.");
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new Configuration(), new KeyShell(), args);
        System.exit(res);
    }

    private class CreateCommand
    extends Command {
        public static final String USAGE = "create <keyname> [-cipher <cipher>] [-size <size>]\n                     [-description <description>]\n                     [-attr <attribute=value>]\n                     [-provider <provider>] [-help]";
        public static final String DESC = "The create subcommand creates a new key for the name specified\nby the <keyname> argument within the provider specified by the\n-provider argument. You may specify a cipher with the -cipher\nargument. The default cipher is currently \"AES/CTR/NoPadding\".\nThe default keysize is 128. You may specify the requested key\nlength using the -size argument. Arbitrary attribute=value\nstyle attributes may be specified using the -attr argument.\n-attr may be specified multiple times, once per attribute.\n";
        final String keyName;
        final KeyProvider.Options options;

        public CreateCommand(String keyName, KeyProvider.Options options) {
            this.keyName = keyName;
            this.options = options;
        }

        @Override
        public boolean validate() {
            boolean rc = true;
            this.provider = this.getKeyProvider();
            if (this.provider == null) {
                KeyShell.this.out.println("There are no valid KeyProviders configured. No key\n was created. You can use the -provider option to specify\n a provider to use.");
                rc = false;
            }
            if (this.keyName == null) {
                KeyShell.this.out.println("Please provide a <keyname>. See the usage description with -help.");
                rc = false;
            }
            return rc;
        }

        @Override
        public void execute() throws IOException, NoSuchAlgorithmException {
            this.warnIfTransientProvider();
            try {
                this.provider.createKey(this.keyName, this.options);
                this.provider.flush();
                KeyShell.this.out.println(this.keyName + " has been successfully created with options " + this.options.toString() + ".");
                this.printProviderWritten();
            }
            catch (InvalidParameterException e) {
                KeyShell.this.out.println(this.keyName + " has not been created. " + e.toString());
                throw e;
            }
            catch (IOException e) {
                KeyShell.this.out.println(this.keyName + " has not been created. " + e.toString());
                throw e;
            }
            catch (NoSuchAlgorithmException e) {
                KeyShell.this.out.println(this.keyName + " has not been created. " + e.toString());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "create <keyname> [-cipher <cipher>] [-size <size>]\n                     [-description <description>]\n                     [-attr <attribute=value>]\n                     [-provider <provider>] [-help]:\n\nThe create subcommand creates a new key for the name specified\nby the <keyname> argument within the provider specified by the\n-provider argument. You may specify a cipher with the -cipher\nargument. The default cipher is currently \"AES/CTR/NoPadding\".\nThe default keysize is 128. You may specify the requested key\nlength using the -size argument. Arbitrary attribute=value\nstyle attributes may be specified using the -attr argument.\n-attr may be specified multiple times, once per attribute.\n";
        }
    }

    private class DeleteCommand
    extends Command {
        public static final String USAGE = "delete <keyname> [-provider <provider>] [-help]";
        public static final String DESC = "The delete subcommand deletes all versions of the key\nspecified by the <keyname> argument from within the\nprovider specified -provider.";
        String keyName;
        boolean cont;

        public DeleteCommand(String keyName) {
            this.keyName = null;
            this.cont = true;
            this.keyName = keyName;
        }

        @Override
        public boolean validate() {
            this.provider = this.getKeyProvider();
            if (this.provider == null) {
                KeyShell.this.out.println("There are no valid KeyProviders configured. Nothing\nwas deleted. Use the -provider option to specify a provider.");
                return false;
            }
            if (this.keyName == null) {
                KeyShell.this.out.println("There is no keyName specified. Please specify a <keyname>. See the usage description with -help.");
                return false;
            }
            if (KeyShell.this.interactive) {
                try {
                    this.cont = ToolRunner.confirmPrompt("You are about to DELETE all versions of  key: " + this.keyName + " from KeyProvider " + this.provider + ". Continue?:");
                    if (!this.cont) {
                        KeyShell.this.out.println("Nothing has been be deleted.");
                    }
                    return this.cont;
                }
                catch (IOException e) {
                    KeyShell.this.out.println(this.keyName + " will not be deleted.");
                    e.printStackTrace(KeyShell.this.err);
                }
            }
            return true;
        }

        @Override
        public void execute() throws IOException {
            this.warnIfTransientProvider();
            KeyShell.this.out.println("Deleting key: " + this.keyName + " from KeyProvider: " + this.provider);
            if (this.cont) {
                try {
                    this.provider.deleteKey(this.keyName);
                    this.provider.flush();
                    KeyShell.this.out.println(this.keyName + " has been successfully deleted.");
                    this.printProviderWritten();
                }
                catch (IOException e) {
                    KeyShell.this.out.println(this.keyName + " has not been deleted. " + e.toString());
                    throw e;
                }
            }
        }

        @Override
        public String getUsage() {
            return "delete <keyname> [-provider <provider>] [-help]:\n\nThe delete subcommand deletes all versions of the key\nspecified by the <keyname> argument from within the\nprovider specified -provider.";
        }
    }

    private class RollCommand
    extends Command {
        public static final String USAGE = "roll <keyname> [-provider <provider>] [-help]";
        public static final String DESC = "The roll subcommand creates a new version for the specified key\nwithin the provider indicated using the -provider argument\n";
        String keyName;

        public RollCommand(String keyName) {
            this.keyName = null;
            this.keyName = keyName;
        }

        @Override
        public boolean validate() {
            boolean rc = true;
            this.provider = this.getKeyProvider();
            if (this.provider == null) {
                KeyShell.this.out.println("There are no valid KeyProviders configured. The key\nhas not been rolled. Use the -provider option to specify\na provider.");
                rc = false;
            }
            if (this.keyName == null) {
                KeyShell.this.out.println("Please provide a <keyname>.\nSee the usage description by using -help.");
                rc = false;
            }
            return rc;
        }

        @Override
        public void execute() throws NoSuchAlgorithmException, IOException {
            try {
                this.warnIfTransientProvider();
                KeyShell.this.out.println("Rolling key version from KeyProvider: " + this.provider + "\n  for key name: " + this.keyName);
                try {
                    this.provider.rollNewVersion(this.keyName);
                    this.provider.flush();
                    KeyShell.this.out.println(this.keyName + " has been successfully rolled.");
                    this.printProviderWritten();
                }
                catch (NoSuchAlgorithmException e) {
                    KeyShell.this.out.println("Cannot roll key: " + this.keyName + " within KeyProvider: " + this.provider + ". " + e.toString());
                    throw e;
                }
            }
            catch (IOException e1) {
                KeyShell.this.out.println("Cannot roll key: " + this.keyName + " within KeyProvider: " + this.provider + ". " + e1.toString());
                throw e1;
            }
        }

        @Override
        public String getUsage() {
            return "roll <keyname> [-provider <provider>] [-help]:\n\nThe roll subcommand creates a new version for the specified key\nwithin the provider indicated using the -provider argument\n";
        }
    }

    private class ListCommand
    extends Command {
        public static final String USAGE = "list [-provider <provider>] [-metadata] [-help]";
        public static final String DESC = "The list subcommand displays the keynames contained within\na particular provider as configured in core-site.xml or\nspecified with the -provider argument. -metadata displays\nthe metadata.";
        private boolean metadata;

        private ListCommand() {
            this.metadata = false;
        }

        @Override
        public boolean validate() {
            boolean rc = true;
            this.provider = this.getKeyProvider();
            if (this.provider == null) {
                KeyShell.this.out.println("There are no non-transient KeyProviders configured.\nUse the -provider option to specify a provider. If you\nwant to list a transient provider then you must use the\n-provider argument.");
                rc = false;
            }
            this.metadata = KeyShell.this.getConf().getBoolean(KeyShell.LIST_METADATA, false);
            return rc;
        }

        @Override
        public void execute() throws IOException {
            try {
                List<String> keys = this.provider.getKeys();
                KeyShell.this.out.println("Listing keys for KeyProvider: " + this.provider);
                if (this.metadata) {
                    KeyProvider.Metadata[] meta = this.provider.getKeysMetadata(keys.toArray(new String[keys.size()]));
                    for (int i = 0; i < meta.length; ++i) {
                        KeyShell.this.out.println(keys.get(i) + " : " + meta[i]);
                    }
                } else {
                    for (String keyName : keys) {
                        KeyShell.this.out.println(keyName);
                    }
                }
            }
            catch (IOException e) {
                KeyShell.this.out.println("Cannot list keys for KeyProvider: " + this.provider + ": " + e.toString());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "list [-provider <provider>] [-metadata] [-help]:\n\nThe list subcommand displays the keynames contained within\na particular provider as configured in core-site.xml or\nspecified with the -provider argument. -metadata displays\nthe metadata.";
        }
    }

    private abstract class Command {
        protected KeyProvider provider = null;

        private Command() {
        }

        public boolean validate() {
            return true;
        }

        protected KeyProvider getKeyProvider() {
            KeyProvider provider;
            block4: {
                provider = null;
                try {
                    List<KeyProvider> providers = KeyProviderFactory.getProviders(KeyShell.this.getConf());
                    if (KeyShell.this.userSuppliedProvider) {
                        provider = providers.get(0);
                        break block4;
                    }
                    for (KeyProvider p : providers) {
                        if (p.isTransient()) continue;
                        provider = p;
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(KeyShell.this.err);
                }
            }
            return provider;
        }

        protected void printProviderWritten() {
            KeyShell.this.out.println(this.provider + " has been updated.");
        }

        protected void warnIfTransientProvider() {
            if (this.provider.isTransient()) {
                KeyShell.this.out.println("WARNING: you are modifying a transient provider.");
            }
        }

        public abstract void execute() throws Exception;

        public abstract String getUsage();
    }
}

