/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetworkTopology {
    public static final String DEFAULT_RACK = "/default-rack";
    public static final int DEFAULT_HOST_LEVEL = 2;
    public static final Logger LOG = LoggerFactory.getLogger(NetworkTopology.class);
    InnerNode clusterMap;
    private int depthOfAllLeaves = -1;
    protected int numOfRacks = 0;
    private boolean clusterEverBeenMultiRack = false;
    protected ReadWriteLock netlock = new ReentrantReadWriteLock();
    private static final Random r = new Random();

    public static NetworkTopology getInstance(Configuration conf) {
        return ReflectionUtils.newInstance(conf.getClass("net.topology.impl", NetworkTopology.class, NetworkTopology.class), conf);
    }

    public NetworkTopology() {
        this.clusterMap = new InnerNode("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Node node) {
        if (node == null) {
            return;
        }
        int newDepth = NodeBase.locationToDepth(node.getNetworkLocation()) + 1;
        this.netlock.writeLock().lock();
        try {
            if (node instanceof InnerNode) {
                throw new IllegalArgumentException("Not allow to add an inner node: " + NodeBase.getPath(node));
            }
            if (this.depthOfAllLeaves != -1 && this.depthOfAllLeaves != newDepth) {
                LOG.error("Error: can't add leaf node {} at depth {} to topology:{}\n", new Object[]{NodeBase.getPath(node), newDepth, this});
                throw new InvalidTopologyException("Failed to add " + NodeBase.getPath(node) + ": You cannot have a rack and a non-rack node at the same " + "level of the network topology.");
            }
            Node rack = this.getNodeForNetworkLocation(node);
            if (rack != null && !(rack instanceof InnerNode)) {
                throw new IllegalArgumentException("Unexpected data node " + node.toString() + " at an illegal network location");
            }
            if (this.clusterMap.add(node)) {
                LOG.info("Adding a new node: " + NodeBase.getPath(node));
                if (rack == null) {
                    this.incrementRacks();
                }
                if (!(node instanceof InnerNode) && this.depthOfAllLeaves == -1) {
                    this.depthOfAllLeaves = node.getLevel();
                }
            }
            LOG.debug("NetworkTopology became:\n{}", (Object)this);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    protected void incrementRacks() {
        ++this.numOfRacks;
        if (!this.clusterEverBeenMultiRack && this.numOfRacks > 1) {
            this.clusterEverBeenMultiRack = true;
        }
    }

    protected Node getNodeForNetworkLocation(Node node) {
        return this.getNode(node.getNetworkLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> getDatanodesInRack(String loc) {
        this.netlock.readLock().lock();
        try {
            InnerNode rack;
            loc = NodeBase.normalize(loc);
            if (!"".equals(loc)) {
                loc = loc.substring(1);
            }
            if ((rack = (InnerNode)this.clusterMap.getLoc(loc)) == null) {
                List<Node> list = null;
                return list;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>(rack.getChildren());
            return arrayList;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof InnerNode) {
            throw new IllegalArgumentException("Not allow to remove an inner node: " + NodeBase.getPath(node));
        }
        LOG.info("Removing a node: " + NodeBase.getPath(node));
        this.netlock.writeLock().lock();
        try {
            InnerNode rack;
            if (this.clusterMap.remove(node) && (rack = (InnerNode)this.getNode(node.getNetworkLocation())) == null) {
                --this.numOfRacks;
            }
            LOG.debug("NetworkTopology became:\n{}", (Object)this);
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Node node) {
        if (node == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            Node parent = node.getParent();
            for (int level = node.getLevel(); parent != null && level > 0; parent = parent.getParent(), --level) {
                if (parent != this.clusterMap) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(String loc) {
        this.netlock.readLock().lock();
        try {
            loc = NodeBase.normalize(loc);
            if (!"".equals(loc)) {
                loc = loc.substring(1);
            }
            Node node = this.clusterMap.getLoc(loc);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public boolean hasClusterEverBeenMultiRack() {
        return this.clusterEverBeenMultiRack;
    }

    public String getRack(String loc) {
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumOfRacks() {
        this.netlock.readLock().lock();
        try {
            int n = this.numOfRacks;
            return n;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumOfLeaves() {
        this.netlock.readLock().lock();
        try {
            int n = this.clusterMap.getNumOfLeaves();
            return n;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDistance(Node node1, Node node2) {
        if (node1 == node2) {
            return 0;
        }
        Node n1 = node1;
        Node n2 = node2;
        int dis = 0;
        this.netlock.readLock().lock();
        try {
            int level1 = node1.getLevel();
            int level2 = node2.getLevel();
            while (n1 != null && level1 > level2) {
                n1 = n1.getParent();
                --level1;
                ++dis;
            }
            while (n2 != null && level2 > level1) {
                n2 = n2.getParent();
                --level2;
                ++dis;
            }
            while (n1 != null && n2 != null && n1.getParent() != n2.getParent()) {
                n1 = n1.getParent();
                n2 = n2.getParent();
                dis += 2;
            }
        }
        finally {
            this.netlock.readLock().unlock();
        }
        if (n1 == null) {
            LOG.warn("The cluster does not contain node: " + NodeBase.getPath(node1));
            return Integer.MAX_VALUE;
        }
        if (n2 == null) {
            LOG.warn("The cluster does not contain node: " + NodeBase.getPath(node2));
            return Integer.MAX_VALUE;
        }
        return dis + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnSameRack(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = this.isSameParents(node1, node2);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public boolean isNodeGroupAware() {
        return false;
    }

    public boolean isOnSameNodeGroup(Node node1, Node node2) {
        return false;
    }

    protected boolean isSameParents(Node node1, Node node2) {
        return node1.getParent() == node2.getParent();
    }

    @VisibleForTesting
    void setRandomSeed(long seed) {
        r.setSeed(seed);
    }

    public Node chooseRandom(String scope) {
        return this.chooseRandom(scope, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node chooseRandom(String scope, Collection<Node> excludedNodes) {
        this.netlock.readLock().lock();
        try {
            if (scope.startsWith("~")) {
                Node node = this.chooseRandom("", scope.substring(1), excludedNodes);
                return node;
            }
            Node node = this.chooseRandom(scope, null, excludedNodes);
            return node;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    private Node chooseRandom(String scope, String excludedScope, Collection<Node> excludedNodes) {
        Node node;
        if (excludedScope != null) {
            if (scope.startsWith(excludedScope)) {
                return null;
            }
            if (!excludedScope.startsWith(scope)) {
                excludedScope = null;
            }
        }
        if (!((node = this.getNode(scope)) instanceof InnerNode)) {
            return excludedNodes != null && excludedNodes.contains(node) ? null : node;
        }
        InnerNode innerNode = (InnerNode)node;
        int numOfDatanodes = innerNode.getNumOfLeaves();
        if (excludedScope == null) {
            node = null;
        } else {
            node = this.getNode(excludedScope);
            numOfDatanodes = !(node instanceof InnerNode) ? --numOfDatanodes : (numOfDatanodes -= ((InnerNode)node).getNumOfLeaves());
        }
        if (numOfDatanodes <= 0) {
            LOG.debug("Failed to find datanode (scope=\"{}\" excludedScope=\"{}\"). numOfDatanodes={}", new Object[]{scope, excludedScope, numOfDatanodes});
            return null;
        }
        int availableNodes = excludedScope == null ? this.countNumOfAvailableNodes(scope, excludedNodes) : this.countNumOfAvailableNodes("~" + excludedScope, excludedNodes);
        LOG.debug("Choosing random from {} available nodes on node {}, scope={}, excludedScope={}, excludeNodes={}. numOfDatanodes={}.", new Object[]{availableNodes, innerNode, scope, excludedScope, excludedNodes, numOfDatanodes});
        Node ret = null;
        if (availableNodes > 0) {
            ret = this.chooseRandom(innerNode, node, excludedNodes, numOfDatanodes, availableNodes);
        }
        LOG.debug("chooseRandom returning {}", ret);
        return ret;
    }

    private Node chooseRandom(InnerNode parentNode, Node excludedScopeNode, Collection<Node> excludedNodes, int totalInScopeNodes, int availableNodes) {
        Preconditions.checkArgument((totalInScopeNodes >= availableNodes && availableNodes > 0 ? 1 : 0) != 0, (Object)String.format("%d should >= %d, and both should be positive.", totalInScopeNodes, availableNodes));
        if (excludedNodes == null || excludedNodes.isEmpty()) {
            int index = r.nextInt(totalInScopeNodes);
            return parentNode.getLeaf(index, excludedScopeNode);
        }
        int nthValidToReturn = r.nextInt(availableNodes);
        LOG.debug("nthValidToReturn is {}", (Object)nthValidToReturn);
        Node ret = parentNode.getLeaf(r.nextInt(totalInScopeNodes), excludedScopeNode);
        if (!excludedNodes.contains(ret)) {
            LOG.debug("Chosen node {} from first random", (Object)ret);
            return ret;
        }
        ret = null;
        Node lastValidNode = null;
        for (int i = 0; i < totalInScopeNodes; ++i) {
            ret = parentNode.getLeaf(i, excludedScopeNode);
            if (!excludedNodes.contains(ret)) {
                if (nthValidToReturn == 0) break;
                --nthValidToReturn;
                lastValidNode = ret;
                continue;
            }
            LOG.debug("Node {} is excluded, continuing.", (Object)ret);
            ret = null;
        }
        if (ret == null && lastValidNode != null) {
            LOG.error("BUG: Found lastValidNode {} but not nth valid node. parentNode={}, excludedScopeNode={}, excludedNodes={}, totalInScopeNodes={}, availableNodes={}, nthValidToReturn={}.", new Object[]{lastValidNode, parentNode, excludedScopeNode, excludedNodes, totalInScopeNodes, availableNodes, nthValidToReturn});
            ret = lastValidNode;
        }
        return ret;
    }

    public List<Node> getLeaves(String scope) {
        Node node = this.getNode(scope);
        ArrayList<Node> leafNodes = new ArrayList<Node>();
        if (!(node instanceof InnerNode)) {
            leafNodes.add(node);
        } else {
            InnerNode innerNode = (InnerNode)node;
            for (int i = 0; i < innerNode.getNumOfLeaves(); ++i) {
                leafNodes.add(innerNode.getLeaf(i, null));
            }
        }
        return leafNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int countNumOfAvailableNodes(String scope, Collection<Node> excludedNodes) {
        boolean isExcluded = false;
        if (scope.startsWith("~")) {
            isExcluded = true;
            scope = scope.substring(1);
        }
        scope = NodeBase.normalize(scope);
        int excludedCountInScope = 0;
        int excludedCountOffScope = 0;
        this.netlock.readLock().lock();
        try {
            if (excludedNodes != null) {
                for (Node node : excludedNodes) {
                    if ((node = this.getNode(NodeBase.getPath(node))) == null) continue;
                    if ((NodeBase.getPath(node) + "/").startsWith(scope + "/")) {
                        ++excludedCountInScope;
                        continue;
                    }
                    ++excludedCountOffScope;
                }
            }
            Node n = this.getNode(scope);
            int scopeNodeCount = 0;
            if (n != null) {
                ++scopeNodeCount;
            }
            if (n instanceof InnerNode) {
                scopeNodeCount = ((InnerNode)n).getNumOfLeaves();
            }
            if (isExcluded) {
                int n2 = this.clusterMap.getNumOfLeaves() - scopeNodeCount - excludedCountOffScope;
                return n2;
            }
            int n3 = scopeNodeCount - excludedCountInScope;
            return n3;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    public String toString() {
        StringBuilder tree = new StringBuilder();
        tree.append("Number of racks: ");
        tree.append(this.numOfRacks);
        tree.append("\n");
        int numOfLeaves = this.getNumOfLeaves();
        tree.append("Expected number of leaves:");
        tree.append(numOfLeaves);
        tree.append("\n");
        for (int i = 0; i < numOfLeaves; ++i) {
            tree.append(NodeBase.getPath(this.clusterMap.getLeaf(i, null)));
            tree.append("\n");
        }
        return tree.toString();
    }

    public static String getFirstHalf(String networkLocation) {
        int index = networkLocation.lastIndexOf("/");
        return networkLocation.substring(0, index);
    }

    public static String getLastHalf(String networkLocation) {
        int index = networkLocation.lastIndexOf("/");
        return networkLocation.substring(index);
    }

    protected int getWeight(Node reader, Node node) {
        int weight = 2;
        if (reader != null) {
            if (reader.equals(node)) {
                weight = 0;
            } else if (this.isOnSameRack(reader, node)) {
                weight = 1;
            }
        }
        return weight;
    }

    public void sortByDistance(Node reader, Node[] nodes, int activeLen) {
        int[] weights = new int[activeLen];
        for (int i = 0; i < activeLen; ++i) {
            weights[i] = this.getWeight(reader, nodes[i]);
        }
        TreeMap<Integer, List> tree = new TreeMap<Integer, List>();
        for (int i = 0; i < activeLen; ++i) {
            int weight = weights[i];
            Node node = nodes[i];
            List list = (List)tree.get(weight);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)1);
                tree.put(weight, list);
            }
            list.add(node);
        }
        int idx = 0;
        for (List list : tree.values()) {
            if (list == null) continue;
            Collections.shuffle(list, r);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                Node n;
                nodes[idx] = n = (Node)i$.next();
                ++idx;
            }
        }
        Preconditions.checkState((idx == activeLen ? 1 : 0) != 0, (Object)"Sorted the wrong number of nodes!");
    }

    static class InnerNode
    extends NodeBase {
        protected List<Node> children = new ArrayList<Node>();
        private int numOfLeaves;

        InnerNode(String path) {
            super(path);
        }

        InnerNode(String name, String location) {
            super(name, location);
        }

        InnerNode(String name, String location, InnerNode parent, int level) {
            super(name, location, parent, level);
        }

        List<Node> getChildren() {
            return this.children;
        }

        int getNumOfChildren() {
            return this.children.size();
        }

        boolean isRack() {
            if (this.children.isEmpty()) {
                return true;
            }
            Node firstChild = this.children.get(0);
            return !(firstChild instanceof InnerNode);
        }

        boolean isAncestor(Node n) {
            return InnerNode.getPath(this).equals("/") || (n.getNetworkLocation() + "/").startsWith(InnerNode.getPath(this) + "/");
        }

        boolean isParent(Node n) {
            return n.getNetworkLocation().equals(InnerNode.getPath(this));
        }

        private String getNextAncestorName(Node n) {
            int index;
            if (!this.isAncestor(n)) {
                throw new IllegalArgumentException(this + "is not an ancestor of " + n);
            }
            String name = n.getNetworkLocation().substring(InnerNode.getPath(this).length());
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if ((index = name.indexOf(47)) != -1) {
                name = name.substring(0, index);
            }
            return name;
        }

        boolean add(Node n) {
            if (!this.isAncestor(n)) {
                throw new IllegalArgumentException(n.getName() + ", which is located at " + n.getNetworkLocation() + ", is not a decendent of " + InnerNode.getPath(this));
            }
            if (this.isParent(n)) {
                n.setParent(this);
                n.setLevel(this.level + 1);
                for (int i = 0; i < this.children.size(); ++i) {
                    if (!this.children.get(i).getName().equals(n.getName())) continue;
                    this.children.set(i, n);
                    return false;
                }
                this.children.add(n);
                ++this.numOfLeaves;
                return true;
            }
            String parentName = this.getNextAncestorName(n);
            InnerNode parentNode = null;
            for (int i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).getName().equals(parentName)) continue;
                parentNode = (InnerNode)this.children.get(i);
                break;
            }
            if (parentNode == null) {
                parentNode = this.createParentNode(parentName);
                this.children.add(parentNode);
            }
            if (parentNode.add(n)) {
                ++this.numOfLeaves;
                return true;
            }
            return false;
        }

        protected InnerNode createParentNode(String parentName) {
            return new InnerNode(parentName, InnerNode.getPath(this), this, this.getLevel() + 1);
        }

        boolean remove(Node n) {
            int i;
            String parent = n.getNetworkLocation();
            String currentPath = InnerNode.getPath(this);
            if (!this.isAncestor(n)) {
                throw new IllegalArgumentException(n.getName() + ", which is located at " + parent + ", is not a descendent of " + currentPath);
            }
            if (this.isParent(n)) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    if (!this.children.get(i2).getName().equals(n.getName())) continue;
                    this.children.remove(i2);
                    --this.numOfLeaves;
                    n.setParent(null);
                    return true;
                }
                return false;
            }
            String parentName = this.getNextAncestorName(n);
            InnerNode parentNode = null;
            for (i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).getName().equals(parentName)) continue;
                parentNode = (InnerNode)this.children.get(i);
                break;
            }
            if (parentNode == null) {
                return false;
            }
            boolean isRemoved = parentNode.remove(n);
            if (isRemoved) {
                if (parentNode.getNumOfChildren() == 0) {
                    this.children.remove(i);
                }
                --this.numOfLeaves;
            }
            return isRemoved;
        }

        private Node getLoc(String loc) {
            if (loc == null || loc.length() == 0) {
                return this;
            }
            String[] path = loc.split("/", 2);
            Node childnode = null;
            for (int i = 0; i < this.children.size(); ++i) {
                if (!this.children.get(i).getName().equals(path[0])) continue;
                childnode = this.children.get(i);
            }
            if (childnode == null) {
                return null;
            }
            if (path.length == 1) {
                return childnode;
            }
            if (childnode instanceof InnerNode) {
                return ((InnerNode)childnode).getLoc(path[1]);
            }
            return null;
        }

        Node getLeaf(int leafIndex, Node excludedNode) {
            int numOfExcludedLeaves;
            int count = 0;
            boolean isLeaf = excludedNode == null || !(excludedNode instanceof InnerNode);
            int n = numOfExcludedLeaves = isLeaf ? 1 : ((InnerNode)excludedNode).getNumOfLeaves();
            if (this.isLeafParent()) {
                int excludedIndex;
                if (isLeaf && (excludedIndex = this.children.indexOf(excludedNode)) != -1 && leafIndex >= 0) {
                    int n2 = leafIndex = leafIndex >= excludedIndex ? leafIndex + 1 : leafIndex;
                }
                if (leafIndex < 0 || leafIndex >= this.getNumOfChildren()) {
                    return null;
                }
                return this.children.get(leafIndex);
            }
            for (int i = 0; i < this.children.size(); ++i) {
                InnerNode child = (InnerNode)this.children.get(i);
                if (excludedNode == null || excludedNode != child) {
                    int numOfLeaves = child.getNumOfLeaves();
                    if (excludedNode != null && child.isAncestor(excludedNode)) {
                        numOfLeaves -= numOfExcludedLeaves;
                    }
                    if (count + numOfLeaves > leafIndex) {
                        return child.getLeaf(leafIndex - count, excludedNode);
                    }
                    count += numOfLeaves;
                    continue;
                }
                excludedNode = null;
            }
            return null;
        }

        protected boolean isLeafParent() {
            return this.isRack();
        }

        protected boolean areChildrenLeaves() {
            return this.isRack();
        }

        int getNumOfLeaves() {
            return this.numOfLeaves;
        }
    }

    public static class InvalidTopologyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidTopologyException(String msg) {
            super(msg);
        }
    }
}

