/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.InputStream;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtils.class);
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String LOAD_EXTERNAL_DECL = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    public static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    public static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final AtomicBoolean CAN_SET_TRANSFORMER_ACCESS_EXTERNAL_DTD = new AtomicBoolean(true);
    private static final AtomicBoolean CAN_SET_TRANSFORMER_ACCESS_EXTERNAL_STYLESHEET = new AtomicBoolean(true);

    public static void transform(InputStream styleSheet, InputStream xml, Writer out) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tFactory = XMLUtils.newSecureTransformerFactory();
        Transformer transformer = tFactory.newTransformer(new StreamSource(styleSheet));
        transformer.transform(new StreamSource(xml), new StreamResult(out));
    }

    public static DocumentBuilderFactory newSecureDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
        dbf.setFeature(LOAD_EXTERNAL_DECL, false);
        dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        dbf.setFeature(CREATE_ENTITY_REF_NODES, false);
        return dbf;
    }

    public static SAXParserFactory newSecureSAXParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setFeature(DISALLOW_DOCTYPE_DECL, true);
        spf.setFeature(LOAD_EXTERNAL_DECL, false);
        spf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        spf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        return spf;
    }

    public static TransformerFactory newSecureTransformerFactory() throws TransformerConfigurationException {
        TransformerFactory trfactory = TransformerFactory.newInstance();
        trfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLUtils.setOptionalSecureTransformerAttributes(trfactory);
        return trfactory;
    }

    public static SAXTransformerFactory newSecureSAXTransformerFactory() throws TransformerConfigurationException {
        SAXTransformerFactory trfactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        trfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLUtils.setOptionalSecureTransformerAttributes(trfactory);
        return trfactory;
    }

    private static void setOptionalSecureTransformerAttributes(TransformerFactory transformerFactory) {
        XMLUtils.bestEffortSetAttribute(transformerFactory, CAN_SET_TRANSFORMER_ACCESS_EXTERNAL_DTD, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        XMLUtils.bestEffortSetAttribute(transformerFactory, CAN_SET_TRANSFORMER_ACCESS_EXTERNAL_STYLESHEET, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    static void bestEffortSetAttribute(TransformerFactory transformerFactory, AtomicBoolean flag, String name, Object value) {
        if (flag.get()) {
            try {
                transformerFactory.setAttribute(name, value);
            }
            catch (Throwable t) {
                flag.set(false);
                LOG.debug("Issue setting TransformerFactory attribute {}: {}", (Object)name, (Object)t.toString());
            }
        }
    }
}

