/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.functional.TaskPool;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class CloseableTaskPoolSubmitter
implements TaskPool.Submitter,
Closeable {
    private ExecutorService pool;

    public CloseableTaskPoolSubmitter(ExecutorService pool) {
        this.pool = Objects.requireNonNull(pool);
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            this.pool = null;
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.pool.submit(task);
    }
}

