/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Abortable;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FSDataOutputStream
extends DataOutputStream
implements Syncable,
CanSetDropBehind,
StreamCapabilities,
IOStatisticsSource,
Abortable {
    private final OutputStream wrappedStream;

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats) {
        this(out, stats, 0L);
    }

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats, long startPosition) {
        super(new PositionCache(out, stats, startPosition));
        this.wrappedStream = out;
    }

    public long getPos() {
        return ((PositionCache)this.out).getPos();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FSDataOutputStream{");
        sb.append("wrappedStream=").append(this.wrappedStream);
        sb.append('}');
        return sb.toString();
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public OutputStream getWrappedStream() {
        return this.wrappedStream;
    }

    @Override
    public boolean hasCapability(String capability) {
        return StoreImplementationUtils.hasCapability(this.wrappedStream, capability);
    }

    @Override
    public void hflush() throws IOException {
        if (this.wrappedStream instanceof Syncable) {
            ((Syncable)((Object)this.wrappedStream)).hflush();
        } else {
            this.wrappedStream.flush();
        }
    }

    @Override
    public void hsync() throws IOException {
        if (this.wrappedStream instanceof Syncable) {
            ((Syncable)((Object)this.wrappedStream)).hsync();
        } else {
            this.wrappedStream.flush();
        }
    }

    @Override
    public void setDropBehind(Boolean dropBehind) throws IOException {
        try {
            ((CanSetDropBehind)((Object)this.wrappedStream)).setDropBehind(dropBehind);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("the wrapped stream does not support setting the drop-behind caching setting.");
        }
    }

    @Override
    public IOStatistics getIOStatistics() {
        return IOStatisticsSupport.retrieveIOStatistics(this.wrappedStream);
    }

    @Override
    public Abortable.AbortableResult abort() {
        if (this.wrappedStream instanceof Abortable) {
            return ((Abortable)((Object)this.wrappedStream)).abort();
        }
        throw new UnsupportedOperationException("Abortable.abort() is not supported");
    }

    private static class PositionCache
    extends FilterOutputStream {
        private final FileSystem.Statistics statistics;
        private long position;

        PositionCache(OutputStream out, FileSystem.Statistics stats, long pos) {
            super(out);
            this.statistics = stats;
            this.position = pos;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.position;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(1L);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(len);
            }
        }

        long getPos() {
            return this.position;
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
        }
    }
}

