/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.hadoop.util.Time;

public class FoldedTreeSet<E>
implements SortedSet<E> {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private final Comparator<E> comparator;
    private Node<E> root;
    private int size;
    private int nodeCount;
    private int modCount;
    private Node<E> cachedNode;

    public FoldedTreeSet() {
        this(null);
    }

    public FoldedTreeSet(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    private Node<E> cachedOrNewNode(E entry) {
        Node<E> node = this.cachedNode != null ? this.cachedNode : new Node<E>();
        this.cachedNode = null;
        ++this.nodeCount;
        node.addEntryLeft(entry);
        return node;
    }

    private void cacheAndClear(Node<E> node) {
        if (this.cachedNode == null) {
            node.clear();
            this.cachedNode = node;
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public E first() {
        if (!this.isEmpty()) {
            Node<E> node = this.root.getLeftMostNode();
            return (E)((Node)node).entries[((Node)node).leftIndex];
        }
        return null;
    }

    @Override
    public E last() {
        if (!this.isEmpty()) {
            Node<E> node = this.root.getRightMostNode();
            return (E)((Node)node).entries[((Node)node).rightIndex];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    public E get(Object obj, Comparator<?> cmp) {
        Objects.requireNonNull(obj);
        Node node = this.root;
        while (node != null) {
            int leftIndex;
            Object[] entries = node.entries;
            int result = FoldedTreeSet.compare(obj, entries[leftIndex = node.leftIndex], cmp);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                return (E)entries[leftIndex];
            }
            int rightIndex = node.rightIndex;
            if (leftIndex != rightIndex) {
                result = FoldedTreeSet.compare(obj, entries[rightIndex], cmp);
            }
            if (result == 0) {
                return (E)entries[rightIndex];
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            int low = leftIndex + 1;
            int high = rightIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                result = FoldedTreeSet.compare(obj, entries[mid], cmp);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result < 0) {
                    high = mid - 1;
                    continue;
                }
                return (E)entries[mid];
            }
            return null;
        }
        return null;
    }

    public E get(E entry) {
        return this.get(entry, this.comparator);
    }

    @Override
    public boolean contains(Object obj) {
        return this.get(obj) != null;
    }

    private static int compare(Object lookup, Object stored, Comparator cmp) {
        return cmp != null ? cmp.compare(lookup, stored) : ((Comparable)lookup).compareTo(stored);
    }

    @Override
    public Iterator<E> iterator() {
        return new TreeSetIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.size];
        if (!this.isEmpty()) {
            int pos = 0;
            Node node = this.root.getLeftMostNode();
            while (node != null) {
                System.arraycopy(node.entries, node.leftIndex, objects, pos, node.size);
                pos += node.size;
                node = node.next;
            }
        }
        return objects;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] r;
        Object[] objectArray = r = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        if (!this.isEmpty()) {
            Node node = this.root.getLeftMostNode();
            int pos = 0;
            while (node != null) {
                System.arraycopy(node.entries, node.leftIndex, r, pos, node.size);
                pos += node.size;
                node = node.next;
            }
            if (r.length > pos) {
                r[pos] = null;
            }
        } else if (a.length > 0) {
            a[0] = null;
        }
        return r;
    }

    public E addOrReplace(E entry) {
        return this.add(entry, true);
    }

    @Override
    public boolean add(E entry) {
        return this.add(entry, false) == null;
    }

    private E add(E entry, boolean replace) {
        Objects.requireNonNull(entry);
        if (this.isEmpty()) {
            this.root = this.cachedOrNewNode(entry);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Node node = this.root;
        Node prevNode = null;
        int result = 0;
        while (node != null) {
            int rightIndex;
            prevNode = node;
            Object[] entries = node.entries;
            result = FoldedTreeSet.compare(entry, entries[rightIndex = node.rightIndex], this.comparator);
            if (result > 0) {
                node = node.right;
                continue;
            }
            if (result == 0) {
                Object prevEntry = entries[rightIndex];
                if (replace) {
                    entries[rightIndex] = entry;
                }
                return (E)prevEntry;
            }
            int leftIndex = node.leftIndex;
            if (leftIndex != rightIndex) {
                result = FoldedTreeSet.compare(entry, entries[leftIndex], this.comparator);
            }
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                Object prevEntry = entries[leftIndex];
                if (replace) {
                    entries[leftIndex] = entry;
                }
                return (E)prevEntry;
            }
            int low = leftIndex + 1;
            int high = rightIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                result = FoldedTreeSet.compare(entry, entries[mid], this.comparator);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    Object prevEntry = entries[mid];
                    if (replace) {
                        entries[mid] = entry;
                    }
                    return (E)prevEntry;
                }
                high = mid - 1;
            }
            this.addElementInNode(node, entry, low);
            return null;
        }
        assert (prevNode != null);
        ++this.size;
        ++this.modCount;
        if (!prevNode.isFull()) {
            if (result < 0) {
                prevNode.addEntryLeft(entry);
            } else {
                prevNode.addEntryRight(entry);
            }
        } else if (result < 0) {
            if (prevNode.prev != null && !prevNode.prev.isFull()) {
                prevNode.prev.addEntryRight(entry);
            } else {
                this.attachNodeLeft(prevNode, this.cachedOrNewNode(entry));
            }
        } else if (prevNode.next != null && !prevNode.next.isFull()) {
            prevNode.next.addEntryLeft(entry);
        } else {
            this.attachNodeRight(prevNode, this.cachedOrNewNode(entry));
        }
        return null;
    }

    public boolean addSortedLast(E entry) {
        if (this.isEmpty()) {
            this.root = this.cachedOrNewNode(entry);
            this.size = 1;
            ++this.modCount;
            return true;
        }
        Node<E> node = this.root.getRightMostNode();
        if (FoldedTreeSet.compare(((Node)node).entries[((Node)node).rightIndex], entry, this.comparator) < 0) {
            ++this.size;
            ++this.modCount;
            if (!node.isFull()) {
                node.addEntryRight(entry);
            } else {
                this.attachNodeRight(node, this.cachedOrNewNode(entry));
            }
            return true;
        }
        return this.add(entry);
    }

    private void addElementInNode(Node<E> node, E entry, int index) {
        ++this.size;
        ++this.modCount;
        if (!node.isFull()) {
            node.addEntryAt(entry, index);
        } else {
            Node prev = ((Node)node).prev;
            Node next = ((Node)node).next;
            if (prev == null) {
                if (next != null && !next.isFull()) {
                    E movedEntry = node.insertEntrySlideRight(entry, index);
                    next.addEntryLeft(movedEntry);
                } else {
                    assert (((Node)node).left == null);
                    E movedEntry = node.insertEntrySlideLeft(entry, index);
                    Node<E> newNode = this.cachedOrNewNode(movedEntry);
                    this.attachNodeLeft(node, newNode);
                }
            } else if (!prev.isFull()) {
                E movedEntry = node.insertEntrySlideLeft(entry, index);
                prev.addEntryRight(movedEntry);
            } else if (next == null) {
                assert (((Node)node).right == null);
                E movedEntry = node.insertEntrySlideRight(entry, index);
                Node<E> newNode = this.cachedOrNewNode(movedEntry);
                this.attachNodeRight(node, newNode);
            } else if (!next.isFull()) {
                E movedEntry = node.insertEntrySlideRight(entry, index);
                next.addEntryLeft(movedEntry);
            } else {
                E movedEntry = node.insertEntrySlideRight(entry, index);
                Node<E> newNode = this.cachedOrNewNode(movedEntry);
                if (((Node)node).right == null) {
                    this.attachNodeRight(node, newNode);
                } else {
                    assert (next.left == null);
                    this.attachNodeLeft(next, newNode);
                }
            }
        }
    }

    private void attachNodeLeft(Node<E> node, Node<E> newNode) {
        ((Node)newNode).parent = (Node)node;
        ((Node)node).left = (Node)newNode;
        ((Node)newNode).next = (Node)node;
        ((Node)newNode).prev = ((Node)node).prev;
        if (((Node)newNode).prev != null) {
            ((Node)newNode).prev.next = (Node)newNode;
        }
        ((Node)node).prev = (Node)newNode;
        this.balanceInsert(newNode);
    }

    private void attachNodeRight(Node<E> node, Node<E> newNode) {
        ((Node)newNode).parent = (Node)node;
        ((Node)node).right = (Node)newNode;
        ((Node)newNode).prev = (Node)node;
        ((Node)newNode).next = ((Node)node).next;
        if (((Node)newNode).next != null) {
            ((Node)newNode).next.prev = (Node)newNode;
        }
        ((Node)node).next = (Node)newNode;
        this.balanceInsert(newNode);
    }

    private void balanceInsert(Node<E> node) {
        node.color = true;
        while (node != this.root && node.parent.isRed()) {
            Node uncle;
            if (node.parent == node.parent.parent.left) {
                uncle = node.parent.parent.right;
                if (uncle != null && uncle.isRed()) {
                    node.parent.color = false;
                    uncle.color = false;
                    node.parent.parent.color = true;
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.rotateLeft(node);
                }
                node.parent.color = false;
                node.parent.parent.color = true;
                this.rotateRight(node.parent.parent);
                continue;
            }
            uncle = node.parent.parent.left;
            if (uncle != null && uncle.isRed()) {
                node.parent.color = false;
                uncle.color = false;
                node.parent.parent.color = true;
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rotateRight(node);
            }
            node.parent.color = false;
            node.parent.parent.color = true;
            this.rotateLeft(node.parent.parent);
        }
        ((Node)this.root).color = false;
    }

    private void rotateRight(Node<E> node) {
        Node pivot = ((Node)node).left;
        ((Node)node).left = pivot.right;
        if (pivot.right != null) {
            pivot.right.parent = (Node)node;
        }
        pivot.parent = ((Node)node).parent;
        if (((Node)node).parent == null) {
            this.root = pivot;
        } else if (node == ((Node)node).parent.right) {
            ((Node)node).parent.right = pivot;
        } else {
            ((Node)node).parent.left = pivot;
        }
        pivot.right = (Node)node;
        ((Node)node).parent = pivot;
    }

    private void rotateLeft(Node<E> node) {
        Node pivot = ((Node)node).right;
        ((Node)node).right = pivot.left;
        if (pivot.left != null) {
            pivot.left.parent = (Node)node;
        }
        pivot.parent = ((Node)node).parent;
        if (((Node)node).parent == null) {
            this.root = pivot;
        } else if (node == ((Node)node).parent.left) {
            ((Node)node).parent.left = pivot;
        } else {
            ((Node)node).parent.right = pivot;
        }
        pivot.left = (Node)node;
        ((Node)node).parent = pivot;
    }

    public E removeAndGet(Object obj, Comparator<?> cmp) {
        Objects.requireNonNull(obj);
        if (!this.isEmpty()) {
            Node node = this.root;
            while (node != null) {
                int leftIndex;
                Object[] entries = node.entries;
                int result = FoldedTreeSet.compare(obj, entries[leftIndex = node.leftIndex], cmp);
                if (result < 0) {
                    node = node.left;
                    continue;
                }
                if (result == 0) {
                    return this.removeElementLeft(node);
                }
                int rightIndex = node.rightIndex;
                if (leftIndex != rightIndex) {
                    result = FoldedTreeSet.compare(obj, entries[rightIndex], cmp);
                }
                if (result == 0) {
                    return this.removeElementRight(node);
                }
                if (result > 0) {
                    node = node.right;
                    continue;
                }
                int low = leftIndex + 1;
                int high = rightIndex - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    result = FoldedTreeSet.compare(obj, entries[mid], cmp);
                    if (result > 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (result == 0) {
                        return this.removeElementAt(node, mid);
                    }
                    high = mid - 1;
                }
                return null;
            }
        }
        return null;
    }

    public E removeAndGet(Object obj) {
        return this.removeAndGet(obj, this.comparator);
    }

    public boolean remove(Object obj, Comparator<?> cmp) {
        return this.removeAndGet(obj, cmp) != null;
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeAndGet(obj, this.comparator) != null;
    }

    private E removeElementLeft(Node<E> node) {
        ++this.modCount;
        --this.size;
        E entry = node.removeEntryLeft();
        if (node.isEmpty()) {
            this.deleteNode(node);
        } else if (((Node)node).prev != null && 63 - ((Node)node).prev.rightIndex >= ((Node)node).size) {
            ((Node)node).prev.addEntriesRight(node);
            this.deleteNode(node);
        } else if (((Node)node).next != null && ((Node)node).next.leftIndex >= ((Node)node).size) {
            ((Node)node).next.addEntriesLeft(node);
            this.deleteNode(node);
        } else if (((Node)node).prev != null && ((Node)node).prev.size < ((Node)node).leftIndex) {
            node.addEntriesLeft(((Node)node).prev);
            this.deleteNode(((Node)node).prev);
        }
        return entry;
    }

    private E removeElementRight(Node<E> node) {
        ++this.modCount;
        --this.size;
        E entry = node.removeEntryRight();
        if (node.isEmpty()) {
            this.deleteNode(node);
        } else if (((Node)node).prev != null && 63 - ((Node)node).prev.rightIndex >= ((Node)node).size) {
            ((Node)node).prev.addEntriesRight(node);
            this.deleteNode(node);
        } else if (((Node)node).next != null && ((Node)node).next.leftIndex >= ((Node)node).size) {
            ((Node)node).next.addEntriesLeft(node);
            this.deleteNode(node);
        } else if (((Node)node).next != null && ((Node)node).next.size < 63 - ((Node)node).rightIndex) {
            node.addEntriesRight(((Node)node).next);
            this.deleteNode(((Node)node).next);
        }
        return entry;
    }

    private E removeElementAt(Node<E> node, int index) {
        ++this.modCount;
        --this.size;
        E entry = node.removeEntryAt(index);
        if (((Node)node).prev != null && 63 - ((Node)node).prev.rightIndex >= ((Node)node).size) {
            ((Node)node).prev.addEntriesRight(node);
            this.deleteNode(node);
        } else if (((Node)node).next != null && ((Node)node).next.leftIndex >= ((Node)node).size) {
            ((Node)node).next.addEntriesLeft(node);
            this.deleteNode(node);
        } else if (((Node)node).prev != null && ((Node)node).prev.size < ((Node)node).leftIndex) {
            node.addEntriesLeft(((Node)node).prev);
            this.deleteNode(((Node)node).prev);
        } else if (((Node)node).next != null && ((Node)node).next.size < 63 - ((Node)node).rightIndex) {
            node.addEntriesRight(((Node)node).next);
            this.deleteNode(((Node)node).next);
        }
        return entry;
    }

    private void deleteNode(Node<E> node) {
        if (((Node)node).right == null) {
            if (((Node)node).left != null) {
                this.attachToParent(node, ((Node)node).left);
            } else {
                this.attachNullToParent(node);
            }
        } else if (((Node)node).left == null) {
            this.attachToParent(node, ((Node)node).right);
        } else {
            Node toMoveUp = ((Node)node).next;
            if (toMoveUp.right == null) {
                this.attachNullToParent(toMoveUp);
            } else {
                this.attachToParent(toMoveUp, toMoveUp.right);
            }
            toMoveUp.left = ((Node)node).left;
            if (toMoveUp.left != null) {
                toMoveUp.left.parent = toMoveUp;
            }
            toMoveUp.right = ((Node)node).right;
            if (toMoveUp.right != null) {
                toMoveUp.right.parent = toMoveUp;
            }
            this.attachToParentNoBalance(node, toMoveUp);
            toMoveUp.color = ((Node)node).color;
        }
        if (((Node)node).prev != null) {
            ((Node)node).prev.next = ((Node)node).next;
        }
        if (((Node)node).next != null) {
            ((Node)node).next.prev = ((Node)node).prev;
        }
        --this.nodeCount;
        this.cacheAndClear(node);
    }

    private void attachToParentNoBalance(Node<E> toDelete, Node<E> toConnect) {
        Node parent = ((Node)toDelete).parent;
        ((Node)toConnect).parent = parent;
        if (parent == null) {
            this.root = toConnect;
        } else if (toDelete == parent.left) {
            parent.left = (Node)toConnect;
        } else {
            parent.right = (Node)toConnect;
        }
    }

    private void attachToParent(Node<E> toDelete, Node<E> toConnect) {
        this.attachToParentNoBalance(toDelete, toConnect);
        if (toDelete.isBlack()) {
            this.balanceDelete(toConnect);
        }
    }

    private void attachNullToParent(Node<E> toDelete) {
        Node parent = ((Node)toDelete).parent;
        if (parent == null) {
            this.root = null;
        } else {
            if (toDelete == parent.left) {
                parent.left = null;
            } else {
                parent.right = null;
            }
            if (toDelete.isBlack()) {
                this.balanceDelete(parent);
            }
        }
    }

    private void balanceDelete(Node<E> node) {
        while (node != this.root && node.isBlack()) {
            Node sibling;
            if (node == ((Node)node).parent.left) {
                sibling = ((Node)node).parent.right;
                if (sibling == null) {
                    node = ((Node)node).parent;
                    continue;
                }
                if (sibling.isRed()) {
                    sibling.color = false;
                    ((Node)node).parent.color = true;
                    this.rotateLeft(((Node)node).parent);
                    sibling = ((Node)node).parent.right;
                    if (sibling == null) {
                        node = ((Node)node).parent;
                        continue;
                    }
                }
                if (!(sibling.left != null && sibling.left.isRed() || sibling.right != null && sibling.right.isRed())) {
                    sibling.color = true;
                    node = ((Node)node).parent;
                    continue;
                }
                if (sibling.right == null || !sibling.right.isRed()) {
                    sibling.left.color = false;
                    sibling.color = true;
                    this.rotateRight(sibling);
                    sibling = ((Node)node).parent.right;
                }
                sibling.color = ((Node)node).parent.color;
                ((Node)node).parent.color = false;
                sibling.right.color = false;
                this.rotateLeft(((Node)node).parent);
                node = this.root;
                continue;
            }
            sibling = ((Node)node).parent.left;
            if (sibling == null) {
                node = ((Node)node).parent;
                continue;
            }
            if (sibling.isRed()) {
                sibling.color = false;
                ((Node)node).parent.color = true;
                this.rotateRight(((Node)node).parent);
                sibling = ((Node)node).parent.left;
                if (sibling == null) {
                    node = ((Node)node).parent;
                    continue;
                }
            }
            if ((sibling.left == null || sibling.left.isBlack()) && (sibling.right == null || sibling.right.isBlack())) {
                sibling.color = true;
                node = ((Node)node).parent;
                continue;
            }
            if (sibling.left == null || sibling.left.isBlack()) {
                sibling.right.color = false;
                sibling.color = true;
                this.rotateLeft(sibling);
                sibling = ((Node)node).parent.left;
            }
            sibling.color = ((Node)node).parent.color;
            ((Node)node).parent.color = false;
            sibling.left.color = false;
            this.rotateRight(((Node)node).parent);
            node = this.root;
        }
        ((Node)node).color = false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object entry : c) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E entry : c) {
            if (!this.add(entry)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object entry : c) {
            if (!this.remove(entry)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        ++this.modCount;
        if (!this.isEmpty()) {
            this.size = 0;
            this.nodeCount = 0;
            this.cacheAndClear(this.root);
            this.root = null;
        }
    }

    public double fillRatio() {
        if (this.nodeCount > 1) {
            return (double)(this.size + (64 - ((Node)this.root.getRightMostNode()).size)) / (double)(this.nodeCount * 64);
        }
        return 1.0;
    }

    public boolean compact(long timeout) {
        if (!this.isEmpty()) {
            long start = Time.monotonicNow();
            Node node = this.root.getLeftMostNode();
            while (node != null) {
                if (node.prev != null && !node.prev.isFull()) {
                    Node prev = node.prev;
                    int count = Math.min(64 - prev.size, node.size);
                    System.arraycopy(node.entries, node.leftIndex, prev.entries, prev.rightIndex + 1, count);
                    node.leftIndex += count;
                    node.size -= count;
                    prev.rightIndex += count;
                    prev.size += count;
                }
                if (node.isEmpty()) {
                    Node temp = node.next;
                    this.deleteNode(node);
                    node = temp;
                    continue;
                }
                if (!node.isFull() && node.leftIndex != 0) {
                    System.arraycopy(node.entries, node.leftIndex, node.entries, 0, node.size);
                    Arrays.fill(node.entries, node.size, node.rightIndex + 1, null);
                    node.leftIndex = 0;
                    node.rightIndex = node.size - 1;
                }
                node = node.next;
                if (Time.monotonicNow() - start <= timeout) continue;
                return false;
            }
        }
        return true;
    }

    private static final class TreeSetIterator<E>
    implements Iterator<E> {
        private final FoldedTreeSet<E> tree;
        private int iteratorModCount;
        private Node<E> node;
        private int index;
        private E lastEntry;
        private int lastIndex;
        private Node<E> lastNode;

        private TreeSetIterator(FoldedTreeSet<E> tree) {
            this.tree = tree;
            this.iteratorModCount = ((FoldedTreeSet)tree).modCount;
            if (!tree.isEmpty()) {
                this.node = ((FoldedTreeSet)tree).root.getLeftMostNode();
                this.index = ((Node)this.node).leftIndex;
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForModification();
            return this.node != null;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                this.lastEntry = ((Node)this.node).entries[this.index];
                this.lastIndex = this.index++;
                this.lastNode = this.node;
                if (this.index > ((Node)this.node).rightIndex) {
                    this.node = ((Node)this.node).next;
                    if (this.node != null) {
                        this.index = ((Node)this.node).leftIndex;
                    }
                }
                return this.lastEntry;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }

        @Override
        public void remove() {
            if (this.lastEntry == null) {
                throw new IllegalStateException("No current element");
            }
            this.checkForModification();
            if (((Node)this.lastNode).size == 1) {
                ((FoldedTreeSet)this.tree).deleteNode(this.lastNode);
            } else if (((Node)this.lastNode).leftIndex == this.lastIndex) {
                this.lastNode.removeEntryLeft();
            } else if (((Node)this.lastNode).rightIndex == this.lastIndex) {
                this.lastNode.removeEntryRight();
            } else {
                assert (this.node == this.lastNode);
                int oldRIndex = ((Node)this.lastNode).rightIndex;
                this.lastNode.removeEntryAt(this.lastIndex);
                if (oldRIndex > ((Node)this.lastNode).rightIndex) {
                    this.index = this.lastIndex;
                }
            }
            this.lastEntry = null;
            ++this.iteratorModCount;
            ((FoldedTreeSet)this.tree).modCount++;
            ((FoldedTreeSet)this.tree).size--;
        }

        private void checkForModification() {
            if (this.iteratorModCount != ((FoldedTreeSet)this.tree).modCount) {
                throw new ConcurrentModificationException("Tree has been modified outside of iterator");
            }
        }
    }

    private static class Node<E> {
        private static final int NODE_SIZE = 64;
        private Node<E> parent;
        private Node<E> left;
        private Node<E> right;
        private boolean color;
        private final E[] entries = new Object[64];
        private int leftIndex = 0;
        private int rightIndex = -1;
        private int size = 0;
        private Node<E> prev;
        private Node<E> next;

        public boolean isRed() {
            return this.color;
        }

        public boolean isBlack() {
            return !this.color;
        }

        public Node<E> getLeftMostNode() {
            Node<E> node = this;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }

        public Node<E> getRightMostNode() {
            Node<E> node = this;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }

        public void addEntryLeft(E entry) {
            assert (this.rightIndex < this.entries.length);
            assert (!this.isFull());
            if (this.leftIndex == 0) {
                ++this.rightIndex;
                System.arraycopy(this.entries, 0, this.entries, 1, this.size);
            } else {
                --this.leftIndex;
            }
            ++this.size;
            this.entries[this.leftIndex] = entry;
        }

        public void addEntryRight(E entry) {
            assert (!this.isFull());
            if (this.rightIndex == 63) {
                assert (this.leftIndex > 0);
                System.arraycopy(this.entries, this.leftIndex, this.entries, --this.leftIndex, this.size);
            } else {
                ++this.rightIndex;
            }
            ++this.size;
            this.entries[this.rightIndex] = entry;
        }

        public void addEntryAt(E entry, int index) {
            assert (!this.isFull());
            if (this.leftIndex == 0 || this.rightIndex != 63 && this.rightIndex - index <= index - this.leftIndex) {
                ++this.rightIndex;
                System.arraycopy(this.entries, index, this.entries, index + 1, this.rightIndex - index);
                this.entries[index] = entry;
            } else {
                int newLeftIndex = this.leftIndex - 1;
                System.arraycopy(this.entries, this.leftIndex, this.entries, newLeftIndex, index - this.leftIndex);
                this.leftIndex = newLeftIndex;
                this.entries[index - 1] = entry;
            }
            ++this.size;
        }

        public void addEntriesLeft(Node<E> from) {
            this.leftIndex -= from.size;
            this.size += from.size;
            System.arraycopy(from.entries, from.leftIndex, this.entries, this.leftIndex, from.size);
        }

        public void addEntriesRight(Node<E> from) {
            System.arraycopy(from.entries, from.leftIndex, this.entries, this.rightIndex + 1, from.size);
            this.size += from.size;
            this.rightIndex += from.size;
        }

        public E insertEntrySlideLeft(E entry, int index) {
            E pushedEntry = this.entries[0];
            System.arraycopy(this.entries, 1, this.entries, 0, index - 1);
            this.entries[index - 1] = entry;
            return pushedEntry;
        }

        public E insertEntrySlideRight(E entry, int index) {
            E movedEntry = this.entries[this.rightIndex];
            System.arraycopy(this.entries, index, this.entries, index + 1, this.rightIndex - index);
            this.entries[index] = entry;
            return movedEntry;
        }

        public E removeEntryLeft() {
            assert (!this.isEmpty());
            E entry = this.entries[this.leftIndex];
            this.entries[this.leftIndex] = null;
            ++this.leftIndex;
            --this.size;
            return entry;
        }

        public E removeEntryRight() {
            assert (!this.isEmpty());
            E entry = this.entries[this.rightIndex];
            this.entries[this.rightIndex] = null;
            --this.rightIndex;
            --this.size;
            return entry;
        }

        public E removeEntryAt(int index) {
            assert (!this.isEmpty());
            E entry = this.entries[index];
            int rightSize = this.rightIndex - index;
            int leftSize = index - this.leftIndex;
            if (rightSize <= leftSize) {
                System.arraycopy(this.entries, index + 1, this.entries, index, rightSize);
                this.entries[this.rightIndex] = null;
                --this.rightIndex;
            } else {
                System.arraycopy(this.entries, this.leftIndex, this.entries, this.leftIndex + 1, leftSize);
                this.entries[this.leftIndex] = null;
                ++this.leftIndex;
            }
            --this.size;
            return entry;
        }

        public boolean isFull() {
            return this.size == 64;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void clear() {
            if (this.leftIndex < this.rightIndex) {
                Arrays.fill(this.entries, this.leftIndex, this.rightIndex + 1, null);
            }
            this.size = 0;
            this.leftIndex = 0;
            this.rightIndex = -1;
            this.prev = null;
            this.next = null;
            this.parent = null;
            this.left = null;
            this.right = null;
            this.color = false;
        }
    }
}

