/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.Private
public class DelegationTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text HDFS_DELEGATION_KIND = new Text("HDFS_DELEGATION_TOKEN");
    private static Map<TokenIdentifier, UserGroupInformation> ugiCache = Collections.synchronizedMap(new LRUMap(64));

    @VisibleForTesting
    public void clearCache() {
        ugiCache.clear();
    }

    public DelegationTokenIdentifier() {
    }

    public DelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    public Text getKind() {
        return HDFS_DELEGATION_KIND;
    }

    public UserGroupInformation getUser() {
        UserGroupInformation ugi = ugiCache.get((Object)this);
        if (ugi == null) {
            ugi = super.getUser();
            ugiCache.put((TokenIdentifier)this, ugi);
        }
        return ugi;
    }

    public String toString() {
        StringBuilder sbld = new StringBuilder();
        sbld.append("token for ").append(this.getUser().getShortUserName()).append(": ").append(super.toString());
        return sbld.toString();
    }

    public String toStringStable() {
        StringBuilder sbld = new StringBuilder();
        sbld.append(this.getKind()).append(" token ").append(this.getSequenceNumber()).append(" for ").append(this.getUser().getShortUserName()).append(" with renewer ").append(this.getRenewer());
        return sbld.toString();
    }

    public static String stringifyToken(Token<?> token) throws IOException {
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        ident.readFields(in);
        if (token.getService().getLength() > 0) {
            return (Object)((Object)ident) + " on " + token.getService();
        }
        return ident.toString();
    }

    public static class SWebHdfsDelegationTokenIdentifier
    extends WebHdfsDelegationTokenIdentifier {
        @Override
        public Text getKind() {
            return SWebHdfsFileSystem.TOKEN_KIND;
        }
    }

    public static class WebHdfsDelegationTokenIdentifier
    extends DelegationTokenIdentifier {
        @Override
        public Text getKind() {
            return WebHdfsFileSystem.TOKEN_KIND;
        }
    }
}

