/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.connectors;

import com.cloudera.org.codehaus.jackson.map.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeConnector
implements ClusterConnector {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeConnector.class);
    private final URL clusterURI;

    public JsonNodeConnector(URL clusterURI) {
        this.clusterURI = clusterURI;
    }

    @Override
    public List<DiskBalancerDataNode> getNodes() throws Exception {
        Preconditions.checkNotNull((Object)this.clusterURI);
        String dataFilePath = this.clusterURI.getPath();
        LOG.info("Reading cluster info from file : " + dataFilePath);
        ObjectMapper mapper = new ObjectMapper();
        DiskBalancerCluster cluster = mapper.readValue(new File(dataFilePath), DiskBalancerCluster.class);
        String message = String.format("Found %d node(s)", cluster.getNodes().size());
        LOG.info(message);
        return cluster.getNodes();
    }

    @Override
    public String getConnectorInfo() {
        return "Json Cluster Connector : Connects to a JSON file that describes a cluster : " + this.clusterURI.toString();
    }
}

