/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.ReencryptionUpdater;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.ByteArray;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FSDirectory
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(FSDirectory.class);
    @VisibleForTesting
    static boolean CHECK_RESERVED_FILE_NAMES = true;
    public static final String DOT_RESERVED_STRING = ".reserved";
    public static final String DOT_RESERVED_PATH_PREFIX = "/.reserved";
    public static final byte[] DOT_RESERVED = DFSUtil.string2Bytes(".reserved");
    private static final String RAW_STRING = "raw";
    private static final byte[] RAW = DFSUtil.string2Bytes("raw");
    public static final String DOT_INODES_STRING = ".inodes";
    public static final byte[] DOT_INODES = DFSUtil.string2Bytes(".inodes");
    private final XAttr KEYID_XATTR = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", null);
    private final XAttr UNREADABLE_BY_SUPERUSER_XATTR = XAttrHelper.buildXAttr("security.hdfs.unreadable.by.superuser", null);
    INodeDirectory rootDir;
    private final FSNamesystem namesystem;
    private volatile boolean skipQuotaCheck = false;
    private final int maxComponentLength;
    private final int maxDirItems;
    private final int lsLimit;
    private final int contentCountLimit;
    private final long contentSleepMicroSec;
    private final INodeMap inodeMap;
    private long yieldCount = 0L;
    private int quotaInitThreads;
    private final int inodeXAttrsLimit;
    private final ReentrantReadWriteLock dirLock = new ReentrantReadWriteLock(true);
    private final boolean isPermissionEnabled;
    private final String fsOwnerShortUserName;
    private final String supergroup;
    private boolean posixAclInheritanceEnabled;
    @VisibleForTesting
    public final EncryptionZoneManager ezManager;
    private final NameCache<ByteArray> nameCache;

    private static INodeDirectory createRoot(FSNamesystem namesystem) {
        INodeDirectory r = new INodeDirectory(16385L, INodeDirectory.ROOT_NAME, namesystem.createFsOwnerPermissions(new FsPermission(493)), 0L);
        r.addDirectoryWithQuotaFeature(Long.MAX_VALUE, -1L);
        r.addSnapshottableFeature();
        r.setSnapshotQuota(0);
        return r;
    }

    void readLock() {
        this.dirLock.readLock().lock();
    }

    void readUnlock() {
        this.dirLock.readLock().unlock();
    }

    void writeLock() {
        this.dirLock.writeLock().lock();
    }

    void writeUnlock() {
        this.dirLock.writeLock().unlock();
    }

    boolean hasWriteLock() {
        return this.dirLock.isWriteLockedByCurrentThread();
    }

    boolean hasReadLock() {
        return this.dirLock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    public int getReadHoldCount() {
        return this.dirLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.dirLock.getWriteHoldCount();
    }

    FSDirectory(FSNamesystem ns, Configuration conf) throws IOException {
        this.rootDir = FSDirectory.createRoot(ns);
        this.inodeMap = INodeMap.newInstance(this.rootDir);
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
        this.fsOwnerShortUserName = UserGroupInformation.getCurrentUser().getShortUserName();
        this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        int configuredLimit = conf.getInt("dfs.ls.limit", 1000);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : 1000;
        this.contentCountLimit = conf.getInt("dfs.content-summary.limit", 5000);
        this.contentSleepMicroSec = conf.getLong("dfs.content-summary.sleep-microsec", 500L);
        this.maxComponentLength = conf.getInt("dfs.namenode.fs-limits.max-component-length", 255);
        this.maxDirItems = conf.getInt("dfs.namenode.fs-limits.max-directory-items", 0x100000);
        this.inodeXAttrsLimit = conf.getInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 32);
        this.posixAclInheritanceEnabled = conf.getBoolean("dfs.namenode.posix.acl.inheritance.enabled", false);
        LOG.info("POSIX ACL inheritance enabled? " + this.posixAclInheritanceEnabled);
        Preconditions.checkArgument((this.inodeXAttrsLimit >= 0 ? 1 : 0) != 0, (String)"Cannot set a negative limit on the number of xattrs per inode (%s).", (Object[])new Object[]{"dfs.namenode.fs-limits.max-xattrs-per-inode"});
        int MAX_DIR_ITEMS = 6400000;
        Preconditions.checkArgument((this.maxDirItems > 0 && this.maxDirItems <= 6400000 ? 1 : 0) != 0, (Object)"Cannot set dfs.namenode.fs-limits.max-directory-items to a value less than 0 or greater than 6400000");
        int threshold = conf.getInt("dfs.namenode.name.cache.threshold", 10);
        NameNode.LOG.info("Caching file names occuring more than " + threshold + " times");
        this.nameCache = new NameCache(threshold);
        this.namesystem = ns;
        this.ezManager = new EncryptionZoneManager(this, conf);
        this.quotaInitThreads = conf.getInt("dfs.namenode.quota.init-threads", 4);
    }

    FSNamesystem getFSNamesystem() {
        return this.namesystem;
    }

    private BlockManager getBlockManager() {
        return this.getFSNamesystem().getBlockManager();
    }

    KeyProviderCryptoExtension getProvider() {
        return this.getFSNamesystem().getProvider();
    }

    public INodeDirectory getRoot() {
        return this.rootDir;
    }

    long getContentSleepMicroSec() {
        return this.contentSleepMicroSec;
    }

    @VisibleForTesting
    public boolean isPosixAclInheritanceEnabled() {
        return this.posixAclInheritanceEnabled;
    }

    @VisibleForTesting
    public void setPosixAclInheritanceEnabled(boolean posixAclInheritanceEnabled) {
        this.posixAclInheritanceEnabled = posixAclInheritanceEnabled;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markNameCacheInitialized() {
        this.writeLock();
        try {
            this.nameCache.initialized();
        }
        finally {
            this.writeUnlock();
        }
    }

    void enableQuotaChecks() {
        this.skipQuotaCheck = false;
    }

    void disableQuotaChecks() {
        this.skipQuotaCheck = true;
    }

    boolean shouldSkipQuotaChecks() {
        return this.skipQuotaCheck;
    }

    private static INodeFile newINodeFile(long id, PermissionStatus permissions, long mtime, long atime, short replication, long preferredBlockSize) {
        return FSDirectory.newINodeFile(id, permissions, mtime, atime, replication, preferredBlockSize, (byte)0);
    }

    private static INodeFile newINodeFile(long id, PermissionStatus permissions, long mtime, long atime, short replication, long preferredBlockSize, byte storagePolicyId) {
        return new INodeFile(id, null, permissions, mtime, atime, BlockInfo.EMPTY_ARRAY, replication, preferredBlockSize, storagePolicyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine) throws FileAlreadyExistsException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException, AclException {
        long modTime = Time.now();
        INodeFile newNode = FSDirectory.newINodeFile(this.namesystem.allocateNewInodeId(), permissions, modTime, modTime, replication, preferredBlockSize);
        newNode.toUnderConstruction(clientName, clientMachine);
        boolean added = false;
        this.writeLock();
        try {
            added = this.addINode(path, newNode, permissions.getPermission());
        }
        finally {
            this.writeUnlock();
        }
        if (!added) {
            NameNode.stateChangeLog.info("DIR* addFile: failed to add " + path);
            return null;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* addFile: " + path + " is added");
        }
        return newNode;
    }

    INodeFile unprotectedAddFile(long id, String path, PermissionStatus permissions, List<AclEntry> aclEntries, List<XAttr> xAttrs, short replication, long modificationTime, long atime, long preferredBlockSize, boolean underConstruction, String clientName, String clientMachine, byte storagePolicyId) {
        block8: {
            INodeFile newNode;
            assert (this.hasWriteLock());
            if (underConstruction) {
                newNode = FSDirectory.newINodeFile(id, permissions, modificationTime, modificationTime, replication, preferredBlockSize, storagePolicyId);
                newNode.toUnderConstruction(clientName, clientMachine);
            } else {
                newNode = FSDirectory.newINodeFile(id, permissions, modificationTime, atime, replication, preferredBlockSize, storagePolicyId);
            }
            try {
                if (this.addINode(path, newNode, permissions.getPermission())) {
                    if (aclEntries != null) {
                        AclStorage.updateINodeAcl(newNode, aclEntries, 0x7FFFFFFE);
                    }
                    if (xAttrs != null) {
                        XAttrStorage.updateINodeXAttrs(newNode, xAttrs, 0x7FFFFFFE);
                    }
                    return newNode;
                }
            }
            catch (IOException e) {
                if (!NameNode.stateChangeLog.isDebugEnabled()) break block8;
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedAddFile: exception when add " + path + " to the file system", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockInfo addBlock(String path, INodesInPath inodesInPath, Block block, DatanodeStorageInfo[] targets) throws IOException {
        this.writeLock();
        try {
            INodeFile fileINode = inodesInPath.getLastINode().asFile();
            Preconditions.checkState((boolean)fileINode.isUnderConstruction());
            this.updateCount(inodesInPath, 0L, fileINode.getBlockDiskspace(), true);
            BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(block, fileINode.getFileReplication(), HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
            this.getBlockManager().addBlockCollection(blockInfo, fileINode);
            fileINode.addBlock(blockInfo);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.addBlock: " + path + " with " + block + " block is added to the in-memory " + "file system");
            }
            BlockInfoUnderConstruction blockInfoUnderConstruction = blockInfo;
            return blockInfoUnderConstruction;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFile fileNode, Block block) throws IOException {
        Preconditions.checkArgument((boolean)fileNode.isUnderConstruction());
        this.writeLock();
        try {
            boolean bl = this.unprotectedRemoveBlock(path, fileNode, block);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean unprotectedRemoveBlock(String path, INodeFile fileNode, Block block) throws IOException {
        boolean removed = fileNode.removeLastBlock(block);
        if (!removed) {
            return false;
        }
        this.getBlockManager().removeBlockFromMap(block);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.removeBlock: " + path + " with " + block + " block is removed from the file system");
        }
        INodesInPath iip = this.getINodesInPath4Write(path, true);
        this.updateCount(iip, 0L, -fileNode.getBlockDiskspace(), true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean renameTo(String src, String dst, long mtime) throws QuotaExceededException, UnresolvedLinkException, FileAlreadyExistsException, SnapshotAccessControlException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        this.writeLock();
        try {
            if (!this.unprotectedRenameTo(src, dst, mtime)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameTo(String src, String dst, long mtime, INode.BlocksMapUpdateInfo collectedBlocks, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        this.writeLock();
        try {
            if (this.unprotectedRenameTo(src, dst, mtime, collectedBlocks, options)) {
                this.namesystem.incrDeletedFileCount(1L);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException, UnresolvedLinkException, FileAlreadyExistsException, SnapshotAccessControlException, IOException {
        assert (this.hasWriteLock());
        INodesInPath srcIIP = this.getINodesInPath4Write(src, false);
        INode srcInode = srcIIP.getLastINode();
        try {
            FSDirectory.validateRenameSource(src, srcIIP);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (IOException ignored) {
            return false;
        }
        if (this.isDir(dst)) {
            dst = dst + "/" + new Path(src).getName();
        }
        if (dst.equals(src)) {
            return true;
        }
        try {
            FSDirectory.validateRenameDestination(src, dst, srcInode);
        }
        catch (IOException ignored) {
            return false;
        }
        INodesInPath dstIIP = this.getINodesInPath4Write(dst, false);
        if (dstIIP.getLastINode() != null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists");
            return false;
        }
        INode dstParent = dstIIP.getINode(-2);
        if (dstParent == null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist");
            return false;
        }
        this.ezManager.checkMoveValidity(srcIIP, dstIIP, src);
        this.verifyFsLimitsForRename(srcIIP, dstIIP);
        this.verifyQuotaForRename(srcIIP.getINodes(), dstIIP.getINodes());
        RenameOperation tx = new RenameOperation(src, dst, srcIIP, dstIIP);
        boolean added = false;
        try {
            long removedSrc = this.removeLastINode(srcIIP);
            if (removedSrc == -1L) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed");
                boolean bl = false;
                return bl;
            }
            INode srcChild = srcIIP.getLastINode();
            this.updateCountForDelete(srcChild, srcIIP);
            added = tx.addSourceToDestination();
            if (added) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                tx.updateQuotasInSourceTree();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (!added) {
                tx.restoreSource();
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        return false;
    }

    boolean unprotectedRenameTo(String src, String dst, long timestamp, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException {
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        boolean ret = this.unprotectedRenameTo(src, dst, timestamp, collectedBlocks, options);
        if (!collectedBlocks.getToDeleteList().isEmpty()) {
            this.getFSNamesystem().removeBlocksAndUpdateSafemodeTotal(collectedBlocks);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp, INode.BlocksMapUpdateInfo collectedBlocks, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException {
        INode dstParent;
        assert (this.hasWriteLock());
        boolean overwrite = options != null && Arrays.asList(options).contains(Options.Rename.OVERWRITE);
        INodesInPath srcIIP = this.getINodesInPath4Write(src, false);
        INode srcInode = srcIIP.getLastINode();
        FSDirectory.validateRenameSource(src, srcIIP);
        if (dst.equals(src)) {
            throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
        }
        FSDirectory.validateRenameDestination(src, dst, srcInode);
        INodesInPath dstIIP = this.getINodesInPath4Write(dst, false);
        if (dstIIP.getINodes().length == 1) {
            String error = "rename destination cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        this.ezManager.checkMoveValidity(srcIIP, dstIIP, src);
        INode dstInode = dstIIP.getLastINode();
        ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
        if (dstInode != null) {
            FSDirectory.validateRenameOverwrite(src, dst, overwrite, srcInode, dstInode);
            FSDirectory.checkSnapshot(dstInode, snapshottableDirs);
        }
        if ((dstParent = dstIIP.getINode(-2)) == null) {
            String error = "rename destination parent " + dst + " not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (!dstParent.isDirectory()) {
            String error = "rename destination parent " + dst + " is a file.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new ParentNotDirectoryException(error);
        }
        this.verifyFsLimitsForRename(srcIIP, dstIIP);
        this.verifyQuotaForRename(srcIIP.getINodes(), dstIIP.getINodes());
        RenameOperation tx = new RenameOperation(src, dst, srcIIP, dstIIP);
        boolean undoRemoveSrc = true;
        long removedSrc = this.removeLastINode(srcIIP);
        if (removedSrc == -1L) {
            String error = "Failed to rename " + src + " to " + dst + " because the source can not be removed";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        INode srcChild = srcIIP.getLastINode();
        this.updateCountForDelete(srcChild, srcIIP);
        boolean undoRemoveDst = false;
        INode removedDst = null;
        long removedNum = 0L;
        try {
            if (dstInode != null && (removedNum = this.removeLastINode(dstIIP)) != -1L) {
                removedDst = dstIIP.getLastINode();
                this.updateCountForDelete(removedDst, dstIIP);
                undoRemoveDst = true;
            }
            if (tx.addSourceToDestination()) {
                undoRemoveSrc = false;
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                boolean filesDeleted = false;
                if (removedDst != null) {
                    undoRemoveDst = false;
                    if (removedNum > 0L) {
                        ChunkedArrayList removedINodes = new ChunkedArrayList();
                        ChunkedArrayList removedUCFiles = new ChunkedArrayList();
                        if (!removedDst.isInLatestSnapshot(dstIIP.getLatestSnapshotId())) {
                            removedDst.destroyAndCollectBlocks(collectedBlocks, (List<INode>)removedINodes, (List<Long>)removedUCFiles);
                            filesDeleted = true;
                        } else {
                            filesDeleted = removedDst.cleanSubtree(0x7FFFFFFE, dstIIP.getLatestSnapshotId(), collectedBlocks, (List<INode>)removedINodes, (List<Long>)removedUCFiles).get(Quota.NAMESPACE) >= 0L;
                        }
                        this.getFSNamesystem().removePathAndBlocks(src, null, (List<Long>)removedUCFiles, (List<INode>)removedINodes, false);
                    }
                }
                if (snapshottableDirs.size() > 0) {
                    this.namesystem.removeSnapshottableDirs(snapshottableDirs);
                }
                tx.updateQuotasInSourceTree();
                boolean removedINodes = filesDeleted;
                return removedINodes;
            }
        }
        finally {
            if (undoRemoveSrc) {
                tx.restoreSource();
            }
            if (undoRemoveDst) {
                if (dstParent.isDirectory() && dstParent.asDirectory().isWithSnapshot()) {
                    dstParent.asDirectory().undoRename4DstParent(removedDst, dstIIP.getLatestSnapshotId());
                } else {
                    this.addLastINodeNoQuotaCheck(dstIIP, removedDst);
                }
                if (removedDst.isReference()) {
                    INodeReference removedDstRef = removedDst.asReference();
                    INodeReference.WithCount wc = (INodeReference.WithCount)removedDstRef.getReferredINode().asReference();
                    wc.addReference(removedDstRef);
                }
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        throw new IOException("rename from " + src + " to " + dst + " failed.");
    }

    private static void validateRenameOverwrite(String src, String dst, boolean overwrite, INode srcInode, INode dstInode) throws IOException {
        ReadOnlyList<INode> children;
        if (dstInode.isDirectory() != srcInode.isDirectory()) {
            String error = "Source " + src + " and destination " + dst + " must both be directories";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        if (!overwrite) {
            String error = "rename destination " + dst + " already exists";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileAlreadyExistsException(error);
        }
        if (dstInode.isDirectory() && !(children = dstInode.asDirectory().getChildrenList(0x7FFFFFFE)).isEmpty()) {
            String error = "rename destination directory is not empty: " + dst;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameDestination(String src, String dst, INode srcInode) throws IOException {
        if (srcInode.isSymlink() && dst.equals(srcInode.asSymlink().getSymlinkString())) {
            throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
        }
        if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
            String error = "Rename destination " + dst + " is a directory or file under source " + src;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameSource(String src, INodesInPath srcIIP) throws IOException {
        INode srcInode = srcIIP.getLastINode();
        if (srcInode == null) {
            String error = "rename source " + src + " is not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (srcIIP.getINodes().length == 1) {
            String error = "rename source cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        FSDirectory.checkSnapshot(srcInode, null);
    }

    String resolvePath(FSPermissionChecker pc, String path, byte[][] pathComponents) throws FileNotFoundException, AccessControlException {
        if (FSDirectory.isReservedRawName(path) && this.isPermissionEnabled) {
            pc.checkSuperuserPrivilege();
        }
        return FSDirectory.resolvePath(path, pathComponents, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockInfo[] setReplication(String src, short replication, short[] blockRepls) throws QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            BlockInfo[] blockInfoArray = this.unprotectedSetReplication(src, replication, blockRepls);
            return blockInfoArray;
        }
        finally {
            this.writeUnlock();
        }
    }

    BlockInfo[] unprotectedSetReplication(String src, short replication, short[] blockRepls) throws QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(src, true);
        INode inode = iip.getLastINode();
        if (inode == null || !inode.isFile()) {
            return null;
        }
        INodeFile file = inode.asFile();
        short oldBR = file.getBlockReplication();
        if (replication > oldBR) {
            long dsDelta = (long)(replication - oldBR) * (file.diskspaceConsumed() / (long)oldBR);
            this.updateCount(iip, 0L, dsDelta, true);
        }
        file.setFileReplication(replication, iip.getLatestSnapshotId());
        short newBR = file.getBlockReplication();
        if (newBR < oldBR) {
            long dsDelta = (long)(newBR - oldBR) * (file.diskspaceConsumed() / (long)newBR);
            this.updateCount(iip, 0L, dsDelta, true);
        }
        if (blockRepls != null) {
            blockRepls[0] = oldBR;
            blockRepls[1] = newBR;
        }
        return file.getBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStoragePolicy(String src, byte policyId) throws IOException {
        this.writeLock();
        try {
            this.unprotectedSetStoragePolicy(src, policyId);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedSetStoragePolicy(String src, byte policyId) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(src, true);
        INode inode = iip.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File/Directory does not exist: " + src);
        }
        int snapshotId = iip.getLatestSnapshotId();
        if (inode.isFile()) {
            BlockStoragePolicy newPolicy = this.getBlockManager().getStoragePolicy(policyId);
            if (newPolicy.isCopyOnCreateFile()) {
                throw new HadoopIllegalArgumentException("Policy " + newPolicy + " cannot be set after file creation.");
            }
            BlockStoragePolicy currentPolicy = this.getBlockManager().getStoragePolicy(inode.getLocalStoragePolicyID());
            if (currentPolicy != null && currentPolicy.isCopyOnCreateFile()) {
                throw new HadoopIllegalArgumentException("Existing policy " + currentPolicy.getName() + " cannot be changed after file creation.");
            }
            inode.asFile().setStoragePolicyID(policyId, snapshotId);
        } else if (inode.isDirectory()) {
            this.setDirStoragePolicy(inode.asDirectory(), policyId, snapshotId);
        } else {
            throw new FileNotFoundException(src + " is not a file or directory");
        }
    }

    private void setDirStoragePolicy(INodeDirectory inode, byte policyId, int latestSnapshotId) throws IOException {
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        XAttr xAttr = BlockStoragePolicySuite.buildXAttr(policyId);
        List<XAttr> newXAttrs = this.setINodeXAttrs(existingXAttrs, Arrays.asList(xAttr), EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        XAttrStorage.updateINodeXAttrs(inode, newXAttrs, latestSnapshotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String path) throws UnresolvedLinkException, FileNotFoundException, IOException {
        this.readLock();
        try {
            long l = INodeFile.valueOf(this.getNode(path, false), path).getPreferredBlockSize();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPermission(String src, FsPermission permission) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        this.writeLock();
        try {
            this.unprotectedSetPermission(src, permission);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        int snapshotId = inodesInPath.getLatestSnapshotId();
        inode.setPermission(permissions, snapshotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        this.writeLock();
        try {
            this.unprotectedSetOwner(src, username, groupname);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        if (username != null) {
            inode = inode.setUser(username, inodesInPath.getLatestSnapshotId());
        }
        if (groupname != null) {
            inode.setGroup(groupname, inodesInPath.getLatestSnapshotId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs, long timestamp) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, SnapshotException {
        this.writeLock();
        try {
            this.unprotectedConcat(target, srcs, timestamp);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedConcat(String target, String[] srcs, long timestamp) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, SnapshotException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSNamesystem.concat to " + target);
        }
        INodesInPath trgIIP = this.getINodesInPath4Write(target, true);
        INode[] trgINodes = trgIIP.getINodes();
        INodeFile trgInode = trgIIP.getLastINode().asFile();
        INodeDirectory trgParent = trgINodes[trgINodes.length - 2].asDirectory();
        int trgLatestSnapshot = trgIIP.getLatestSnapshotId();
        INodeFile[] allSrcInodes = new INodeFile[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            INodesInPath iip = this.getINodesInPath4Write(srcs[i]);
            int latest = iip.getLatestSnapshotId();
            INode inode = iip.getLastINode();
            if (inode.isInLatestSnapshot(latest)) {
                throw new SnapshotException("Concat: the source file " + srcs[i] + " is in snapshot " + latest);
            }
            if (inode.isReference() && ((INodeReference.WithCount)inode.asReference().getReferredINode()).getReferenceCount() > 1) {
                throw new SnapshotException("Concat: the source file " + srcs[i] + " is referred by some other reference in some snapshot.");
            }
            allSrcInodes[i] = inode.asFile();
        }
        trgInode.concatBlocks(allSrcInodes);
        int count = 0;
        for (INodeFile nodeToRemove : allSrcInodes) {
            if (nodeToRemove == null) continue;
            nodeToRemove.setBlocks(null);
            trgParent.removeChild(nodeToRemove, trgLatestSnapshot);
            this.inodeMap.remove(nodeToRemove);
            ++count;
        }
        trgInode.setModificationTime(timestamp, trgLatestSnapshot);
        trgParent.updateModificationTime(timestamp, trgLatestSnapshot);
        FSDirectory.unprotectedUpdateCount(trgIIP, trgINodes.length - 1, -count, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long delete(String src, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles, long mtime) throws IOException {
        long filesRemoved;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.delete: " + src);
        }
        this.writeLock();
        try {
            INodesInPath inodesInPath = this.getINodesInPath4Write(FSDirectory.normalizePath(src), false);
            if (!FSDirectory.deleteAllowed(inodesInPath, src)) {
                filesRemoved = -1L;
            } else {
                ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
                FSDirectory.checkSnapshot(inodesInPath.getLastINode(), snapshottableDirs);
                filesRemoved = this.unprotectedDelete(inodesInPath, collectedBlocks, removedINodes, removedUCFiles, mtime);
                this.namesystem.removeSnapshottableDirs(snapshottableDirs);
            }
        }
        finally {
            this.writeUnlock();
        }
        return filesRemoved;
    }

    private static boolean deleteAllowed(INodesInPath iip, String src) {
        INode[] inodes = iip.getINodes();
        if (inodes == null || inodes.length == 0 || inodes[inodes.length - 1] == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist");
            }
            return false;
        }
        if (inodes.length == 1) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNonEmptyDirectory(String path) throws UnresolvedLinkException {
        this.readLock();
        try {
            INodesInPath inodesInPath = this.getLastINodeInPath(path, false);
            INode inode = inodesInPath.getINode(0);
            if (inode == null || !inode.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            int s = inodesInPath.getPathSnapshotId();
            boolean bl = !inode.asDirectory().getChildrenList(s).isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    void unprotectedDelete(String src, long mtime) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, IOException {
        assert (this.hasWriteLock());
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ChunkedArrayList removedINodes = new ChunkedArrayList();
        ChunkedArrayList removedUCFiles = new ChunkedArrayList();
        INodesInPath inodesInPath = this.getINodesInPath4Write(FSDirectory.normalizePath(src), false);
        long filesRemoved = -1L;
        if (FSDirectory.deleteAllowed(inodesInPath, src)) {
            ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
            FSDirectory.checkSnapshot(inodesInPath.getLastINode(), snapshottableDirs);
            filesRemoved = this.unprotectedDelete(inodesInPath, collectedBlocks, (List<INode>)removedINodes, (List<Long>)removedUCFiles, mtime);
            this.namesystem.removeSnapshottableDirs(snapshottableDirs);
        }
        if (filesRemoved >= 0L) {
            this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks, (List<Long>)removedUCFiles, (List<INode>)removedINodes, false);
        }
    }

    long unprotectedDelete(INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles, long mtime) {
        assert (this.hasWriteLock());
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return -1L;
        }
        int latestSnapshot = iip.getLatestSnapshotId();
        targetNode.recordModification(latestSnapshot);
        long removed = this.removeLastINode(iip);
        if (removed == -1L) {
            return -1L;
        }
        INodeDirectory parent = targetNode.getParent();
        parent.updateModificationTime(mtime, latestSnapshot);
        this.updateCountForDelete(targetNode, iip);
        if (removed == 0L) {
            return 0L;
        }
        if (!targetNode.isInLatestSnapshot(latestSnapshot)) {
            targetNode.destroyAndCollectBlocks(collectedBlocks, removedINodes, removedUCFiles);
        } else {
            Quota.Counts counts = targetNode.cleanSubtree(0x7FFFFFFE, latestSnapshot, collectedBlocks, removedINodes, removedUCFiles);
            removed = counts.get(Quota.NAMESPACE);
            this.updateCountNoQuotaCheck(iip, iip.length() - 1, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: " + targetNode.getFullPathName() + " is removed");
        }
        return removed;
    }

    private static void checkSnapshot(INode target, List<INodeDirectory> snapshottableDirs) throws SnapshotException {
        if (target.isDirectory()) {
            INodeDirectory targetDir = target.asDirectory();
            DirectorySnapshottableFeature sf = targetDir.getDirectorySnapshottableFeature();
            if (sf != null) {
                if (sf.getNumSnapshots() > 0) {
                    String fullPath = targetDir.getFullPathName();
                    throw new SnapshotException("The directory " + fullPath + " cannot be deleted since " + fullPath + " is snapshottable and already has snapshots");
                }
                if (snapshottableDirs != null) {
                    snapshottableDirs.add(targetDir);
                }
            }
            for (INode child : targetDir.getChildrenList(0x7FFFFFFE)) {
                FSDirectory.checkSnapshot(child, snapshottableDirs);
            }
        }
    }

    private byte getStoragePolicyID(byte inodePolicy, byte parentPolicy) {
        return inodePolicy != 0 ? inodePolicy : parentPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation, boolean isSuperUser) throws UnresolvedLinkException, IOException {
        String srcs = FSDirectory.normalizePath(src);
        boolean isRawPath = FSDirectory.isReservedRawName(src);
        this.readLock();
        try {
            byte parentStoragePolicy;
            if (srcs.endsWith("/.snapshot")) {
                DirectoryListing directoryListing = this.getSnapshotsListing(srcs, startAfter);
                return directoryListing;
            }
            INodesInPath inodesInPath = this.getINodesInPath(srcs, true);
            INode[] inodes = inodesInPath.getINodes();
            int snapshot = inodesInPath.getPathSnapshotId();
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null) {
                DirectoryListing directoryListing = null;
                return directoryListing;
            }
            byte by = parentStoragePolicy = isSuperUser ? targetNode.getStoragePolicyID() : (byte)0;
            if (!targetNode.isDirectory()) {
                DirectoryListing directoryListing = new DirectoryListing(new HdfsFileStatus[]{this.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode, needLocation, parentStoragePolicy, snapshot, isRawPath, inodesInPath)}, 0);
                return directoryListing;
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
            int locationBudget = this.lsLimit;
            int listingCnt = 0;
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
                INode cur = contents.get(startChild + i);
                byte curPolicy = isSuperUser && !cur.isSymlink() ? cur.getLocalStoragePolicyID() : (byte)0;
                listing[i] = this.createFileStatus(cur.getLocalNameBytes(), cur, needLocation, this.getStoragePolicyID(curPolicy, parentStoragePolicy), snapshot, isRawPath, inodesInPath);
                ++listingCnt;
                if (!needLocation) continue;
                LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getBlockLocations();
                locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
            }
            if (listingCnt < numOfListing) {
                listing = Arrays.copyOf(listing, listingCnt);
            }
            DirectoryListing directoryListing = new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
            return directoryListing;
        }
        finally {
            this.readUnlock();
        }
    }

    private DirectoryListing getSnapshotsListing(String src, byte[] startAfter) throws UnresolvedLinkException, IOException {
        Preconditions.checkState((boolean)this.hasReadLock());
        Preconditions.checkArgument((boolean)src.endsWith("/.snapshot"), (String)"%s does not end with %s", (Object[])new Object[]{src, "/.snapshot"});
        String dirPath = FSDirectory.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        INodeDirectory dirNode = INodeDirectory.valueOf(node, dirPath);
        DirectorySnapshottableFeature sf = dirNode.getDirectorySnapshottableFeature();
        if (sf == null) {
            throw new SnapshotException("Directory is not a snapshottable directory: " + dirPath);
        }
        ReadOnlyList<Snapshot> snapshots = sf.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, this.lsLimit);
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            listing[i] = this.createFileStatus(sRoot.getLocalNameBytes(), sRoot, (byte)0, 0x7FFFFFFE, false, null);
        }
        return new DirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    Collection<String> getSnapshotFiles(List<DirectorySnapshottableFeature> lsf, String file) throws IOException {
        ArrayList<String> snaps = new ArrayList<String>();
        for (DirectorySnapshottableFeature sf : lsf) {
            Snapshot s;
            String dirName;
            ReadOnlyList<Snapshot> lsnap = sf.getSnapshotList();
            Iterator i$ = lsnap.iterator();
            while (i$.hasNext() && file.startsWith(dirName = (s = (Snapshot)i$.next()).getRoot().getRootFullPathName())) {
                String snapname = s.getRoot().getFullPathName();
                if (dirName.equals("/")) {
                    snapname = snapname + "/";
                }
                snapname = snapname + file.substring(file.indexOf(dirName) + dirName.length());
                if (this.getFSNamesystem().getFileInfo(snapname, true) == null) continue;
                snaps.add(snapname);
            }
        }
        return snaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src, boolean resolveLink, boolean isRawPath, boolean includeStoragePolicy) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            if (srcs.endsWith("/.snapshot")) {
                HdfsFileStatus hdfsFileStatus = this.getFileInfo4DotSnapshot(srcs);
                return hdfsFileStatus;
            }
            INodesInPath inodesInPath = this.getINodesInPath(srcs, resolveLink);
            INode[] inodes = inodesInPath.getINodes();
            INode i = inodes[inodes.length - 1];
            byte policyId = includeStoragePolicy && i != null && !i.isSymlink() ? i.getStoragePolicyID() : (byte)0;
            HdfsFileStatus hdfsFileStatus = i == null ? null : this.createFileStatus(HdfsFileStatus.EMPTY_NAME, i, policyId, inodesInPath.getPathSnapshotId(), isRawPath, inodesInPath);
            return hdfsFileStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    private HdfsFileStatus getFileInfo4DotSnapshot(String src) throws UnresolvedLinkException {
        if (this.getINode4DotSnapshot(src) != null) {
            return new HdfsFileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, null, HdfsFileStatus.EMPTY_NAME, -1L, 0, null, 0);
        }
        return null;
    }

    private INode getINode4DotSnapshot(String src) throws UnresolvedLinkException {
        Preconditions.checkArgument((boolean)src.endsWith("/.snapshot"), (String)"%s does not end with %s", (Object[])new Object[]{src, "/.snapshot"});
        String dirPath = FSDirectory.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        if (node != null && node.isDirectory() && node.asDirectory().isSnapshottable()) {
            return node;
        }
        return null;
    }

    INodesInPath getExistingPathINodes(byte[][] components) throws UnresolvedLinkException {
        return INodesInPath.resolve(this.rootDir, components);
    }

    public INode getINode(String src) throws UnresolvedLinkException {
        return this.getLastINodeInPath(src).getINode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodesInPath getLastINodeInPath(String src) throws UnresolvedLinkException {
        this.readLock();
        try {
            INodesInPath iNodesInPath = this.getLastINodeInPath(src, true);
            return iNodesInPath;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodesInPath getINodesInPath4Write(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        this.readLock();
        try {
            INodesInPath iNodesInPath = this.getINodesInPath4Write(src, true);
            return iNodesInPath;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getINode4Write(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        this.readLock();
        try {
            INode iNode = this.getINode4Write(src, true);
            return iNode;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidToCreate(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            boolean bl = srcs.startsWith("/") && !srcs.endsWith("/") && this.getINode4Write(srcs, false) == null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) throws UnresolvedLinkException {
        src = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode node = this.getNode(src, false);
            boolean bl = node != null && node.isDirectory();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirMutable(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        src = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode node = this.getINode4Write(src, false);
            boolean bl = node != null && node.isDirectory();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCountForQuota(int initThreads) {
        this.writeLock();
        try {
            int threads = initThreads < 1 ? 1 : initThreads;
            LOG.info("Initializing quota with " + threads + " thread(s)");
            long start = Time.now();
            Quota.Counts counts = Quota.Counts.newInstance();
            ForkJoinPool p = new ForkJoinPool(threads);
            InitQuotaTask task = new InitQuotaTask(this.rootDir, counts);
            p.execute(task);
            task.join();
            p.shutdown();
            LOG.info("Quota initialization completed in " + (Time.now() - start) + " milliseconds\n" + counts);
        }
        finally {
            this.writeUnlock();
        }
    }

    void updateCountForQuota() {
        this.updateCountForQuota(this.quotaInitThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            INodesInPath iip = this.getINodesInPath4Write(path, false);
            if (iip.getLastINode() == null) {
                throw new FileNotFoundException("Path not found: " + path);
            }
            this.updateCount(iip, nsDelta, dsDelta, true);
        }
        finally {
            this.writeUnlock();
        }
    }

    void updateCountForDelete(INode inode, INodesInPath iip) {
        if (this.getFSNamesystem().isImageLoaded() && !inode.isInLatestSnapshot(iip.getLatestSnapshotId())) {
            Quota.Counts counts = inode.computeQuotaUsage();
            FSDirectory.unprotectedUpdateCount(iip, iip.length() - 1, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        }
    }

    private void updateCount(INodesInPath iip, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        this.updateCount(iip, iip.getINodes().length - 1, nsDelta, dsDelta, checkQuota);
    }

    private void updateCount(INodesInPath iip, int numOfINodes, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        assert (this.hasWriteLock());
        if (!this.namesystem.isImageLoaded()) {
            return;
        }
        INode[] inodes = iip.getINodes();
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        if (checkQuota && !this.skipQuotaCheck) {
            FSDirectory.verifyQuota(inodes, numOfINodes, nsDelta, dsDelta, null);
        }
        FSDirectory.unprotectedUpdateCount(iip, numOfINodes, nsDelta, dsDelta);
    }

    void updateCountNoQuotaCheck(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta) {
        assert (this.hasWriteLock());
        try {
            this.updateCount(inodesInPath, numOfINodes, nsDelta, dsDelta, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.error("BUG: unexpected exception ", (Throwable)e);
        }
    }

    private static void unprotectedUpdateCount(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta) {
        INode[] inodes = inodesInPath.getINodes();
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            inodes[i].asDirectory().getDirectoryWithQuotaFeature().addSpaceConsumed2Cache(nsDelta, dsDelta);
        }
    }

    static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        if (inodes[0].isRoot()) {
            if (pos == 0) {
                return "/";
            }
        } else {
            fullPathName.append(inodes[0].getLocalName());
        }
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    INode unprotectedMkdir(long inodeId, String src, PermissionStatus permissions, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, UnresolvedLinkException, AclException {
        assert (this.hasWriteLock());
        byte[][] components = INode.getPathComponents(src);
        INodesInPath iip = this.getExistingPathINodes(components);
        INode[] inodes = iip.getINodes();
        int pos = inodes.length - 1;
        this.unprotectedMkdir(inodeId, iip, pos, components[pos], permissions, aclEntries, timestamp);
        return inodes[pos];
    }

    void unprotectedMkdir(long inodeId, INodesInPath inodesInPath, int pos, byte[] name, PermissionStatus permission, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, AclException {
        assert (this.hasWriteLock());
        INodeDirectory dir = new INodeDirectory(inodeId, name, permission, timestamp);
        if (this.addChild(inodesInPath, pos, dir, permission.getPermission(), true)) {
            if (aclEntries != null) {
                AclStorage.updateINodeAcl(dir, aclEntries, 0x7FFFFFFE);
            }
            inodesInPath.setINode(pos, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean addINode(String src, INode child, FsPermission modes) throws QuotaExceededException, UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(src);
        child.setLocalName(components[components.length - 1]);
        this.cacheName(child);
        this.writeLock();
        try {
            boolean bl = this.addLastINode(this.getExistingPathINodes(components), child, modes, true);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    static void verifyQuota(INode[] inodes, int pos, long nsDelta, long dsDelta, INode commonAncestor) throws QuotaExceededException {
        if (nsDelta <= 0L && dsDelta <= 0L) {
            return;
        }
        for (int i = (pos > inodes.length ? inodes.length : pos) - 1; i >= 0; --i) {
            if (commonAncestor == inodes[i]) {
                return;
            }
            DirectoryWithQuotaFeature q = inodes[i].asDirectory().getDirectoryWithQuotaFeature();
            if (q == null) continue;
            try {
                q.verifyQuota(nsDelta, dsDelta);
                continue;
            }
            catch (QuotaExceededException e) {
                e.setPathName(FSDirectory.getFullPathName(inodes, i));
                throw e;
            }
        }
    }

    private void verifyQuotaForRename(INode[] src, INode[] dst) throws QuotaExceededException {
        if (!this.namesystem.isImageLoaded() || this.skipQuotaCheck) {
            return;
        }
        int i = 0;
        while (src[i] == dst[i]) {
            ++i;
        }
        Quota.Counts delta = src[src.length - 1].computeQuotaUsage();
        int dstIndex = dst.length - 1;
        if (dst[dstIndex] != null) {
            delta.subtract(dst[dstIndex].computeQuotaUsage());
        }
        FSDirectory.verifyQuota(dst, dstIndex, delta.get(Quota.NAMESPACE), delta.get(Quota.DISKSPACE), src[i - 1]);
    }

    private void verifyFsLimitsForRename(INodesInPath srcIIP, INodesInPath dstIIP) throws FSLimitException.PathComponentTooLongException, FSLimitException.MaxDirectoryItemsExceededException {
        byte[] dstChildName = dstIIP.getLastLocalName();
        INode[] dstInodes = dstIIP.getINodes();
        int pos = dstInodes.length - 1;
        this.verifyMaxComponentLength(dstChildName, dstInodes, pos);
        if (srcIIP.getINode(-2) != dstIIP.getINode(-2)) {
            this.verifyMaxDirItems(dstInodes, pos);
        }
    }

    void verifySnapshotName(String snapshotName, String path) throws FSLimitException.PathComponentTooLongException {
        if (snapshotName.contains("/")) {
            throw new HadoopIllegalArgumentException("Snapshot name cannot contain \"/\"");
        }
        byte[] bytes = DFSUtil.string2Bytes(snapshotName);
        this.verifyINodeName(bytes);
        this.verifyMaxComponentLength(bytes, path, 0);
    }

    void verifyINodeName(byte[] childName) throws HadoopIllegalArgumentException {
        if (Arrays.equals(HdfsConstants.DOT_SNAPSHOT_DIR_BYTES, childName)) {
            String s = "\".snapshot\" is a reserved name.";
            if (!this.namesystem.isImageLoaded()) {
                s = s + "  Please rename it before upgrade.";
            }
            throw new HadoopIllegalArgumentException(s);
        }
    }

    private void verifyMaxComponentLength(byte[] childName, Object parentPath, int pos) throws FSLimitException.PathComponentTooLongException {
        if (this.maxComponentLength == 0) {
            return;
        }
        int length = childName.length;
        if (length > this.maxComponentLength) {
            String p = parentPath instanceof INode[] ? FSDirectory.getFullPathName((INode[])parentPath, pos - 1) : (String)parentPath;
            FSLimitException.PathComponentTooLongException e = new FSLimitException.PathComponentTooLongException(this.maxComponentLength, length, p, DFSUtil.bytes2String(childName));
            if (this.namesystem.isImageLoaded()) {
                throw e;
            }
            NameNode.LOG.error("ERROR in FSDirectory.verifyINodeName", (Throwable)e);
        }
    }

    private void verifyMaxDirItems(INode[] pathComponents, int pos) throws FSLimitException.MaxDirectoryItemsExceededException {
        INodeDirectory parent = pathComponents[pos - 1].asDirectory();
        int count = parent.getChildrenList(0x7FFFFFFE).size();
        if (count >= this.maxDirItems) {
            FSLimitException.MaxDirectoryItemsExceededException e = new FSLimitException.MaxDirectoryItemsExceededException(this.maxDirItems, count);
            if (this.namesystem.isImageLoaded()) {
                e.setPathName(FSDirectory.getFullPathName(pathComponents, pos - 1));
                throw e;
            }
            NameNode.LOG.error("FSDirectory.verifyMaxDirItems: " + e.getLocalizedMessage());
        }
    }

    private void copyINodeDefaultAcl(INode child, FsPermission modes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("child: {}, posixAclInheritanceEnabled: {}, modes: {}", new Object[]{child, this.posixAclInheritanceEnabled, modes});
        }
        if (this.posixAclInheritanceEnabled && modes != null && modes.getUnmasked() != null) {
            child.setPermission(modes.getUnmasked());
            if (!AclStorage.copyINodeDefaultAcl(child)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: no parent default ACL to inherit", (Object)child);
                }
                child.setPermission(modes.getMasked());
            }
        } else {
            AclStorage.copyINodeDefaultAcl(child);
        }
    }

    @VisibleForTesting
    public boolean addLastINode(INodesInPath inodesInPath, INode inode, FsPermission modes, boolean checkQuota) throws QuotaExceededException {
        int pos = inodesInPath.getINodes().length - 1;
        return this.addChild(inodesInPath, pos, inode, modes, checkQuota);
    }

    private boolean addChild(INodesInPath iip, int pos, INode child, FsPermission modes, boolean checkQuota) throws QuotaExceededException {
        boolean added;
        INode[] inodes = iip.getINodes();
        if (pos == 1 && inodes[0] == this.rootDir && FSDirectory.isReservedName(child)) {
            throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved and cannot " + "be created. If this is during upgrade change the name of the " + "existing file or directory to another name before upgrading " + "to the new release.");
        }
        if (checkQuota) {
            this.verifyMaxComponentLength(child.getLocalNameBytes(), inodes, pos);
            this.verifyMaxDirItems(inodes, pos);
        }
        this.verifyINodeName(child.getLocalNameBytes());
        Quota.Counts counts = child.computeQuotaUsage();
        this.updateCount(iip, pos, counts.get(Quota.NAMESPACE), counts.get(Quota.DISKSPACE), checkQuota);
        boolean isRename = child.getParent() != null;
        INodeDirectory parent = inodes[pos - 1].asDirectory();
        try {
            added = parent.addChild(child, true, iip.getLatestSnapshotId());
        }
        catch (QuotaExceededException e) {
            this.updateCountNoQuotaCheck(iip, pos, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
            throw e;
        }
        if (!added) {
            this.updateCountNoQuotaCheck(iip, pos, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        } else {
            iip.setINode(pos - 1, child.getParent());
            if (!isRename) {
                this.copyINodeDefaultAcl(child, modes);
            }
            this.addToInodeMap(child);
        }
        return added;
    }

    private boolean addLastINodeNoQuotaCheck(INodesInPath inodesInPath, INode i) {
        try {
            return this.addLastINode(inodesInPath, i, null, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn("FSDirectory.addChildNoQuotaCheck - unexpected", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    public long removeLastINode(INodesInPath iip) {
        int latestSnapshot = iip.getLatestSnapshotId();
        INode last = iip.getLastINode();
        INodeDirectory parent = iip.getINode(-2).asDirectory();
        if (!parent.removeChild(last, latestSnapshot)) {
            return -1L;
        }
        return !last.isInLatestSnapshot(latestSnapshot) && INodeReference.tryRemoveReference(last) > 0 ? 0L : 1L;
    }

    static String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws FileNotFoundException, UnresolvedLinkException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode targetNode = this.getNode(srcs, false);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            ContentSummaryComputationContext cscc = new ContentSummaryComputationContext(this, this.getFSNamesystem(), this.contentCountLimit, this.contentSleepMicroSec);
            byte[][] components = INode.getPathComponents(src);
            INodesInPath iip = INodesInPath.resolve(this.rootDir, components);
            ContentSummary cs = targetNode.computeAndConvertContentSummary(iip.getPathSnapshotId(), cscc);
            this.yieldCount += cscc.getYieldCount();
            ContentSummary contentSummary = cs;
            return contentSummary;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    public long getYieldCount() {
        return this.yieldCount;
    }

    public INodeMap getINodeMap() {
        return this.inodeMap;
    }

    public final void addToInodeMap(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.inodeMap.put(inode);
            if (!inode.isSymlink()) {
                XAttrFeature xaf = inode.getXAttrFeature();
                this.addEncryptionZone((INodeWithAdditionalFields)inode, xaf);
            }
        }
    }

    private void addEncryptionZone(INodeWithAdditionalFields inode, XAttrFeature xaf) {
        if (xaf == null) {
            return;
        }
        ImmutableList<XAttr> xattrs = xaf.getXAttrs();
        for (XAttr xattr : xattrs) {
            String xaName = XAttrHelper.getPrefixName(xattr);
            if (!"raw.hdfs.crypto.encryption.zone".equals(xaName)) continue;
            try {
                HdfsProtos.ZoneEncryptionInfoProto ezProto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom(xattr.getValue());
                this.ezManager.unprotectedAddEncryptionZone(inode.getId(), PBHelper.convert(ezProto.getSuite()), PBHelper.convert(ezProto.getCryptoProtocolVersion()), ezProto.getKeyName());
                if (!ezProto.hasReencryptionProto()) continue;
                HdfsProtos.ReencryptionInfoProto reProto = ezProto.getReencryptionProto();
                this.ezManager.getReencryptionStatus().updateZoneStatus(inode.getId(), null, reProto);
            }
            catch (InvalidProtocolBufferException e) {
                NameNode.LOG.warn("Error parsing protocol buffer of EZ XAttr " + xattr.getName() + " dir:" + inode.getFullPathName());
            }
        }
    }

    public final void addRootDirToEncryptionZone(XAttrFeature xaf) {
        this.addEncryptionZone(this.rootDir, xaf);
    }

    public final void removeFromInodeMap(List<? extends INode> inodes) {
        if (inodes != null) {
            for (INode iNode : inodes) {
                if (iNode == null || !(iNode instanceof INodeWithAdditionalFields)) continue;
                this.inodeMap.remove(iNode);
                this.ezManager.removeEncryptionZone(iNode.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getInode(long id) {
        this.readLock();
        try {
            INode iNode = this.inodeMap.get(id);
            return iNode;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    int getInodeMapSize() {
        return this.inodeMap.size();
    }

    INodeDirectory unprotectedSetQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota != -1L || dsQuota < 0L && dsQuota != Long.MAX_VALUE && dsQuota != -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or dsQuota : " + nsQuota + " and " + dsQuota);
        }
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = this.getINodesInPath4Write(srcs, true);
        INodeDirectory dirNode = INodeDirectory.valueOf(iip.getLastINode(), srcs);
        if (dirNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        Quota.Counts oldQuota = dirNode.getQuotaCounts();
        long oldNsQuota = oldQuota.get(Quota.NAMESPACE);
        long oldDsQuota = oldQuota.get(Quota.DISKSPACE);
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (dsQuota == Long.MAX_VALUE) {
            dsQuota = oldDsQuota;
        }
        if (oldNsQuota == nsQuota && oldDsQuota == dsQuota) {
            return null;
        }
        int latest = iip.getLatestSnapshotId();
        dirNode.recordModification(latest);
        dirNode.setQuota(nsQuota, dsQuota);
        return dirNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeDirectory setQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            INodeDirectory iNodeDirectory = this.unprotectedSetQuota(src, nsQuota, dsQuota);
            return iNodeDirectory;
        }
        finally {
            this.writeUnlock();
        }
    }

    long totalInodes() {
        return this.getInodeMapSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setTimes(INode inode, long mtime, long atime, boolean force, int latestSnapshotId) throws QuotaExceededException {
        this.writeLock();
        try {
            boolean bl = this.unprotectedSetTimes(inode, mtime, atime, force, latestSnapshotId);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean unprotectedSetTimes(String src, long mtime, long atime, boolean force) throws UnresolvedLinkException, QuotaExceededException {
        assert (this.hasWriteLock());
        INodesInPath i = this.getLastINodeInPath(src);
        return this.unprotectedSetTimes(i.getLastINode(), mtime, atime, force, i.getLatestSnapshotId());
    }

    private boolean unprotectedSetTimes(INode inode, long mtime, long atime, boolean force, int latest) throws QuotaExceededException {
        assert (this.hasWriteLock());
        boolean status = false;
        if (mtime != -1L) {
            inode = inode.setModificationTime(mtime, latest);
            status = true;
        }
        if (atime != -1L && (status || force || atime > inode.getAccessTime() + this.getFSNamesystem().getAccessTimePrecision())) {
            inode.setAccessTime(atime, latest, this.getFSNamesystem().getSnapshotManager().getSkipCaptureAccessTimeOnlyChange());
            status = true;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        this.writeLock();
        try {
            this.rootDir = FSDirectory.createRoot(this.getFSNamesystem());
            this.inodeMap.clear();
            this.addToInodeMap(this.rootDir);
            this.nameCache.reset();
        }
        finally {
            this.writeUnlock();
        }
    }

    private HdfsFileStatus createFileStatus(byte[] path, INode node, boolean needLocation, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        if (needLocation) {
            return this.createLocatedFileStatus(path, node, storagePolicy, snapshot, isRawPath, iip);
        }
        return this.createFileStatus(path, node, storagePolicy, snapshot, isRawPath, iip);
    }

    HdfsFileStatus createFileStatus(byte[] path, INode node, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        boolean isEncrypted;
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        FileEncryptionInfo feInfo = isRawPath ? null : this.getFileEncryptionInfo(node, snapshot, iip);
        boolean isLazyPersist = false;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            isEncrypted = feInfo != null || isRawPath && this.isInAnEZ(INodesInPath.fromINode(node));
        } else {
            isEncrypted = this.isInAnEZ(INodesInPath.fromINode(node));
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        return new HdfsFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirectory.getPermissionForFileStatus(node, snapshot, isEncrypted), node.getUserName(snapshot), node.getGroupName(snapshot), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), childrenNum, feInfo, storagePolicy);
    }

    private HdfsLocatedFileStatus createLocatedFileStatus(byte[] path, INode node, byte storagePolicy, int snapshot, boolean isRawPath, INodesInPath iip) throws IOException {
        boolean isEncrypted;
        FileEncryptionInfo feInfo;
        assert (this.hasReadLock());
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        LocatedBlocks loc = null;
        FileEncryptionInfo fileEncryptionInfo = feInfo = isRawPath ? null : this.getFileEncryptionInfo(node, snapshot, iip);
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            boolean inSnapshot = snapshot != 0x7FFFFFFE;
            boolean isUc = !inSnapshot && fileNode.isUnderConstruction();
            long fileSize = !inSnapshot && isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
            loc = this.getFSNamesystem().getBlockManager().createLocatedBlocks(fileNode.getBlocks(), fileSize, isUc, 0L, size, false, inSnapshot, feInfo);
            if (loc == null) {
                loc = new LocatedBlocks();
            }
            isEncrypted = feInfo != null || isRawPath && this.isInAnEZ(INodesInPath.fromINode(node));
        } else {
            isEncrypted = this.isInAnEZ(INodesInPath.fromINode(node));
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        HdfsLocatedFileStatus status = new HdfsLocatedFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirectory.getPermissionForFileStatus(node, snapshot, isEncrypted), node.getUserName(snapshot), node.getGroupName(snapshot), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), loc, childrenNum, feInfo, storagePolicy);
        if (loc != null) {
            CacheManager cacheManager = this.namesystem.getCacheManager();
            for (LocatedBlock lb : loc.getLocatedBlocks()) {
                cacheManager.setCachedLocations(lb);
            }
        }
        return status;
    }

    private static FsPermission getPermissionForFileStatus(INode node, int snapshot, boolean isEncrypted) {
        boolean hasAcl;
        FsPermission perm = node.getFsPermission(snapshot);
        boolean bl = hasAcl = node.getAclFeature(snapshot) != null;
        if (hasAcl || isEncrypted) {
            perm = new FsPermissionExtension(perm, hasAcl, isEncrypted);
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeSymlink addSymlink(long id, String path, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException {
        this.writeLock();
        try {
            INodeSymlink iNodeSymlink = this.unprotectedAddSymlink(id, path, target, mtime, atime, perm);
            return iNodeSymlink;
        }
        finally {
            this.writeUnlock();
        }
    }

    INodeSymlink unprotectedAddSymlink(long id, String path, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException {
        assert (this.hasWriteLock());
        INodeSymlink symlink = new INodeSymlink(id, null, perm, mtime, atime, target);
        return this.addINode(path, symlink, perm.getPermission()) ? symlink : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedModifyAclEntries(src, aclSpec);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<AclEntry> unprotectedModifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.mergeAclEntries(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedRemoveAclEntries(src, aclSpec);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<AclEntry> unprotectedRemoveAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.filterAclEntriesByAclSpec(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> removeDefaultAcl(String src) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedRemoveDefaultAcl(src);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<AclEntry> unprotectedRemoveDefaultAcl(String src) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.filterDefaultAclEntries(existingAcl);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcl(String src) throws IOException {
        this.writeLock();
        try {
            this.unprotectedRemoveAcl(src);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void unprotectedRemoveAcl(String src) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        AclStorage.removeINodeAcl(inode, snapshotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedSetAcl(src, aclSpec, false);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    List<AclEntry> unprotectedSetAcl(String src, List<AclEntry> aclSpec, boolean fromEdits) throws IOException {
        if (aclSpec.isEmpty()) {
            this.unprotectedRemoveAcl(src);
            return AclFeature.EMPTY_ENTRY_LIST;
        }
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> newAcl = aclSpec;
        if (!fromEdits) {
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            newAcl = AclTransformation.replaceAclEntries(existingAcl, aclSpec);
        }
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AclStatus getAclStatus(String src) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            if (srcs.endsWith("/.snapshot") && this.getINode4DotSnapshot(srcs) != null) {
                AclStatus aclStatus = new AclStatus.Builder().owner("").group("").build();
                return aclStatus;
            }
            INodesInPath iip = this.getLastINodeInPath(srcs, true);
            INode inode = FSDirectory.resolveLastINode(src, iip);
            int snapshotId = iip.getPathSnapshotId();
            List<AclEntry> acl = AclStorage.readINodeAcl(inode, snapshotId);
            FsPermission fsPermission = inode.getFsPermission(snapshotId);
            AclStatus aclStatus = new AclStatus.Builder().owner(inode.getUserName()).group(inode.getGroupName()).stickyBit(fsPermission.getStickyBit()).setPermission(fsPermission).addEntries(acl).build();
            return aclStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> removeXAttrs(String src, List<XAttr> toRemove) throws IOException {
        this.writeLock();
        try {
            List<XAttr> list = this.unprotectedRemoveXAttrs(src, toRemove);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    List<XAttr> unprotectedRemoveXAttrs(String src, List<XAttr> toRemove) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        ArrayList removedXAttrs = Lists.newArrayListWithCapacity((int)toRemove.size());
        List<XAttr> newXAttrs = this.filterINodeXAttrs(existingXAttrs, toRemove, removedXAttrs);
        if (existingXAttrs.size() != newXAttrs.size()) {
            XAttrStorage.updateINodeXAttrs(inode, newXAttrs, snapshotId);
            return removedXAttrs;
        }
        return null;
    }

    @VisibleForTesting
    List<XAttr> filterINodeXAttrs(List<XAttr> existingXAttrs, List<XAttr> toFilter, List<XAttr> filtered) throws AccessControlException {
        if (existingXAttrs == null || existingXAttrs.isEmpty() || toFilter == null || toFilter.isEmpty()) {
            return existingXAttrs;
        }
        ArrayList newXAttrs = Lists.newArrayListWithCapacity((int)existingXAttrs.size());
        for (XAttr a : existingXAttrs) {
            boolean add = true;
            ListIterator<XAttr> it = toFilter.listIterator();
            while (it.hasNext()) {
                XAttr filter = it.next();
                Preconditions.checkArgument((!this.KEYID_XATTR.equalsIgnoreValue(filter) ? 1 : 0) != 0, (Object)"The encryption zone xattr should never be deleted.");
                if (this.UNREADABLE_BY_SUPERUSER_XATTR.equalsIgnoreValue(filter)) {
                    throw new AccessControlException("The xattr 'security.hdfs.unreadable.by.superuser' can not be deleted.");
                }
                if (!a.equalsIgnoreValue(filter)) continue;
                add = false;
                it.remove();
                filtered.add(filter);
                break;
            }
            if (!add) continue;
            newXAttrs.add(a);
        }
        return newXAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInAnEZ(INodesInPath iip) throws UnresolvedLinkException, SnapshotAccessControlException {
        this.readLock();
        try {
            boolean bl = this.ezManager.isInAnEZ(iip);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getKeyName(INodesInPath iip) {
        this.readLock();
        try {
            String string = this.ezManager.getKeyName(iip);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XAttr createEncryptionZone(String src, CipherSuite suite, CryptoProtocolVersion version, String keyName) throws IOException {
        this.writeLock();
        try {
            XAttr xAttr = this.ezManager.createEncryptionZone(src, suite, version, keyName);
            return xAttr;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EncryptionZone getEZForPath(INodesInPath iip) {
        this.readLock();
        try {
            EncryptionZone encryptionZone = this.ezManager.getEZINodeForPath(iip);
            return encryptionZone;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        this.readLock();
        try {
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> batchedListEntries = this.ezManager.listEncryptionZones(prevId);
            return batchedListEntries;
        }
        finally {
            this.readUnlock();
        }
    }

    List<XAttr> reencryptEncryptionZone(INodesInPath iip, String keyVersionName) throws IOException {
        assert (keyVersionName != null);
        return this.ezManager.reencryptEncryptionZone(iip, keyVersionName);
    }

    List<XAttr> cancelReencryptEncryptionZone(INodesInPath iip) throws IOException {
        return this.ezManager.cancelReencryptEncryptionZone(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> listReencryptionStatus(long prevId) throws IOException {
        this.readLock();
        try {
            BatchedRemoteIterator.BatchedListEntries<ZoneReencryptionStatus> batchedListEntries = this.ezManager.listReencryptionStatus(prevId);
            return batchedListEntries;
        }
        finally {
            this.readUnlock();
        }
    }

    XAttr updateReencryptionSubmitted(INodesInPath iip, String ezKeyVersionName) throws IOException {
        assert (this.hasWriteLock());
        Preconditions.checkNotNull((Object)ezKeyVersionName, (Object)"ezKeyVersionName is null.");
        HdfsProtos.ZoneEncryptionInfoProto zoneProto = this.getZoneEncryptionInfoProto(iip);
        Preconditions.checkNotNull((Object)zoneProto, (Object)"ZoneEncryptionInfoProto is null.");
        HdfsProtos.ReencryptionInfoProto newProto = PBHelper.convert(ezKeyVersionName, Time.now(), false, 0L, 0L, null, null);
        HdfsProtos.ZoneEncryptionInfoProto newZoneProto = PBHelper.convert(PBHelper.convert(zoneProto.getSuite()), PBHelper.convert(zoneProto.getCryptoProtocolVersion()), zoneProto.getKeyName(), newProto);
        XAttr xattr = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", newZoneProto.toByteArray());
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(xattr);
        this.unprotectedSetXAttrs(iip.getPath(), xattrs, EnumSet.of(XAttrSetFlag.REPLACE));
        return xattr;
    }

    XAttr updateReencryptionProgress(INode zoneNode, ZoneReencryptionStatus origStatus, String lastFile, long numReencrypted, long numFailures) throws IOException {
        assert (this.hasWriteLock());
        Preconditions.checkNotNull((Object)zoneNode, (Object)"Zone node is null");
        INodesInPath iip = INodesInPath.fromINode(zoneNode);
        HdfsProtos.ZoneEncryptionInfoProto zoneProto = this.getZoneEncryptionInfoProto(iip);
        Preconditions.checkNotNull((Object)zoneProto, (Object)"ZoneEncryptionInfoProto is null.");
        Preconditions.checkNotNull((Object)origStatus, (Object)("Null status for " + iip.getPath()));
        HdfsProtos.ReencryptionInfoProto newProto = PBHelper.convert(origStatus.getEzKeyVersionName(), origStatus.getSubmissionTime(), false, origStatus.getFilesReencrypted() + numReencrypted, origStatus.getNumReencryptionFailures() + numFailures, null, lastFile);
        HdfsProtos.ZoneEncryptionInfoProto newZoneProto = PBHelper.convert(PBHelper.convert(zoneProto.getSuite()), PBHelper.convert(zoneProto.getCryptoProtocolVersion()), zoneProto.getKeyName(), newProto);
        XAttr xattr = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", newZoneProto.toByteArray());
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(xattr);
        this.unprotectedSetXAttrs(iip.getPath(), xattrs, EnumSet.of(XAttrSetFlag.REPLACE));
        return xattr;
    }

    List<XAttr> updateReencryptionFinish(INodesInPath zoneIIP, ZoneReencryptionStatus origStatus) throws IOException {
        assert (origStatus != null);
        assert (this.hasWriteLock());
        this.ezManager.getReencryptionStatus().markZoneCompleted(zoneIIP.getLastINode().getId());
        XAttr xattr = this.generateNewXAttrForReencryptionFinish(zoneIIP, origStatus);
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(xattr);
        this.unprotectedSetXAttrs(zoneIIP.getPath(), xattrs, EnumSet.of(XAttrSetFlag.REPLACE));
        return xattrs;
    }

    XAttr generateNewXAttrForReencryptionFinish(INodesInPath iip, ZoneReencryptionStatus status) throws IOException {
        HdfsProtos.ZoneEncryptionInfoProto zoneProto = this.getZoneEncryptionInfoProto(iip);
        HdfsProtos.ReencryptionInfoProto newRiProto = PBHelper.convert(status.getEzKeyVersionName(), status.getSubmissionTime(), status.isCanceled(), status.getFilesReencrypted(), status.getNumReencryptionFailures(), Time.now(), null);
        HdfsProtos.ZoneEncryptionInfoProto newZoneProto = PBHelper.convert(PBHelper.convert(zoneProto.getSuite()), PBHelper.convert(zoneProto.getCryptoProtocolVersion()), zoneProto.getKeyName(), newRiProto);
        XAttr xattr = XAttrHelper.buildXAttr("raw.hdfs.crypto.encryption.zone", newZoneProto.toByteArray());
        return xattr;
    }

    private HdfsProtos.ZoneEncryptionInfoProto getZoneEncryptionInfoProto(INodesInPath iip) throws IOException {
        XAttr fileXAttr = this.unprotectedGetXAttrByName(iip.getLastINode(), 0x7FFFFFFE, "raw.hdfs.crypto.encryption.zone");
        if (fileXAttr == null) {
            throw new IOException("Could not find reencryption XAttr for file " + iip.getPath());
        }
        try {
            return HdfsProtos.ZoneEncryptionInfoProto.parseFrom(fileXAttr.getValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Could not parse file encryption info for inode " + iip.getPath(), e);
        }
    }

    void saveFileXAttrsForBatch(List<ReencryptionUpdater.FileEdekInfo> batch) {
        assert (this.getFSNamesystem().hasWriteLock());
        assert (!this.hasWriteLock());
        if (batch != null && !batch.isEmpty()) {
            for (ReencryptionUpdater.FileEdekInfo entry : batch) {
                INode inode = this.getInode(entry.getInodeId());
                if (inode == null) {
                    NameNode.LOG.info("Cannot find inode {}, skip saving xattr for re-encryption", (Object)entry.getInodeId());
                    continue;
                }
                this.getFSNamesystem().getEditLog().logSetXAttrs(inode.getFullPathName(), (List<XAttr>)inode.getXAttrFeature().getXAttrs(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileEncryptionInfo(String src, FileEncryptionInfo info, XAttrSetFlag flag) throws IOException {
        HdfsProtos.PerFileEncryptionInfoProto proto = PBHelper.convertPerFileEncInfo(info);
        byte[] protoBytes = proto.toByteArray();
        XAttr fileEncryptionAttr = XAttrHelper.buildXAttr("raw.hdfs.crypto.file.encryption.info", protoBytes);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(fileEncryptionAttr);
        this.writeLock();
        try {
            this.unprotectedSetXAttrs(src, xAttrs, EnumSet.of(flag));
        }
        finally {
            this.writeUnlock();
        }
    }

    FileEncryptionInfo getFileEncryptionInfo(INode inode, int snapshotId, INodesInPath iip) throws IOException {
        if (!inode.isFile() || !this.ezManager.hasCreatedEncryptionZone()) {
            return null;
        }
        this.readLock();
        try {
            EncryptionZone encryptionZone;
            if (iip == null) {
                iip = this.getINodesInPath(inode.getFullPathName(), true);
            }
            if ((encryptionZone = this.getEZForPath(iip)) == null) {
                FileEncryptionInfo fileEncryptionInfo = null;
                return fileEncryptionInfo;
            }
            if ((encryptionZone.getPath() == null || encryptionZone.getPath().isEmpty()) && NameNode.LOG.isDebugEnabled()) {
                NameNode.LOG.debug("Encryption zone " + encryptionZone.getPath() + " does not have a valid path.");
            }
            CryptoProtocolVersion version = encryptionZone.getVersion();
            CipherSuite suite = encryptionZone.getSuite();
            String keyName = encryptionZone.getKeyName();
            XAttr fileXAttr = this.unprotectedGetXAttrByName(inode, snapshotId, "raw.hdfs.crypto.file.encryption.info");
            if (fileXAttr == null) {
                NameNode.LOG.warn("Could not find encryption XAttr for file " + inode.getFullPathName() + " in encryption zone " + encryptionZone.getPath());
                FileEncryptionInfo fileEncryptionInfo = null;
                return fileEncryptionInfo;
            }
            HdfsProtos.PerFileEncryptionInfoProto fileProto = HdfsProtos.PerFileEncryptionInfoProto.parseFrom(fileXAttr.getValue());
            FileEncryptionInfo fileEncryptionInfo = PBHelper.convert(fileProto, suite, version, keyName);
            return fileEncryptionInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    String getCurrentKeyVersion(String zone) throws IOException {
        KeyProviderCryptoExtension.EncryptedKeyVersion edek;
        assert (this.getProvider() != null);
        assert (!this.hasReadLock());
        String keyName = this.getKeyNameForZone(zone);
        if (keyName == null) {
            throw new IOException(zone + " is not an encryption zone.");
        }
        this.getProvider().drain(keyName);
        try {
            edek = this.getProvider().generateEncryptedKey(keyName);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
        Preconditions.checkNotNull((Object)edek);
        return edek.getEncryptionKeyVersionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getKeyNameForZone(String zone) throws IOException {
        assert (this.getProvider() != null);
        this.readLock();
        try {
            INodesInPath iip = this.getINodesInPath(zone, false);
            this.ezManager.checkEncryptionZoneRoot(iip.getLastINode(), zone);
            String string = this.ezManager.getKeyName(iip);
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setXAttrs(String src, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.writeLock();
        try {
            this.unprotectedSetXAttrs(src, xAttrs, flag);
        }
        finally {
            this.writeUnlock();
        }
    }

    INode unprotectedSetXAttrs(String src, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws QuotaExceededException, IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        List<XAttr> newXAttrs = this.setINodeXAttrs(existingXAttrs, xAttrs, flag);
        boolean isFile = inode.isFile();
        for (XAttr xattr : newXAttrs) {
            String xaName = XAttrHelper.getPrefixName(xattr);
            if ("raw.hdfs.crypto.encryption.zone".equals(xaName)) {
                HdfsProtos.ZoneEncryptionInfoProto ezProto = HdfsProtos.ZoneEncryptionInfoProto.parseFrom(xattr.getValue());
                this.ezManager.addEncryptionZone(inode.getId(), PBHelper.convert(ezProto.getSuite()), PBHelper.convert(ezProto.getCryptoProtocolVersion()), ezProto.getKeyName());
                if (ezProto.hasReencryptionProto()) {
                    HdfsProtos.ReencryptionInfoProto reProto = ezProto.getReencryptionProto();
                    this.ezManager.getReencryptionStatus().updateZoneStatus(inode.getId(), iip.getPath(), reProto);
                }
            }
            if (isFile || !"security.hdfs.unreadable.by.superuser".equals(xaName)) continue;
            throw new IOException("Can only set 'security.hdfs.unreadable.by.superuser' on a file.");
        }
        XAttrStorage.updateINodeXAttrs(inode, newXAttrs, snapshotId);
        return inode;
    }

    List<XAttr> setINodeXAttrs(List<XAttr> existingXAttrs, List<XAttr> toSet, EnumSet<XAttrSetFlag> flag) throws IOException {
        for (int i = 0; i < toSet.size(); ++i) {
            for (int j = i + 1; j < toSet.size(); ++j) {
                if (!toSet.get(i).equalsIgnoreValue(toSet.get(j))) continue;
                throw new IOException("Cannot specify the same XAttr to be set more than once");
            }
        }
        int userVisibleXAttrsNum = 0;
        int newSize = existingXAttrs != null ? existingXAttrs.size() : 0;
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)(newSize += toSet.size()));
        for (XAttr xAttr : toSet) {
            boolean exist = false;
            if (existingXAttrs != null) {
                for (XAttr a : existingXAttrs) {
                    if (!a.equalsIgnoreValue(xAttr)) continue;
                    exist = true;
                    break;
                }
            }
            XAttrSetFlag.validate((String)xAttr.getName(), (boolean)exist, flag);
            xAttrs.add(xAttr);
            if (!this.isUserVisible(xAttr)) continue;
            ++userVisibleXAttrsNum;
        }
        if (existingXAttrs != null) {
            for (XAttr existing : existingXAttrs) {
                boolean alreadySet = false;
                for (XAttr set : toSet) {
                    if (!set.equalsIgnoreValue(existing)) continue;
                    alreadySet = true;
                    break;
                }
                if (alreadySet) continue;
                xAttrs.add(existing);
                if (!this.isUserVisible(existing)) continue;
                ++userVisibleXAttrsNum;
            }
        }
        if (userVisibleXAttrsNum > this.inodeXAttrsLimit) {
            throw new IOException("Cannot add additional XAttr to inode, would exceed limit of " + this.inodeXAttrsLimit);
        }
        return xAttrs;
    }

    private boolean isUserVisible(XAttr xAttr) {
        return xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> getXAttrs(String src) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INodesInPath iip = this.getLastINodeInPath(srcs, true);
            INode inode = FSDirectory.resolveLastINode(src, iip);
            int snapshotId = iip.getPathSnapshotId();
            List<XAttr> list = this.unprotectedGetXAttrs(inode, snapshotId);
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> getXAttrs(INode inode, int snapshotId) throws IOException {
        this.readLock();
        try {
            List<XAttr> list = this.unprotectedGetXAttrs(inode, snapshotId);
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    private List<XAttr> unprotectedGetXAttrs(INode inode, int snapshotId) throws IOException {
        return XAttrStorage.readINodeXAttrs(inode, snapshotId);
    }

    private XAttr unprotectedGetXAttrByName(INode inode, int snapshotId, String xAttrName) throws IOException {
        List<XAttr> xAttrs = XAttrStorage.readINodeXAttrs(inode, snapshotId);
        if (xAttrs == null) {
            return null;
        }
        for (XAttr x : xAttrs) {
            if (!XAttrHelper.getPrefixName(x).equals(xAttrName)) continue;
            return x;
        }
        return null;
    }

    private static INode resolveLastINode(String src, INodesInPath iip) throws FileNotFoundException {
        INode inode = iip.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("cannot find " + src);
        }
        return inode;
    }

    void cacheName(INode inode) {
        if (!inode.isFile()) {
            return;
        }
        ByteArray name = new ByteArray(inode.getLocalNameBytes());
        if ((name = this.nameCache.put(name)) != null) {
            inode.setLocalName(name.getBytes());
        }
    }

    void shutdown() {
        this.nameCache.reset();
        this.inodeMap.clear();
    }

    public static byte[][] getPathComponents(INode inode) {
        ArrayList<byte[]> components = new ArrayList<byte[]>();
        components.add(0, inode.getLocalNameBytes());
        while (inode.getParent() != null) {
            components.add(0, inode.getParent().getLocalNameBytes());
            inode = inode.getParent();
        }
        return (byte[][])components.toArray((T[])new byte[components.size()][]);
    }

    static byte[][] getPathComponentsForReservedPath(String src) {
        return !FSDirectory.isReservedName(src) ? (byte[][])null : INode.getPathComponents(src);
    }

    public static boolean isReservedName(INode inode) {
        return CHECK_RESERVED_FILE_NAMES && Arrays.equals(inode.getLocalNameBytes(), DOT_RESERVED);
    }

    public static boolean isReservedName(String src) {
        return src.startsWith("/.reserved/");
    }

    static boolean isReservedRawName(String src) {
        return src.startsWith("/.reserved/raw");
    }

    static String resolvePath(String src, byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        int nComponents;
        int n = nComponents = pathComponents == null ? 0 : pathComponents.length;
        if (nComponents <= 2) {
            return src;
        }
        if (!Arrays.equals(DOT_RESERVED, pathComponents[1])) {
            return src;
        }
        if (Arrays.equals(DOT_INODES, pathComponents[2])) {
            if (nComponents > 3) {
                return FSDirectory.resolveDotInodesPath(src, pathComponents, fsd);
            }
            return src;
        }
        if (Arrays.equals(RAW, pathComponents[2])) {
            if (nComponents == 3) {
                return "/";
            }
            return FSDirectory.constructRemainingPath("", pathComponents, 3);
        }
        return src;
    }

    private static String resolveDotInodesPath(String src, byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        long id;
        String inodeId = DFSUtil.bytes2String(pathComponents[3]);
        try {
            id = Long.parseLong(inodeId);
        }
        catch (NumberFormatException e) {
            throw new FileNotFoundException("Invalid inode path: " + src);
        }
        if (id == 16385L && pathComponents.length == 4) {
            return "/";
        }
        INode inode = fsd.getInode(id);
        if (inode == null) {
            throw new FileNotFoundException("File for given inode path does not exist: " + src);
        }
        if (pathComponents.length > 4 && DFSUtil.bytes2String(pathComponents[4]).equals("..")) {
            INodeDirectory parent = inode.getParent();
            if (parent == null || ((INode)parent).getId() == 16385L) {
                return "/";
            }
            return parent.getFullPathName();
        }
        String path = "";
        if (id != 16385L) {
            path = inode.getFullPathName();
        }
        return FSDirectory.constructRemainingPath(path, pathComponents, 4);
    }

    private static String constructRemainingPath(String pathPrefix, byte[][] pathComponents, int startAt) {
        StringBuilder path = new StringBuilder(pathPrefix);
        for (int i = startAt; i < pathComponents.length; ++i) {
            path.append("/").append(DFSUtil.bytes2String(pathComponents[i]));
        }
        if (NameNode.LOG.isDebugEnabled()) {
            NameNode.LOG.debug("Resolved path is " + path);
        }
        return path.toString();
    }

    private INodesInPath getLastINodeInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        return INodesInPath.resolve(this.rootDir, INode.getPathComponents(path), 1, resolveLink);
    }

    INodesInPath getINodesInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(path);
        return INodesInPath.resolve(this.rootDir, components, components.length, resolveLink);
    }

    INode getNode(String path, boolean resolveLink) throws UnresolvedLinkException {
        return this.getLastINodeInPath(path, resolveLink).getINode(0);
    }

    private INode getINode4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        return this.getINodesInPath4Write(src, resolveLink).getLastINode();
    }

    INodesInPath getINodesInPath4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        byte[][] components = INode.getPathComponents(src);
        INodesInPath inodesInPath = INodesInPath.resolve(this.rootDir, components, components.length, resolveLink);
        if (inodesInPath.isSnapshot()) {
            throw new SnapshotAccessControlException("Modification on a read-only snapshot is disallowed");
        }
        return inodesInPath;
    }

    FSPermissionChecker getPermissionChecker() throws AccessControlException {
        try {
            return new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup, NameNode.getRemoteUser());
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    void checkOwner(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, true, null, null, null, null);
    }

    void checkPathAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, access, null);
    }

    void checkParentAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, access, null, null);
    }

    void checkAncestorAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, access, null, null, null);
    }

    void checkTraverse(FSPermissionChecker pc, String path) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, false, null, null, null, null);
    }

    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException {
        this.checkPermission(pc, path, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        if (!pc.isSuperUser()) {
            this.readLock();
            try {
                pc.checkPermission(path, this, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir, resolveLink);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    private static class InitQuotaTask
    extends RecursiveAction {
        private final INodeDirectory dir;
        private final Quota.Counts counts;

        public InitQuotaTask(INodeDirectory dir, Quota.Counts counts) {
            this.dir = dir;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void compute() {
            Quota.Counts myCounts = Quota.Counts.newInstance();
            this.dir.computeQuotaUsage4CurrentDirectory(myCounts);
            ReadOnlyList<INode> children = this.dir.getChildrenList(0x7FFFFFFE);
            if (children.size() > 0) {
                ArrayList<InitQuotaTask> subtasks = new ArrayList<InitQuotaTask>();
                for (INode child : children) {
                    if (child.isDirectory()) {
                        subtasks.add(new InitQuotaTask(child.asDirectory(), myCounts));
                        continue;
                    }
                    child.computeQuotaUsage(myCounts, false, 0x7FFFFFFE);
                }
                InitQuotaTask.invokeAll(subtasks);
            }
            if (this.dir.isQuotaSet()) {
                Quota.Counts q = this.dir.getQuotaCounts();
                long nsConsumed = myCounts.get(Quota.NAMESPACE);
                long nsQuota = q.get(Quota.NAMESPACE);
                if (Quota.isViolated(nsQuota, nsConsumed)) {
                    LOG.warn("Namespace quota violation in image for " + this.dir.getFullPathName() + " quota = " + nsQuota + " < consumed = " + nsConsumed);
                }
                long ssConsumed = myCounts.get(Quota.DISKSPACE);
                long ssQuota = q.get(Quota.DISKSPACE);
                if (Quota.isViolated(ssQuota, ssConsumed)) {
                    LOG.warn("Storagespace quota violation in image for " + this.dir.getFullPathName() + " quota = " + ssQuota + " < consumed = " + ssConsumed);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting quota for " + this.dir + "\n" + myCounts);
                }
                this.dir.getDirectoryWithQuotaFeature().setSpaceConsumed(nsConsumed, ssConsumed);
            }
            Quota.Counts counts = this.counts;
            synchronized (counts) {
                this.counts.add(myCounts);
            }
        }
    }

    private class RenameOperation {
        private final INodesInPath srcIIP;
        private final INodesInPath dstIIP;
        private final String src;
        private final String dst;
        private INode srcChild;
        private final INodeReference.WithCount withCount;
        private final int srcRefDstSnapshot;
        private final INodeDirectory srcParent;
        private final byte[] srcChildName;
        private final boolean isSrcInSnapshot;
        private final boolean srcChildIsReference;
        private final Quota.Counts oldSrcCounts;

        private RenameOperation(String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP) throws QuotaExceededException {
            this.srcIIP = srcIIP;
            this.dstIIP = dstIIP;
            this.src = src;
            this.dst = dst;
            this.srcChild = srcIIP.getLastINode();
            this.srcChildName = this.srcChild.getLocalNameBytes();
            this.isSrcInSnapshot = this.srcChild.isInLatestSnapshot(srcIIP.getLatestSnapshotId());
            this.srcChildIsReference = this.srcChild.isReference();
            this.srcParent = srcIIP.getINode(-2).asDirectory();
            if (this.isSrcInSnapshot) {
                this.srcChild.recordModification(srcIIP.getLatestSnapshotId());
            }
            this.srcRefDstSnapshot = this.srcChildIsReference ? this.srcChild.asReference().getDstSnapshotId() : 0x7FFFFFFE;
            this.oldSrcCounts = Quota.Counts.newInstance();
            if (this.isSrcInSnapshot) {
                INodeReference.WithName withName = srcIIP.getINode(-2).asDirectory().replaceChild4ReferenceWithName(this.srcChild, srcIIP.getLatestSnapshotId());
                this.withCount = (INodeReference.WithCount)withName.getReferredINode();
                this.srcChild = withName;
                srcIIP.setLastINode(this.srcChild);
                this.withCount.getReferredINode().computeQuotaUsage(this.oldSrcCounts, true);
            } else {
                this.withCount = this.srcChildIsReference ? (INodeReference.WithCount)this.srcChild.asReference().getReferredINode() : null;
            }
        }

        boolean addSourceToDestination() {
            INode toDst;
            INode dstParent = this.dstIIP.getINode(-2);
            this.srcChild = this.srcIIP.getLastINode();
            byte[] dstChildName = this.dstIIP.getLastLocalName();
            if (this.withCount == null) {
                this.srcChild.setLocalName(dstChildName);
                toDst = this.srcChild;
            } else {
                this.withCount.getReferredINode().setLocalName(dstChildName);
                int dstSnapshotId = this.dstIIP.getLatestSnapshotId();
                toDst = new INodeReference.DstReference(dstParent.asDirectory(), this.withCount, dstSnapshotId);
            }
            return FSDirectory.this.addLastINodeNoQuotaCheck(this.dstIIP, toDst);
        }

        void updateMtimeAndLease(long timestamp) throws QuotaExceededException {
            this.srcParent.updateModificationTime(timestamp, this.srcIIP.getLatestSnapshotId());
            INode dstParent = this.dstIIP.getINode(-2);
            dstParent.updateModificationTime(timestamp, this.dstIIP.getLatestSnapshotId());
        }

        void restoreSource() throws QuotaExceededException {
            INode oldSrcChild = this.srcChild;
            if (this.withCount == null) {
                this.srcChild.setLocalName(this.srcChildName);
            } else if (!this.srcChildIsReference) {
                this.srcChild = this.withCount.getReferredINode();
                this.srcChild.setLocalName(this.srcChildName);
            } else {
                this.withCount.removeReference(oldSrcChild.asReference());
                this.srcChild = new INodeReference.DstReference(this.srcParent, this.withCount, this.srcRefDstSnapshot);
                this.withCount.getReferredINode().setLocalName(this.srcChildName);
            }
            if (this.isSrcInSnapshot) {
                this.srcParent.undoRename4ScrParent(oldSrcChild.asReference(), this.srcChild);
            } else {
                FSDirectory.this.addLastINodeNoQuotaCheck(this.srcIIP, this.srcChild);
            }
        }

        void updateQuotasInSourceTree() throws QuotaExceededException {
            if (this.isSrcInSnapshot) {
                Quota.Counts newSrcCounts = this.srcChild.computeQuotaUsage(Quota.Counts.newInstance(), false);
                newSrcCounts.subtract(this.oldSrcCounts);
                this.srcParent.addSpaceConsumed(newSrcCounts.get(Quota.NAMESPACE), newSrcCounts.get(Quota.DISKSPACE), false);
            }
        }
    }
}

