/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

public class INodeDirectory
extends INodeWithAdditionalFields
implements INodeDirectoryAttributes {
    public static final int DEFAULT_FILES_PER_DIRECTORY = 2;
    static final byte[] ROOT_NAME = DFSUtil.string2Bytes("");
    private List<INode> children = null;
    static final String DUMPTREE_EXCEPT_LAST_ITEM = "+-";
    static final String DUMPTREE_LAST_ITEM = "\\-";

    public static INodeDirectory valueOf(INode inode, Object path) throws FileNotFoundException, PathIsNotDirectoryException {
        if (inode == null) {
            throw new FileNotFoundException("Directory does not exist: " + DFSUtil.path2String(path));
        }
        if (!inode.isDirectory()) {
            throw new PathIsNotDirectoryException(DFSUtil.path2String(path));
        }
        return inode.asDirectory();
    }

    public INodeDirectory(long id, byte[] name, PermissionStatus permissions, long mtime) {
        super(id, name, permissions, mtime, 0L);
    }

    public INodeDirectory(INodeDirectory other, boolean adopt, INode.Feature ... featuresToCopy) {
        super(other);
        this.children = other.children;
        if (adopt && this.children != null) {
            for (INode child : this.children) {
                child.setParent(this);
            }
        }
        this.features = featuresToCopy;
    }

    @Override
    public final boolean isDirectory() {
        return true;
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this;
    }

    @Override
    public byte getLocalStoragePolicyID() {
        XAttrFeature f = this.getXAttrFeature();
        ImmutableList<XAttr> xattrs = f == null ? ImmutableList.of() : f.getXAttrs();
        for (XAttr xattr : xattrs) {
            if (!BlockStoragePolicySuite.isStoragePolicyXAttr(xattr)) continue;
            return xattr.getValue()[0];
        }
        return 0;
    }

    @Override
    public byte getStoragePolicyID() {
        byte id = this.getLocalStoragePolicyID();
        if (id != 0) {
            return id;
        }
        return this.getParent() != null ? this.getParent().getStoragePolicyID() : (byte)0;
    }

    void setQuota(long nsQuota, long dsQuota) {
        DirectoryWithQuotaFeature quota = this.getDirectoryWithQuotaFeature();
        if (quota != null) {
            quota.setQuota(nsQuota, dsQuota);
            if (!this.isQuotaSet() && !this.isRoot()) {
                this.removeFeature(quota);
            }
        } else {
            Quota.Counts c = this.computeQuotaUsage();
            quota = this.addDirectoryWithQuotaFeature(nsQuota, dsQuota);
            quota.setSpaceConsumed(c.get(Quota.NAMESPACE), c.get(Quota.DISKSPACE));
        }
    }

    @Override
    public Quota.Counts getQuotaCounts() {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        return q != null ? q.getQuota() : super.getQuotaCounts();
    }

    @Override
    public void addSpaceConsumed(long nsDelta, long dsDelta, boolean verify) throws QuotaExceededException {
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (q != null) {
            q.addSpaceConsumed(this, nsDelta, dsDelta, verify);
        } else {
            this.addSpaceConsumed2Parent(nsDelta, dsDelta, verify);
        }
    }

    public final DirectoryWithQuotaFeature getDirectoryWithQuotaFeature() {
        return (DirectoryWithQuotaFeature)this.getFeature(DirectoryWithQuotaFeature.class);
    }

    final boolean isWithQuota() {
        return this.getDirectoryWithQuotaFeature() != null;
    }

    DirectoryWithQuotaFeature addDirectoryWithQuotaFeature(long nsQuota, long dsQuota) {
        Preconditions.checkState((!this.isWithQuota() ? 1 : 0) != 0, (Object)"Directory is already with quota");
        DirectoryWithQuotaFeature quota = new DirectoryWithQuotaFeature(nsQuota, dsQuota);
        this.addFeature(quota);
        return quota;
    }

    int searchChildren(byte[] name) {
        return this.children == null ? -1 : Collections.binarySearch(this.children, name);
    }

    public DirectoryWithSnapshotFeature addSnapshotFeature(DirectoryWithSnapshotFeature.DirectoryDiffList diffs) {
        Preconditions.checkState((!this.isWithSnapshot() ? 1 : 0) != 0, (Object)"Directory is already with snapshot");
        DirectoryWithSnapshotFeature sf = new DirectoryWithSnapshotFeature(diffs);
        this.addFeature(sf);
        return sf;
    }

    public final DirectoryWithSnapshotFeature getDirectoryWithSnapshotFeature() {
        return (DirectoryWithSnapshotFeature)this.getFeature(DirectoryWithSnapshotFeature.class);
    }

    public final boolean isWithSnapshot() {
        return this.getDirectoryWithSnapshotFeature() != null;
    }

    public DirectoryWithSnapshotFeature.DirectoryDiffList getDiffs() {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        return sf != null ? sf.getDiffs() : null;
    }

    @Override
    public INodeDirectoryAttributes getSnapshotINode(int snapshotId) {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        return sf == null ? this : (INodeDirectoryAttributes)sf.getDiffs().getSnapshotINode(snapshotId, this);
    }

    @Override
    public String toDetailString() {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        return super.toDetailString() + (sf == null ? "" : ", " + sf.getDiffs());
    }

    public DirectorySnapshottableFeature getDirectorySnapshottableFeature() {
        return (DirectorySnapshottableFeature)this.getFeature(DirectorySnapshottableFeature.class);
    }

    public boolean isSnapshottable() {
        return this.getDirectorySnapshottableFeature() != null;
    }

    public boolean isDescendantOfSnapshotRoot(INodeDirectory snapshotRootDir) {
        Preconditions.checkArgument((boolean)snapshotRootDir.isSnapshottable());
        for (INodeDirectory dir = this; dir != null; dir = dir.getParent()) {
            if (!dir.equals(snapshotRootDir)) continue;
            return true;
        }
        return false;
    }

    public Snapshot getSnapshot(byte[] snapshotName) {
        return this.getDirectorySnapshottableFeature().getSnapshot(snapshotName);
    }

    public void setSnapshotQuota(int snapshotQuota) {
        this.getDirectorySnapshottableFeature().setSnapshotQuota(snapshotQuota);
    }

    public Snapshot addSnapshot(int id, String name, LeaseManager leaseManager, boolean captureOpenFiles) throws SnapshotException, QuotaExceededException {
        return this.getDirectorySnapshottableFeature().addSnapshot(this, id, name, leaseManager, captureOpenFiles);
    }

    public Snapshot removeSnapshot(String snapshotName, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws SnapshotException {
        return this.getDirectorySnapshottableFeature().removeSnapshot(this, snapshotName, collectedBlocks, removedINodes);
    }

    public void renameSnapshot(String path, String oldName, String newName) throws SnapshotException {
        this.getDirectorySnapshottableFeature().renameSnapshot(path, oldName, newName);
    }

    public void addSnapshottableFeature() {
        Preconditions.checkState((!this.isSnapshottable() ? 1 : 0) != 0, (String)"this is already snapshottable, this=%s", (Object[])new Object[]{this});
        DirectoryWithSnapshotFeature s = this.getDirectoryWithSnapshotFeature();
        DirectorySnapshottableFeature snapshottable = new DirectorySnapshottableFeature(s);
        if (s != null) {
            this.removeFeature(s);
        }
        this.addFeature(snapshottable);
    }

    public void removeSnapshottableFeature() {
        DirectorySnapshottableFeature s = this.getDirectorySnapshottableFeature();
        Preconditions.checkState((s != null ? 1 : 0) != 0, (String)"The dir does not have snapshottable feature: this=%s", (Object[])new Object[]{this});
        this.removeFeature(s);
        if (s.getDiffs().asList().size() > 0) {
            DirectoryWithSnapshotFeature sf = new DirectoryWithSnapshotFeature(s.getDiffs());
            this.addFeature(sf);
        }
    }

    public void replaceChild(INode oldChild, INode newChild, INodeMap inodeMap) {
        Preconditions.checkNotNull(this.children);
        int i = this.searchChildren(newChild.getLocalNameBytes());
        Preconditions.checkState((i >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((oldChild == this.children.get(i) || oldChild == this.children.get(i).asReference().getReferredINode().asReference().getReferredINode() ? 1 : 0) != 0);
        oldChild = this.children.get(i);
        if (oldChild.isReference() && newChild.isReference()) {
            INodeReference.WithCount withCount = (INodeReference.WithCount)oldChild.asReference().getReferredINode();
            withCount.removeReference(oldChild.asReference());
        }
        this.children.set(i, newChild);
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (sf != null) {
            sf.getDiffs().replaceChild(Diff.ListType.CREATED, oldChild, newChild);
        }
        if (inodeMap != null) {
            inodeMap.put(newChild);
        }
    }

    INodeReference.WithName replaceChild4ReferenceWithName(INode oldChild, int latestSnapshotId) {
        INodeReference.WithCount withCount;
        Preconditions.checkArgument((latestSnapshotId != 0x7FFFFFFE ? 1 : 0) != 0);
        if (oldChild instanceof INodeReference.WithName) {
            return (INodeReference.WithName)oldChild;
        }
        if (oldChild.isReference()) {
            Preconditions.checkState((boolean)(oldChild instanceof INodeReference.DstReference));
            withCount = (INodeReference.WithCount)oldChild.asReference().getReferredINode();
        } else {
            withCount = new INodeReference.WithCount(null, oldChild);
        }
        INodeReference.WithName ref = new INodeReference.WithName(this, withCount, oldChild.getLocalNameBytes(), latestSnapshotId);
        this.replaceChild(oldChild, ref, null);
        return ref;
    }

    @Override
    public void recordModification(int latestSnapshotId) {
        if (this.isInLatestSnapshot(latestSnapshotId) && !this.shouldRecordInSrcSnapshot(latestSnapshotId)) {
            DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
            if (sf == null) {
                sf = this.addSnapshotFeature(null);
            }
            sf.getDiffs().saveSelf2Snapshot(latestSnapshotId, this, null);
        }
    }

    public INode saveChild2Snapshot(INode child, int latestSnapshotId, INode snapshotCopy) {
        if (latestSnapshotId == 0x7FFFFFFE) {
            return child;
        }
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (sf == null) {
            sf = this.addSnapshotFeature(null);
        }
        return sf.saveChild2Snapshot(this, child, latestSnapshotId, snapshotCopy);
    }

    public INode getChild(byte[] name, int snapshotId) {
        DirectoryWithSnapshotFeature sf;
        if (snapshotId == 0x7FFFFFFE || (sf = this.getDirectoryWithSnapshotFeature()) == null) {
            ReadOnlyList<INode> c = this.getCurrentChildrenList();
            int i = ReadOnlyList.Util.binarySearch(c, name);
            return i < 0 ? null : c.get(i);
        }
        return sf.getChild(this, name, snapshotId);
    }

    public int searchChild(INode inode) {
        INode child = this.getChild(inode.getLocalNameBytes(), 0x7FFFFFFE);
        if (child != inode) {
            DirectoryWithSnapshotFeature.DirectoryDiffList diffs = this.getDiffs();
            if (diffs == null) {
                return -1;
            }
            return diffs.findSnapshotDeleted(inode);
        }
        return 0x7FFFFFFE;
    }

    public ReadOnlyList<INode> getChildrenList(int snapshotId) {
        DirectoryWithSnapshotFeature sf;
        if (snapshotId == 0x7FFFFFFE || (sf = this.getDirectoryWithSnapshotFeature()) == null) {
            return this.getCurrentChildrenList();
        }
        return sf.getChildrenList(this, snapshotId);
    }

    private ReadOnlyList<INode> getCurrentChildrenList() {
        return this.children == null ? ReadOnlyList.Util.emptyList() : ReadOnlyList.Util.asReadOnlyList(this.children);
    }

    static int nextChild(ReadOnlyList<INode> children, byte[] name) {
        if (name.length == 0) {
            return 0;
        }
        int nextPos = ReadOnlyList.Util.binarySearch(children, name) + 1;
        if (nextPos >= 0) {
            return nextPos;
        }
        return -nextPos;
    }

    public boolean removeChild(INode child, int latestSnapshotId) {
        if (this.isInLatestSnapshot(latestSnapshotId)) {
            DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
            if (sf == null) {
                sf = this.addSnapshotFeature(null);
            }
            return sf.removeChild(this, child, latestSnapshotId);
        }
        return this.removeChild(child);
    }

    public boolean removeChild(INode child) {
        int i = this.searchChildren(child.getLocalNameBytes());
        if (i < 0) {
            return false;
        }
        INode removed = this.children.remove(i);
        Preconditions.checkState((removed == child ? 1 : 0) != 0);
        return true;
    }

    public boolean addChild(INode node, boolean setModTime, int latestSnapshotId) throws QuotaExceededException {
        int low = this.searchChildren(node.getLocalNameBytes());
        if (low >= 0) {
            return false;
        }
        if (this.isInLatestSnapshot(latestSnapshotId)) {
            DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
            if (sf == null) {
                sf = this.addSnapshotFeature(null);
            }
            return sf.addChild(this, node, setModTime, latestSnapshotId);
        }
        this.addChild(node, low);
        if (setModTime) {
            this.updateModificationTime(node.getModificationTime(), latestSnapshotId);
        }
        return true;
    }

    public boolean addChild(INode node) {
        int low = this.searchChildren(node.getLocalNameBytes());
        if (low >= 0) {
            return false;
        }
        this.addChild(node, low);
        return true;
    }

    private void addChild(INode node, int insertionPoint) {
        if (this.children == null) {
            this.children = new ArrayList<INode>(2);
        }
        node.setParent(this);
        this.children.add(-insertionPoint - 1, node);
        if (node.getFsimageGroupName() == null) {
            node.setGroup(this.getFsimageGroupName());
        }
    }

    @Override
    public Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (!(sf == null || lastSnapshotId == 0x7FFFFFFE || useCache && this.isQuotaSet())) {
            ReadOnlyList<INode> childrenList = this.getChildrenList(lastSnapshotId);
            for (INode child : childrenList) {
                child.computeQuotaUsage(counts, useCache, lastSnapshotId);
            }
            counts.add(Quota.NAMESPACE, 1L);
            return counts;
        }
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (useCache && q != null && q.isQuotaSet()) {
            return q.addNamespaceDiskspace(counts);
        }
        useCache = q != null && !q.isQuotaSet() ? false : useCache;
        return this.computeDirectoryQuotaUsage(counts, useCache, lastSnapshotId);
    }

    private Quota.Counts computeDirectoryQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        if (this.children != null) {
            for (INode child : this.children) {
                child.computeQuotaUsage(counts, useCache, lastSnapshotId);
            }
        }
        return this.computeQuotaUsage4CurrentDirectory(counts);
    }

    public Quota.Counts computeQuotaUsage4CurrentDirectory(Quota.Counts counts) {
        counts.add(Quota.NAMESPACE, 1L);
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (sf != null) {
            sf.computeQuotaUsage4CurrentDirectory(counts);
        }
        return counts;
    }

    @Override
    public ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
        DirectoryWithQuotaFeature q;
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (sf != null && snapshotId == 0x7FFFFFFE) {
            Content.Counts counts = Content.Counts.newInstance();
            sf.computeContentSummary4Snapshot(counts);
            summary.getCounts().add(counts);
            summary.getSnapshotCounts().add(counts);
        }
        if ((q = this.getDirectoryWithQuotaFeature()) != null && snapshotId == 0x7FFFFFFE) {
            return q.computeContentSummary(this, summary);
        }
        return this.computeDirectoryContentSummary(summary, snapshotId);
    }

    protected ContentSummaryComputationContext computeDirectoryContentSummary(ContentSummaryComputationContext summary, int snapshotId) {
        ReadOnlyList<INode> childrenList = this.getChildrenList(snapshotId);
        for (int i = 0; i < childrenList.size(); ++i) {
            INode child = childrenList.get(i);
            byte[] childName = child.getLocalNameBytes();
            long lastYieldCount = summary.getYieldCount();
            child.computeContentSummary(snapshotId, summary);
            if (lastYieldCount == summary.getYieldCount()) continue;
            if (!this.isRoot() && this.getParent() == null) break;
            childrenList = this.getChildrenList(snapshotId);
            i = INodeDirectory.nextChild(childrenList, childName) - 1;
        }
        summary.getCounts().add(Content.DIRECTORY, 1L);
        summary.yield();
        return summary;
    }

    public void undoRename4ScrParent(INodeReference oldChild, INode newChild) throws QuotaExceededException {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        Preconditions.checkState((sf != null ? 1 : 0) != 0, (Object)"Directory does not have snapshot feature");
        sf.getDiffs().removeChild(Diff.ListType.DELETED, oldChild);
        sf.getDiffs().replaceChild(Diff.ListType.CREATED, oldChild, newChild);
        this.addChild(newChild, true, 0x7FFFFFFE);
    }

    public void undoRename4DstParent(INode deletedChild, int latestSnapshotId) throws QuotaExceededException {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        Preconditions.checkState((sf != null ? 1 : 0) != 0, (Object)"Directory does not have snapshot feature");
        boolean removeDeletedChild = sf.getDiffs().removeChild(Diff.ListType.DELETED, deletedChild);
        int sid = removeDeletedChild ? 0x7FFFFFFE : latestSnapshotId;
        boolean added = this.addChild(deletedChild, true, sid);
        if (added && !removeDeletedChild) {
            Quota.Counts counts = deletedChild.computeQuotaUsage();
            this.addSpaceConsumed(counts.get(Quota.NAMESPACE), counts.get(Quota.DISKSPACE), false);
        }
    }

    public void clearChildren() {
        this.children = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren();
    }

    public Quota.Counts cleanSubtreeRecursively(int snapshot, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles, Map<INode, INode> excludedNodes) {
        Quota.Counts counts = Quota.Counts.newInstance();
        int s = snapshot != 0x7FFFFFFE && prior != -1 ? prior : snapshot;
        for (INode child : this.getChildrenList(s)) {
            if (snapshot != 0x7FFFFFFE && excludedNodes != null && excludedNodes.containsKey(child)) continue;
            Quota.Counts childCounts = child.cleanSubtree(snapshot, prior, collectedBlocks, removedINodes, removedUCFiles);
            counts.add(childCounts);
        }
        return counts;
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles) {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (sf != null) {
            sf.clear(this, collectedBlocks, removedINodes, removedUCFiles);
        }
        for (INode child : this.getChildrenList(0x7FFFFFFE)) {
            child.destroyAndCollectBlocks(collectedBlocks, removedINodes, removedUCFiles);
        }
        this.clear();
        removedINodes.add(this);
    }

    @Override
    public Quota.Counts cleanSubtree(int snapshotId, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles) {
        DirectoryWithSnapshotFeature sf = this.getDirectoryWithSnapshotFeature();
        if (sf != null) {
            return sf.cleanDirectory(this, snapshotId, priorSnapshotId, collectedBlocks, removedINodes, removedUCFiles);
        }
        if (priorSnapshotId == -1 && snapshotId == 0x7FFFFFFE) {
            Quota.Counts counts = Quota.Counts.newInstance();
            this.computeQuotaUsage(counts, true);
            this.destroyAndCollectBlocks(collectedBlocks, removedINodes, removedUCFiles);
            return counts;
        }
        Quota.Counts counts = this.cleanSubtreeRecursively(snapshotId, priorSnapshotId, collectedBlocks, removedINodes, removedUCFiles, null);
        if (this.isQuotaSet()) {
            this.getDirectoryWithQuotaFeature().addSpaceConsumed2Cache(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        }
        return counts;
    }

    @Override
    public boolean metadataEquals(INodeDirectoryAttributes other) {
        return other != null && this.getQuotaCounts().equals(other.getQuotaCounts()) && this.getPermissionLong() == other.getPermissionLong() && (this.getFsimageAclFeature() == other.getFsimageAclFeature() || this.getFsimageAclFeature() != null && other.getFsimageAclFeature() != null && this.getFsimageAclFeature().equals(other.getFsimageAclFeature())) && this.getXAttrFeature() == other.getXAttrFeature();
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, final int snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        out.print(", childrenSize=" + this.getChildrenList(snapshot).size());
        DirectoryWithQuotaFeature q = this.getDirectoryWithQuotaFeature();
        if (q != null) {
            out.print(", " + q);
        }
        if (this instanceof Snapshot.Root) {
            out.print(", snapshotId=" + snapshot);
        }
        out.println();
        if (prefix.length() >= 2) {
            prefix.setLength(prefix.length() - 2);
            prefix.append("  ");
        }
        INodeDirectory.dumpTreeRecursively(out, prefix, new Iterable<SnapshotAndINode>(){
            final Iterator<INode> i;
            {
                this.i = INodeDirectory.this.getChildrenList(snapshot).iterator();
            }

            @Override
            public Iterator<SnapshotAndINode> iterator() {
                return new Iterator<SnapshotAndINode>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public SnapshotAndINode next() {
                        return new SnapshotAndINode(snapshot, i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        DirectorySnapshottableFeature s = this.getDirectorySnapshottableFeature();
        if (s != null) {
            s.dumpTreeRecursively(this, out, prefix, snapshot);
        }
    }

    @VisibleForTesting
    public static void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Iterable<SnapshotAndINode> subs) {
        if (subs != null) {
            Iterator<SnapshotAndINode> i = subs.iterator();
            while (i.hasNext()) {
                SnapshotAndINode pair = i.next();
                prefix.append(i.hasNext() ? DUMPTREE_EXCEPT_LAST_ITEM : DUMPTREE_LAST_ITEM);
                pair.inode.dumpTreeRecursively(out, prefix, pair.snapshotId);
                prefix.setLength(prefix.length() - 2);
            }
        }
    }

    public final int getChildrenNum(int snapshotId) {
        return this.getChildrenList(snapshotId).size();
    }

    public static class SnapshotAndINode {
        public final int snapshotId;
        public final INode inode;

        public SnapshotAndINode(int snapshot, INode inode) {
            this.snapshotId = snapshot;
            this.inode = inode;
        }
    }
}

