/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.cloudera.io.netty.buffer.ByteBuf;
import com.cloudera.io.netty.buffer.Unpooled;
import com.cloudera.io.netty.channel.ChannelFutureListener;
import com.cloudera.io.netty.channel.ChannelHandlerContext;
import com.cloudera.io.netty.channel.SimpleChannelInboundHandler;
import com.cloudera.io.netty.channel.group.ChannelGroup;
import com.cloudera.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.cloudera.io.netty.handler.codec.http.DefaultHttpResponse;
import com.cloudera.io.netty.handler.codec.http.HttpMethod;
import com.cloudera.io.netty.handler.codec.http.HttpRequest;
import com.cloudera.io.netty.handler.codec.http.HttpResponseStatus;
import com.cloudera.io.netty.handler.codec.http.HttpVersion;
import com.cloudera.io.netty.handler.codec.http.QueryStringDecoder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.web.JsonUtil;

class FSImageHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final Log LOG = LogFactory.getLog(FSImageHandler.class);
    private final FSImageLoader image;
    private final ChannelGroup activeChannels;

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.activeChannels.add(ctx.channel());
    }

    FSImageHandler(FSImageLoader image, ChannelGroup activeChannels) throws IOException {
        this.image = image;
        this.activeChannels = activeChannels;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        String content;
        if (request.getMethod() != HttpMethod.GET) {
            DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            resp.headers().set("Connection", (Object)"close");
            ctx.write(resp).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        String op = FSImageHandler.getOp(decoder);
        String path = FSImageHandler.getPath(decoder);
        if ("GETFILESTATUS".equals(op)) {
            content = this.image.getFileStatus(path);
        } else if ("LISTSTATUS".equals(op)) {
            content = this.image.listStatus(path);
        } else if ("GETACLSTATUS".equals(op)) {
            content = this.image.getAclStatus(path);
        } else {
            throw new IllegalArgumentException("Invalid value for webhdfs parameter \"op\"");
        }
        LOG.info((Object)("op=" + op + " target=" + path));
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer(content.getBytes()));
        resp.headers().set("Content-Type", (Object)"application/json");
        resp.headers().set("Content-Length", (Object)resp.content().readableBytes());
        resp.headers().set("Connection", (Object)"close");
        ctx.write(resp).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exception e = cause instanceof Exception ? (Exception)cause : new Exception(cause);
        String output = JsonUtil.toJsonString(e);
        ByteBuf content = Unpooled.wrappedBuffer(output.getBytes());
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, content);
        resp.headers().set("Content-Type", (Object)"application/json");
        if (e instanceof IllegalArgumentException) {
            resp.setStatus(HttpResponseStatus.BAD_REQUEST);
        } else if (e instanceof FileNotFoundException) {
            resp.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        resp.headers().set("Content-Length", (Object)resp.content().readableBytes());
        resp.headers().set("Connection", (Object)"close");
        ctx.write(resp).addListener(ChannelFutureListener.CLOSE);
    }

    private static String getOp(QueryStringDecoder decoder) {
        Map<String, List<String>> parameters = decoder.parameters();
        return parameters.containsKey("op") ? parameters.get("op").get(0).toUpperCase() : null;
    }

    private static String getPath(QueryStringDecoder decoder) throws FileNotFoundException {
        String path = decoder.path();
        if (path.startsWith("/webhdfs/v1/")) {
            return path.substring(11);
        }
        throw new FileNotFoundException("Path: " + path + " should " + "start with \"/webhdfs/v1/\"");
    }
}

