/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.UserGroupInformation;

public class MiniDFSClusterWithNodeGroup
extends MiniDFSCluster {
    private static String[] NODE_GROUPS = null;
    private static final Log LOG = LogFactory.getLog(MiniDFSClusterWithNodeGroup.class);

    public MiniDFSClusterWithNodeGroup(MiniDFSCluster.Builder builder) throws IOException {
        super(builder);
    }

    public static void setNodeGroups(String[] nodeGroups) {
        NODE_GROUPS = nodeGroups;
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, StorageType[][] storageTypes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] nodeGroups, String[] hosts, long[][] storageCapacities, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig) throws IOException {
        int i;
        String[] stringArray;
        assert (storageCapacities == null || simulatedCapacities == null);
        assert (storageTypes == null || storageTypes.length == numDataNodes);
        assert (storageCapacities == null || storageCapacities.length == numDataNodes);
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        if (checkDataNodeHostConfig) {
            conf.setIfUnset("dfs.datanode.hostname", "127.0.0.1");
        } else {
            conf.set("dfs.datanode.hostname", "127.0.0.1");
        }
        conf.set("dfs.datanode.hostname", "127.0.0.1");
        int curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (nodeGroups != null && numDataNodes > nodeGroups.length) {
            throw new IllegalArgumentException("The length of nodeGroups [" + nodeGroups.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            hosts = new String[numDataNodes];
            for (int i2 = curDatanodesNum; i2 < curDatanodesNum + numDataNodes; ++i2) {
                hosts[i2 - curDatanodesNum] = "host" + i2 + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (operation == null || operation != HdfsServerConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        DataNode[] dns = new DataNode[numDataNodes];
        for (i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            DataNode dn;
            HdfsConfiguration dnConf = new HdfsConfiguration(conf);
            this.setupDatanodeAddress((Configuration)dnConf, setupHostsFile, checkDataNodeAddrConfig);
            if (manageDfsDirs) {
                String dirs = this.makeDataNodeDirs(i, storageTypes == null ? null : storageTypes[i]);
                dnConf.set("dfs.datanode.data.dir", dirs);
                conf.set("dfs.datanode.data.dir", dirs);
            }
            if (simulatedCapacities != null) {
                SimulatedFSDataset.setFactory((Configuration)dnConf);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            LOG.info((Object)("Starting DataNode " + i + " with " + "dfs.datanode.data.dir" + ": " + dnConf.get("dfs.datanode.data.dir")));
            if (hosts != null) {
                dnConf.set("dfs.datanode.hostname", hosts[i - curDatanodesNum]);
                LOG.info((Object)("Starting DataNode " + i + " with hostname set to: " + dnConf.get("dfs.datanode.hostname")));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                if (nodeGroups == null) {
                    LOG.info((Object)("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)name, (String)racks[i - curDatanodesNum]);
                } else {
                    LOG.info((Object)("Adding node with hostname : " + name + " to serverGroup " + nodeGroups[i - curDatanodesNum] + " and rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)name, (String)(racks[i - curDatanodesNum] + nodeGroups[i - curDatanodesNum]));
                }
            }
            HdfsConfiguration newconf = new HdfsConfiguration((Configuration)dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            SecureDataNodeStarter.SecureResources secureResources = null;
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    secureResources = SecureDataNodeStarter.getSecureResources((Configuration)dnConf);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if ((dn = DataNode.instantiateDataNode((String[])dnArgs, (Configuration)dnConf, (SecureDataNodeStarter.SecureResources)secureResources)) == null) {
                throw new IOException("Cannot start DataNode in " + dnConf.get("dfs.datanode.data.dir"));
            }
            String ipAddr = dn.getXferAddress().getAddress().getHostAddress();
            if (racks != null) {
                int port = dn.getXferAddress().getPort();
                if (nodeGroups == null) {
                    LOG.info((Object)("Adding node with IP:port : " + ipAddr + ":" + port + " to rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)(ipAddr + ":" + port), (String)racks[i - curDatanodesNum]);
                } else {
                    LOG.info((Object)("Adding node with IP:port : " + ipAddr + ":" + port + " to nodeGroup " + nodeGroups[i - curDatanodesNum] + " and rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)(ipAddr + ":" + port), (String)(racks[i - curDatanodesNum] + nodeGroups[i - curDatanodesNum]));
                }
            }
            dn.runDatanodeDaemon();
            this.dataNodes.add(new MiniDFSCluster.DataNodeProperties(this, dn, (Configuration)newconf, dnArgs, secureResources, dn.getIpcPort()));
            dns[i - curDatanodesNum] = dn;
        }
        curDatanodesNum += numDataNodes;
        this.numDataNodes += numDataNodes;
        this.waitActive();
        if (storageCapacities != null) {
            for (i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
                try (FsDatasetSpi.FsVolumeReferences volumes = dns[i].getFSDataset().getFsVolumeReferences();){
                    assert (volumes.size() == this.storagesPerDatanode);
                    for (int j = 0; j < volumes.size(); ++j) {
                        FsVolumeImpl volume = (FsVolumeImpl)volumes.get(j);
                        volume.setCapacityForTesting(storageCapacities[i][j]);
                    }
                    continue;
                }
            }
        }
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] nodeGroups, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.startDataNodes(conf, numDataNodes, (StorageType[][])null, manageDfsDirs, operation, racks, nodeGroups, hosts, (long[][])null, simulatedCapacities, setupHostsFile, false, false);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities, String[] nodeGroups) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, nodeGroups, null, simulatedCapacities, false);
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, StorageType[][] storageTypes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[][] storageCapacities, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig, Configuration[] dnConfOverlays) throws IOException {
        this.startDataNodes(conf, numDataNodes, storageTypes, manageDfsDirs, operation, racks, NODE_GROUPS, hosts, storageCapacities, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, checkDataNodeHostConfig);
    }
}

