/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.htrace.core.SpanId;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDFSOutputStream {
    static MiniDFSCluster cluster;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @Test
    public void testCloseTwice() throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        AtomicReference ex = (AtomicReference)Whitebox.getInternalState((Object)dos, (String)"lastException");
        Assert.assertEquals(null, ex.get());
        dos.close();
        IOException dummy = new IOException("dummy");
        ex.set(dummy);
        try {
            dos.close();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)e, (Object)dummy);
        }
        Assert.assertEquals(null, ex.get());
        dos.close();
    }

    @Test
    public void testCongestionBackoff() throws IOException {
        DFSClient.Conf dfsClientConf = (DFSClient.Conf)Mockito.mock(DFSClient.Conf.class);
        DFSClient client = (DFSClient)Mockito.mock(DFSClient.class);
        Mockito.when((Object)client.getConf()).thenReturn((Object)dfsClientConf);
        client.clientRunning = true;
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/foo"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        DFSOutputStream.DataStreamer stream = (DFSOutputStream.DataStreamer)Whitebox.getInternalState((Object)dos, (String)"streamer");
        DataOutputStream blockStream = (DataOutputStream)Mockito.mock(DataOutputStream.class);
        ((DataOutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)blockStream)).flush();
        Whitebox.setInternalState((Object)stream, (String)"blockStream", (Object)blockStream);
        Whitebox.setInternalState((Object)stream, (String)"stage", (Object)BlockConstructionStage.PIPELINE_CLOSE);
        LinkedList dataQueue = (LinkedList)Whitebox.getInternalState((Object)dos, (String)"dataQueue");
        ArrayList congestedNodes = (ArrayList)Whitebox.getInternalState((Object)stream, (String)"congestedNodes");
        congestedNodes.add(Mockito.mock(DatanodeInfo.class));
        DFSOutputStream.Packet packet = (DFSOutputStream.Packet)Mockito.mock(DFSOutputStream.Packet.class);
        Mockito.when((Object)packet.getTraceParents()).thenReturn((Object)new SpanId[0]);
        dataQueue.add(packet);
        stream.run();
        Assert.assertTrue((boolean)congestedNodes.isEmpty());
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }
}

