/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.htrace.core.SpanId;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSPacket {
    private static final int checksumSize = 4;
    private static final int maxChunksPerPacket = 4;

    @Test
    public void testAddParentsGetParents() throws Exception {
        DFSOutputStream.Packet p = new DFSOutputStream.Packet(null, 4, 0L, 0L, 4);
        SpanId[] parents = p.getTraceParents();
        Assert.assertEquals((long)0L, (long)parents.length);
        p.addTraceParent(new SpanId(0L, 123L));
        p.addTraceParent(new SpanId(0L, 123L));
        parents = p.getTraceParents();
        Assert.assertEquals((long)1L, (long)parents.length);
        Assert.assertEquals((Object)new SpanId(0L, 123L), (Object)parents[0]);
        parents = p.getTraceParents();
        Assert.assertEquals((long)1L, (long)parents.length);
        Assert.assertEquals((Object)new SpanId(0L, 123L), (Object)parents[0]);
        p.addTraceParent(new SpanId(0L, 1L));
        p.addTraceParent(new SpanId(0L, 456L));
        p.addTraceParent(new SpanId(0L, 789L));
        parents = p.getTraceParents();
        Assert.assertEquals((long)4L, (long)parents.length);
        Assert.assertEquals((Object)new SpanId(0L, 1L), (Object)parents[0]);
        Assert.assertEquals((Object)new SpanId(0L, 123L), (Object)parents[1]);
        Assert.assertEquals((Object)new SpanId(0L, 456L), (Object)parents[2]);
        Assert.assertEquals((Object)new SpanId(0L, 789L), (Object)parents[3]);
    }
}

