/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSTestWrapper;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestWrapper;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UnknownCipherSuiteException;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.EncryptionFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.CryptoAdmin;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TestEncryptionZones {
    protected Configuration conf;
    private FileSystemTestHelper fsHelper;
    protected MiniDFSCluster cluster;
    protected HdfsAdmin dfsAdmin;
    protected DistributedFileSystem fs;
    private File testRootDir;
    protected final String TEST_KEY = "test_key";
    protected FileSystemTestWrapper fsWrapper;
    protected FileContextTestWrapper fcWrapper;
    protected static final EnumSet<CreateEncryptionZoneFlag> NO_TRASH = EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH);

    protected String getKeyProviderURI() {
        return "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri();
    }

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        this.conf.set("dfs.encryption.key.provider.uri", this.getKeyProviderURI());
        this.conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        Logger.getLogger(EncryptionZoneManager.class).setLevel(Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.fsWrapper = new FileSystemTestWrapper((FileSystem)this.fs);
        this.fcWrapper = new FileContextTestWrapper(FileContext.getFileContext((URI)this.cluster.getURI(), (Configuration)this.conf));
        this.dfsAdmin = new HdfsAdmin(this.cluster.getURI(), this.conf);
        this.setProvider();
        DFSTestUtil.createKey("test_key", this.cluster, this.conf);
    }

    protected void setProvider() {
        this.fs.getClient().setKeyProvider((KeyProvider)this.cluster.getNameNode().getNamesystem().getProvider());
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        EncryptionFaultInjector.instance = new EncryptionFaultInjector();
    }

    public void assertNumZones(int numZones) throws IOException {
        RemoteIterator it = this.dfsAdmin.listEncryptionZones();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        Assert.assertEquals((String)"Unexpected number of encryption zones!", (long)numZones, (long)count);
    }

    public void assertZonePresent(String keyName, String path) throws IOException {
        RemoteIterator it = this.dfsAdmin.listEncryptionZones();
        boolean match = false;
        while (it.hasNext()) {
            boolean matchPath;
            EncryptionZone zone = (EncryptionZone)it.next();
            boolean matchKey = keyName == null;
            boolean bl = matchPath = path == null;
            if (keyName != null && zone.getKeyName().equals(keyName)) {
                matchKey = true;
            }
            if (path != null && zone.getPath().equals(path)) {
                matchPath = true;
            }
            if (!matchKey || !matchPath) continue;
            match = true;
            break;
        }
        Assert.assertTrue((String)("Did not find expected encryption zone with keyName " + keyName + " path " + path), (boolean)match);
    }

    @Test(timeout=60000L)
    public void testTrashStickyBit() throws Exception {
        Path zoneParent = new Path("/zones");
        final Path zone1 = new Path(zoneParent, "zone1");
        CryptoAdmin cryptoAdmin = new CryptoAdmin(this.conf);
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        this.fsWrapper.setPermission(zone1, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        String[] cryptoArgv = new String[]{"-createZone", "-keyName", "test_key", "-path", zone1.toUri().getPath()};
        cryptoAdmin.run(cryptoArgv);
        Path ezfile1 = new Path(zone1, "file1");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, ezfile1, 8192L, (short)1, 65261L);
        Configuration clientConf = new Configuration(this.conf);
        clientConf.setLong("fs.trash.interval", 1L);
        final FsShell shell = new FsShell(clientConf);
        String[] argv = new String[]{"-rm", ezfile1.toString()};
        int res = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertEquals((String)"Can't remove a file in EZ as superuser", (long)0L, (long)res);
        Path trashDir = new Path(zone1, ".Trash");
        Assert.assertTrue((boolean)this.fsWrapper.exists(trashDir));
        FileStatus trashFileStatus = this.fsWrapper.getFileStatus(trashDir);
        Assert.assertTrue((boolean)trashFileStatus.getPermission().getStickyBit());
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Path ezfile2 = new Path(zone1, "file2");
                int len = 8192;
                FileSystem fs2 = FileSystem.get((Configuration)TestEncryptionZones.this.cluster.getConfiguration(0));
                DFSTestUtil.createFile(fs2, ezfile2, 8192L, (short)1, 65261L);
                String[] argv = new String[]{"-rm", ezfile2.toString()};
                int res = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)"Can't remove a file in EZ as user:mygroup", (long)0L, (long)res);
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testProvisionTrash() throws Exception {
        Path zoneParent = new Path("/zones");
        Path zone1 = new Path(zoneParent, "zone1");
        CryptoAdmin cryptoAdmin = new CryptoAdmin(this.conf);
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        String[] cryptoArgv = new String[]{"-createZone", "-keyName", "test_key", "-path", zone1.toUri().getPath()};
        cryptoAdmin.run(cryptoArgv);
        Configuration clientConf = new Configuration(this.conf);
        clientConf.setLong("fs.trash.interval", 1L);
        FsShell shell = new FsShell(clientConf);
        Path trashDir = new Path(zone1, ".Trash");
        String[] argv = new String[]{"-rmdir", trashDir.toUri().getPath()};
        int res = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertEquals((String)"Unable to delete trash directory.", (long)0L, (long)res);
        Assert.assertFalse((boolean)this.fsWrapper.exists(trashDir));
        String[] provisionTrashArgv = new String[]{"-provisionTrash", "-path", zone1.toUri().getPath()};
        cryptoAdmin.run(provisionTrashArgv);
        Assert.assertTrue((boolean)this.fsWrapper.exists(trashDir));
        FileStatus trashFileStatus = this.fsWrapper.getFileStatus(trashDir);
        Assert.assertTrue((boolean)trashFileStatus.getPermission().getStickyBit());
    }

    @Test(timeout=60000L)
    public void testBasicOperations() throws Exception {
        int numZones = 0;
        Path zoneParent = new Path("/zones");
        Path zone1 = new Path(zoneParent, "zone1");
        try {
            this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
            Assert.fail((String)"expected /test doesn't exist");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"cannot find", (Throwable)e);
        }
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
        this.assertNumZones(++numZones);
        this.assertZonePresent(null, zone1.toString());
        try {
            this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"is already an encryption zone", (Throwable)e);
        }
        try {
            this.dfsAdmin.createEncryptionZone(zoneParent, "test_key", NO_TRASH);
            Assert.fail((String)"EZ over an EZ");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"encryption zone for a non-empty directory", (Throwable)e);
        }
        Path notEmpty = new Path("/notEmpty");
        Path notEmptyChild = new Path(notEmpty, "child");
        this.fsWrapper.mkdir(notEmptyChild, FsPermission.getDirDefault(), true);
        try {
            this.dfsAdmin.createEncryptionZone(notEmpty, "test_key", NO_TRASH);
            Assert.fail((String)"Created EZ on an non-empty directory with folder");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"create an encryption zone", (Throwable)e);
        }
        this.fsWrapper.delete(notEmptyChild, false);
        this.fsWrapper.createFile(notEmptyChild);
        try {
            this.dfsAdmin.createEncryptionZone(notEmpty, "test_key", NO_TRASH);
            Assert.fail((String)"Created EZ on an non-empty directory with file");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"create an encryption zone", (Throwable)e);
        }
        try {
            this.dfsAdmin.createEncryptionZone(notEmptyChild, "test_key", NO_TRASH);
            Assert.fail((String)"Created EZ on a file");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"create an encryption zone for a file.", (Throwable)e);
        }
        Path zone2 = new Path("/zone2");
        this.fsWrapper.mkdir(zone2, FsPermission.getDirDefault(), false);
        String myKeyName = "mykeyname";
        try {
            this.dfsAdmin.createEncryptionZone(zone2, "mykeyname", NO_TRASH);
            Assert.fail((String)"expected key doesn't exist");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"doesn't exist.", (Throwable)e);
        }
        try {
            this.dfsAdmin.createEncryptionZone(zone2, "", NO_TRASH);
            Assert.fail((String)"created a zone with empty key name");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Must specify a key name when creating", (Throwable)e);
        }
        try {
            this.dfsAdmin.createEncryptionZone(zone2, null, NO_TRASH);
            Assert.fail((String)"created a zone with null key name");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Must specify a key name when creating", (Throwable)e);
        }
        this.assertNumZones(1);
        DFSTestUtil.createKey("mykeyname", this.cluster, this.conf);
        this.dfsAdmin.createEncryptionZone(zone2, "mykeyname", NO_TRASH);
        this.assertNumZones(++numZones);
        this.assertZonePresent("mykeyname", zone2.toString());
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        final Path nonSuper = new Path("/nonSuper");
        this.fsWrapper.mkdir(nonSuper, FsPermission.getDirDefault(), false);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                HdfsAdmin userAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)TestEncryptionZones.this.conf), TestEncryptionZones.this.conf);
                try {
                    userAdmin.createEncryptionZone(nonSuper, "test_key", NO_TRASH);
                    Assert.fail((String)"createEncryptionZone is superuser-only operation");
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Superuser privilege is required", (Throwable)e);
                }
                return null;
            }
        });
        Path deepZone = new Path("/d/e/e/p/zone");
        this.fsWrapper.mkdir(deepZone, FsPermission.getDirDefault(), true);
        this.dfsAdmin.createEncryptionZone(deepZone, "test_key", NO_TRASH);
        this.assertNumZones(++numZones);
        this.assertZonePresent(null, deepZone.toString());
        for (int i = 1; i < 6; ++i) {
            Path zonePath = new Path("/listZone" + i);
            this.fsWrapper.mkdir(zonePath, FsPermission.getDirDefault(), false);
            this.dfsAdmin.createEncryptionZone(zonePath, "test_key", NO_TRASH);
            this.assertNumZones(++numZones);
            this.assertZonePresent(null, zonePath.toString());
        }
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.restartNameNode(true);
        this.assertNumZones(numZones);
        this.assertZonePresent(null, zone1.toString());
        Path nonpersistZone = new Path("/nonpersistZone");
        this.fsWrapper.mkdir(nonpersistZone, FsPermission.getDirDefault(), false);
        this.dfsAdmin.createEncryptionZone(nonpersistZone, "test_key", NO_TRASH);
        this.cluster.restartNameNode(true);
        this.assertNumZones(++numZones);
        this.assertZonePresent(null, nonpersistZone.toString());
    }

    @Test(timeout=60000L)
    public void testBasicOperationsRootDir() throws Exception {
        int numZones = 0;
        Path rootDir = new Path("/");
        Path zone1 = new Path(rootDir, "zone1");
        this.dfsAdmin.createEncryptionZone(rootDir, "test_key", NO_TRASH);
        this.assertNumZones(++numZones);
        this.assertZonePresent(null, rootDir.toString());
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.restartNameNode(true);
        this.assertNumZones(numZones);
        this.assertZonePresent(null, rootDir.toString());
    }

    @Test(timeout=60000L)
    public void testListEncryptionZonesAsNonSuperUser() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        Path testRoot = new Path("/tmp/TestEncryptionZones");
        Path superPath = new Path(testRoot, "superuseronly");
        Path allPath = new Path(testRoot, "accessall");
        this.fsWrapper.mkdir(superPath, new FsPermission(448), true);
        this.dfsAdmin.createEncryptionZone(superPath, "test_key", NO_TRASH);
        this.fsWrapper.mkdir(allPath, new FsPermission(455), true);
        this.dfsAdmin.createEncryptionZone(allPath, "test_key", NO_TRASH);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                HdfsAdmin userAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)TestEncryptionZones.this.conf), TestEncryptionZones.this.conf);
                try {
                    userAdmin.listEncryptionZones();
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Superuser privilege is required", (Throwable)e);
                }
                return null;
            }
        });
    }

    @Test(timeout=60000L)
    public void testGetEZAsNonSuperUser() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        Path testRoot = new Path("/tmp/TestEncryptionZones");
        Path superPath = new Path(testRoot, "superuseronly");
        final Path superPathFile = new Path(superPath, "file1");
        final Path allPath = new Path(testRoot, "accessall");
        final Path allPathFile = new Path(allPath, "file1");
        final Path nonEZDir = new Path(testRoot, "nonEZDir");
        final Path nonEZFile = new Path(nonEZDir, "file1");
        final Path nonexistent = new Path("/nonexistent");
        int len = 8192;
        this.fsWrapper.mkdir(testRoot, new FsPermission(511), true);
        this.fsWrapper.mkdir(superPath, new FsPermission(448), false);
        this.fsWrapper.mkdir(allPath, new FsPermission(511), false);
        this.fsWrapper.mkdir(nonEZDir, new FsPermission(511), false);
        this.dfsAdmin.createEncryptionZone(superPath, "test_key", NO_TRASH);
        this.dfsAdmin.createEncryptionZone(allPath, "test_key", NO_TRASH);
        this.dfsAdmin.allowSnapshot(new Path("/"));
        final Path newSnap = this.fs.createSnapshot(new Path("/"));
        DFSTestUtil.createFile((FileSystem)this.fs, superPathFile, 8192L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, allPathFile, 8192L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, nonEZFile, 8192L, (short)1, 65261L);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                HdfsAdmin userAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)TestEncryptionZones.this.conf), TestEncryptionZones.this.conf);
                try {
                    userAdmin.getEncryptionZoneForPath(null);
                    Assert.fail((String)"should have thrown NPE");
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                Assert.assertEquals((String)"expected ez path", (Object)allPath.toString(), (Object)userAdmin.getEncryptionZoneForPath(allPath).getPath().toString());
                Assert.assertEquals((String)"expected ez path", (Object)allPath.toString(), (Object)userAdmin.getEncryptionZoneForPath(allPathFile).getPath().toString());
                try {
                    userAdmin.getEncryptionZoneForPath(superPathFile);
                    Assert.fail((String)"expected AccessControlException");
                }
                catch (AccessControlException e) {
                    GenericTestUtils.assertExceptionContains((String)"Permission denied:", (Throwable)e);
                }
                Assert.assertNull((String)"expected null for nonexistent path", (Object)userAdmin.getEncryptionZoneForPath(nonexistent));
                Assert.assertNull((String)"expected null for non-ez path", (Object)userAdmin.getEncryptionZoneForPath(nonEZDir));
                Assert.assertNull((String)"expected null for non-ez path", (Object)userAdmin.getEncryptionZoneForPath(nonEZFile));
                String snapshottedAllPath = newSnap.toString() + allPath.toString();
                Assert.assertEquals((String)"expected ez path", (Object)allPath.toString(), (Object)userAdmin.getEncryptionZoneForPath(new Path(snapshottedAllPath)).getPath().toString());
                TestEncryptionZones.this.fs.delete(allPathFile, false);
                Assert.assertEquals((String)"expected ez path", (Object)allPath.toString(), (Object)userAdmin.getEncryptionZoneForPath(new Path(snapshottedAllPath)).getPath().toString());
                TestEncryptionZones.this.fs.delete(allPath, true);
                Assert.assertEquals((String)"expected ez path", (Object)allPath.toString(), (Object)userAdmin.getEncryptionZoneForPath(new Path(snapshottedAllPath)).getPath().toString());
                Assert.assertNull((String)"expected null for deleted file path", (Object)userAdmin.getEncryptionZoneForPath(allPathFile));
                Assert.assertNull((String)"expected null for deleted directory path", (Object)userAdmin.getEncryptionZoneForPath(allPath));
                return null;
            }
        });
    }

    private void doRenameEncryptionZone(FSTestWrapper wrapper) throws Exception {
        Path testRoot = new Path("/tmp/TestEncryptionZones");
        Path pathFoo = new Path(testRoot, "foo");
        Path pathFooBaz = new Path(pathFoo, "baz");
        Path pathFooBazFile = new Path(pathFooBaz, "file");
        Path pathFooBar = new Path(pathFoo, "bar");
        Path pathFooBarFile = new Path(pathFooBar, "file");
        int len = 8192;
        wrapper.mkdir(pathFoo, FsPermission.getDirDefault(), true);
        this.dfsAdmin.createEncryptionZone(pathFoo, "test_key", NO_TRASH);
        wrapper.mkdir(pathFooBaz, FsPermission.getDirDefault(), true);
        DFSTestUtil.createFile((FileSystem)this.fs, pathFooBazFile, 8192L, (short)1, 65261L);
        String contents = DFSTestUtil.readFile((FileSystem)this.fs, pathFooBazFile);
        try {
            wrapper.rename(pathFooBaz, testRoot, new Options.Rename[0]);
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)(pathFooBaz.toString() + " can't be moved from" + " an encryption zone."), (Throwable)e);
        }
        Assert.assertTrue((boolean)this.fs.rename(pathFooBaz, pathFooBar));
        Assert.assertTrue((String)"Rename of dir and file within ez failed", (!wrapper.exists(pathFooBaz) && wrapper.exists(pathFooBar) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Renamed file contents not the same", (Object)contents, (Object)DFSTestUtil.readFile((FileSystem)this.fs, pathFooBarFile));
        Path newFoo = new Path(testRoot, "newfoo");
        Assert.assertTrue((String)"Rename of EZ root", (boolean)this.fs.rename(pathFoo, newFoo));
        Assert.assertTrue((String)"Rename of EZ root failed", (!wrapper.exists(pathFoo) && wrapper.exists(newFoo) ? 1 : 0) != 0);
        try {
            wrapper.rename(newFoo, newFoo, new Options.Rename[0]);
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"are the same", (Throwable)e);
        }
    }

    @Test(timeout=60000L)
    public void testRenameFileSystem() throws Exception {
        this.doRenameEncryptionZone((FSTestWrapper)this.fsWrapper);
    }

    @Test(timeout=60000L)
    public void testRenameFileContext() throws Exception {
        this.doRenameEncryptionZone((FSTestWrapper)this.fcWrapper);
    }

    private FileEncryptionInfo getFileEncryptionInfo(Path path) throws Exception {
        LocatedBlocks blocks = this.fs.getClient().getLocatedBlocks(path.toString(), 0L);
        return blocks.getFileEncryptionInfo();
    }

    @Test(timeout=120000L)
    public void testReadWrite() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        Path baseFile = new Path("/base");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, baseFile, 8192L, (short)1, 65261L);
        Path zone = new Path("/zone");
        this.fs.mkdirs(zone);
        dfsAdmin.createEncryptionZone(zone, "test_key", NO_TRASH);
        Path encFile1 = new Path(zone, "myfile");
        DFSTestUtil.createFile((FileSystem)this.fs, encFile1, 8192L, (short)1, 65261L);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, baseFile, encFile1, 8192);
        this.assertNumZones(1);
        String keyName = ((EncryptionZone)dfsAdmin.listEncryptionZones().next()).getKeyName();
        FileEncryptionInfo feInfo1 = this.getFileEncryptionInfo(encFile1);
        this.cluster.getNamesystem().getProvider().rollNewVersion(keyName);
        boolean rollSucceeded = false;
        for (int i = 0; i <= 600; ++i) {
            KeyProviderCryptoExtension.EncryptedKeyVersion ekv2 = this.cluster.getNamesystem().getProvider().generateEncryptedKey("test_key");
            if (feInfo1.getEzKeyVersionName().equals(ekv2.getEncryptionKeyVersionName())) continue;
            rollSucceeded = true;
            break;
        }
        Assert.assertTrue((String)"rollover did not generate a new key even after queue is drained", (boolean)rollSucceeded);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, baseFile, encFile1, 8192);
        Path encFile2 = new Path(zone, "myfile2");
        DFSTestUtil.createFile((FileSystem)this.fs, encFile2, 8192L, (short)1, 65261L);
        FileEncryptionInfo feInfo2 = this.getFileEncryptionInfo(encFile2);
        Assert.assertFalse((String)"EDEKs should be different", (boolean)Arrays.equals(feInfo1.getEncryptedDataEncryptionKey(), feInfo2.getEncryptedDataEncryptionKey()));
        Assert.assertNotEquals((String)"Key was rolled, versions should be different", (Object)feInfo1.getEzKeyVersionName(), (Object)feInfo2.getEzKeyVersionName());
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, encFile1, encFile2, 8192);
    }

    @Test(timeout=120000L)
    public void testReadWriteUsingWebHdfs() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        WebHdfsFileSystem webHdfsFs = WebHdfsTestUtil.getWebHdfsFileSystem(this.conf, "webhdfs");
        Path zone = new Path("/zone");
        this.fs.mkdirs(zone);
        dfsAdmin.createEncryptionZone(zone, "test_key", NO_TRASH);
        Path unencFile = new Path("/unenc");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)webHdfsFs, unencFile, 8192L, (short)1, 65261L);
        Path encFile1 = new Path(zone, "myfile");
        DFSTestUtil.createFile((FileSystem)webHdfsFs, encFile1, 8192L, (short)1, 65261L);
        DFSTestUtil.verifyFilesEqual((FileSystem)webHdfsFs, unencFile, encFile1, 8192);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, unencFile, encFile1, 8192);
        Path encFile2 = new Path(zone, "myfile2");
        DFSTestUtil.createFile((FileSystem)this.fs, encFile2, 8192L, (short)1, 65261L);
        DFSTestUtil.verifyFilesEqual((FileSystem)webHdfsFs, unencFile, encFile2, 8192);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, unencFile, encFile2, 8192);
        this.appendOneByte((FileSystem)this.fs, unencFile);
        this.appendOneByte((FileSystem)webHdfsFs, encFile1);
        this.appendOneByte((FileSystem)this.fs, encFile2);
        DFSTestUtil.verifyFilesEqual((FileSystem)webHdfsFs, unencFile, encFile1, 8192);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, unencFile, encFile1, 8192);
        DFSTestUtil.verifyFilesEqual((FileSystem)webHdfsFs, unencFile, encFile2, 8192);
        DFSTestUtil.verifyFilesEqual((FileSystem)this.fs, unencFile, encFile2, 8192);
    }

    private void appendOneByte(FileSystem fs, Path p) throws IOException {
        FSDataOutputStream out = fs.append(p);
        out.write(35);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testVersionAndSuiteNegotiation() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        Path zone = new Path("/zone");
        this.fs.mkdirs(zone);
        dfsAdmin.createEncryptionZone(zone, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, new Path(zone, "success1"), 0L, (short)1, 65261L);
        DFSOutputStream.SUPPORTED_CRYPTO_VERSIONS = new CryptoProtocolVersion[0];
        try {
            DFSTestUtil.createFile((FileSystem)this.fs, new Path(zone, "fail"), 0L, (short)1, 65261L);
            Assert.fail((String)"Created a file without specifying a crypto protocol version");
        }
        catch (UnknownCryptoProtocolVersionException e) {
            GenericTestUtils.assertExceptionContains((String)"No crypto protocol versions", (Throwable)e);
        }
        DFSOutputStream.SUPPORTED_CRYPTO_VERSIONS = new CryptoProtocolVersion[]{CryptoProtocolVersion.UNKNOWN, CryptoProtocolVersion.UNKNOWN};
        try {
            DFSTestUtil.createFile((FileSystem)this.fs, new Path(zone, "fail"), 0L, (short)1, 65261L);
            Assert.fail((String)"Created a file without specifying a known crypto protocol version");
        }
        catch (UnknownCryptoProtocolVersionException e) {
            GenericTestUtils.assertExceptionContains((String)"No crypto protocol versions", (Throwable)e);
        }
        DFSOutputStream.SUPPORTED_CRYPTO_VERSIONS = new CryptoProtocolVersion[]{CryptoProtocolVersion.UNKNOWN, CryptoProtocolVersion.UNKNOWN, CryptoProtocolVersion.ENCRYPTION_ZONES};
        DFSTestUtil.createFile((FileSystem)this.fs, new Path(zone, "success2"), 0L, (short)1, 65261L);
        DFSOutputStream.SUPPORTED_CRYPTO_VERSIONS = new CryptoProtocolVersion[]{CryptoProtocolVersion.ENCRYPTION_ZONES, CryptoProtocolVersion.UNKNOWN, CryptoProtocolVersion.UNKNOWN};
        DFSTestUtil.createFile((FileSystem)this.fs, new Path(zone, "success3"), 4096L, (short)1, 65261L);
        this.cluster.getNamesystem().getProvider().flush();
        KeyProvider provider = KeyProviderFactory.get((URI)new URI(this.conf.getTrimmed("dfs.encryption.key.provider.uri")), (Configuration)this.conf);
        List keys = provider.getKeys();
        Assert.assertEquals((String)"Expected NN to have created one key per zone", (long)1L, (long)keys.size());
        ArrayList allVersions = Lists.newArrayList();
        for (String key : keys) {
            List versions = provider.getKeyVersions(key);
            Assert.assertEquals((String)"Should only have one key version per key", (long)1L, (long)versions.size());
            allVersions.addAll(versions);
        }
        for (int i = 2; i <= 3; ++i) {
            FileEncryptionInfo feInfo = this.getFileEncryptionInfo(new Path(zone.toString() + "/success" + i));
            Assert.assertEquals((Object)feInfo.getCipherSuite(), (Object)CipherSuite.AES_CTR_NOPADDING);
        }
        DFSClient old = this.fs.dfs;
        try {
            TestEncryptionZones.testCipherSuiteNegotiation(this.fs, this.conf);
        }
        finally {
            this.fs.dfs = old;
        }
    }

    private static void mockCreate(ClientProtocol mcp, CipherSuite suite, CryptoProtocolVersion version) throws Exception {
        ((ClientProtocol)Mockito.doReturn((Object)new HdfsFileStatus(0L, false, 1, 1024L, 0L, 0L, new FsPermission(777), "owner", "group", new byte[0], new byte[0], 1010L, 0, new FileEncryptionInfo(suite, version, new byte[suite.getAlgorithmBlockSize()], new byte[suite.getAlgorithmBlockSize()], "fakeKey", "fakeVersion"), 0)).when((Object)mcp)).create(Mockito.anyString(), (FsPermission)Matchers.anyObject(), Mockito.anyString(), (EnumSetWritable)Matchers.anyObject(), Matchers.anyBoolean(), Matchers.anyShort(), Matchers.anyLong(), (CryptoProtocolVersion[])Matchers.anyObject());
    }

    private static void testCipherSuiteNegotiation(DistributedFileSystem fs, Configuration conf) throws Exception {
        ClientProtocol mcp = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Configuration noCodecConf = new Configuration(conf);
        CipherSuite suite = CipherSuite.AES_CTR_NOPADDING;
        String confKey = "hadoop.security.crypto.codec.classes" + suite.getConfigSuffix();
        noCodecConf.set(confKey, "");
        fs.dfs = new DFSClient(null, mcp, noCodecConf, null);
        TestEncryptionZones.mockCreate(mcp, suite, CryptoProtocolVersion.ENCRYPTION_ZONES);
        try {
            fs.create(new Path("/mock"));
            Assert.fail((String)"Created with no configured codecs!");
        }
        catch (UnknownCipherSuiteException e) {
            GenericTestUtils.assertExceptionContains((String)"No configuration found for the cipher", (Throwable)e);
        }
        fs.dfs = new DFSClient(null, mcp, conf, null);
        CipherSuite unknown = CipherSuite.UNKNOWN;
        unknown.setUnknownValue(989);
        TestEncryptionZones.mockCreate(mcp, unknown, CryptoProtocolVersion.ENCRYPTION_ZONES);
        try {
            fs.create(new Path("/mock"));
            Assert.fail((String)"Created with unknown cipher!");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"unknown CipherSuite with ID 989", (Throwable)e);
        }
    }

    @Test(timeout=120000L)
    public void testCreateEZWithNoProvider() throws Exception {
        Configuration clusterConf = this.cluster.getConfiguration(0);
        clusterConf.unset("dfs.encryption.key.provider.uri");
        this.cluster.restartNameNode(true);
        this.cluster.waitActive();
        Path zone1 = new Path("/zone1");
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        try {
            this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
            Assert.fail((String)"expected exception");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"since no key provider is available", (Throwable)e);
        }
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        clusterConf.set("dfs.encryption.key.provider.uri", "jceks://file" + jksPath.toUri());
        this.assertNumZones(0);
    }

    @Test(timeout=120000L)
    public void testIsEncryptedMethod() throws Exception {
        this.doTestIsEncryptedMethod(new Path("/"));
        this.doTestIsEncryptedMethod(new Path("/.reserved/raw"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestIsEncryptedMethod(Path prefix) throws Exception {
        try {
            this.dTIEM(prefix);
        }
        finally {
            for (FileStatus s : this.fsWrapper.listStatus(prefix)) {
                this.fsWrapper.delete(s.getPath(), true);
            }
        }
    }

    private void dTIEM(Path prefix) throws Exception {
        FileStatus[] statuses;
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        Path baseFile = new Path(prefix, "base");
        this.fsWrapper.createFile(baseFile);
        FileStatus stat = this.fsWrapper.getFileStatus(baseFile);
        Assert.assertFalse((String)("Expected isEncrypted to return false for " + baseFile), (boolean)stat.isEncrypted());
        Path zone = new Path(prefix, "zone");
        this.fsWrapper.mkdir(zone, FsPermission.getDirDefault(), true);
        dfsAdmin.createEncryptionZone(zone, "test_key", NO_TRASH);
        Path encFile = new Path(zone, "encfile");
        this.fsWrapper.createFile(encFile);
        stat = this.fsWrapper.getFileStatus(encFile);
        Assert.assertTrue((String)("Expected isEncrypted to return true for enc file" + encFile), (boolean)stat.isEncrypted());
        stat = this.fsWrapper.getFileStatus(zone);
        Assert.assertTrue((String)"Expected isEncrypted to return true for ezroot", (boolean)stat.isEncrypted());
        Path zoneSubdir = new Path(zone, "subdir");
        this.fsWrapper.mkdir(zoneSubdir, FsPermission.getDirDefault(), true);
        stat = this.fsWrapper.getFileStatus(zoneSubdir);
        Assert.assertTrue((String)("Expected isEncrypted to return true for ez subdir " + zoneSubdir), (boolean)stat.isEncrypted());
        Path nonEzDirPath = new Path(prefix, "nonzone");
        this.fsWrapper.mkdir(nonEzDirPath, FsPermission.getDirDefault(), true);
        stat = this.fsWrapper.getFileStatus(nonEzDirPath);
        Assert.assertFalse((String)("Expected isEncrypted to return false for directory " + nonEzDirPath), (boolean)stat.isEncrypted());
        for (FileStatus s : statuses = this.fsWrapper.listStatus(zone)) {
            Assert.assertTrue((String)("Expected isEncrypted to return true for ez stat " + zone), (boolean)s.isEncrypted());
        }
        for (FileStatus s : statuses = this.fsWrapper.listStatus(encFile)) {
            Assert.assertTrue((String)("Expected isEncrypted to return true for ez file stat " + encFile), (boolean)s.isEncrypted());
        }
        for (FileStatus s : statuses = this.fsWrapper.listStatus(nonEzDirPath)) {
            Assert.assertFalse((String)("Expected isEncrypted to return false for nonez stat " + nonEzDirPath), (boolean)s.isEncrypted());
        }
        for (FileStatus s : statuses = this.fsWrapper.listStatus(baseFile)) {
            Assert.assertFalse((String)("Expected isEncrypted to return false for non ez stat " + baseFile), (boolean)s.isEncrypted());
        }
    }

    @Test(timeout=120000L)
    public void testStartFileRetry() throws Exception {
        Path zone1 = new Path("/zone1");
        Path file = new Path(zone1, "file1");
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new InjectFaultTask(){

            @Override
            public void doFault() throws Exception {
                TestEncryptionZones.this.dfsAdmin.createEncryptionZone(this.zone1, "test_key", NO_TRASH);
            }

            @Override
            public void doCleanup() throws Exception {
                Assert.assertEquals((String)"Expected a startFile retry", (long)2L, (long)this.injector.generateCount);
                TestEncryptionZones.this.fsWrapper.delete(this.file, false);
            }
        }).get();
        executor.submit(new InjectFaultTask(){

            @Override
            public void doFault() throws Exception {
                TestEncryptionZones.this.fsWrapper.delete(this.zone1, true);
            }

            @Override
            public void doCleanup() throws Exception {
                Assert.assertEquals((String)"Expected no startFile retries", (long)1L, (long)this.injector.generateCount);
                TestEncryptionZones.this.fsWrapper.delete(this.file, false);
            }
        }).get();
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        String otherKey = "other_key";
        DFSTestUtil.createKey("other_key", this.cluster, this.conf);
        this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
        executor.submit(new InjectFaultTask(){

            @Override
            public void doFault() throws Exception {
                TestEncryptionZones.this.fsWrapper.delete(this.zone1, true);
                TestEncryptionZones.this.fsWrapper.mkdir(this.zone1, FsPermission.getDirDefault(), true);
                TestEncryptionZones.this.dfsAdmin.createEncryptionZone(this.zone1, "other_key", NO_TRASH);
            }

            @Override
            public void doCleanup() throws Exception {
                Assert.assertEquals((String)"Expected a startFile retry", (long)2L, (long)this.injector.generateCount);
                TestEncryptionZones.this.fsWrapper.delete(this.zone1, true);
            }
        }).get();
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        String anotherKey = "another_key";
        DFSTestUtil.createKey("another_key", this.cluster, this.conf);
        this.dfsAdmin.createEncryptionZone(zone1, "another_key", NO_TRASH);
        String keyToUse = "other_key";
        MyInjector injector = new MyInjector();
        EncryptionFaultInjector.instance = injector;
        Future<Void> future = executor.submit(new CreateFileTask(this.fsWrapper, file));
        for (int i = 0; i < 11; ++i) {
            injector.ready.await();
            this.fsWrapper.delete(zone1, true);
            this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
            this.dfsAdmin.createEncryptionZone(zone1, keyToUse, NO_TRASH);
            keyToUse = keyToUse == "other_key" ? "another_key" : "other_key";
            injector.wait.countDown();
            injector = new MyInjector();
            EncryptionFaultInjector.instance = injector;
        }
        try {
            future.get();
            Assert.fail((String)"Expected exception from too many retries");
        }
        catch (ExecutionException e) {
            GenericTestUtils.assertExceptionContains((String)"Too many retries because of encryption zone operations", (Throwable)e.getCause());
        }
    }

    @Test(timeout=120000L)
    public void testDelegationToken() throws Exception {
        UserGroupInformation.createRemoteUser((String)"JobTracker");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        KeyProvider keyProvider = (KeyProvider)Mockito.mock(KeyProvider.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{KeyProviderDelegationTokenExtension.DelegationTokenExtension.class, KeyProviderCryptoExtension.CryptoExtension.class}));
        Mockito.when((Object)keyProvider.getConf()).thenReturn((Object)this.conf);
        byte[] testIdentifier = "Test identifier for delegation token".getBytes();
        Token testToken = new Token(testIdentifier, new byte[0], new Text(), new Text());
        Mockito.when((Object)((KeyProviderDelegationTokenExtension.DelegationTokenExtension)keyProvider).addDelegationTokens(Mockito.anyString(), (Credentials)Mockito.any())).thenReturn((Object)new Token[]{testToken});
        dfs.getClient().setKeyProvider(keyProvider);
        Credentials creds = new Credentials();
        Token[] tokens = dfs.addDelegationTokens("JobTracker", creds);
        DistributedFileSystem.LOG.debug((Object)("Delegation tokens: " + Arrays.asList(tokens)));
        Assert.assertEquals((long)2L, (long)tokens.length);
        Assert.assertEquals((Object)tokens[1], (Object)testToken);
        Assert.assertEquals((long)1L, (long)creds.numberOfTokens());
    }

    @Test(timeout=60000L)
    public void testFsckOnEncryptionZones() throws Exception {
        int len = 8196;
        Path zoneParent = new Path("/zones");
        Path zone1 = new Path(zoneParent, "zone1");
        Path zone1File = new Path(zone1, "file");
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, zone1File, 8196L, (short)1, 65261L);
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        int errCode = ToolRunner.run((Tool)new DFSck(this.conf, out), (String[])new String[]{"/"});
        Assert.assertEquals((String)"Fsck ran with non-zero error code", (long)0L, (long)errCode);
        String result = bStream.toString();
        Assert.assertTrue((String)"Fsck did not return HEALTHY status", (boolean)result.contains("is HEALTHY"));
        errCode = ToolRunner.run((Tool)new DFSck(this.conf, out), (String[])new String[]{zoneParent.toString()});
        Assert.assertEquals((String)"Fsck ran with non-zero error code", (long)0L, (long)errCode);
        result = bStream.toString();
        Assert.assertTrue((String)"Fsck did not return HEALTHY status", (boolean)result.contains("is HEALTHY"));
    }

    @Test(timeout=60000L)
    public void testSnapshotsOnEncryptionZones() throws Exception {
        String TEST_KEY2 = "testkey2";
        DFSTestUtil.createKey("testkey2", this.cluster, this.conf);
        int len = 8196;
        Path zoneParent = new Path("/zones");
        Path zone = new Path(zoneParent, "zone");
        Path zoneFile = new Path(zone, "zoneFile");
        this.fsWrapper.mkdir(zone, FsPermission.getDirDefault(), true);
        this.dfsAdmin.allowSnapshot(zoneParent);
        this.dfsAdmin.createEncryptionZone(zone, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, zoneFile, 8196L, (short)1, 65261L);
        String contents = DFSTestUtil.readFile((FileSystem)this.fs, zoneFile);
        Path snap1 = this.fs.createSnapshot(zoneParent, "snap1");
        Path snap1Zone = new Path(snap1, zone.getName());
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)this.dfsAdmin.getEncryptionZoneForPath(snap1Zone).getPath().toString());
        this.fsWrapper.delete(zone, true);
        this.fsWrapper.mkdir(zone, FsPermission.getDirDefault(), true);
        Path snap2 = this.fs.createSnapshot(zoneParent, "snap2");
        Path snap2Zone = new Path(snap2, zone.getName());
        Assert.assertNull((String)"Expected null ez path", (Object)this.dfsAdmin.getEncryptionZoneForPath(snap2Zone));
        this.dfsAdmin.createEncryptionZone(zone, "testkey2", NO_TRASH);
        Path snap3 = this.fs.createSnapshot(zoneParent, "snap3");
        Path snap3Zone = new Path(snap3, zone.getName());
        EncryptionZone ezSnap3 = this.dfsAdmin.getEncryptionZoneForPath(snap3Zone);
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)ezSnap3.getPath().toString());
        Assert.assertEquals((String)"Unexpected ez key", (Object)"testkey2", (Object)ezSnap3.getKeyName());
        EncryptionZone ezSnap1 = this.dfsAdmin.getEncryptionZoneForPath(snap1Zone);
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)ezSnap1.getPath().toString());
        Assert.assertEquals((String)"Unexpected ez key", (Object)"test_key", (Object)ezSnap1.getKeyName());
        ArrayList listZones = Lists.newArrayList();
        RemoteIterator it = this.dfsAdmin.listEncryptionZones();
        while (it.hasNext()) {
            listZones.add(it.next());
        }
        for (EncryptionZone z : listZones) {
            System.out.println(z);
        }
        Assert.assertEquals((String)"Did not expect additional encryption zones!", (long)1L, (long)listZones.size());
        EncryptionZone listZone = (EncryptionZone)listZones.get(0);
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)listZone.getPath().toString());
        Assert.assertEquals((String)"Unexpected ez key", (Object)"testkey2", (Object)listZone.getKeyName());
        Path snapshottedZoneFile = new Path(snap1.toString() + "/" + zone.getName() + "/" + zoneFile.getName());
        Assert.assertEquals((String)"Contents of snapshotted file have changed unexpectedly", (Object)contents, (Object)DFSTestUtil.readFile((FileSystem)this.fs, snapshottedZoneFile));
        this.fs.deleteSnapshot(zoneParent, snap2.getName());
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)this.dfsAdmin.getEncryptionZoneForPath(snap1Zone).getPath().toString());
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)this.dfsAdmin.getEncryptionZoneForPath(snap3Zone).getPath().toString());
        this.fs.deleteSnapshot(zoneParent, snap1.getName());
        Assert.assertEquals((String)"Got unexpected ez path", (Object)zone.toString(), (Object)this.dfsAdmin.getEncryptionZoneForPath(snap3Zone).getPath().toString());
    }

    @Test(timeout=60000L)
    public void testEncryptionZonesWithSymlinks() throws Exception {
        int len = 8192;
        Path parent = new Path("/parent");
        Path linkParent = new Path(parent, "symdir1");
        Path targetParent = new Path(parent, "symdir2");
        Path link = new Path(linkParent, "link");
        Path target = new Path(targetParent, "target");
        this.fs.mkdirs(parent);
        this.dfsAdmin.createEncryptionZone(parent, "test_key", NO_TRASH);
        this.fs.mkdirs(linkParent);
        this.fs.mkdirs(targetParent);
        DFSTestUtil.createFile((FileSystem)this.fs, target, 8192L, (short)1, 65261L);
        String content = DFSTestUtil.readFile((FileSystem)this.fs, target);
        this.fs.createSymlink(target, link, false);
        Assert.assertEquals((String)"Contents read from link are not the same as target", (Object)content, (Object)DFSTestUtil.readFile((FileSystem)this.fs, link));
        this.fs.delete(parent, true);
        this.fs.mkdirs(linkParent);
        this.fs.mkdirs(targetParent);
        this.dfsAdmin.createEncryptionZone(linkParent, "test_key", NO_TRASH);
        this.dfsAdmin.createEncryptionZone(targetParent, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, target, 8192L, (short)1, 65261L);
        content = DFSTestUtil.readFile((FileSystem)this.fs, target);
        this.fs.createSymlink(target, link, false);
        Assert.assertEquals((String)"Contents read from link are not the same as target", (Object)content, (Object)DFSTestUtil.readFile((FileSystem)this.fs, link));
        this.fs.delete(link, true);
        this.fs.delete(target, true);
    }

    @Test(timeout=60000L)
    public void testConcatFailsInEncryptionZones() throws Exception {
        int len = 8192;
        Path ez = new Path("/ez");
        this.fs.mkdirs(ez);
        this.dfsAdmin.createEncryptionZone(ez, "test_key", NO_TRASH);
        Path src1 = new Path(ez, "src1");
        Path src2 = new Path(ez, "src2");
        Path target = new Path(ez, "target");
        DFSTestUtil.createFile((FileSystem)this.fs, src1, 8192L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, src2, 8192L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, target, 8192L, (short)1, 65261L);
        try {
            this.fs.concat(target, new Path[]{src1, src2});
            Assert.fail((String)"expected concat to throw en exception for files in an ez");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"concat can not be called for files in an encryption zone", (Throwable)e);
        }
        this.fs.delete(ez, true);
    }

    @Test(timeout=60000L)
    public void testOfflineImageViewerOnEncryptionZones() throws Exception {
        int len = 8196;
        Path zoneParent = new Path("/zones");
        Path zone1 = new Path(zoneParent, "zone1");
        Path zone1File = new Path(zone1, "file");
        this.fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
        this.dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, zone1File, 8196L, (short)1, 65261L);
        this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        this.fs.saveNamespace();
        File originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(this.cluster.getNameNode()).getStorage().getStorageDir(0));
        if (originalFsimage == null) {
            throw new RuntimeException("Didn't generate or can't find fsimage");
        }
        StringWriter output = new StringWriter();
        PrintWriter pw = new PrintWriter(output);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), pw);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        String xml = output.getBuffer().toString();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(new InputSource(new StringReader(xml)), new DefaultHandler());
    }

    @Test(timeout=60000L)
    public void testEncryptionZonesOnRootPath() throws Exception {
        int len = 8196;
        Path rootDir = new Path("/");
        Path zoneFile = new Path(rootDir, "file");
        Path rawFile = new Path("/.reserved/raw/file");
        this.dfsAdmin.createEncryptionZone(rootDir, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, zoneFile, 8196L, (short)1, 65261L);
        Assert.assertEquals((String)"File can be created on the root encryption zone with correct length", (long)8196L, (long)this.fs.getFileStatus(zoneFile).getLen());
        Assert.assertEquals((String)"Root dir is encrypted", (Object)true, (Object)this.fs.getFileStatus(rootDir).isEncrypted());
        Assert.assertEquals((String)"File is encrypted", (Object)true, (Object)this.fs.getFileStatus(zoneFile).isEncrypted());
        DFSTestUtil.verifyFilesNotEqual((FileSystem)this.fs, zoneFile, rawFile, 8196);
    }

    @Test(timeout=60000L)
    public void testEncryptionZonesOnRelativePath() throws Exception {
        int len = 8196;
        Path baseDir = new Path("/somewhere/base");
        Path zoneDir = new Path("zone");
        Path zoneFile = new Path("file");
        this.fs.setWorkingDirectory(baseDir);
        this.fs.mkdirs(zoneDir);
        this.dfsAdmin.createEncryptionZone(zoneDir, "test_key", NO_TRASH);
        DFSTestUtil.createFile((FileSystem)this.fs, zoneFile, 8196L, (short)1, 65261L);
        this.assertNumZones(1);
        this.assertZonePresent("test_key", "/somewhere/base/zone");
        Assert.assertEquals((String)"Got unexpected ez path", (Object)"/somewhere/base/zone", (Object)this.dfsAdmin.getEncryptionZoneForPath(zoneDir).getPath().toString());
    }

    @Test(timeout=120000L)
    public void testEncryptionZoneWithTrash() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        Path zone1 = new Path("/zone1");
        this.fs.mkdirs(zone1);
        dfsAdmin.createEncryptionZone(zone1, "test_key", NO_TRASH);
        Path encFile1 = new Path(zone1, "encFile1");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, encFile1, 8192L, (short)1, 65261L);
        Configuration clientConf = new Configuration(this.conf);
        clientConf.setLong("fs.trash.interval", 1L);
        FsShell shell = new FsShell(clientConf);
        this.verifyShellDeleteWithTrash(shell, encFile1);
        this.verifyShellDeleteWithTrash(shell, zone1);
        Path topEZ = new Path("/topEZ");
        this.fs.mkdirs(topEZ);
        dfsAdmin.createEncryptionZone(topEZ, "test_key", NO_TRASH);
        String NESTED_EZ_TEST_KEY = "nested_ez_test_key";
        DFSTestUtil.createKey("nested_ez_test_key", this.cluster, this.conf);
        Path nestedEZ = new Path(topEZ, "nestedEZ");
        this.fs.mkdirs(nestedEZ);
        dfsAdmin.createEncryptionZone(nestedEZ, "nested_ez_test_key", NO_TRASH);
        Path topEZFile = new Path(topEZ, "file");
        Path nestedEZFile = new Path(nestedEZ, "file");
        DFSTestUtil.createFile((FileSystem)this.fs, topEZFile, 8192L, (short)1, 65261L);
        DFSTestUtil.createFile((FileSystem)this.fs, nestedEZFile, 8192L, (short)1, 65261L);
        this.verifyShellDeleteWithTrash(shell, topEZFile);
        this.verifyShellDeleteWithTrash(shell, nestedEZFile);
        this.verifyShellDeleteWithTrash(shell, nestedEZ);
        this.verifyShellDeleteWithTrash(shell, topEZ);
    }

    @Test(timeout=120000L)
    public void testRootDirEZTrash() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        dfsAdmin.createEncryptionZone(new Path("/"), "test_key", NO_TRASH);
        Path encFile = new Path("/encFile");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, encFile, 8192L, (short)1, 65261L);
        Configuration clientConf = new Configuration(this.conf);
        clientConf.setLong("fs.trash.interval", 1L);
        FsShell shell = new FsShell(clientConf);
        this.verifyShellDeleteWithTrash(shell, encFile);
    }

    @Test(timeout=120000L)
    public void testGetTrashRoots() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        Path ezRoot1 = new Path("/ez1");
        this.fs.mkdirs(ezRoot1);
        dfsAdmin.createEncryptionZone(ezRoot1, "test_key", NO_TRASH);
        Path ezRoot2 = new Path("/ez2");
        this.fs.mkdirs(ezRoot2);
        dfsAdmin.createEncryptionZone(ezRoot2, "test_key", NO_TRASH);
        Path ezRoot3 = new Path("/ez3");
        this.fs.mkdirs(ezRoot3);
        dfsAdmin.createEncryptionZone(ezRoot3, "test_key", NO_TRASH);
        Collection trashRootsBegin = this.fs.getTrashRoots(true);
        Assert.assertEquals((String)"Unexpected getTrashRoots result", (long)0L, (long)trashRootsBegin.size());
        Path encFile = new Path(ezRoot2, "encFile");
        int len = 8192;
        DFSTestUtil.createFile((FileSystem)this.fs, encFile, 8192L, (short)1, 65261L);
        Configuration clientConf = new Configuration(this.conf);
        clientConf.setLong("fs.trash.interval", 1L);
        FsShell shell = new FsShell(clientConf);
        this.verifyShellDeleteWithTrash(shell, encFile);
        Collection trashRootsDelete1 = this.fs.getTrashRoots(true);
        Assert.assertEquals((String)"Unexpected getTrashRoots result", (long)1L, (long)trashRootsDelete1.size());
        Path nonEncFile = new Path("/nonEncFile");
        DFSTestUtil.createFile((FileSystem)this.fs, nonEncFile, 8192L, (short)1, 65261L);
        this.verifyShellDeleteWithTrash(shell, nonEncFile);
        Collection trashRootsDelete2 = this.fs.getTrashRoots(true);
        Assert.assertEquals((String)"Unexpected getTrashRoots result", (long)2L, (long)trashRootsDelete2.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyShellDeleteWithTrash(FsShell shell, Path path) throws Exception {
        try {
            Path trashDir;
            Path checkTrash = trashDir = shell.getCurrentTrashDir(path);
            while (!checkTrash.isRoot() && !checkTrash.getName().equals(".Trash")) {
                checkTrash = checkTrash.getParent();
            }
            Assert.assertEquals((String)("No .Trash component found in trash dir " + trashDir), (Object)".Trash", (Object)checkTrash.getName());
            Path trashFile = new Path(shell.getCurrentTrashDir(path) + "/" + path);
            String[] argv = new String[]{"-rm", "-r", path.toString()};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"rm failed", (long)0L, (long)res);
            Assert.assertTrue((String)("File not in trash : " + trashFile), (boolean)this.fs.exists(trashFile));
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        finally {
            if (this.fs.exists(path)) {
                this.fs.delete(path, true);
            }
        }
    }

    private class InjectFaultTask
    implements Callable<Void> {
        final Path zone1 = new Path("/zone1");
        final Path file = new Path(this.zone1, "file1");
        final ExecutorService executor = Executors.newSingleThreadExecutor();
        MyInjector injector;

        private InjectFaultTask() {
        }

        @Override
        public Void call() throws Exception {
            this.injector = new MyInjector();
            EncryptionFaultInjector.instance = this.injector;
            Future<Void> future = this.executor.submit(new CreateFileTask(TestEncryptionZones.this.fsWrapper, this.file));
            this.injector.ready.await();
            this.doFault();
            this.injector.wait.countDown();
            future.get();
            this.doCleanup();
            return null;
        }

        public void doFault() throws Exception {
        }

        public void doCleanup() throws Exception {
        }
    }

    private class CreateFileTask
    implements Callable<Void> {
        private FileSystemTestWrapper fsWrapper;
        private Path name;

        CreateFileTask(FileSystemTestWrapper fsWrapper, Path name) {
            this.fsWrapper = fsWrapper;
            this.name = name;
        }

        @Override
        public Void call() throws Exception {
            this.fsWrapper.createFile(this.name);
            return null;
        }
    }

    private class MyInjector
    extends EncryptionFaultInjector {
        int generateCount;
        CountDownLatch ready = new CountDownLatch(1);
        CountDownLatch wait = new CountDownLatch(1);

        public void startFileAfterGenerateKey() throws IOException {
            this.ready.countDown();
            try {
                this.wait.await();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            ++this.generateCount;
        }
    }
}

