/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestGetBlocks {
    private static final int blockSize = 8192;
    private static final String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
    private static final int numDatanodes = racks.length;

    private DataNode stopDataNodeHeartbeat(MiniDFSCluster cluster, String hostName) {
        for (DataNode dn : cluster.getDataNodes()) {
            if (!dn.getDatanodeId().getHostName().equals(hostName)) continue;
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
            return dn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadSelectNonStaleDatanode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        long staleInterval = 1800000L;
        conf.setLong("dfs.namenode.stale.datanode.interval", staleInterval);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDatanodes).racks(racks).build();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        List nodeInfoList = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanodeListForReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Unexpected number of datanodes", (long)numDatanodes, (long)nodeInfoList.size());
        DistributedFileSystem fileSys = cluster.getFileSystem();
        FSDataOutputStream stm = null;
        try {
            Path fileName = new Path("/file1");
            stm = fileSys.create(fileName, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
            stm.write(new byte[12288]);
            stm.hflush();
            LocatedBlocks blocks = client.getNamenode().getBlockLocations(fileName.toString(), 0L, 8192L);
            DatanodeInfo[] nodes = blocks.get(0).getLocations();
            Assert.assertEquals((long)nodes.length, (long)3L);
            DataNode staleNode = null;
            DatanodeDescriptor staleNodeInfo = null;
            staleNode = this.stopDataNodeHeartbeat(cluster, nodes[0].getHostName());
            Assert.assertNotNull((Object)staleNode);
            staleNodeInfo = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(staleNode.getDatanodeId());
            staleNodeInfo.setLastUpdate(Time.now() - staleInterval - 1L);
            LocatedBlocks blocksAfterStale = client.getNamenode().getBlockLocations(fileName.toString(), 0L, 8192L);
            DatanodeInfo[] nodesAfterStale = blocksAfterStale.get(0).getLocations();
            Assert.assertEquals((long)nodesAfterStale.length, (long)3L);
            Assert.assertEquals((Object)nodesAfterStale[2].getHostName(), (Object)nodes[0].getHostName());
            DataNodeTestUtils.setHeartbeatsDisabledForTests(staleNode, false);
            staleNodeInfo.setLastUpdate(Time.now());
            LocatedBlock lastBlock = client.getLocatedBlocks(fileName.toString(), 0L, Long.MAX_VALUE).getLastLocatedBlock();
            nodes = lastBlock.getLocations();
            Assert.assertEquals((long)nodes.length, (long)3L);
            staleNode = this.stopDataNodeHeartbeat(cluster, nodes[0].getHostName());
            Assert.assertNotNull((Object)staleNode);
            cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(staleNode.getDatanodeId()).setLastUpdate(Time.now() - staleInterval - 1L);
            LocatedBlock lastBlockAfterStale = client.getLocatedBlocks(fileName.toString(), 0L, Long.MAX_VALUE).getLastLocatedBlock();
            nodesAfterStale = lastBlockAfterStale.getLocations();
            Assert.assertEquals((long)nodesAfterStale.length, (long)3L);
            Assert.assertEquals((Object)nodesAfterStale[2].getHostName(), (Object)nodes[0].getHostName());
        }
        finally {
            if (stm != null) {
                stm.close();
            }
            client.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBlocks() throws Exception {
        HdfsConfiguration CONF = new HdfsConfiguration();
        int REPLICATION_FACTOR = 2;
        int DEFAULT_BLOCK_SIZE = 1024;
        Random r = new Random();
        CONF.setLong("dfs.blocksize", 1024L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).build();
        try {
            boolean notWritten;
            long fileLen;
            int bytesToWriteNext;
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(new Path("/tmp.txt"), (short)2);
            byte[] data = new byte[1024];
            for (long bytesToWrite = fileLen = 2048L; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                r.nextBytes(data);
                bytesToWriteNext = 1024L < bytesToWrite ? 1024 : (int)bytesToWrite;
                out.write(data, 0, bytesToWriteNext);
            }
            out.close();
            DatanodeInfo[] dataNodes = null;
            block6: do {
                DFSClient dfsclient = new DFSClient(NameNode.getAddress((Configuration)CONF), (Configuration)CONF);
                List locatedBlocks = dfsclient.getNamenode().getBlockLocations("/tmp.txt", 0L, fileLen).getLocatedBlocks();
                Assert.assertEquals((long)2L, (long)locatedBlocks.size());
                notWritten = false;
                for (int i = 0; i < 2; ++i) {
                    dataNodes = ((LocatedBlock)locatedBlocks.get(i)).getLocations();
                    if (dataNodes.length == 2) continue;
                    notWritten = true;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {}
                    continue block6;
                }
            } while (notWritten);
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            NamenodeProtocol namenode = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)CONF, (URI)NameNode.getUri((InetSocketAddress)addr), NamenodeProtocol.class).getProxy();
            BlocksWithLocations.BlockWithLocations[] locs = namenode.getBlocks(dataNodes[0], fileLen).getBlocks();
            Assert.assertEquals((long)locs.length, (long)2L);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            Assert.assertEquals((long)locs[1].getStorageIDs().length, (long)2L);
            locs = namenode.getBlocks(dataNodes[0], 1024L).getBlocks();
            Assert.assertEquals((long)locs.length, (long)1L);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            locs = namenode.getBlocks(dataNodes[0], 1L).getBlocks();
            Assert.assertEquals((long)locs.length, (long)1L);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            this.getBlocksWithException(namenode, dataNodes[0], 0L);
            this.getBlocksWithException(namenode, dataNodes[0], -1L);
            DatanodeInfo info = DFSTestUtil.getDatanodeInfo("1.2.3.4");
            this.getBlocksWithException(namenode, info, 2L);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void getBlocksWithException(NamenodeProtocol namenode, DatanodeInfo datanode, long size) throws IOException {
        boolean getException = false;
        try {
            namenode.getBlocks(DFSTestUtil.getLocalDatanodeInfo(), 2L);
        }
        catch (RemoteException e) {
            getException = true;
            Assert.assertTrue((boolean)e.getClassName().contains("HadoopIllegalArgumentException"));
        }
        Assert.assertTrue((boolean)getException);
    }

    @Test
    public void testBlockKey() {
        int i;
        HashMap<Block, Long> map = new HashMap<Block, Long>();
        Random RAN = new Random();
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        long[] blkids = new long[10];
        for (i = 0; i < blkids.length; ++i) {
            blkids[i] = 1000L + (long)RAN.nextInt(100000);
            map.put(new Block(blkids[i], 0L, blkids[i]), blkids[i]);
        }
        System.out.println("map=" + ((Object)map).toString().replace(",", "\n  "));
        for (i = 0; i < blkids.length; ++i) {
            Block b = new Block(blkids[i], 0L, 0L);
            Long v = (Long)map.get(b);
            System.out.println(b + " => " + v);
            Assert.assertEquals((long)blkids[i], (long)v);
        }
    }
}

