/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockInfo {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestBlockInfo");

    @Test
    public void testIsDeleted() {
        BlockInfo blockInfo = new BlockInfo(3);
        BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
        blockInfo.setBlockCollection(bc);
        Assert.assertFalse((boolean)blockInfo.isDeleted());
        blockInfo.setBlockCollection(null);
        Assert.assertTrue((boolean)blockInfo.isDeleted());
    }

    @Test
    public void testAddStorage() throws Exception {
        BlockInfo blockInfo = new BlockInfo(3);
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        boolean added = blockInfo.addStorage(storage);
        Assert.assertTrue((boolean)added);
        Assert.assertEquals((Object)storage, (Object)blockInfo.getStorageInfo(0));
    }

    @Test
    public void testReplaceStorage() throws Exception {
        DatanodeStorageInfo storage1 = DFSTestUtil.createDatanodeStorageInfo("storageID1", "127.0.0.1");
        DatanodeStorageInfo storage2 = new DatanodeStorageInfo(storage1.getDatanodeDescriptor(), new DatanodeStorage("storageID2"));
        int NUM_BLOCKS = 10;
        BlockInfo[] blockInfos = new BlockInfo[10];
        for (int i = 0; i < 10; ++i) {
            blockInfos[i] = new BlockInfo(3);
            storage1.addBlock(blockInfos[i]);
        }
        boolean added = storage2.addBlock(blockInfos[5]) == DatanodeStorageInfo.AddBlockResult.ADDED;
        Assert.assertThat((Object)added, (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)blockInfos[5].getStorageInfo(0), (Matcher)Is.is((Object)storage2));
    }
}

