/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestBlockStatsMXBean {
    private MiniDFSCluster cluster;

    @Before
    public void setup() throws IOException {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = null;
        StorageType[][] types = new StorageType[6][];
        for (i = 0; i < 3; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.DISK};
        }
        for (i = 3; i < 5; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE};
        }
        types[5] = new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE, StorageType.ARCHIVE};
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(6).storageTypes(types).storagesPerDatanode(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testStorageTypeStats() throws Exception {
        Map storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        Assert.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.RAM_DISK));
        Assert.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.DISK));
        Assert.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.ARCHIVE));
        StorageTypeStats storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assert.assertEquals((long)6L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assert.assertEquals((long)3L, (long)storageTypeStats.getNodesInService());
    }

    protected static String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    @Test
    public void testStorageTypeStatsJMX() throws Exception {
        URL baseUrl = new URL(this.cluster.getHttpUri(0));
        String result = TestBlockStatsMXBean.readOutput(new URL(baseUrl, "/jmx"));
        Map stat = (Map)JSON.parse((String)result);
        Object[] beans = (Object[])stat.get("beans");
        Map blockStats = null;
        for (Object bean : beans) {
            Map map = (Map)bean;
            if (!map.get("name").equals("Hadoop:service=NameNode,name=BlockStats")) continue;
            blockStats = map;
        }
        Assert.assertNotNull(blockStats);
        Object[] storageTypeStatsList = (Object[])blockStats.get("StorageTypeStats");
        Assert.assertNotNull((Object)storageTypeStatsList);
        Assert.assertEquals((long)3L, (long)storageTypeStatsList.length);
        HashSet<String> typesPresent = new HashSet<String>();
        for (Object obj : storageTypeStatsList) {
            Map entry = (Map)obj;
            String storageType = (String)entry.get("key");
            Map storageTypeStats = (Map)entry.get("value");
            typesPresent.add(storageType);
            if (storageType.equals("ARCHIVE") || storageType.equals("DISK")) {
                Assert.assertEquals((Object)3L, storageTypeStats.get("nodesInService"));
                continue;
            }
            if (storageType.equals("RAM_DISK")) {
                Assert.assertEquals((Object)6L, storageTypeStats.get("nodesInService"));
                continue;
            }
            Assert.fail();
        }
        Assert.assertTrue((boolean)typesPresent.contains("ARCHIVE"));
        Assert.assertTrue((boolean)typesPresent.contains("DISK"));
        Assert.assertTrue((boolean)typesPresent.contains("RAM_DISK"));
    }
}

