/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDataNodeExit {
    private static final long WAIT_TIME_IN_MILLIS = 10L;
    Configuration conf;
    MiniDFSCluster cluster = null;

    @Before
    public void setUp() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 100);
        this.conf.setInt("dfs.bytes-per-checksum", 100);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).build();
        for (int i = 0; i < 3; ++i) {
            this.cluster.waitActive(i);
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private void stopBPServiceThreads(int numStopThreads, DataNode dn) throws Exception {
        BPOfferService[] bpoList = dn.getAllBpOs();
        int expected = dn.getBpOsCount() - numStopThreads;
        int index = numStopThreads - 1;
        while (index >= 0) {
            bpoList[index--].stop();
        }
        for (int iterations = 3000; dn.getBpOsCount() != expected && iterations > 0; --iterations) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Mismatch in number of BPServices running", (long)expected, (long)dn.getBpOsCount());
    }

    @Test
    public void testBPServiceExit() throws Exception {
        DataNode dn = this.cluster.getDataNodes().get(0);
        this.stopBPServiceThreads(1, dn);
        Assert.assertTrue((String)"DataNode should not exit", (boolean)dn.isDatanodeUp());
        this.stopBPServiceThreads(2, dn);
        Assert.assertFalse((String)"DataNode should exit", (boolean)dn.isDatanodeUp());
    }

    @Test
    public void testSendOOBToPeers() throws Exception {
        DataNode dn = this.cluster.getDataNodes().get(0);
        DataXceiverServer spyXserver = (DataXceiverServer)Mockito.spy((Object)dn.getXferServer());
        NullPointerException npe = new NullPointerException();
        ((DataXceiverServer)Mockito.doThrow((Throwable)npe).when((Object)spyXserver)).sendOOBToPeers();
        dn.xserver = spyXserver;
        try {
            dn.shutdown();
        }
        catch (Exception e) {
            Assert.fail((String)("DataNode shutdown should not have thrown exception " + e));
        }
    }
}

