/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import com.cloudera.io.netty.handler.codec.http.QueryStringDecoder;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.DataNodeUGIProvider;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ParameterParser;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.NamenodeAddressParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDataNodeUGIProvider {
    private final URI uri = URI.create("swebhdfs://127.0.0.1:0");
    private final String PATH = "/foo";
    private final int OFFSET = 42;
    private final int LENGTH = 512;
    private static final int EXPIRE_AFTER_ACCESS = 5000;
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = WebHdfsTestUtil.createConf();
        this.conf.setInt("dfs.webhdfs.ugi.expire.after.access", 5000);
        DataNodeUGIProvider.init((Configuration)this.conf);
    }

    @Test
    public void testUGICacheSecure() throws Exception {
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        ugi = UserGroupInformation.createProxyUser((String)"test-proxy-user", (UserGroupInformation)ugi);
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        ArrayList tokens = Lists.newArrayList();
        this.getWebHdfsFileSystem(ugi, this.conf, tokens);
        String uri1 = "/webhdfs/v1/foo?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new NamenodeAddressParam("127.0.0.1:1010"), new OffsetParam(Long.valueOf(42L)), new LengthParam(Long.valueOf(512L)), new DelegationParam(((Token)tokens.get(0)).encodeToUrlString())});
        String uri2 = "/webhdfs/v1/foo?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new NamenodeAddressParam("127.0.0.1:1010"), new OffsetParam(Long.valueOf(42L)), new LengthParam(Long.valueOf(512L)), new DelegationParam(((Token)tokens.get(1)).encodeToUrlString())});
        DataNodeUGIProvider ugiProvider1 = new DataNodeUGIProvider(new ParameterParser(new QueryStringDecoder(URI.create(uri1)), this.conf));
        UserGroupInformation ugi11 = ugiProvider1.ugi();
        UserGroupInformation ugi12 = ugiProvider1.ugi();
        Assert.assertEquals((String)"With UGI cache, two UGIs returned by the same token should be same", (Object)ugi11, (Object)ugi12);
        DataNodeUGIProvider ugiProvider2 = new DataNodeUGIProvider(new ParameterParser(new QueryStringDecoder(URI.create(uri2)), this.conf));
        UserGroupInformation url21 = ugiProvider2.ugi();
        UserGroupInformation url22 = ugiProvider2.ugi();
        Assert.assertEquals((String)"With UGI cache, two UGIs returned by the same token should be same", (Object)url21, (Object)url22);
        Assert.assertNotEquals((String)"With UGI cache, two UGIs for the different token should not be same", (Object)ugi11, (Object)url22);
        ugiProvider2.clearCache();
        this.awaitCacheEmptyDueToExpiration();
        ugi12 = ugiProvider1.ugi();
        url22 = ugiProvider2.ugi();
        String msg = "With cache eviction, two UGIs returned by the same token should not be same";
        Assert.assertNotEquals((String)msg, (Object)ugi11, (Object)ugi12);
        Assert.assertNotEquals((String)msg, (Object)url21, (Object)url22);
        Assert.assertNotEquals((String)"With UGI cache, two UGIs for the different token should not be same", (Object)ugi11, (Object)url22);
    }

    @Test
    public void testUGICacheInSecure() throws Exception {
        String uri1 = "/webhdfs/v1/foo?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new OffsetParam(Long.valueOf(42L)), new LengthParam(Long.valueOf(512L)), new UserParam("root")});
        String uri2 = "/webhdfs/v1/foo?op=OPEN" + Param.toSortedString((String)"&", (Param[])new Param[]{new OffsetParam(Long.valueOf(42L)), new LengthParam(Long.valueOf(512L)), new UserParam("hdfs")});
        DataNodeUGIProvider ugiProvider1 = new DataNodeUGIProvider(new ParameterParser(new QueryStringDecoder(URI.create(uri1)), this.conf));
        UserGroupInformation ugi11 = ugiProvider1.ugi();
        UserGroupInformation ugi12 = ugiProvider1.ugi();
        Assert.assertEquals((String)"With UGI cache, two UGIs for the same user should be same", (Object)ugi11, (Object)ugi12);
        DataNodeUGIProvider ugiProvider2 = new DataNodeUGIProvider(new ParameterParser(new QueryStringDecoder(URI.create(uri2)), this.conf));
        UserGroupInformation url21 = ugiProvider2.ugi();
        UserGroupInformation url22 = ugiProvider2.ugi();
        Assert.assertEquals((String)"With UGI cache, two UGIs for the same user should be same", (Object)url21, (Object)url22);
        Assert.assertNotEquals((String)"With UGI cache, two UGIs for the different user should not be same", (Object)ugi11, (Object)url22);
        this.awaitCacheEmptyDueToExpiration();
        ugi12 = ugiProvider1.ugi();
        url22 = ugiProvider2.ugi();
        String msg = "With cache eviction, two UGIs returned by the same user should not be same";
        Assert.assertNotEquals((String)msg, (Object)ugi11, (Object)ugi12);
        Assert.assertNotEquals((String)msg, (Object)url21, (Object)url22);
        Assert.assertNotEquals((String)"With UGI cache, two UGIs for the different user should not be same", (Object)ugi11, (Object)url22);
    }

    private void awaitCacheEmptyDueToExpiration() throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                DataNodeUGIProvider.ugiCache.cleanUp();
                return DataNodeUGIProvider.ugiCache.size() == 0L;
            }
        }, (int)5000, (int)50000);
    }

    private WebHdfsFileSystem getWebHdfsFileSystem(UserGroupInformation ugi, Configuration conf, List<Token<DelegationTokenIdentifier>> tokens) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(ugi.getUserName()), null, null);
            FSNamesystem namesystem = (FSNamesystem)Mockito.mock(FSNamesystem.class);
            DelegationTokenSecretManager dtSecretManager = new DelegationTokenSecretManager(86400000L, 86400000L, 86400000L, 86400000L, namesystem);
            dtSecretManager.startThreads();
            Token token1 = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
            Token token2 = new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
            SecurityUtil.setTokenService((Token)token1, (InetSocketAddress)NetUtils.createSocketAddr((String)this.uri.getAuthority()));
            SecurityUtil.setTokenService((Token)token2, (InetSocketAddress)NetUtils.createSocketAddr((String)this.uri.getAuthority()));
            token1.setKind(SWebHdfsFileSystem.TOKEN_KIND);
            token2.setKind(SWebHdfsFileSystem.TOKEN_KIND);
            tokens.add((Token<DelegationTokenIdentifier>)token1);
            tokens.add((Token<DelegationTokenIdentifier>)token2);
            ugi.addToken(token1);
            ugi.addToken(token2);
        }
        return (WebHdfsFileSystem)FileSystem.get((URI)this.uri, (Configuration)conf);
    }
}

