/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import com.cloudera.io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ParameterParser;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;

public class TestParameterParser {
    private static final String LOGICAL_NAME = "minidfs";

    @Test
    public void testDeserializeHAToken() throws IOException {
        Configuration conf = DFSTestUtil.newHAConfiguration(LOGICAL_NAME);
        Token token = new Token();
        QueryStringDecoder decoder = new QueryStringDecoder("/webhdfs/v1/?namenoderpcaddress=minidfs&delegation=" + token.encodeToUrlString());
        ParameterParser testParser = new ParameterParser(decoder, conf);
        Token tok2 = testParser.delegationToken();
        Assert.assertTrue((boolean)HAUtil.isTokenForLogicalUri((Token)tok2));
    }

    @Test
    public void testDecodePath() {
        String ESCAPED_PATH = "/test%25+1%26%3Dtest?op=OPEN&foo=bar";
        String EXPECTED_PATH = "/test%+1&=test";
        Configuration conf = new Configuration();
        QueryStringDecoder decoder = new QueryStringDecoder("/webhdfs/v1/test%25+1%26%3Dtest?op=OPEN&foo=bar");
        ParameterParser testParser = new ParameterParser(decoder, conf);
        Assert.assertEquals((Object)"/test%+1&=test", (Object)testParser.path());
    }

    @Test
    public void testOffset() throws IOException {
        long X = 42L;
        long offset = new OffsetParam(Long.toString(42L)).getOffset();
        Assert.assertEquals((String)"OffsetParam: ", (long)42L, (long)offset);
        offset = new OffsetParam((String)null).getOffset();
        Assert.assertEquals((String)"OffsetParam with null should have defaulted to 0", (long)0L, (long)offset);
        try {
            offset = (Long)new OffsetParam("abc").getValue();
            Assert.fail((String)"OffsetParam with nondigit value should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }
}

