/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.mover.Mover;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestStorageMover {
    static final Log LOG = LogFactory.getLog(TestStorageMover.class);
    private static final int BLOCK_SIZE = 1024;
    private static final short REPL = 3;
    private static final int NUM_DATANODES = 6;
    private static final Configuration DEFAULT_CONF;
    private static final BlockStoragePolicySuite DEFAULT_POLICIES;
    private static final BlockStoragePolicy HOT;
    private static final BlockStoragePolicy WARM;
    private static final BlockStoragePolicy COLD;

    private static StorageType[][] genStorageTypes(int numDataNodes) {
        return TestStorageMover.genStorageTypes(numDataNodes, 0, 0, 0);
    }

    private static StorageType[][] genStorageTypes(int numDataNodes, int numAllDisk, int numAllArchive) {
        return TestStorageMover.genStorageTypes(numDataNodes, numAllDisk, numAllArchive, 0);
    }

    private static StorageType[][] genStorageTypes(int numDataNodes, int numAllDisk, int numAllArchive, int numRamDisk) {
        int i;
        Preconditions.checkArgument((numAllDisk + numAllArchive + numRamDisk <= numDataNodes ? 1 : 0) != 0);
        StorageType[][] types = new StorageType[numDataNodes][];
        for (i = 0; i < numRamDisk; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.DISK};
        }
        while (i < numRamDisk + numAllDisk) {
            types[i] = new StorageType[]{StorageType.DISK, StorageType.DISK};
            ++i;
        }
        while (i < numRamDisk + numAllDisk + numAllArchive) {
            types[i] = new StorageType[]{StorageType.ARCHIVE, StorageType.ARCHIVE};
            ++i;
        }
        while (i < types.length) {
            types[i] = new StorageType[]{StorageType.DISK, StorageType.ARCHIVE};
            ++i;
        }
        return types;
    }

    private static long[][] genCapacities(int nDatanodes, int numAllDisk, int numAllArchive, int numRamDisk, long diskCapacity, long archiveCapacity, long ramDiskCapacity) {
        int i;
        long[][] capacities = new long[nDatanodes][];
        for (i = 0; i < numRamDisk; ++i) {
            capacities[i] = new long[]{ramDiskCapacity, diskCapacity};
        }
        while (i < numRamDisk + numAllDisk) {
            capacities[i] = new long[]{diskCapacity, diskCapacity};
            ++i;
        }
        while (i < numRamDisk + numAllDisk + numAllArchive) {
            capacities[i] = new long[]{archiveCapacity, archiveCapacity};
            ++i;
        }
        while (i < capacities.length) {
            capacities[i] = new long[]{diskCapacity, archiveCapacity};
            ++i;
        }
        return capacities;
    }

    @Test
    public void testMigrateFileToArchival() throws Exception {
        LOG.info((Object)"testMigrateFileToArchival");
        Path foo = new Path("/foo");
        HashMap policyMap = Maps.newHashMap();
        policyMap.put(foo, COLD);
        NamespaceScheme nsScheme = new NamespaceScheme(null, Arrays.asList(foo), 2048L, null, policyMap);
        ClusterScheme clusterScheme = new ClusterScheme(DEFAULT_CONF, 6, 3, TestStorageMover.genStorageTypes(6), null);
        new MigrationTest(clusterScheme, nsScheme).runBasicTest(true);
    }

    static void banner(String string) {
        LOG.info((Object)("\n\n\n\n================================================\n" + string + "\n" + "==================================================\n\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveSpecificPaths() throws Exception {
        LOG.info((Object)"testMoveSpecificPaths");
        Path foo = new Path("/foo");
        Path barFile = new Path(foo, "bar");
        Path foo2 = new Path("/foo2");
        Path bar2File = new Path(foo2, "bar2");
        HashMap policyMap = Maps.newHashMap();
        policyMap.put(foo, COLD);
        policyMap.put(foo2, WARM);
        NamespaceScheme nsScheme = new NamespaceScheme(Arrays.asList(foo, foo2), Arrays.asList(barFile, bar2File), 1024L, null, policyMap);
        ClusterScheme clusterScheme = new ClusterScheme(DEFAULT_CONF, 6, 3, TestStorageMover.genStorageTypes(6), null);
        MigrationTest test = new MigrationTest(clusterScheme, nsScheme);
        test.setupCluster();
        try {
            test.prepareNamespace();
            test.setStoragePolicy();
            Map map = Mover.Cli.getNameNodePathsToMove((Configuration)test.conf, (String[])new String[]{"-p", "/foo/bar", "/foo2"});
            int result = Mover.run((Map)map, (Configuration)test.conf);
            Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)result);
            Thread.sleep(5000L);
            test.verify(true);
        }
        finally {
            test.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMigrateOpenFileToArchival() throws Exception {
        LOG.info((Object)"testMigrateOpenFileToArchival");
        Path fooDir = new Path("/foo");
        HashMap policyMap = Maps.newHashMap();
        policyMap.put(fooDir, COLD);
        NamespaceScheme nsScheme = new NamespaceScheme(Arrays.asList(fooDir), null, 1024L, null, policyMap);
        ClusterScheme clusterScheme = new ClusterScheme(DEFAULT_CONF, 6, 3, TestStorageMover.genStorageTypes(6), null);
        MigrationTest test = new MigrationTest(clusterScheme, nsScheme);
        test.setupCluster();
        TestStorageMover.banner("writing to file /foo/bar");
        Path barFile = new Path(fooDir, "bar");
        DFSTestUtil.createFile((FileSystem)test.dfs, barFile, 1024L, (short)1, 0L);
        FSDataOutputStream out = test.dfs.append(barFile);
        out.writeBytes("hello, ");
        ((DFSOutputStream)out.getWrappedStream()).hsync();
        try {
            TestStorageMover.banner("start data migration");
            test.setStoragePolicy();
            test.migrate();
            LocatedBlocks lbs = test.dfs.getClient().getLocatedBlocks(barFile.toString(), 1024L);
            LOG.info((Object)("Locations: " + lbs));
            List blks = lbs.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)blks.size());
            Assert.assertEquals((long)1L, (long)((LocatedBlock)blks.get(0)).getLocations().length);
            TestStorageMover.banner("finish the migration, continue writing");
            out.writeBytes("world!");
            ((DFSOutputStream)out.getWrappedStream()).hsync();
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            lbs = test.dfs.getClient().getLocatedBlocks(barFile.toString(), 1024L);
            LOG.info((Object)("Locations: " + lbs));
            blks = lbs.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)blks.size());
            Assert.assertEquals((long)1L, (long)((LocatedBlock)blks.get(0)).getLocations().length);
            TestStorageMover.banner("finish writing, starting reading");
            FSDataInputStream in = test.dfs.open(barFile);
            byte[] buf = new byte[13];
            in.readFully(1024L, buf, 0, buf.length);
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            Assert.assertEquals((Object)"hello, world!", (Object)new String(buf));
        }
        finally {
            test.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHotWarmColdDirs() throws Exception {
        LOG.info((Object)"testHotWarmColdDirs");
        PathPolicyMap pathPolicyMap = new PathPolicyMap(3);
        NamespaceScheme nsScheme = pathPolicyMap.newNamespaceScheme();
        ClusterScheme clusterScheme = new ClusterScheme();
        MigrationTest test = new MigrationTest(clusterScheme, nsScheme);
        try {
            test.runBasicTest(false);
            pathPolicyMap.moveAround(test.dfs);
            test.migrate();
            test.verify(true);
        }
        finally {
            test.shutdownCluster();
        }
    }

    private void waitForAllReplicas(int expectedReplicaNum, Path file, DistributedFileSystem dfs) throws Exception {
        for (int i = 0; i < 5; ++i) {
            LocatedBlocks lbs = dfs.getClient().getLocatedBlocks(file.toString(), 0L, 1024L);
            LocatedBlock lb = lbs.get(0);
            if (lb.getLocations().length >= expectedReplicaNum) {
                return;
            }
            Thread.sleep(1000L);
        }
    }

    private void setVolumeFull(DataNode dn, StorageType type) {
        try (FsDatasetSpi.FsVolumeReferences refs = dn.getFSDataset().getFsVolumeReferences();){
            for (FsVolumeSpi fvs : refs) {
                FsVolumeImpl volume = (FsVolumeImpl)fvs;
                if (volume.getStorageType() != type) continue;
                LOG.info((Object)("setCapacity to 0 for [" + volume.getStorageType() + "]" + volume.getStorageID()));
                volume.setCapacityForTesting(0L);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unexpected exception by closing FsVolumeReference", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSpaceDisk() throws Exception {
        LOG.info((Object)"testNoSpaceDisk");
        PathPolicyMap pathPolicyMap = new PathPolicyMap(0);
        NamespaceScheme nsScheme = pathPolicyMap.newNamespaceScheme();
        Configuration conf = new Configuration(DEFAULT_CONF);
        ClusterScheme clusterScheme = new ClusterScheme(conf, 6, 3, TestStorageMover.genStorageTypes(6), null);
        MigrationTest test = new MigrationTest(clusterScheme, nsScheme);
        try {
            test.runBasicTest(false);
            int replication = 3;
            for (int i = 0; i < 2; ++i) {
                Path p = new Path(pathPolicyMap.hot, "file" + i);
                DFSTestUtil.createFile((FileSystem)test.dfs, p, 1024L, (short)3, 0L);
                this.waitForAllReplicas(3, p, test.dfs);
            }
            for (DataNode dn : test.cluster.getDataNodes()) {
                this.setVolumeFull(dn, StorageType.DISK);
                DataNodeTestUtils.triggerHeartbeat(dn);
            }
            Path file0 = new Path(pathPolicyMap.hot, "file0");
            Replication r = test.getReplication(file0);
            int newReplication = 5;
            test.dfs.setReplication(file0, (short)5);
            Thread.sleep(10000L);
            test.verifyReplication(file0, r.disk, 5 - r.disk);
            Path p = new Path(pathPolicyMap.cold, "foo");
            DFSTestUtil.createFile((FileSystem)test.dfs, p, 1024L, (short)3, 0L);
            test.verifyReplication(p, 0, 3);
            test.dfs.setReplication(p, (short)5);
            Thread.sleep(10000L);
            test.verifyReplication(p, 0, 5);
            Path file1 = new Path(pathPolicyMap.hot, "file1");
            test.dfs.rename(file1, pathPolicyMap.warm);
            test.migrate();
            test.verifyFile(new Path(pathPolicyMap.warm, "file1"), WARM.getId());
        }
        finally {
            test.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSpaceArchive() throws Exception {
        LOG.info((Object)"testNoSpaceArchive");
        PathPolicyMap pathPolicyMap = new PathPolicyMap(0);
        NamespaceScheme nsScheme = pathPolicyMap.newNamespaceScheme();
        ClusterScheme clusterScheme = new ClusterScheme(DEFAULT_CONF, 6, 3, TestStorageMover.genStorageTypes(6), null);
        MigrationTest test = new MigrationTest(clusterScheme, nsScheme);
        try {
            test.runBasicTest(false);
            int replication = 3;
            for (int i = 0; i < 2; ++i) {
                Path p = new Path(pathPolicyMap.cold, "file" + i);
                DFSTestUtil.createFile((FileSystem)test.dfs, p, 1024L, (short)3, 0L);
                this.waitForAllReplicas(3, p, test.dfs);
            }
            for (DataNode dn : test.cluster.getDataNodes()) {
                this.setVolumeFull(dn, StorageType.ARCHIVE);
                DataNodeTestUtils.triggerHeartbeat(dn);
            }
            Path file0 = new Path(pathPolicyMap.cold, "file0");
            Replication r = test.getReplication(file0);
            Assert.assertEquals((long)0L, (long)r.disk);
            int newReplication = 5;
            test.dfs.setReplication(file0, (short)5);
            Thread.sleep(10000L);
            test.verifyReplication(file0, 0, r.archive);
            Path p = new Path(pathPolicyMap.hot, "foo");
            DFSTestUtil.createFile((FileSystem)test.dfs, p, 1024L, (short)3, 0L);
            Path file1 = new Path(pathPolicyMap.cold, "file1");
            test.dfs.rename(file1, pathPolicyMap.warm);
            test.migrate();
            test.verify(true);
        }
        finally {
            test.shutdownCluster();
        }
    }

    static {
        ((Log4JLogger)LogFactory.getLog(BlockPlacementPolicy.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(Dispatcher.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(DataTransferProtocol.class)).getLogger().setLevel(Level.ALL);
        DEFAULT_CONF = new HdfsConfiguration();
        DEFAULT_CONF.setLong("dfs.blocksize", 1024L);
        DEFAULT_CONF.setLong("dfs.heartbeat.interval", 1L);
        DEFAULT_CONF.setLong("dfs.namenode.replication.interval", 2L);
        DEFAULT_CONF.setLong("dfs.mover.movedWinWidth", 2000L);
        DEFAULT_POLICIES = BlockStoragePolicySuite.createDefaultSuite();
        HOT = DEFAULT_POLICIES.getPolicy("HOT");
        WARM = DEFAULT_POLICIES.getPolicy("WARM");
        COLD = DEFAULT_POLICIES.getPolicy("COLD");
        TestBalancer.initTestSetup();
        Dispatcher.setDelayAfterErrors((long)1000L);
    }

    private static class PathPolicyMap {
        final Map<Path, BlockStoragePolicy> map = Maps.newHashMap();
        final Path hot = new Path("/hot");
        final Path warm = new Path("/warm");
        final Path cold = new Path("/cold");
        final List<Path> files;

        PathPolicyMap(int filesPerDir) {
            this.map.put(this.hot, HOT);
            this.map.put(this.warm, WARM);
            this.map.put(this.cold, COLD);
            this.files = new ArrayList<Path>();
            for (Path dir : this.map.keySet()) {
                for (int i = 0; i < filesPerDir; ++i) {
                    this.files.add(new Path(dir, "file" + i));
                }
            }
        }

        NamespaceScheme newNamespaceScheme() {
            return new NamespaceScheme(Arrays.asList(this.hot, this.warm, this.cold), this.files, 512L, null, this.map);
        }

        void moveAround(DistributedFileSystem dfs) throws Exception {
            for (Path srcDir : this.map.keySet()) {
                int i = 0;
                for (Path dstDir : this.map.keySet()) {
                    if (srcDir.equals((Object)dstDir)) continue;
                    Path src = new Path(srcDir, "file" + i++);
                    Path dst = new Path(dstDir, srcDir.getName() + "2" + dstDir.getName());
                    LOG.info((Object)("rename " + src + " to " + dst));
                    dfs.rename(src, dst);
                }
            }
        }
    }

    static class Replication {
        int disk;
        int archive;

        Replication() {
        }

        public int hashCode() {
            return this.disk ^ this.archive;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Replication)) {
                return false;
            }
            Replication that = (Replication)obj;
            return this.disk == that.disk && this.archive == that.archive;
        }

        public String toString() {
            return "[disk=" + this.disk + ", archive=" + this.archive + "]";
        }
    }

    class MigrationTest {
        private final ClusterScheme clusterScheme;
        private final NamespaceScheme nsScheme;
        private final Configuration conf;
        private MiniDFSCluster cluster;
        private DistributedFileSystem dfs;
        private final BlockStoragePolicySuite policies;

        MigrationTest(ClusterScheme cScheme, NamespaceScheme nsScheme) {
            this.clusterScheme = cScheme;
            this.nsScheme = nsScheme;
            this.conf = this.clusterScheme.conf;
            this.policies = DEFAULT_POLICIES;
        }

        void setupCluster() throws Exception {
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.clusterScheme.numDataNodes).storageTypes(this.clusterScheme.storageTypes).storageCapacities(this.clusterScheme.storageCapacities).build();
            this.cluster.waitActive();
            this.dfs = this.cluster.getFileSystem();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runBasicTest(boolean shutdown) throws Exception {
            this.setupCluster();
            try {
                this.prepareNamespace();
                this.verify(true);
                this.setStoragePolicy();
                this.migrate();
                this.verify(true);
            }
            finally {
                if (shutdown) {
                    this.shutdownCluster();
                }
            }
        }

        void shutdownCluster() throws Exception {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.dfs});
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }

        void prepareNamespace() throws Exception {
            this.nsScheme.prepare(this.dfs, this.clusterScheme.repl);
        }

        void setStoragePolicy() throws Exception {
            this.nsScheme.setStoragePolicy(this.dfs);
        }

        void migrate() throws Exception {
            this.runMover();
            Thread.sleep(5000L);
        }

        void verify(boolean verifyAll) throws Exception {
            for (DataNode dn : this.cluster.getDataNodes()) {
                DataNodeTestUtils.triggerBlockReport(dn);
            }
            if (verifyAll) {
                this.verifyNamespace();
            }
        }

        private void runMover() throws Exception {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)this.conf);
            HashMap nnMap = Maps.newHashMap();
            for (URI nn : namenodes) {
                nnMap.put(nn, null);
            }
            int result = Mover.run((Map)nnMap, (Configuration)this.conf);
            Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)result);
        }

        private void verifyNamespace() throws Exception {
            HdfsFileStatus status = this.dfs.getClient().getFileInfo("/");
            this.verifyRecursively(null, status);
        }

        private void verifyRecursively(Path parent, HdfsFileStatus status) throws Exception {
            if (status.isDir()) {
                Path fullPath = parent == null ? new Path("/") : status.getFullPath(parent);
                DirectoryListing children = this.dfs.getClient().listPaths(fullPath.toString(), HdfsFileStatus.EMPTY_NAME, true);
                for (HdfsFileStatus child : children.getPartialListing()) {
                    this.verifyRecursively(fullPath, child);
                }
            } else if (!status.isSymlink()) {
                this.verifyFile(parent, status, null);
            }
        }

        void verifyFile(Path file, Byte expectedPolicyId) throws Exception {
            Path parent = file.getParent();
            DirectoryListing children = this.dfs.getClient().listPaths(parent.toString(), HdfsFileStatus.EMPTY_NAME, true);
            for (HdfsFileStatus child : children.getPartialListing()) {
                if (!child.getLocalName().equals(file.getName())) continue;
                this.verifyFile(parent, child, expectedPolicyId);
                return;
            }
            Assert.fail((String)("File " + file + " not found."));
        }

        private void verifyFile(Path parent, HdfsFileStatus status, Byte expectedPolicyId) throws Exception {
            HdfsLocatedFileStatus fileStatus = (HdfsLocatedFileStatus)status;
            byte policyId = fileStatus.getStoragePolicy();
            BlockStoragePolicy policy = this.policies.getPolicy(policyId);
            if (expectedPolicyId != null) {
                Assert.assertEquals((long)expectedPolicyId.byteValue(), (long)policy.getId());
            }
            List types = policy.chooseStorageTypes(status.getReplication());
            for (LocatedBlock lb : fileStatus.getBlockLocations().getLocatedBlocks()) {
                Mover.StorageTypeDiff diff = new Mover.StorageTypeDiff(types, lb.getStorageTypes());
                Assert.assertTrue((String)(fileStatus.getFullName(parent.toString()) + " with policy " + policy + " has non-empty overlap: " + diff + ", the corresponding block is " + lb.getBlock().getLocalBlock()), (boolean)diff.removeOverlap(true));
            }
        }

        Replication getReplication(Path file) throws IOException {
            return this.getOrVerifyReplication(file, null);
        }

        Replication verifyReplication(Path file, int expectedDiskCount, int expectedArchiveCount) throws IOException {
            Replication r = new Replication();
            r.disk = expectedDiskCount;
            r.archive = expectedArchiveCount;
            return this.getOrVerifyReplication(file, r);
        }

        private Replication getOrVerifyReplication(Path file, Replication expected) throws IOException {
            List lbs = this.dfs.getClient().getLocatedBlocks(file.toString(), 0L).getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)lbs.size());
            LocatedBlock lb = (LocatedBlock)lbs.get(0);
            StringBuilder types = new StringBuilder();
            Replication r = new Replication();
            for (StorageType t : lb.getStorageTypes()) {
                types.append(t).append(", ");
                if (t == StorageType.DISK) {
                    ++r.disk;
                    continue;
                }
                if (t == StorageType.ARCHIVE) {
                    ++r.archive;
                    continue;
                }
                Assert.fail((String)("Unexpected storage type " + t));
            }
            if (expected != null) {
                String s = "file = " + file + "\n  types = [" + types + "]";
                Assert.assertEquals((String)s, (Object)expected, (Object)r);
            }
            return r;
        }
    }

    static class ClusterScheme {
        final Configuration conf;
        final int numDataNodes;
        final short repl;
        final StorageType[][] storageTypes;
        final long[][] storageCapacities;

        ClusterScheme() {
            this(DEFAULT_CONF, 6, 3, TestStorageMover.genStorageTypes(6), null);
        }

        ClusterScheme(Configuration conf, int numDataNodes, short repl, StorageType[][] types, long[][] capacities) {
            Preconditions.checkArgument((types == null || types.length == numDataNodes ? 1 : 0) != 0);
            Preconditions.checkArgument((capacities == null || capacities.length == numDataNodes ? 1 : 0) != 0);
            this.conf = conf;
            this.numDataNodes = numDataNodes;
            this.repl = repl;
            this.storageTypes = types;
            this.storageCapacities = capacities;
        }
    }

    static class NamespaceScheme {
        final List<Path> dirs;
        final List<Path> files;
        final long fileSize;
        final Map<Path, List<String>> snapshotMap;
        final Map<Path, BlockStoragePolicy> policyMap;

        NamespaceScheme(List<Path> dirs, List<Path> files, long fileSize, Map<Path, List<String>> snapshotMap, Map<Path, BlockStoragePolicy> policyMap) {
            this.dirs = dirs == null ? Collections.emptyList() : dirs;
            this.files = files == null ? Collections.emptyList() : files;
            this.fileSize = fileSize;
            this.snapshotMap = snapshotMap == null ? Collections.emptyMap() : snapshotMap;
            this.policyMap = policyMap;
        }

        void prepare(DistributedFileSystem dfs, short repl) throws Exception {
            for (Path path : this.dirs) {
                dfs.mkdirs(path);
            }
            for (Path path : this.files) {
                DFSTestUtil.createFile((FileSystem)dfs, path, this.fileSize, repl, 0L);
            }
            for (Map.Entry entry : this.snapshotMap.entrySet()) {
                for (String snapshot : (List)entry.getValue()) {
                    SnapshotTestHelper.createSnapshot(dfs, (Path)entry.getKey(), snapshot);
                }
            }
        }

        void setStoragePolicy(DistributedFileSystem dfs) throws Exception {
            for (Map.Entry<Path, BlockStoragePolicy> entry : this.policyMap.entrySet()) {
                dfs.setStoragePolicy(entry.getKey(), entry.getValue().getName());
            }
        }
    }
}

