/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FSXAttrBaseTest {
    protected static MiniDFSCluster dfsCluster;
    protected static Configuration conf;
    private static int pathCount;
    protected static Path path;
    protected static Path filePath;
    protected static Path rawPath;
    protected static Path rawFilePath;
    protected static final String name1 = "user.a1";
    protected static final byte[] value1;
    protected static final byte[] newValue1;
    protected static final String name2 = "user.a2";
    protected static final byte[] value2;
    protected static final String name3 = "user.a3";
    protected static final String name4 = "user.a4";
    protected static final String raw1 = "raw.a1";
    protected static final String raw2 = "raw.a2";
    protected static final String security1 = "security.hdfs.unreadable.by.superuser";
    private static final int MAX_SIZE;
    protected FileSystem fs;
    private static final UserGroupInformation BRUCE;
    private static final UserGroupInformation DIANA;

    @BeforeClass
    public static void init() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 3);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", MAX_SIZE);
        FSXAttrBaseTest.initCluster(true);
    }

    @AfterClass
    public static void shutdown() {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        path = new Path("/p" + ++pathCount);
        filePath = new Path(path, "file");
        rawPath = new Path("/.reserved/raw/p" + pathCount);
        rawFilePath = new Path(rawPath, "file");
        this.initFileSystem();
    }

    @After
    public void destroyFileSystems() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs});
        this.fs = null;
    }

    @Test(timeout=120000L)
    public void testCreateXAttr() throws Exception {
        HashMap expectedXAttrs = Maps.newHashMap();
        expectedXAttrs.put(name1, value1);
        expectedXAttrs.put(name2, null);
        expectedXAttrs.put(security1, null);
        this.doTestCreateXAttr(filePath, expectedXAttrs);
        expectedXAttrs.put(raw1, value1);
        this.doTestCreateXAttr(rawFilePath, expectedXAttrs);
    }

    private void doTestCreateXAttr(Path usePath, Map<String, byte[]> expectedXAttrs) throws Exception {
        byte[] val;
        DFSTestUtil.createFile(this.fs, usePath, 8192L, (short)1, 65261L);
        this.fs.setXAttr(usePath, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(usePath);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(usePath, name1);
        xattrs = this.fs.getXAttrs(usePath);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
        this.fs.setXAttr(usePath, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        try {
            this.fs.setXAttr(usePath, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
            Assert.fail((String)"Creating xattr which already exists should fail.");
        }
        catch (IOException e) {
            // empty catch block
        }
        this.fs.removeXAttr(usePath, name1);
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            this.fs.setXAttr(usePath, ent.getKey(), ent.getValue(), EnumSet.of(XAttrSetFlag.CREATE));
        }
        xattrs = this.fs.getXAttrs(usePath);
        Assert.assertEquals((long)xattrs.size(), (long)expectedXAttrs.size());
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            val = ent.getValue() == null ? new byte[]{} : ent.getValue();
            Assert.assertArrayEquals((byte[])val, (byte[])((byte[])xattrs.get(ent.getKey())));
        }
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(usePath);
        Assert.assertEquals((long)xattrs.size(), (long)expectedXAttrs.size());
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            val = ent.getValue() == null ? new byte[]{} : ent.getValue();
            Assert.assertArrayEquals((byte[])val, (byte[])((byte[])xattrs.get(ent.getKey())));
        }
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(usePath);
        Assert.assertEquals((long)xattrs.size(), (long)expectedXAttrs.size());
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            val = ent.getValue() == null ? new byte[]{} : ent.getValue();
            Assert.assertArrayEquals((byte[])val, (byte[])((byte[])xattrs.get(ent.getKey())));
        }
        this.fs.delete(usePath, false);
    }

    @Test(timeout=120000L)
    public void testReplaceXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.REPLACE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        try {
            this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.REPLACE));
            Assert.fail((String)"Replacing xattr which does not exist should fail.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, null, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
    }

    @Test(timeout=120000L)
    public void testSetXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        try {
            this.fs.setXAttr(path, null, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting xattr with null name should fail.");
        }
        catch (NullPointerException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be null", (Throwable)e);
        }
        catch (RemoteException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be null", (Throwable)e);
        }
        try {
            this.fs.setXAttr(path, "user.", value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting xattr with empty name should fail.");
        }
        catch (RemoteException e) {
            Assert.assertEquals((String)("Unexpected RemoteException: " + (Object)((Object)e)), (Object)e.getClassName(), (Object)HadoopIllegalArgumentException.class.getCanonicalName());
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be empty", (Throwable)e);
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be empty", (Throwable)e);
        }
        try {
            this.fs.setXAttr(path, "a1", value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting xattr with invalid name prefix or without name prefix should fail.");
        }
        catch (RemoteException e) {
            Assert.assertEquals((String)("Unexpected RemoteException: " + (Object)((Object)e)), (Object)e.getClassName(), (Object)HadoopIllegalArgumentException.class.getCanonicalName());
            GenericTestUtils.assertExceptionContains((String)"XAttr name must be prefixed", (Throwable)e);
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name must be prefixed", (Throwable)e);
        }
        this.fs.setXAttr(path, name1, value1);
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1);
        this.fs.setXAttr(path, name2, value2);
        this.fs.setXAttr(path, name3, null);
        try {
            this.fs.setXAttr(path, name4, null);
            Assert.fail((String)"Setting xattr should fail if total number of xattrs for inode exceeds max limit.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot add additional XAttr", (Throwable)e);
        }
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        this.fs.removeXAttr(path, name3);
        String longName = "user.0123456789abcdefX0123456789abcdefX0123456789abcdef";
        try {
            this.fs.setXAttr(path, longName, null);
            Assert.fail((String)"Setting xattr should fail if name is too long.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr is too big", (Throwable)e);
            GenericTestUtils.assertExceptionContains((String)"total size is 50", (Throwable)e);
        }
        byte[] longValue = new byte[MAX_SIZE];
        try {
            this.fs.setXAttr(path, "user.a", longValue);
            Assert.fail((String)"Setting xattr should fail if value is too long.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr is too big", (Throwable)e);
            GenericTestUtils.assertExceptionContains((String)"total size is 38", (Throwable)e);
        }
        String name = "user.111";
        byte[] value = new byte[MAX_SIZE - 3];
        this.fs.setXAttr(path, name, value);
    }

    @Test(timeout=120000L)
    public void testGetXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        try {
            byte[] value = this.fs.getXAttr(path, name3);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"At least one of the attributes provided was not found.", (Throwable)e);
        }
        ArrayList names = Lists.newArrayList();
        names.add(name1);
        names.add(name2);
        names.add(name3);
        try {
            Map xattrs = this.fs.getXAttrs(path, (List)names);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"At least one of the attributes provided was not found.", (Throwable)e);
        }
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        try {
            byte[] xattr = this.fs.getXAttr(path, "wackynamespace.foo");
            Assert.fail((String)"expected IOException");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'", (Throwable)e);
        }
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        this.fs.setXAttr(path, "trusted.foo", "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(path, "trusted.foo");
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"User doesn't have permission", (Throwable)e);
        }
        this.fs.setXAttr(path, name1, "1234".getBytes());
        this.fs.setPermission(path, new FsPermission(448));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(path, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        final Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)448));
        this.fs.setXAttr(childDir, name1, "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(452));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(449));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(452));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                return null;
            }
        });
    }

    @Test(timeout=120000L)
    public void testRemoveXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name3, null, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        this.fs.removeXAttr(path, name3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRemoveXAttrPermissions() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name3, null, EnumSet.of(XAttrSetFlag.CREATE));
        try {
            this.fs.removeXAttr(path, name2);
            this.fs.removeXAttr(path, name2);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"No matching attributes found", (Throwable)e);
        }
        String expectedExceptionString = "An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'";
        try {
            this.fs.removeXAttr(path, "wackynamespace.foo");
            Assert.fail((String)"expected IOException");
        }
        catch (RemoteException e) {
            Assert.assertEquals((String)("Unexpected RemoteException: " + (Object)((Object)e)), (Object)e.getClassName(), (Object)HadoopIllegalArgumentException.class.getCanonicalName());
            GenericTestUtils.assertExceptionContains((String)"An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'", (Throwable)e);
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'", (Throwable)e);
        }
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        this.fs.setXAttr(path, "trusted.foo", "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(path, "trusted.foo");
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"User doesn't have permission", (Throwable)e);
        }
        finally {
            this.fs.removeXAttr(path, "trusted.foo");
        }
        this.fs.setPermission(path, new FsPermission(448));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(path, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        final Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)448));
        this.fs.setXAttr(childDir, name1, "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(452));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(449));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(454));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                return null;
            }
        });
    }

    @Test(timeout=120000L)
    public void testRenameFileWithXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        Path renamePath = new Path(path.toString() + "-rename");
        this.fs.rename(path, renamePath);
        Map xattrs = this.fs.getXAttrs(renamePath);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(renamePath, name1);
        this.fs.removeXAttr(renamePath, name2);
    }

    @Test(timeout=120000L)
    public void testListXAttrs() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        try {
            this.fs.listXAttrs(path);
            Assert.fail((String)"expected FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains((String)"cannot find", (Throwable)e);
        }
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        List noXAttrs = this.fs.listXAttrs(path);
        Assert.assertTrue((String)"XAttrs were found?", (noXAttrs.size() == 0 ? 1 : 0) != 0);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        List xattrNames = this.fs.listXAttrs(path);
        Assert.assertTrue((boolean)xattrNames.contains(name1));
        Assert.assertTrue((boolean)xattrNames.contains(name2));
        Assert.assertTrue((xattrNames.size() == 2 ? 1 : 0) != 0);
        this.fs.setPermission(path, new FsPermission(452));
        final Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)448));
        this.fs.setXAttr(childDir, name1, "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.listXAttrs(childDir);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(450));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.listXAttrs(childDir);
                    return null;
                }
            });
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied", (Throwable)e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                userFs.listXAttrs(childDir);
                return null;
            }
        });
        this.fs.setXAttr(childDir, "trusted.myxattr", "1234".getBytes());
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                Assert.assertTrue((userFs.listXAttrs(childDir).size() == 1 ? 1 : 0) != 0);
                return null;
            }
        });
        Assert.assertTrue((this.fs.listXAttrs(childDir).size() == 2 ? 1 : 0) != 0);
    }

    @Test(timeout=120000L)
    public void testCleanupXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    @Test(timeout=120000L)
    public void testXAttrAcl() throws Exception {
        Map xattrs;
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setOwner(path, BRUCE.getUserName(), null);
        FileSystem fsAsBruce = this.createFileSystem(BRUCE);
        FileSystem fsAsDiana = this.createFileSystem(DIANA);
        fsAsBruce.setXAttr(path, name1, value1);
        try {
            xattrs = fsAsDiana.getXAttrs(path);
            Assert.fail((String)"Diana should not have read access to get xattrs");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        fsAsBruce.modifyAclEntries(path, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, DIANA.getUserName(), FsAction.READ)}));
        xattrs = fsAsDiana.getXAttrs(path);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        try {
            fsAsDiana.removeXAttr(path, name1);
            Assert.fail((String)"Diana should not have write access to remove xattrs");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        try {
            fsAsDiana.setXAttr(path, name2, value2);
            Assert.fail((String)"Diana should not have write access to set xattrs");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        fsAsBruce.modifyAclEntries(path, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, DIANA.getUserName(), FsAction.ALL)}));
        fsAsDiana.setXAttr(path, name2, value2);
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])fsAsDiana.getXAttrs(path).get(name2)));
        fsAsDiana.removeXAttr(path, name1);
        fsAsDiana.removeXAttr(path, name2);
    }

    @Test(timeout=120000L)
    public void testRawXAttrs() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        byte[] value = this.fs.getXAttr(rawPath, raw1);
        Assert.assertArrayEquals((byte[])value, (byte[])value1);
        Map xattrs = this.fs.getXAttrs(rawPath);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(raw1)));
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(rawPath, raw1, newValue1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(rawPath);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(raw1)));
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(rawPath, raw2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        List xattrNames = this.fs.listXAttrs(rawPath);
        Assert.assertTrue((boolean)xattrNames.contains(raw1));
        Assert.assertTrue((boolean)xattrNames.contains(raw2));
        Assert.assertTrue((xattrNames.size() == 2 ? 1 : 0) != 0);
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.removeXAttr(rawPath, raw2);
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(rawPath, raw2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        xattrNames = this.fs.listXAttrs(path);
        Assert.assertTrue((xattrNames.size() == 0 ? 1 : 0) != 0);
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.removeXAttr(rawPath, raw2);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                try {
                    userFs.setXAttr(path, FSXAttrBaseTest.raw1, value1);
                    Assert.fail((String)"setXAttr should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                try {
                    userFs.setXAttr(rawPath, FSXAttrBaseTest.raw1, value1);
                    Assert.fail((String)"setXAttr should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                try {
                    userFs.getXAttrs(rawPath);
                    Assert.fail((String)"getXAttrs should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                try {
                    userFs.getXAttrs(path);
                    Assert.fail((String)"getXAttrs should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                try {
                    userFs.getXAttr(rawPath, FSXAttrBaseTest.raw1);
                    Assert.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                try {
                    userFs.getXAttr(path, FSXAttrBaseTest.raw1);
                    Assert.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.fs.setXAttr(rawPath, raw1, value1);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                try {
                    userFs.getXAttr(rawPath, FSXAttrBaseTest.raw1);
                    Assert.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                try {
                    userFs.getXAttr(path, FSXAttrBaseTest.raw1);
                    Assert.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException e) {
                    // empty catch block
                }
                List xattrNames = userFs.listXAttrs(path);
                Assert.assertTrue((xattrNames.size() == 0 ? 1 : 0) != 0);
                try {
                    userFs.listXAttrs(rawPath);
                    Assert.fail((String)"listXAttrs on raw path should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.fs.removeXAttr(rawPath, raw1);
    }

    @Test(timeout=120000L)
    public void testUnreadableBySuperuserXAttr() throws Exception {
        this.doTestUnreadableBySuperuserXAttr(this.fs, true);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                FSXAttrBaseTest.this.doTestUnreadableBySuperuserXAttr((FileSystem)userFs, false);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestUnreadableBySuperuserXAttr(FileSystem userFs, boolean expectOpenFailure) throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)511));
        DFSTestUtil.createFile(userFs, filePath, 8192L, (short)1, 65261L);
        try {
            this.doTUBSXAInt(userFs, expectOpenFailure);
            userFs.delete(filePath, false);
        }
        finally {
            this.fs.delete(path, true);
        }
    }

    private void doTUBSXAInt(FileSystem userFs, boolean expectOpenFailure) throws Exception {
        try {
            userFs.setXAttr(path, security1, null, EnumSet.of(XAttrSetFlag.CREATE));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Can only set 'security.hdfs.unreadable.by.superuser' on a file", (Throwable)e);
        }
        userFs.setXAttr(filePath, security1, null, EnumSet.of(XAttrSetFlag.CREATE));
        this.verifySecurityXAttrExists(userFs);
        userFs.setXAttr(filePath, security1, null, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        this.verifySecurityXAttrExists(userFs);
        try {
            userFs.removeXAttr(filePath, security1);
            Assert.fail((String)"Removing security xattr should fail.");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"The xattr 'security.hdfs.unreadable.by.superuser' can not be deleted.", (Throwable)e);
        }
        this.verifySecurityXAttrExists(userFs);
        try {
            userFs.setXAttr(filePath, security1, value1, EnumSet.of(XAttrSetFlag.REPLACE));
            Assert.fail((String)"Should have thrown on attempt to set value");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"Values are not allowed", (Throwable)e);
        }
        List xattrNames = userFs.listXAttrs(filePath);
        Assert.assertTrue((boolean)xattrNames.contains(security1));
        Assert.assertTrue((xattrNames.size() == 1 ? 1 : 0) != 0);
        this.verifyFileAccess(userFs, expectOpenFailure);
        Path toPath = new Path(filePath.toString() + "x");
        userFs.rename(filePath, toPath);
        userFs.rename(toPath, filePath);
    }

    private void verifySecurityXAttrExists(FileSystem userFs) throws Exception {
        try {
            Map xattrs = userFs.getXAttrs(filePath);
            Assert.assertEquals((long)1L, (long)xattrs.size());
            Assert.assertNotNull(xattrs.get(security1));
            Assert.assertArrayEquals((String)"expected empty byte[] from getXAttr", (byte[])new byte[0], (byte[])userFs.getXAttr(filePath, security1));
        }
        catch (AccessControlException e) {
            Assert.fail((String)"getXAttrs failed but expected it to succeed");
        }
    }

    private void verifyFileAccess(FileSystem userFs, boolean expectOpenFailure) throws Exception {
        try {
            userFs.open(filePath).read();
            Assert.assertFalse((String)"open succeeded but expected it to fail", (boolean)expectOpenFailure);
        }
        catch (AccessControlException e) {
            Assert.assertTrue((String)"open failed but expected it to succeed", (boolean)expectOpenFailure);
        }
    }

    protected FileSystem createFileSystem() throws Exception {
        return dfsCluster.getFileSystem();
    }

    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return DFSTestUtil.getFileSystemAs(user, conf);
    }

    private void initFileSystem() throws Exception {
        this.fs = this.createFileSystem();
    }

    protected static void initCluster(boolean format) throws Exception {
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        dfsCluster.waitActive();
    }

    protected static void restart(boolean checkpoint) throws Exception {
        NameNode nameNode = dfsCluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        FSXAttrBaseTest.shutdown();
        FSXAttrBaseTest.initCluster(false);
    }

    static {
        pathCount = 0;
        value1 = new byte[]{49, 50, 51};
        newValue1 = new byte[]{49, 49, 49};
        value2 = new byte[]{55, 56, 57};
        MAX_SIZE = security1.length();
        BRUCE = UserGroupInformation.createUserForTesting((String)"bruce", (String[])new String[0]);
        DIANA = UserGroupInformation.createUserForTesting((String)"diana", (String[])new String[0]);
    }
}

