/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.ha.EditLogTailer;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class NameNodeAdapter {
    public static FSNamesystem getNamesystem(NameNode namenode) {
        return namenode.getNamesystem();
    }

    public static LocatedBlocks getBlockLocations(NameNode namenode, String src, long offset, long length) throws IOException {
        return namenode.getNamesystem().getBlockLocations("foo", src, offset, length);
    }

    public static HdfsFileStatus getFileInfo(NameNode namenode, String src, boolean resolveLink) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        return namenode.getNamesystem().getFileInfo(src, resolveLink);
    }

    public static boolean mkdirs(NameNode namenode, String src, PermissionStatus permissions, boolean createParent) throws UnresolvedLinkException, IOException {
        return namenode.getNamesystem().mkdirs(src, permissions, createParent);
    }

    public static void saveNamespace(NameNode namenode) throws AccessControlException, IOException {
        namenode.getNamesystem().saveNamespace();
    }

    public static void enterSafeMode(NameNode namenode, boolean resourcesLow) throws IOException {
        namenode.getNamesystem().enterSafeMode(resourcesLow);
    }

    public static void leaveSafeMode(NameNode namenode) {
        namenode.getNamesystem().leaveSafeMode();
    }

    public static void abortEditLogs(NameNode nn) {
        FSEditLog el = nn.getFSImage().getEditLog();
        el.abortCurrentLogSegment();
    }

    public static Server getRpcServer(NameNode namenode) {
        return ((NameNodeRpcServer)namenode.getRpcServer()).clientRpcServer;
    }

    public static DelegationTokenSecretManager getDtSecretManager(FSNamesystem ns) {
        return ns.getDelegationTokenSecretManager();
    }

    public static HeartbeatResponse sendHeartBeat(DatanodeRegistration nodeReg, DatanodeDescriptor dd, FSNamesystem namesystem) throws IOException {
        return namesystem.handleHeartbeat(nodeReg, BlockManagerTestUtil.getStorageReportsForDatanode(dd), dd.getCacheCapacity(), dd.getCacheRemaining(), 0, 0, 0, null, true);
    }

    public static boolean setReplication(FSNamesystem ns, String src, short replication) throws IOException {
        return ns.setReplication(src, replication);
    }

    public static LeaseManager getLeaseManager(FSNamesystem ns) {
        return ns.leaseManager;
    }

    public static void setLeasePeriod(FSNamesystem namesystem, long soft, long hard) {
        NameNodeAdapter.getLeaseManager(namesystem).setLeasePeriod(soft, hard);
        namesystem.leaseManager.triggerMonitorCheckNow();
    }

    public static String getLeaseHolderForPath(NameNode namenode, String path) {
        LeaseManager.Lease l = namenode.getNamesystem().leaseManager.getLeaseByPath(path);
        return l == null ? null : l.getHolder();
    }

    public static long getLeaseRenewalTime(NameNode nn, String path) {
        LeaseManager lm = nn.getNamesystem().leaseManager;
        LeaseManager.Lease l = lm.getLeaseByPath(path);
        if (l == null) {
            return -1L;
        }
        return l.getLastUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatanodeDescriptor getDatanode(FSNamesystem ns, DatanodeID id) throws IOException {
        ns.readLock();
        try {
            DatanodeDescriptor datanodeDescriptor = ns.getBlockManager().getDatanodeManager().getDatanode(id);
            return datanodeDescriptor;
        }
        finally {
            ns.readUnlock();
        }
    }

    public static long[] getStats(FSNamesystem fsn) {
        return fsn.getStats();
    }

    public static ReentrantReadWriteLock spyOnFsLock(FSNamesystem fsn) {
        ReentrantReadWriteLock spy = (ReentrantReadWriteLock)Mockito.spy((Object)fsn.getFsLockForTests());
        fsn.setFsLockForTests(spy);
        return spy;
    }

    public static FSImage spyOnFsImage(NameNode nn1) {
        FSNamesystem fsn = nn1.getNamesystem();
        FSImage spy = (FSImage)Mockito.spy((Object)fsn.getFSImage());
        Whitebox.setInternalState((Object)fsn, (String)"fsImage", (Object)spy);
        return spy;
    }

    public static FSEditLog spyOnEditLog(NameNode nn) {
        FSEditLog spyEditLog = (FSEditLog)Mockito.spy((Object)nn.getNamesystem().getFSImage().getEditLog());
        nn.getFSImage().setEditLogForTesting(spyEditLog);
        EditLogTailer tailer = nn.getNamesystem().getEditLogTailer();
        if (tailer != null) {
            tailer.setEditLog(spyEditLog);
        }
        return spyEditLog;
    }

    public static JournalSet spyOnJournalSet(NameNode nn) {
        FSEditLog editLog = nn.getFSImage().getEditLog();
        JournalSet js = (JournalSet)Mockito.spy((Object)editLog.getJournalSet());
        editLog.setJournalSetForTesting(js);
        return js;
    }

    public static String getMkdirOpPath(FSEditLogOp op) {
        if (op.opCode == FSEditLogOpCodes.OP_MKDIR) {
            return ((FSEditLogOp.MkdirOp)op).path;
        }
        return null;
    }

    public static FSEditLogOp createMkdirOp(String path) {
        FSEditLogOp.MkdirOp op = FSEditLogOp.MkdirOp.getInstance((FSEditLogOp.OpInstanceCache)new FSEditLogOp.OpInstanceCache()).setPath(path).setTimestamp(0L).setPermissionStatus(new PermissionStatus("testuser", "testgroup", FsPermission.getDefault()));
        return op;
    }

    public static int getSafeModeSafeBlocks(NameNode nn) {
        FSNamesystem.SafeModeInfo smi = nn.getNamesystem().getSafeModeInfoForTests();
        if (smi == null) {
            return -1;
        }
        return smi.blockSafe;
    }

    public static boolean safeModeInitializedReplQueues(NameNode nn) {
        return nn.getNamesystem().isPopulatingReplQueues();
    }

    public static File getInProgressEditsFile(Storage.StorageDirectory sd, long startTxId) {
        return NNStorage.getInProgressEditsFile((Storage.StorageDirectory)sd, (long)startTxId);
    }

    public static NamenodeCommand startCheckpoint(NameNode nn, NamenodeRegistration backupNode, NamenodeRegistration activeNamenode) throws IOException {
        return nn.getNamesystem().startCheckpoint(backupNode, activeNamenode);
    }
}

