/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestEditLogAutoroll {
    private static boolean useAsyncEditLog;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private FileSystem fs;
    private FSEditLog editLog;
    private final Random random = new Random();
    private static final Log LOG;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestEditLogAutoroll(Boolean async) {
        useAsyncEditLog = async;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.namenode.checkpoint.period", Long.MAX_VALUE);
        this.conf.setLong("dfs.namenode.checkpoint.txns", 20L);
        this.conf.setFloat("dfs.namenode.edit.log.autoroll.multiplier.threshold", 0.5f);
        this.conf.setInt("dfs.namenode.edit.log.autoroll.check.interval.ms", 100);
        this.conf.setBoolean("dfs.namenode.edits.asynclogging", useAsyncEditLog);
        int retryCount = 0;
        while (true) {
            try {
                int basePort = 10060 + this.random.nextInt(100) * 2;
                MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setHttpPort(basePort)).addNN(new MiniDFSNNTopology.NNConf("nn2").setHttpPort(basePort + 1)));
                this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(topology).numDataNodes(0).build();
                this.cluster.waitActive();
                this.nn0 = this.cluster.getNameNode(0);
                this.fs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
                this.cluster.transitionToActive(0);
                this.fs = this.cluster.getFileSystem(0);
                this.editLog = this.nn0.getNamesystem().getEditLog();
                ++retryCount;
            }
            catch (BindException e) {
                LOG.info((Object)("Set up MiniDFSCluster failed due to port conflicts, retry " + retryCount + " times"));
                continue;
            }
            break;
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testEditLogAutoroll() throws Exception {
        final long startTxId = this.editLog.getCurSegmentTxId();
        for (int i = 0; i < 11; ++i) {
            this.fs.mkdirs(new Path("testEditLogAutoroll-" + i));
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestEditLogAutoroll.this.editLog.getCurSegmentTxId() > startTxId;
            }
        }, (int)1000, (int)5000);
        this.nn0.transitionToStandby();
        GenericTestUtils.assertNoThreadsMatching((String)(".*" + FSNamesystem.NameNodeEditLogRoller.class.getSimpleName() + ".*"));
    }

    static {
        GenericTestUtils.setLogLevel((Log)FSEditLog.LOG, (Level)Level.ALL);
        LOG = LogFactory.getLog(TestEditLog.class);
    }
}

