/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestMetadataVersionOutput {
    private MiniDFSCluster dfsCluster = null;
    private final Configuration conf = new Configuration();

    @After
    public void tearDown() throws Exception {
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
        Thread.sleep(2000L);
    }

    private void initConfig() {
        this.conf.set("dfs.nameservice.id", "ns1");
        this.conf.set("dfs.ha.namenodes.ns1", "nn1");
        this.conf.set("dfs.ha.namenode.id", "nn1");
        this.conf.set("dfs.namenode.name.dir.ns1.nn1", MiniDFSCluster.getBaseDirectory() + "1");
        this.conf.unset("dfs.namenode.name.dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMetadataVersionOutput() throws IOException {
        this.initConfig();
        this.dfsCluster = new MiniDFSCluster.Builder(this.conf).manageNameDfsDirs(false).numDataNodes(1).checkExitOnShutdown(false).build();
        this.dfsCluster.waitClusterUp();
        this.dfsCluster.shutdown(false);
        this.initConfig();
        PrintStream origOut = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream stdOut = new PrintStream(baos);
        try {
            System.setOut(stdOut);
            try {
                NameNode.createNameNode((String[])new String[]{"-metadataVersion"}, (Configuration)this.conf);
            }
            catch (Exception e) {
                GenericTestUtils.assertExceptionContains((String)"ExitException", (Throwable)e);
            }
            String verNumStr = HdfsConstants.NAMENODE_LAYOUT_VERSION + "";
            Assert.assertTrue((boolean)baos.toString("UTF-8").contains("HDFS Image Version: " + verNumStr));
            Assert.assertTrue((boolean)baos.toString("UTF-8").contains("Software format version: " + verNumStr));
        }
        finally {
            System.setOut(origOut);
        }
    }
}

