/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSecondaryWebUi {
    private static MiniDFSCluster cluster;
    private static SecondaryNameNode snn;
    private static final Configuration conf;

    @BeforeClass
    public static void setUpCluster() throws IOException {
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        conf.setLong("dfs.namenode.checkpoint.txns", 500L);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        snn = new SecondaryNameNode(conf);
        snn.startInfoServer();
    }

    @AfterClass
    public static void shutDownCluster() {
        if (cluster != null) {
            cluster.shutdown();
        }
        if (snn != null) {
            snn.shutdown();
        }
    }

    @Test
    public void testSecondaryWebUi() throws IOException, MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=SecondaryNameNode,name=SecondaryNameNodeInfo");
        Object[] checkpointDir = (String[])mbs.getAttribute(mxbeanName, "CheckpointDirectories");
        Assert.assertArrayEquals((Object[])checkpointDir, (Object[])snn.getCheckpointDirectories());
        Object[] checkpointEditlogDir = (String[])mbs.getAttribute(mxbeanName, "CheckpointEditlogDirectories");
        Assert.assertArrayEquals((Object[])checkpointEditlogDir, (Object[])snn.getCheckpointEditlogDirectories());
    }

    @Test
    public void testSecondaryWebUiJsp() throws IOException, MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        String pageContents = DFSTestUtil.urlGet(new URL("http://localhost:" + SecondaryNameNode.getHttpAddress((Configuration)conf).getPort() + "/status.jsp"));
        Assert.assertTrue((String)"Didn't find \"Last Checkpoint\"", (boolean)pageContents.contains("Last Checkpoint"));
        Assert.assertTrue((String)"Didn't find Checkpoint Transactions: 500", (boolean)pageContents.contains("Checkpoint Transactions: 500"));
    }

    static {
        conf = new Configuration();
    }
}

