/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.MockFSInputStream;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.StreamFile;
import org.apache.hadoop.net.NetUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mortbay.jetty.InclusiveByteRange;

public class TestStreamFile {
    private final HdfsConfiguration CONF = new HdfsConfiguration();
    private final DFSClient clientMock = (DFSClient)Mockito.mock(DFSClient.class);
    private final HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private final HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private final ServletContext mockServletContext = (ServletContext)Mockito.mock(ServletContext.class);
    final StreamFile sfile = new StreamFile(){
        private static final long serialVersionUID = -5513776238875189473L;

        public ServletContext getServletContext() {
            return TestStreamFile.this.mockServletContext;
        }

        protected DFSClient getDFSClient(HttpServletRequest request) throws IOException, InterruptedException {
            return TestStreamFile.this.clientMock;
        }
    };

    private static byte[] getOutputArray(int start, int count) {
        byte[] a = new byte[count];
        for (int i = 0; i < count; ++i) {
            a[i] = (byte)(start + i);
        }
        return a;
    }

    @Test
    public void testWriteTo() throws IOException {
        FSDataInputStream fsdin = new FSDataInputStream((InputStream)((Object)new MockFSInputStream()));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int[] pairs = new int[]{0, 10000, 50, 100, 50, 6000, 1000, 2000, 0, 1, 0, 0, 5000, 0};
        Assert.assertTrue((String)"Pairs array must be even", (pairs.length % 2 == 0 ? 1 : 0) != 0);
        for (int i = 0; i < pairs.length; i += 2) {
            StreamFile.copyFromOffset((FSDataInputStream)fsdin, (OutputStream)os, (long)pairs[i], (long)pairs[i + 1]);
            Assert.assertArrayEquals((String)("Reading " + pairs[i + 1] + " bytes from offset " + pairs[i]), (byte[])TestStreamFile.getOutputArray(pairs[i], pairs[i + 1]), (byte[])os.toByteArray());
            os.reset();
        }
    }

    private List<InclusiveByteRange> strToRanges(String s, int contentLength) {
        List<String> l = Arrays.asList("bytes=" + s);
        Enumeration<String> e = new Vector<String>(l).elements();
        return InclusiveByteRange.satisfiableRanges(e, (long)contentLength);
    }

    @Test
    public void testSendPartialData() throws IOException {
        FSDataInputStream in = new FSDataInputStream((InputStream)((Object)new MockFSInputStream()));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List<InclusiveByteRange> ranges = this.strToRanges("0-,10-300", 500);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StreamFile.sendPartialData((FSDataInputStream)in, (OutputStream)os, (HttpServletResponse)response, (long)500L, ranges);
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(416);
        os.reset();
        HttpServletResponse response2 = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StreamFile.sendPartialData((FSDataInputStream)in, (OutputStream)os, (HttpServletResponse)response2, (long)500L, null);
        ((HttpServletResponse)Mockito.verify((Object)response2)).setStatus(416);
        ranges = this.strToRanges("600-800", 500);
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StreamFile.sendPartialData((FSDataInputStream)in, (OutputStream)os, (HttpServletResponse)response, (long)500L, ranges);
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(416);
        ranges = this.strToRanges("100-300", 500);
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StreamFile.sendPartialData((FSDataInputStream)in, (OutputStream)os, (HttpServletResponse)response, (long)500L, ranges);
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(206);
        Assert.assertArrayEquals((String)"Byte range from 100-300", (byte[])TestStreamFile.getOutputArray(100, 201), (byte[])os.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoGetShouldWriteTheFileContentIntoServletOutputStream() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)this.CONF).numDataNodes(1).build();
        try {
            Path testFile = this.createFile();
            this.setUpForDoGetTest(cluster, testFile);
            ServletOutputStreamExtn outStream = new ServletOutputStreamExtn();
            ((HttpServletResponse)Mockito.doReturn((Object)((Object)outStream)).when((Object)this.mockHttpServletResponse)).getOutputStream();
            StreamFile sfile = new StreamFile(){
                private static final long serialVersionUID = 7715590481809562722L;

                public ServletContext getServletContext() {
                    return TestStreamFile.this.mockServletContext;
                }
            };
            sfile.doGet(this.mockHttpServletRequest, this.mockHttpServletResponse);
            Assert.assertEquals((String)"Not writing the file data into ServletOutputStream", (Object)outStream.getResult(), (Object)"test");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoGetShouldCloseTheDFSInputStreamIfResponseGetOutPutStreamThrowsAnyException() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)this.CONF).numDataNodes(1).build();
        try {
            Path testFile = this.createFile();
            this.setUpForDoGetTest(cluster, testFile);
            ((HttpServletResponse)Mockito.doThrow((Throwable)new IOException()).when((Object)this.mockHttpServletResponse)).getOutputStream();
            DFSInputStream fsMock = (DFSInputStream)Mockito.mock(DFSInputStream.class);
            ((DFSClient)Mockito.doReturn((Object)fsMock).when((Object)this.clientMock)).open(testFile.toString());
            ((DFSInputStream)Mockito.doReturn((Object)4L).when((Object)fsMock)).getFileLength();
            try {
                this.sfile.doGet(this.mockHttpServletRequest, this.mockHttpServletResponse);
                Assert.fail((String)"Not throwing the IOException");
            }
            catch (IOException e) {
                ((DFSClient)Mockito.verify((Object)this.clientMock, (VerificationMode)Mockito.atLeastOnce())).close();
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private void setUpForDoGetTest(MiniDFSCluster cluster, Path testFile) {
        ((ServletContext)Mockito.doReturn((Object)this.CONF).when((Object)this.mockServletContext)).getAttribute("current.conf");
        ((HttpServletRequest)Mockito.doReturn((Object)NetUtils.getHostPortString((InetSocketAddress)NameNode.getAddress((Configuration)this.CONF))).when((Object)this.mockHttpServletRequest)).getParameter("nnaddr");
        ((HttpServletRequest)Mockito.doReturn((Object)testFile.toString()).when((Object)this.mockHttpServletRequest)).getPathInfo();
        ((HttpServletRequest)Mockito.doReturn((Object)("/streamFile" + testFile.toString())).when((Object)this.mockHttpServletRequest)).getRequestURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path writeFile(FileSystem fs, Path f) throws IOException {
        try (FSDataOutputStream out = fs.create(f);){
            out.writeBytes("test");
        }
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }

    private Path createFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.CONF);
        Path testFile = new Path("/test/mkdirs/doGet");
        TestStreamFile.writeFile(fs, testFile);
        return testFile;
    }

    public static class ServletOutputStreamExtn
    extends ServletOutputStream {
        private final StringBuffer buffer = new StringBuffer(3);

        public String getResult() {
            return this.buffer.toString();
        }

        public void write(int b) throws IOException {
            this.buffer.append((char)b);
        }
    }
}

