/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDFSAdmin {
    private Configuration conf = null;
    private MiniDFSCluster cluster;
    private DFSAdmin admin;
    private DataNode datanode;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.restartCluster();
        this.admin = new DFSAdmin();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void restartCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.datanode = this.cluster.getDataNodes().get(0);
    }

    private List<String> getReconfigureStatus(String nodeType, String address) throws IOException {
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bufOut);
        ByteArrayOutputStream bufErr = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(bufErr);
        this.admin.getReconfigurationStatus(nodeType, address, out, err);
        Scanner scanner = new Scanner(bufOut.toString());
        ArrayList outputs = Lists.newArrayList();
        while (scanner.hasNextLine()) {
            outputs.add(scanner.nextLine());
        }
        return outputs;
    }

    private void testGetReconfigurationStatus(boolean expectedSuccuss) throws IOException, InterruptedException {
        int count;
        ReconfigurationUtil ru = (ReconfigurationUtil)Mockito.mock(ReconfigurationUtil.class);
        this.datanode.setReconfigurationUtil(ru);
        ArrayList<ReconfigurationUtil.PropertyChange> changes = new ArrayList<ReconfigurationUtil.PropertyChange>();
        File newDir = new File(this.cluster.getDataDirectory(), "data_new");
        if (expectedSuccuss) {
            newDir.mkdirs();
        } else {
            newDir.createNewFile();
        }
        changes.add(new ReconfigurationUtil.PropertyChange("dfs.datanode.data.dir", newDir.toString(), this.datanode.getConf().get("dfs.datanode.data.dir")));
        changes.add(new ReconfigurationUtil.PropertyChange("randomKey", "new123", "old456"));
        Mockito.when((Object)ru.parseChangedProperties((Configuration)Matchers.any(Configuration.class), (Configuration)Matchers.any(Configuration.class))).thenReturn(changes);
        int port = this.datanode.getIpcPort();
        String address = "localhost:" + port;
        Assert.assertThat((Object)this.admin.startReconfiguration("datanode", address), (Matcher)CoreMatchers.is((Object)0));
        List<String> outputs = null;
        for (count = 100; count > 0 && ((outputs = this.getReconfigureStatus("datanode", address)).isEmpty() || !outputs.get(0).contains("finished")); --count) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        if (expectedSuccuss) {
            Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)4));
        } else {
            Assert.assertThat((Object)outputs.size(), (Matcher)CoreMatchers.is((Object)6));
        }
        List locations = DataNode.getStorageLocations((Configuration)this.datanode.getConf());
        if (expectedSuccuss) {
            Assert.assertThat((Object)locations.size(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)((StorageLocation)locations.get(0)).getFile(), (Matcher)CoreMatchers.is((Object)newDir));
            Assert.assertTrue((boolean)new File(newDir, "current").isDirectory());
        } else {
            Assert.assertTrue((boolean)locations.isEmpty());
        }
        int offset = 1;
        if (expectedSuccuss) {
            Assert.assertThat((Object)outputs.get(offset), (Matcher)CoreMatchers.containsString((String)"SUCCESS: Changed property dfs.datanode.data.dir"));
        } else {
            Assert.assertThat((Object)outputs.get(offset), (Matcher)CoreMatchers.containsString((String)"FAILED: Change property dfs.datanode.data.dir"));
        }
        Assert.assertThat((Object)outputs.get(offset + 1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"From:"), (Matcher)CoreMatchers.containsString((String)"data1"), (Matcher)CoreMatchers.containsString((String)"data2"))));
        Assert.assertThat((Object)outputs.get(offset + 2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"data1"), (Matcher)CoreMatchers.containsString((String)"data2")))));
        Assert.assertThat((Object)outputs.get(offset + 2), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"To"), (Matcher)CoreMatchers.containsString((String)"data_new"))));
    }

    @Test(timeout=30000L)
    public void testGetReconfigurationStatus() throws IOException, InterruptedException {
        this.testGetReconfigurationStatus(true);
        this.restartCluster();
        this.testGetReconfigurationStatus(false);
    }

    private List<String> getReconfigurationAllowedProperties(String nodeType, String address) throws IOException {
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bufOut);
        ByteArrayOutputStream bufErr = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(bufErr);
        this.admin.getReconfigurableProperties(nodeType, address, out, err);
        Scanner scanner = new Scanner(bufOut.toString());
        ArrayList outputs = Lists.newArrayList();
        while (scanner.hasNextLine()) {
            outputs.add(scanner.nextLine());
        }
        return outputs;
    }

    @Test(timeout=30000L)
    public void testGetReconfigAllowedProperties() throws IOException {
        int port = this.datanode.getIpcPort();
        String address = "localhost:" + port;
        List<String> outputs = this.getReconfigurationAllowedProperties("datanode", address);
        Assert.assertEquals((long)2L, (long)outputs.size());
        Assert.assertEquals((Object)"dfs.datanode.data.dir", (Object)outputs.get(1));
    }
}

