/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestByteArrayManager {
    static final Log LOG;
    private static final Comparator<Future<Integer>> CMP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCounter() throws Exception {
        int i;
        long countResetTimePeriodMs = 200L;
        final ByteArrayManager.Counter c = new ByteArrayManager.Counter(200L);
        int n = DFSUtil.getRandom().nextInt(512) + 512;
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(n);
        ExecutorService pool = Executors.newFixedThreadPool(32);
        try {
            for (i = 0; i < n; ++i) {
                futures.add(pool.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return (int)c.increment();
                    }
                }));
            }
            Collections.sort(futures, CMP);
        }
        finally {
            pool.shutdown();
        }
        Assert.assertEquals((long)n, (long)futures.size());
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((long)(i + 1), (long)((Integer)((Future)futures.get(i)).get()).intValue());
        }
        Assert.assertEquals((long)n, (long)c.getCount());
        Thread.sleep(300L);
        Assert.assertEquals((long)1L, (long)c.increment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocateRecycle() throws Exception {
        int countThreshold = 4;
        int countLimit = 8;
        long countResetTimePeriodMs = 200L;
        ByteArrayManager.Impl bam = new ByteArrayManager.Impl(new ByteArrayManager.Conf(4, 8, 200L));
        ByteArrayManager.CounterMap counters = bam.getCounters();
        ByteArrayManager.ManagerMap managers = bam.getManagers();
        int[] uncommonArrays = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
        int arrayLength = 1024;
        Allocator allocator = new Allocator((ByteArrayManager)bam);
        Recycler recycler = new Recycler((ByteArrayManager)bam);
        try {
            for (int i = 0; i < 4; ++i) {
                allocator.submit(1024);
            }
            TestByteArrayManager.waitForAll(allocator.futures);
            Assert.assertEquals((long)4L, (long)counters.get(Integer.valueOf(1024), false).getCount());
            Assert.assertNull((Object)managers.get(Integer.valueOf(1024), false));
            for (int n : uncommonArrays) {
                Assert.assertNull((Object)counters.get(Integer.valueOf(n), false));
                Assert.assertNull((Object)managers.get(Integer.valueOf(n), false));
            }
            for (int i = 0; i < 2; ++i) {
                recycler.submit((byte[])TestByteArrayManager.removeLast(allocator.futures).get());
            }
            for (Future<Integer> f : recycler.furtures) {
                Assert.assertEquals((long)-1L, (long)f.get().intValue());
            }
            recycler.furtures.clear();
            allocator.submit(1024).get();
            Assert.assertEquals((long)5L, (long)counters.get(Integer.valueOf(1024), false).getCount());
            Assert.assertNotNull((Object)managers.get(Integer.valueOf(1024), false));
            int n = allocator.recycleAll(recycler);
            recycler.verify(n);
            for (int i = 0; i < 8; ++i) {
                allocator.submit(1024);
            }
            TestByteArrayManager.waitForAll(allocator.futures);
            AllocatorThread t = new AllocatorThread(1024, (ByteArrayManager)bam);
            t.start();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(100L);
                Thread.State threadState = t.getState();
                if (threadState == Thread.State.RUNNABLE || threadState == Thread.State.WAITING || threadState == Thread.State.TIMED_WAITING) continue;
                Assert.fail((String)("threadState = " + (Object)((Object)threadState)));
            }
            recycler.submit((byte[])TestByteArrayManager.removeLast(allocator.futures).get());
            Assert.assertEquals((long)1L, (long)((Integer)TestByteArrayManager.removeLast(recycler.furtures).get()).intValue());
            Thread.sleep(100L);
            Assert.assertEquals((Object)((Object)Thread.State.TERMINATED), (Object)((Object)t.getState()));
            Assert.assertEquals((long)7L, (long)allocator.recycleAll(recycler));
            recycler.submit(t.array);
            recycler.verify(8);
            Assert.assertEquals((long)8L, (long)bam.release(new byte[1024]));
        }
        finally {
            allocator.pool.shutdown();
            recycler.pool.shutdown();
        }
    }

    static <T> Future<T> removeLast(List<Future<T>> furtures) throws Exception {
        return TestByteArrayManager.remove(furtures, furtures.size() - 1);
    }

    static <T> Future<T> remove(List<Future<T>> furtures, int i) throws Exception {
        return furtures.isEmpty() ? null : furtures.remove(i);
    }

    static <T> void waitForAll(List<Future<T>> furtures) throws Exception {
        for (Future<T> f : furtures) {
            f.get();
        }
    }

    @Test
    public void testByteArrayManager() throws Exception {
        int countThreshold = 32;
        int countLimit = 64;
        long countResetTimePeriodMs = 1000L;
        ByteArrayManager.Impl bam = new ByteArrayManager.Impl(new ByteArrayManager.Conf(32, 64, 1000L));
        ByteArrayManager.CounterMap counters = bam.getCounters();
        ByteArrayManager.ManagerMap managers = bam.getManagers();
        ExecutorService pool = Executors.newFixedThreadPool(128);
        final Runner[] runners = new Runner[5];
        final Thread[] threads = new Thread[runners.length];
        int num = 1024;
        for (int i = 0; i < runners.length; ++i) {
            runners[i] = new Runner(i, 32, 64, pool, i, (ByteArrayManager)bam);
            threads[i] = runners[i].start(1024);
        }
        final ArrayList exceptions = new ArrayList();
        Thread randomRecycler = new Thread(){

            @Override
            public void run() {
                LOG.info((Object)"randomRecycler start");
                int i = 0;
                while (this.shouldRun()) {
                    int j = DFSUtil.getRandom().nextInt(runners.length);
                    try {
                        runners[j].recycle();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptions.add(new Exception(this + " has an exception", e));
                    }
                    if ((i & 0xFF) == 0) {
                        LOG.info((Object)("randomRecycler sleep, i=" + i));
                        TestByteArrayManager.sleepMs(100L);
                    }
                    ++i;
                }
                LOG.info((Object)"randomRecycler done");
            }

            boolean shouldRun() {
                for (int i = 0; i < runners.length; ++i) {
                    if (threads[i].isAlive()) {
                        return true;
                    }
                    if (runners[i].isEmpty()) continue;
                    return true;
                }
                return false;
            }
        };
        randomRecycler.start();
        randomRecycler.join();
        Assert.assertTrue((boolean)exceptions.isEmpty());
        Assert.assertNull((Object)counters.get(Integer.valueOf(0), false));
        for (int i = 1; i < runners.length; ++i) {
            int arrayLength;
            if (!runners[i].assertionErrors.isEmpty()) {
                for (AssertionError e : runners[i].assertionErrors) {
                    LOG.error((Object)("AssertionError " + i), (Throwable)((Object)e));
                }
                Assert.fail((String)(runners[i].assertionErrors.size() + " AssertionError(s)"));
            }
            boolean exceedCountThreshold = counters.get(Integer.valueOf(arrayLength = Runner.index2arrayLength(i)), false).getCount() > 32L;
            ByteArrayManager.FixedLengthManager m = managers.get(Integer.valueOf(arrayLength), false);
            if (exceedCountThreshold) {
                Assert.assertNotNull((Object)m);
                continue;
            }
            Assert.assertNull((Object)m);
        }
    }

    static void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)("Sleep is interrupted: " + e));
        }
    }

    public static void main(String[] args) throws Exception {
        ((Log4JLogger)LogFactory.getLog(ByteArrayManager.class)).getLogger().setLevel(Level.OFF);
        int arrayLength = 65536;
        int nThreads = 512;
        int nAllocations = 32768;
        int maxArrays = 1024;
        int nTrials = 5;
        System.out.println("arrayLength=65536, nThreads=512, nAllocations=32768, maxArrays=1024");
        Random ran = DFSUtil.getRandom();
        ByteArrayManager[] impls = new ByteArrayManager[]{new ByteArrayManager.NewByteArrayWithoutLimit(), new NewByteArrayWithLimit(1024), new ByteArrayManager.Impl(new ByteArrayManager.Conf(128, 1024, 10000L))};
        double[] avg = new double[impls.length];
        for (int i = 0; i < impls.length; ++i) {
            int j;
            double duration = 0.0;
            TestByteArrayManager.printf("%26s:", impls[i].getClass().getSimpleName());
            for (j = 0; j < 5; ++j) {
                int[] sleepTime = new int[32768];
                for (int k = 0; k < sleepTime.length; ++k) {
                    sleepTime[k] = ran.nextInt(100);
                }
                long elapsed = TestByteArrayManager.performanceTest(65536, 1024, 512, sleepTime, impls[i]);
                duration += (double)elapsed;
                TestByteArrayManager.printf("%5d, ", elapsed);
            }
            avg[i] = duration / 5.0;
            TestByteArrayManager.printf("avg=%6.3fs", avg[i] / 1000.0);
            for (j = 0; j < i; ++j) {
                TestByteArrayManager.printf(" (%6.2f%%)", TestByteArrayManager.percentageDiff(avg[j], avg[i]));
            }
            TestByteArrayManager.printf("\n", new Object[0]);
        }
    }

    static double percentageDiff(double original, double newValue) {
        return (newValue - original) / original * 100.0;
    }

    static void printf(String format, Object ... args) {
        System.out.printf(format, args);
        System.out.flush();
    }

    static long performanceTest(final int arrayLength, int maxArrays, int nThreads, int[] sleepTimeMSs, final ByteArrayManager impl) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(sleepTimeMSs.length);
        long startTime = Time.monotonicNow();
        for (int i = 0; i < sleepTimeMSs.length; ++i) {
            final long sleepTime = sleepTimeMSs[i];
            futures.add(pool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    byte[] array = impl.newByteArray(arrayLength);
                    TestByteArrayManager.sleepMs(sleepTime);
                    impl.release(array);
                    return null;
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        long endTime = Time.monotonicNow();
        pool.shutdown();
        return endTime - startTime;
    }

    static {
        ((Log4JLogger)LogFactory.getLog(ByteArrayManager.class)).getLogger().setLevel(Level.ALL);
        LOG = LogFactory.getLog(TestByteArrayManager.class);
        CMP = new Comparator<Future<Integer>>(){

            @Override
            public int compare(Future<Integer> left, Future<Integer> right) {
                try {
                    return left.get() - right.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static class NewByteArrayWithLimit
    extends ByteArrayManager {
        private final int maxCount;
        private int count = 0;

        NewByteArrayWithLimit(int maxCount) {
            this.maxCount = maxCount;
        }

        public synchronized byte[] newByteArray(int size) throws InterruptedException {
            while (this.count >= this.maxCount) {
                ((Object)((Object)this)).wait();
            }
            ++this.count;
            return new byte[size];
        }

        public synchronized int release(byte[] array) {
            if (this.count == this.maxCount) {
                ((Object)((Object)this)).notifyAll();
            }
            --this.count;
            return 0;
        }
    }

    static class Runner
    implements Runnable {
        static final int NUM_RUNNERS = 5;
        private final ByteArrayManager bam;
        final int maxArrayLength;
        final int countThreshold;
        final int maxArrays;
        final ExecutorService pool;
        final List<Future<byte[]>> arrays = new ArrayList<Future<byte[]>>();
        final AtomicInteger count = new AtomicInteger();
        final int p;
        private int n;
        final List<AssertionError> assertionErrors = new ArrayList<AssertionError>();

        static int index2arrayLength(int index) {
            return 32 << index - 1;
        }

        Runner(int index, int countThreshold, int maxArrays, ExecutorService pool, int p, ByteArrayManager bam) {
            this.maxArrayLength = Runner.index2arrayLength(index);
            this.countThreshold = countThreshold;
            this.maxArrays = maxArrays;
            this.pool = pool;
            this.p = p;
            this.bam = bam;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isEmpty() {
            List<Future<byte[]>> list = this.arrays;
            synchronized (list) {
                return this.arrays.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<byte[]> submitAllocate() {
            this.count.incrementAndGet();
            Future<byte[]> f = this.pool.submit(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    int lower = Runner.this.maxArrayLength == 32 ? 0 : Runner.this.maxArrayLength >> 1;
                    int arrayLength = DFSUtil.getRandom().nextInt(Runner.this.maxArrayLength - lower) + lower + 1;
                    byte[] array = Runner.this.bam.newByteArray(arrayLength);
                    try {
                        Assert.assertEquals((String)("arrayLength=" + arrayLength + ", lower=" + lower), (long)Runner.this.maxArrayLength, (long)array.length);
                    }
                    catch (AssertionError e) {
                        Runner.this.assertionErrors.add(e);
                    }
                    return array;
                }
            });
            List<Future<byte[]>> list = this.arrays;
            synchronized (list) {
                this.arrays.add(f);
            }
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Future<byte[]> removeFirst() throws Exception {
            List<Future<byte[]>> list = this.arrays;
            synchronized (list) {
                return TestByteArrayManager.remove(this.arrays, 0);
            }
        }

        void recycle() throws Exception {
            Future<byte[]> f = this.removeFirst();
            if (f != null) {
                TestByteArrayManager.printf("randomRecycler: ", new Object[0]);
                try {
                    this.recycle(f.get(10L, TimeUnit.MILLISECONDS));
                }
                catch (TimeoutException e) {
                    this.recycle(new byte[this.maxArrayLength]);
                    TestByteArrayManager.printf("timeout, new byte[%d]\n", this.maxArrayLength);
                }
            }
        }

        int recycle(byte[] array) {
            return this.bam.release(array);
        }

        Future<Integer> submitRecycle(final byte[] array) {
            this.count.decrementAndGet();
            Future<Integer> f = this.pool.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Runner.this.recycle(array);
                }
            });
            return f;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.n; ++i) {
                boolean isAllocate;
                boolean bl = isAllocate = DFSUtil.getRandom().nextInt(5) < this.p;
                if (isAllocate) {
                    this.submitAllocate();
                } else {
                    try {
                        Future<byte[]> f = this.removeFirst();
                        if (f != null) {
                            this.submitRecycle(f.get());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)(this + " has " + e));
                    }
                }
                if ((i & 0xFF) != 0) continue;
                TestByteArrayManager.sleepMs(100L);
            }
        }

        Thread start(int n) {
            this.n = n;
            Thread t = new Thread(this);
            t.start();
            return t;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": max=" + this.maxArrayLength + ", count=" + this.count;
        }
    }

    static class Recycler {
        private final ByteArrayManager bam;
        final ExecutorService pool = Executors.newFixedThreadPool(8);
        final List<Future<Integer>> furtures = new LinkedList<Future<Integer>>();

        Recycler(ByteArrayManager bam) {
            this.bam = bam;
        }

        Future<Integer> submit(final byte[] array) {
            Future<Integer> f = this.pool.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Recycler.this.bam.release(array);
                }
            });
            this.furtures.add(f);
            return f;
        }

        void verify(int expectedSize) throws Exception {
            Assert.assertEquals((long)expectedSize, (long)this.furtures.size());
            Collections.sort(this.furtures, CMP);
            for (int i = 0; i < this.furtures.size(); ++i) {
                Assert.assertEquals((long)(i + 1), (long)this.furtures.get(i).get().intValue());
            }
            this.furtures.clear();
        }
    }

    static class Allocator {
        private final ByteArrayManager bam;
        final ExecutorService pool = Executors.newFixedThreadPool(8);
        final List<Future<byte[]>> futures = new LinkedList<Future<byte[]>>();

        Allocator(ByteArrayManager bam) {
            this.bam = bam;
        }

        Future<byte[]> submit(final int arrayLength) {
            Future<byte[]> f = this.pool.submit(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    byte[] array = Allocator.this.bam.newByteArray(arrayLength);
                    Assert.assertEquals((long)arrayLength, (long)array.length);
                    return array;
                }
            });
            this.futures.add(f);
            return f;
        }

        int recycleAll(Recycler recycler) throws Exception {
            int n = this.futures.size();
            for (Future<byte[]> f : this.futures) {
                recycler.submit(f.get());
            }
            this.futures.clear();
            return n;
        }
    }

    static class AllocatorThread
    extends Thread {
        private final ByteArrayManager bam;
        private final int arrayLength;
        private byte[] array;

        AllocatorThread(int arrayLength, ByteArrayManager bam) {
            this.bam = bam;
            this.arrayLength = arrayLength;
        }

        @Override
        public void run() {
            try {
                this.array = this.bam.newByteArray(this.arrayLength);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

