/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.ErrorReportAction;
import org.apache.hadoop.hdfs.server.datanode.ReportBadBlockAction;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;

@InterfaceAudience.Private
class BPOfferService {
    static final Log LOG = DataNode.LOG;
    NamespaceInfo bpNSInfo;
    volatile DatanodeRegistration bpRegistration;
    private final DataNode dn;
    private BPServiceActor bpServiceToActive = null;
    private final List<BPServiceActor> bpServices = new CopyOnWriteArrayList<BPServiceActor>();
    private long lastActiveClaimTxId = -1L;
    private final ReentrantReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();
    private final Lock mReadLock = this.mReadWriteLock.readLock();
    private final Lock mWriteLock = this.mReadWriteLock.writeLock();

    void readLock() {
        this.mReadLock.lock();
    }

    void readUnlock() {
        this.mReadLock.unlock();
    }

    void writeLock() {
        this.mWriteLock.lock();
    }

    void writeUnlock() {
        this.mWriteLock.unlock();
    }

    BPOfferService(List<InetSocketAddress> nnAddrs, DataNode dn) {
        Preconditions.checkArgument((!nnAddrs.isEmpty() ? 1 : 0) != 0, (Object)"Must pass at least one NN.");
        this.dn = dn;
        for (InetSocketAddress addr : nnAddrs) {
            this.bpServices.add(new BPServiceActor(addr, this));
        }
    }

    void refreshNNList(ArrayList<InetSocketAddress> addrs) throws IOException {
        HashSet oldAddrs = Sets.newHashSet();
        for (BPServiceActor actor : this.bpServices) {
            oldAddrs.add(actor.getNNSocketAddress());
        }
        HashSet newAddrs = Sets.newHashSet(addrs);
        if (!Sets.symmetricDifference((Set)oldAddrs, (Set)newAddrs).isEmpty()) {
            throw new IOException("HA does not currently support adding a new standby to a running DN. Please do a rolling restart of DNs to reconfigure the list of NNs.");
        }
    }

    boolean isInitialized() {
        return this.bpRegistration != null;
    }

    boolean isAlive() {
        for (BPServiceActor actor : this.bpServices) {
            if (!actor.isAlive()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getBlockPoolId() {
        this.readLock();
        try {
            if (this.bpNSInfo != null) {
                String string = this.bpNSInfo.getBlockPoolID();
                return string;
            }
            LOG.warn((Object)"Block pool ID needed, but service not yet registered with NN", (Throwable)new Exception("trace"));
            String string = null;
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    boolean hasBlockPoolId() {
        return this.getNamespaceInfo() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = this.bpNSInfo;
            return namespaceInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock();
        try {
            if (this.bpNSInfo == null) {
                String datanodeUuid = this.dn.getDatanodeUuid();
                if (datanodeUuid == null || datanodeUuid.isEmpty()) {
                    datanodeUuid = "unassigned";
                }
                String string = "Block pool <registering> (Datanode Uuid " + datanodeUuid + ")";
                return string;
            }
            String string = "Block pool " + this.getBlockPoolId() + " (Datanode Uuid " + this.dn.getDatanodeUuid() + ")";
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    void reportBadBlocks(ExtendedBlock block, String storageUuid, StorageType storageType) {
        this.checkBlock(block);
        for (BPServiceActor actor : this.bpServices) {
            ReportBadBlockAction rbbAction = new ReportBadBlockAction(block, storageUuid, storageType);
            actor.bpThreadEnqueue(rbbAction);
        }
    }

    void notifyNamenodeReceivedBlock(ExtendedBlock block, String delHint, String storageUuid, boolean isOnTransientStorage) {
        this.notifyNamenodeBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, delHint, storageUuid, isOnTransientStorage);
    }

    void notifyNamenodeReceivingBlock(ExtendedBlock block, String storageUuid) {
        this.notifyNamenodeBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null, storageUuid, false);
    }

    void notifyNamenodeDeletedBlock(ExtendedBlock block, String storageUuid) {
        this.notifyNamenodeBlock(block, ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null, storageUuid, false);
    }

    private void notifyNamenodeBlock(ExtendedBlock block, ReceivedDeletedBlockInfo.BlockStatus status, String delHint, String storageUuid, boolean isOnTransientStorage) {
        this.checkBlock(block);
        ReceivedDeletedBlockInfo info = new ReceivedDeletedBlockInfo(block.getLocalBlock(), status, delHint);
        DatanodeStorage storage = this.dn.getFSDataset().getStorage(storageUuid);
        for (BPServiceActor actor : this.bpServices) {
            actor.getIbrManager().notifyNamenodeBlock(info, storage, isOnTransientStorage);
        }
    }

    private void checkBlock(ExtendedBlock block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block is null");
        Preconditions.checkArgument((boolean)block.getBlockPoolId().equals(this.getBlockPoolId()), (String)"block belongs to BP %s instead of BP %s", (Object[])new Object[]{block.getBlockPoolId(), this.getBlockPoolId()});
    }

    void start() {
        for (BPServiceActor actor : this.bpServices) {
            actor.start();
        }
    }

    void stop() {
        for (BPServiceActor actor : this.bpServices) {
            actor.stop();
        }
    }

    void join() {
        for (BPServiceActor actor : this.bpServices) {
            actor.join();
        }
    }

    DataNode getDataNode() {
        return this.dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyAndSetNamespaceInfo(NamespaceInfo nsInfo) throws IOException {
        block8: {
            this.writeLock();
            try {
                if (this.bpNSInfo == null) {
                    this.bpNSInfo = nsInfo;
                    boolean success = false;
                    try {
                        this.dn.initBlockPool(this);
                        success = true;
                        break block8;
                    }
                    finally {
                        if (!success) {
                            this.bpNSInfo = null;
                        }
                    }
                }
                BPOfferService.checkNSEquality(this.bpNSInfo.getBlockPoolID(), nsInfo.getBlockPoolID(), "Blockpool ID");
                BPOfferService.checkNSEquality(this.bpNSInfo.getNamespaceID(), nsInfo.getNamespaceID(), "Namespace ID");
                BPOfferService.checkNSEquality(this.bpNSInfo.getClusterID(), nsInfo.getClusterID(), "Cluster ID");
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registrationSucceeded(BPServiceActor bpServiceActor, DatanodeRegistration reg) throws IOException {
        this.writeLock();
        try {
            if (this.bpRegistration != null) {
                BPOfferService.checkNSEquality(this.bpRegistration.getStorageInfo().getNamespaceID(), reg.getStorageInfo().getNamespaceID(), "namespace ID");
                BPOfferService.checkNSEquality(this.bpRegistration.getStorageInfo().getClusterID(), reg.getStorageInfo().getClusterID(), "cluster ID");
            }
            this.bpRegistration = reg;
            this.dn.bpRegistrationSucceeded(this.bpRegistration, this.getBlockPoolId());
            if (this.dn.isBlockTokenEnabled) {
                this.dn.blockPoolTokenSecretManager.addKeys(this.getBlockPoolId(), reg.getExportedKeys());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private static void checkNSEquality(Object ourID, Object theirID, String idHelpText) throws IOException {
        if (!ourID.equals(theirID)) {
            throw new IOException(idHelpText + " mismatch: " + "previously connected to " + idHelpText + " " + ourID + " but now connected to " + idHelpText + " " + theirID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeRegistration createRegistration() {
        this.writeLock();
        try {
            Preconditions.checkState((this.bpNSInfo != null ? 1 : 0) != 0, (Object)"getRegistration() can only be called after initial handshake");
            DatanodeRegistration datanodeRegistration = this.dn.createBPRegistration(this.bpNSInfo);
            return datanodeRegistration;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownActor(BPServiceActor actor) {
        this.writeLock();
        try {
            if (this.bpServiceToActive == actor) {
                this.bpServiceToActive = null;
            }
            this.bpServices.remove(actor);
            if (this.bpServices.isEmpty()) {
                this.dn.shutdownBlockPool(this);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void trySendErrorReport(int errCode, String errMsg) {
        for (BPServiceActor actor : this.bpServices) {
            ErrorReportAction errorReportAction = new ErrorReportAction(errCode, errMsg);
            actor.bpThreadEnqueue(errorReportAction);
        }
    }

    void scheduleBlockReport(long delay) {
        for (BPServiceActor actor : this.bpServices) {
            actor.getScheduler().scheduleBlockReport(delay);
        }
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) {
        for (BPServiceActor actor : this.bpServices) {
            try {
                actor.reportRemoteBadBlock(dnInfo, block);
            }
            catch (IOException e) {
                LOG.warn((Object)("Couldn't report bad block " + block + " to " + actor), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeProtocolClientSideTranslatorPB getActiveNN() {
        this.readLock();
        try {
            if (this.bpServiceToActive != null) {
                DatanodeProtocolClientSideTranslatorPB datanodeProtocolClientSideTranslatorPB = this.bpServiceToActive.bpNamenode;
                return datanodeProtocolClientSideTranslatorPB;
            }
            DatanodeProtocolClientSideTranslatorPB datanodeProtocolClientSideTranslatorPB = null;
            return datanodeProtocolClientSideTranslatorPB;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    List<BPServiceActor> getBPServiceActors() {
        return Lists.newArrayList(this.bpServices);
    }

    void signalRollingUpgrade(RollingUpgradeStatus rollingUpgradeStatus) throws IOException {
        if (rollingUpgradeStatus == null) {
            return;
        }
        String bpid = this.getBlockPoolId();
        if (!rollingUpgradeStatus.isFinalized()) {
            this.dn.getFSDataset().enableTrash(bpid);
            this.dn.getFSDataset().setRollingUpgradeMarker(bpid);
        } else {
            this.dn.getFSDataset().clearTrash(bpid);
            this.dn.getFSDataset().clearRollingUpgradeMarker(bpid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateActorStatesFromHeartbeat(BPServiceActor actor, NNHAStatusHeartbeat nnHaState) {
        this.writeLock();
        try {
            boolean isMoreRecentClaim;
            long txid = nnHaState.getTxId();
            boolean nnClaimsActive = nnHaState.getState() == HAServiceProtocol.HAServiceState.ACTIVE;
            boolean bposThinksActive = this.bpServiceToActive == actor;
            boolean bl = isMoreRecentClaim = txid > this.lastActiveClaimTxId;
            if (nnClaimsActive && !bposThinksActive) {
                LOG.info((Object)("Namenode " + actor + " trying to claim ACTIVE state with " + "txid=" + txid));
                if (!isMoreRecentClaim) {
                    LOG.warn((Object)("NN " + actor + " tried to claim ACTIVE state at txid=" + txid + " but there was already a more recent claim at txid=" + this.lastActiveClaimTxId));
                    return;
                }
                if (this.bpServiceToActive == null) {
                    LOG.info((Object)("Acknowledging ACTIVE Namenode " + actor));
                } else {
                    LOG.info((Object)("Namenode " + actor + " taking over ACTIVE state from " + this.bpServiceToActive + " at higher txid=" + txid));
                }
                this.bpServiceToActive = actor;
            } else if (!nnClaimsActive && bposThinksActive) {
                LOG.info((Object)("Namenode " + actor + " relinquishing ACTIVE state with " + "txid=" + nnHaState.getTxId()));
                this.bpServiceToActive = null;
            }
            if (this.bpServiceToActive == actor) {
                assert (txid >= this.lastActiveClaimTxId);
                this.lastActiveClaimTxId = txid;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean containsNN(InetSocketAddress addr) {
        for (BPServiceActor actor : this.bpServices) {
            if (!actor.getNNSocketAddress().equals(addr)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int countNameNodes() {
        return this.bpServices.size();
    }

    @VisibleForTesting
    void triggerBlockReportForTests() throws IOException {
        for (BPServiceActor actor : this.bpServices) {
            actor.triggerBlockReportForTests();
        }
    }

    @VisibleForTesting
    void triggerDeletionReportForTests() throws IOException {
        for (BPServiceActor actor : this.bpServices) {
            actor.getIbrManager().triggerDeletionReportForTests();
        }
    }

    @VisibleForTesting
    void triggerHeartbeatForTests() throws IOException {
        for (BPServiceActor actor : this.bpServices) {
            actor.triggerHeartbeatForTests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processCommandFromActor(DatanodeCommand cmd, BPServiceActor actor) throws IOException {
        assert (this.bpServices.contains(actor));
        if (cmd == null) {
            return true;
        }
        if (4 == cmd.getAction()) {
            LOG.info((Object)("DatanodeCommand action : DNA_REGISTER from " + actor.nnAddr + " with " + actor.state + " state"));
            actor.reRegister();
            return false;
        }
        this.writeLock();
        try {
            if (actor == this.bpServiceToActive) {
                boolean bl = this.processCommandFromActive(cmd, actor);
                return bl;
            }
            boolean bl = this.processCommandFromStandby(cmd, actor);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private String blockIdArrayToString(long[] ids) {
        long maxNumberOfBlocksToLog = this.dn.getMaxNumberOfBlocksToLog();
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        for (int i = 0; i < ids.length; ++i) {
            if ((long)i >= maxNumberOfBlocksToLog) {
                bld.append("...");
                break;
            }
            bld.append(prefix).append(ids[i]);
            prefix = ", ";
        }
        return bld.toString();
    }

    private boolean processCommandFromActive(DatanodeCommand cmd, BPServiceActor actor) throws IOException {
        BlockCommand bcmd = cmd instanceof BlockCommand ? (BlockCommand)cmd : null;
        BlockIdCommand blockIdCmd = cmd instanceof BlockIdCommand ? (BlockIdCommand)cmd : null;
        switch (cmd.getAction()) {
            case 1: {
                this.dn.transferBlocks(bcmd.getBlockPoolId(), bcmd.getBlocks(), bcmd.getTargets(), bcmd.getTargetStorageTypes());
                this.dn.metrics.incrBlocksReplicated(bcmd.getBlocks().length);
                break;
            }
            case 2: {
                Block[] toDelete = bcmd.getBlocks();
                this.dn.getFSDataset().invalidate(bcmd.getBlockPoolId(), toDelete);
                this.dn.metrics.incrBlocksRemoved(toDelete.length);
                break;
            }
            case 9: {
                LOG.info((Object)("DatanodeCommand action: DNA_CACHE for " + blockIdCmd.getBlockPoolId() + " of [" + this.blockIdArrayToString(blockIdCmd.getBlockIds()) + "]"));
                this.dn.getFSDataset().cache(blockIdCmd.getBlockPoolId(), blockIdCmd.getBlockIds());
                break;
            }
            case 10: {
                LOG.info((Object)("DatanodeCommand action: DNA_UNCACHE for " + blockIdCmd.getBlockPoolId() + " of [" + this.blockIdArrayToString(blockIdCmd.getBlockIds()) + "]"));
                this.dn.getFSDataset().uncache(blockIdCmd.getBlockPoolId(), blockIdCmd.getBlockIds());
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Received unimplemented DNA_SHUTDOWN");
            }
            case 5: {
                String bp = ((FinalizeCommand)cmd).getBlockPoolId();
                LOG.info((Object)("Got finalize command for block pool " + bp));
                assert (this.getBlockPoolId().equals(bp)) : "BP " + this.getBlockPoolId() + " received DNA_FINALIZE " + "for other block pool " + bp;
                this.dn.finalizeUpgradeForPool(bp);
                break;
            }
            case 6: {
                String who = "NameNode at " + actor.getNNSocketAddress();
                this.dn.getBlockRecoveryWorker().recoverBlocks(who, ((BlockRecoveryCommand)cmd).getRecoveringBlocks());
                break;
            }
            case 7: {
                LOG.info((Object)"DatanodeCommand action: DNA_ACCESSKEYUPDATE");
                if (!this.dn.isBlockTokenEnabled) break;
                this.dn.blockPoolTokenSecretManager.addKeys(this.getBlockPoolId(), ((KeyUpdateCommand)cmd).getExportedKeys());
                break;
            }
            case 8: {
                LOG.info((Object)"DatanodeCommand action: DNA_BALANCERBANDWIDTHUPDATE");
                long bandwidth = ((BalancerBandwidthCommand)cmd).getBalancerBandwidthValue();
                if (bandwidth <= 0L) break;
                DataXceiverServer dxcs = (DataXceiverServer)this.dn.dataXceiverServer.getRunnable();
                LOG.info((Object)("Updating balance throttler bandwidth from " + dxcs.balanceThrottler.getBandwidth() + " bytes/s " + "to: " + bandwidth + " bytes/s."));
                dxcs.balanceThrottler.setBandwidth(bandwidth);
                break;
            }
            default: {
                LOG.warn((Object)("Unknown DatanodeCommand action: " + cmd.getAction()));
            }
        }
        return true;
    }

    private boolean processCommandFromStandby(DatanodeCommand cmd, BPServiceActor actor) throws IOException {
        switch (cmd.getAction()) {
            case 7: {
                LOG.info((Object)"DatanodeCommand action from standby: DNA_ACCESSKEYUPDATE");
                if (!this.dn.isBlockTokenEnabled) break;
                this.dn.blockPoolTokenSecretManager.addKeys(this.getBlockPoolId(), ((KeyUpdateCommand)cmd).getExportedKeys());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                LOG.warn((Object)("Got a command from standby NN - ignoring command:" + cmd.getAction()));
                break;
            }
            default: {
                LOG.warn((Object)("Unknown DatanodeCommand action: " + cmd.getAction()));
            }
        }
        return true;
    }

    boolean shouldRetryInit() {
        if (this.hasBlockPoolId()) {
            return true;
        }
        return this.isAlive();
    }
}

